## ⭐️ misato

A tool for downloading videos from the "MissAV" website.

## ⚙️ Installation

To install misato from the Python Package Index (PyPI) run:

```
pip install misato
```

To upgrade misato from the Python Package Index (PyPI) run:

```
pip install --upgrade misato
```

## 📷 Snapshot

![snapshot.png](resources/readme_pics/snapshot.png)

## 📖 Instructions

```
[root@misato ~]# misato -h
usage: main.py [-h] [-auto  [...]] [-auth  [...]] [-limit] [-search] [-file] [-proxy] [-ffmpeg] [-cover] [-ffcover] [-noban] [-title] [-quality] [-retry] [-delay] [-timeout]

A tool for downloading videos from the "MissAV" website.

Main Options:
Use the -auto   option to specify the video or playlist URLs to download. can be mixed.
Use the -auth   option to specify the username and password to download the videos collected by the account.
Use the -search option to search for movie by serial number and download it.
Use the -file   option to download video or playlist URLs in the file. ( Each line is a URL )

Additional Options:
Use the -limit   option to limit the number of downloads. 
Use the -proxy   option to configure http proxy server ip and port.
Use the -ffmpeg  option to get the best video quality. ( Recommend! )
Use the -cover   option to save the cover when downloading the video
Use the -ffcover option to set the cover as the video preview (ffmpeg required)
Use the -noban   option to turn off the misato banner when downloading the video
Use the -title   option to use the full title as the movie file name
Use the -quality option to specify the movie resolution (360, 480, 720, 1080...)
Use the -retry   option to specify the number of retries for downloading segments
Use the -delay   option to specify the delay before retry ( seconds )
Use the -timeout option to specify the timeout for segment download ( seconds )

options:
  -h, --help     show this help message and exit
  -auto  [ ...]  Multiple movie and playlist URLs can be mixed. separate with spaces
  -auth  [ ...]  Username and password, separate with space
  -limit         Limit the number of downloads
  -search        Movie serial number
  -file          File path
  -proxy         HTTP(S) proxy
  -ffmpeg        Enable ffmpeg processing
  -cover         Download video cover
  -ffcover       Set cover as preview (ffmpeg required)
  -noban         Do not display the banner
  -title         Full title as file name
  -quality       Specify the movie resolution
  -retry         Number of retries for downloading segments
  -delay         Delay in seconds before retry
  -timeout       Timeout in seconds for segment download

Examples:
  misato -auto "https://missav.ai/sw-950" "https://missav.ai/dm132/actresses/JULIA"
  misato -auto "https://missav.ai/dm132/actresses/JULIA" -limit 20 -ffcover
  misato -auto "https://missav.ai/sw-950" "https://missav.ai/dandy-917"
  misato -auto "https://missav.ai/sw-950" -proxy localhost:7890
  misato -auth misato@gmail.com miyukiQAQ -ffmpeg -noban -limit 20
  misato -file /home/misato/url.txt -ffmpeg -title -limit 20
  misato -search sw-950 -ffcover -quality 720
```

## 💬 The ```-auto``` option

- Use the -auto option to download movies from a playlist.
- This playlist can be a public playlist created by your own account, or any playlist displayed based on search results or tag filters.
- **You should wrap the playlist URL with " " when you use the -auto option.**

Command Examples:
- ```misato -auto "https://missav.ai/search/JULIA?filters=uncensored-leak&sort=saved" -limit 50 -ffmpeg```
- ```misato -auto "https://missav.ai/search/JULIA?filters=individual&sort=views" -limit 20 -ffmpeg```
- ```misato -auto "https://missav.ai/dm132/actresses/JULIA" -limit 20 -ffmpeg```
- ```misato -auto "https://missav.ai/playlists/ewzoukev" -limit 20 -ffmpeg```
- ```misato -auto "https://missav.ai/dm444/en/labels/WANZ" -limit 20 -ffmpeg```
- ```misato -auto "https://missav.ai/dm21/en/makers/Takara%20Visual" -limit 20 -ffmpeg```
- ```misato -auto "https://missav.ai/dm1/en/genres/4K" -limit 20 -ffmpeg```

## 💡 Precautions

- If you are from an ancient oriental country, you will most likely need a proxy.
- Use ffmpeg to synthesize videos for the best experience.

## 👀 About FFmpeg

1. If you want misato to use ffmpeg to process the video, use the -ffmpeg option.
2. Please check whether the ffmpeg command is valid before using the -ffmpeg option. (e.g. ```ffmpeg -version```)
3. To install FFmpeg, please refer to https://ffmpeg.org/

## 📄 Disclaimer

This project is licensed under the [MIT License](LICENSE). The following additional disclaimers and notices apply:

### 1. Legal Compliance
- This software is provided solely for **communication, research, learning, and personal use**.  
- Users are responsible for ensuring that their use of this software complies with all applicable laws and regulations in their jurisdiction.  
- The software must not be used for any unlawful, unethical, or unauthorized purposes, including but not limited to violating third-party rights or legal restrictions.

### 2. No Warranty
As stated in the MIT License:  
> "THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT."

### 3. Limitation of Liability
- The author(s) shall not be held liable for any claims, damages, or other liabilities arising from or in connection with the use or performance of this software.  
- Users bear all risks and responsibilities for the use of this software, including but not limited to data loss, system damage, or legal consequences.

### 4. Third-Party Dependencies
- This project may include or depend on third-party libraries or tools. Users are responsible for reviewing and complying with the licenses and terms of these dependencies.

### 5. Security and Privacy
- This software may interact with user systems, networks, or data. Users should implement appropriate security measures to protect sensitive information and infrastructure.  
- The authors are not responsible for any security vulnerabilities or data breaches resulting from the use of this software.
