from _typeshed import Incomplete
from typing import Callable, TextIO

LANGUAGES: Incomplete
TO_LANGUAGE_CODE: Incomplete
LANGUAGES_WITHOUT_SPACES: Incomplete
system_encoding: Incomplete

def make_safe(string): ...
def exact_div(x, y): ...
def str2bool(string): ...
def optional_int(string): ...
def optional_float(string): ...
def compression_ratio(text) -> float: ...
def format_timestamp(
    seconds: float, always_include_hours: bool = False, decimal_marker: str = "."
): ...

class ResultWriter:
    extension: str
    output_dir: Incomplete
    def __init__(self, output_dir: str) -> None: ...
    def __call__(self, result: dict, audio_path: str, options: dict): ...
    def write_result(self, result: dict, file: TextIO, options: dict): ...

class WriteTXT(ResultWriter):
    extension: str
    def write_result(self, result: dict, file: TextIO, options: dict): ...

class SubtitlesWriter(ResultWriter):
    always_include_hours: bool
    decimal_marker: str
    def iterate_result(self, result: dict, options: dict): ...
    def format_timestamp(self, seconds: float): ...

class WriteVTT(SubtitlesWriter):
    extension: str
    always_include_hours: bool
    decimal_marker: str
    def write_result(self, result: dict, file: TextIO, options: dict): ...

class WriteSRT(SubtitlesWriter):
    extension: str
    always_include_hours: bool
    decimal_marker: str
    def write_result(self, result: dict, file: TextIO, options: dict): ...

class WriteTSV(ResultWriter):
    extension: str
    def write_result(self, result: dict, file: TextIO, options: dict): ...

class WriteAudacity(ResultWriter):
    extension: str
    def write_result(self, result: dict, file: TextIO, options: dict): ...

class WriteJSON(ResultWriter):
    extension: str
    def write_result(self, result: dict, file: TextIO, options: dict): ...

def get_writer(
    output_format: str, output_dir: str
) -> Callable[[dict, TextIO, dict], None]: ...
def interpolate_nans(x, method: str = "nearest"): ...
