# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.drive_agent_response import DriveAgentResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawDriveClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def invoke(
        self,
        *,
        config: typing.Dict[str, typing.Optional[typing.Any]],
        messages: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DriveAgentResponse]:
        """
        Coming soon! Manage folders and search for files in the internal drive.

        Parameters
        ----------
        config : typing.Dict[str, typing.Optional[typing.Any]]
            Configuration for the drive agent including folder paths and search parameters

        messages : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]
            The messages to send to the drive agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DriveAgentResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v0/agents/drive/invoke",
            method="POST",
            json={
                "config": config,
                "messages": messages,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DriveAgentResponse,
                    parse_obj_as(
                        type_=DriveAgentResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawDriveClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def invoke(
        self,
        *,
        config: typing.Dict[str, typing.Optional[typing.Any]],
        messages: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DriveAgentResponse]:
        """
        Coming soon! Manage folders and search for files in the internal drive.

        Parameters
        ----------
        config : typing.Dict[str, typing.Optional[typing.Any]]
            Configuration for the drive agent including folder paths and search parameters

        messages : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]
            The messages to send to the drive agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DriveAgentResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v0/agents/drive/invoke",
            method="POST",
            json={
                "config": config,
                "messages": messages,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DriveAgentResponse,
                    parse_obj_as(
                        type_=DriveAgentResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
