# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.general_agent_request import GeneralAgentRequest
from ...types.general_agent_response import GeneralAgentResponse
from .raw_client import AsyncRawGeneralClient, RawGeneralClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class GeneralClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawGeneralClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawGeneralClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawGeneralClient
        """
        return self._raw_client

    def batch(
        self, *, request: typing.Sequence[GeneralAgentRequest], request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[GeneralAgentResponse]:
        """
        Coming soon! Call the general agent with batched requests and return the results.

        Parameters
        ----------
        request : typing.Sequence[GeneralAgentRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[GeneralAgentResponse]
            Successful Response

        Examples
        --------
        from athena import Athena, GeneralAgentConfig, GeneralAgentRequest, InputMessage

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.agents.general.batch(
            request=[
                GeneralAgentRequest(
                    config=GeneralAgentConfig(
                        enabled_tools=[],
                    ),
                    messages=[
                        InputMessage(
                            content="Please call the search tool for AAPL news.",
                            role="user",
                        )
                    ],
                )
            ],
        )
        """
        _response = self._raw_client.batch(request=request, request_options=request_options)
        return _response.data

    def invoke(
        self, *, request: GeneralAgentRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> GeneralAgentResponse:
        """
        Call the general Athena agent synchronously.

        Call the agent with the messages list, wait for the agent to complete,
        and return the result.

        Parameters
        ----------
        request : GeneralAgentRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GeneralAgentResponse
            Successful Response

        Examples
        --------
        from athena import Athena, GeneralAgentConfig, GeneralAgentRequest, InputMessage

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.agents.general.invoke(
            request=GeneralAgentRequest(
                config=GeneralAgentConfig(
                    enabled_tools=[],
                ),
                messages=[
                    InputMessage(
                        content="Please call the search tool for AAPL news.",
                        role="user",
                    )
                ],
            ),
        )
        """
        _response = self._raw_client.invoke(request=request, request_options=request_options)
        return _response.data

    def stream_events(
        self, *, request: GeneralAgentRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> GeneralAgentResponse:
        """
        Coming soon! Call the general agent and stream events for real-time chat applications.

        Parameters
        ----------
        request : GeneralAgentRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GeneralAgentResponse
            Successful Response

        Examples
        --------
        from athena import Athena, GeneralAgentConfig, GeneralAgentRequest, InputMessage

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.agents.general.stream_events(
            request=GeneralAgentRequest(
                config=GeneralAgentConfig(
                    enabled_tools=[],
                ),
                messages=[
                    InputMessage(
                        content="Please call the search tool for AAPL news.",
                        role="user",
                    )
                ],
            ),
        )
        """
        _response = self._raw_client.stream_events(request=request, request_options=request_options)
        return _response.data


class AsyncGeneralClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawGeneralClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawGeneralClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawGeneralClient
        """
        return self._raw_client

    async def batch(
        self, *, request: typing.Sequence[GeneralAgentRequest], request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[GeneralAgentResponse]:
        """
        Coming soon! Call the general agent with batched requests and return the results.

        Parameters
        ----------
        request : typing.Sequence[GeneralAgentRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[GeneralAgentResponse]
            Successful Response

        Examples
        --------
        import asyncio

        from athena import (
            AsyncAthena,
            GeneralAgentConfig,
            GeneralAgentRequest,
            InputMessage,
        )

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.agents.general.batch(
                request=[
                    GeneralAgentRequest(
                        config=GeneralAgentConfig(
                            enabled_tools=[],
                        ),
                        messages=[
                            InputMessage(
                                content="Please call the search tool for AAPL news.",
                                role="user",
                            )
                        ],
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.batch(request=request, request_options=request_options)
        return _response.data

    async def invoke(
        self, *, request: GeneralAgentRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> GeneralAgentResponse:
        """
        Call the general Athena agent synchronously.

        Call the agent with the messages list, wait for the agent to complete,
        and return the result.

        Parameters
        ----------
        request : GeneralAgentRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GeneralAgentResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import (
            AsyncAthena,
            GeneralAgentConfig,
            GeneralAgentRequest,
            InputMessage,
        )

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.agents.general.invoke(
                request=GeneralAgentRequest(
                    config=GeneralAgentConfig(
                        enabled_tools=[],
                    ),
                    messages=[
                        InputMessage(
                            content="Please call the search tool for AAPL news.",
                            role="user",
                        )
                    ],
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.invoke(request=request, request_options=request_options)
        return _response.data

    async def stream_events(
        self, *, request: GeneralAgentRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> GeneralAgentResponse:
        """
        Coming soon! Call the general agent and stream events for real-time chat applications.

        Parameters
        ----------
        request : GeneralAgentRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GeneralAgentResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import (
            AsyncAthena,
            GeneralAgentConfig,
            GeneralAgentRequest,
            InputMessage,
        )

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.agents.general.stream_events(
                request=GeneralAgentRequest(
                    config=GeneralAgentConfig(
                        enabled_tools=[],
                    ),
                    messages=[
                        InputMessage(
                            content="Please call the search tool for AAPL news.",
                            role="user",
                        )
                    ],
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.stream_events(request=request, request_options=request_options)
        return _response.data
