# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import httpx
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .environment import AthenaEnvironment

if typing.TYPE_CHECKING:
    from .agents.client import AgentsClient, AsyncAgentsClient
    from .aop.client import AopClient, AsyncAopClient
    from .assets.client import AssetsClient, AsyncAssetsClient
    from .query.client import AsyncQueryClient, QueryClient
    from .threads.client import AsyncThreadsClient, ThreadsClient
    from .tools.client import AsyncToolsClient, ToolsClient


class BaseAthena:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : AthenaEnvironment
        The environment to use for requests from the client. from .environment import AthenaEnvironment



        Defaults to AthenaEnvironment.PRODUCTION



    api_key : str
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from athena import Athena

    client = Athena(
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: AthenaEnvironment = AthenaEnvironment.PRODUCTION,
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._agents: typing.Optional[AgentsClient] = None
        self._aop: typing.Optional[AopClient] = None
        self._assets: typing.Optional[AssetsClient] = None
        self._query: typing.Optional[QueryClient] = None
        self._threads: typing.Optional[ThreadsClient] = None
        self._tools: typing.Optional[ToolsClient] = None

    @property
    def agents(self):
        if self._agents is None:
            from .agents.client import AgentsClient  # noqa: E402

            self._agents = AgentsClient(client_wrapper=self._client_wrapper)
        return self._agents

    @property
    def aop(self):
        if self._aop is None:
            from .aop.client import AopClient  # noqa: E402

            self._aop = AopClient(client_wrapper=self._client_wrapper)
        return self._aop

    @property
    def assets(self):
        if self._assets is None:
            from .assets.client import AssetsClient  # noqa: E402

            self._assets = AssetsClient(client_wrapper=self._client_wrapper)
        return self._assets

    @property
    def query(self):
        if self._query is None:
            from .query.client import QueryClient  # noqa: E402

            self._query = QueryClient(client_wrapper=self._client_wrapper)
        return self._query

    @property
    def threads(self):
        if self._threads is None:
            from .threads.client import ThreadsClient  # noqa: E402

            self._threads = ThreadsClient(client_wrapper=self._client_wrapper)
        return self._threads

    @property
    def tools(self):
        if self._tools is None:
            from .tools.client import ToolsClient  # noqa: E402

            self._tools = ToolsClient(client_wrapper=self._client_wrapper)
        return self._tools


class AsyncBaseAthena:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : AthenaEnvironment
        The environment to use for requests from the client. from .environment import AthenaEnvironment



        Defaults to AthenaEnvironment.PRODUCTION



    api_key : str
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from athena import AsyncAthena

    client = AsyncAthena(
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: AthenaEnvironment = AthenaEnvironment.PRODUCTION,
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._agents: typing.Optional[AsyncAgentsClient] = None
        self._aop: typing.Optional[AsyncAopClient] = None
        self._assets: typing.Optional[AsyncAssetsClient] = None
        self._query: typing.Optional[AsyncQueryClient] = None
        self._threads: typing.Optional[AsyncThreadsClient] = None
        self._tools: typing.Optional[AsyncToolsClient] = None

    @property
    def agents(self):
        if self._agents is None:
            from .agents.client import AsyncAgentsClient  # noqa: E402

            self._agents = AsyncAgentsClient(client_wrapper=self._client_wrapper)
        return self._agents

    @property
    def aop(self):
        if self._aop is None:
            from .aop.client import AsyncAopClient  # noqa: E402

            self._aop = AsyncAopClient(client_wrapper=self._client_wrapper)
        return self._aop

    @property
    def assets(self):
        if self._assets is None:
            from .assets.client import AsyncAssetsClient  # noqa: E402

            self._assets = AsyncAssetsClient(client_wrapper=self._client_wrapper)
        return self._assets

    @property
    def query(self):
        if self._query is None:
            from .query.client import AsyncQueryClient  # noqa: E402

            self._query = AsyncQueryClient(client_wrapper=self._client_wrapper)
        return self._query

    @property
    def threads(self):
        if self._threads is None:
            from .threads.client import AsyncThreadsClient  # noqa: E402

            self._threads = AsyncThreadsClient(client_wrapper=self._client_wrapper)
        return self._threads

    @property
    def tools(self):
        if self._tools is None:
            from .tools.client import AsyncToolsClient  # noqa: E402

            self._tools = AsyncToolsClient(client_wrapper=self._client_wrapper)
        return self._tools


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: AthenaEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
