# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.thread_status_response_out import ThreadStatusResponseOut
from .raw_client import AsyncRawThreadsClient, RawThreadsClient


class ThreadsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawThreadsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawThreadsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawThreadsClient
        """
        return self._raw_client

    def get_status(
        self, thread_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ThreadStatusResponseOut:
        """
        Check the status of a thread execution by thread ID. Returns thread status and associated conversation asset information for tracking progress.

        Parameters
        ----------
        thread_id : str
            The unique thread ID to check status for

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ThreadStatusResponseOut
            Thread status retrieved successfully

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.threads.get_status(
            thread_id="thread_id",
        )
        """
        _response = self._raw_client.get_status(thread_id, request_options=request_options)
        return _response.data


class AsyncThreadsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawThreadsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawThreadsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawThreadsClient
        """
        return self._raw_client

    async def get_status(
        self, thread_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ThreadStatusResponseOut:
        """
        Check the status of a thread execution by thread ID. Returns thread status and associated conversation asset information for tracking progress.

        Parameters
        ----------
        thread_id : str
            The unique thread ID to check status for

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ThreadStatusResponseOut
            Thread status retrieved successfully

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.threads.get_status(
                thread_id="thread_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_status(thread_id, request_options=request_options)
        return _response.data
