# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from .raw_client import AsyncRawEmailClient, RawEmailClient


class EmailClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawEmailClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawEmailClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawEmailClient
        """
        return self._raw_client

    def create_draft(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.Optional[typing.Any]:
        """
        Coming soon! Create email drafts with specified content and recipients.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.email.create_draft()
        """
        _response = self._raw_client.create_draft(request_options=request_options)
        return _response.data

    def search(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.Optional[typing.Any]:
        """
        Coming soon! Search through emails with configurable filters.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.email.search()
        """
        _response = self._raw_client.search(request_options=request_options)
        return _response.data

    def send(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.Optional[typing.Any]:
        """
        Coming soon! Send emails to specified recipients.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.email.send()
        """
        _response = self._raw_client.send(request_options=request_options)
        return _response.data


class AsyncEmailClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawEmailClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawEmailClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawEmailClient
        """
        return self._raw_client

    async def create_draft(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Coming soon! Create email drafts with specified content and recipients.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.email.create_draft()


        asyncio.run(main())
        """
        _response = await self._raw_client.create_draft(request_options=request_options)
        return _response.data

    async def search(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.Optional[typing.Any]:
        """
        Coming soon! Search through emails with configurable filters.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.email.search()


        asyncio.run(main())
        """
        _response = await self._raw_client.search(request_options=request_options)
        return _response.data

    async def send(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.Optional[typing.Any]:
        """
        Coming soon! Send emails to specified recipients.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.email.send()


        asyncio.run(main())
        """
        _response = await self._raw_client.send(request_options=request_options)
        return _response.data
