# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.cell_format import CellFormat
from ...types.create_new_sheet_tab_response import CreateNewSheetTabResponse
from ...types.get_table_response import GetTableResponse
from ...types.sheet import Sheet
from ...types.sheet_operation_response import SheetOperationResponse
from ...types.table_row_data import TableRowData
from .raw_client import AsyncRawSheetsClient, RawSheetsClient
from .types.update_sheet_range_request_values_item_item import UpdateSheetRangeRequestValuesItemItem

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SheetsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSheetsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSheetsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSheetsClient
        """
        return self._raw_client

    def update_cell(
        self,
        *,
        asset_id: str,
        column: int,
        row: int,
        value: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Update a single cell in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        column : int
            1-based column index (e.g., 1 = column A)

        row : int
            1-based row index (e.g., 1 = first row)

        value : str
            Value to set in the cell

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.sheets.update_cell(
            asset_id="asset_id",
            column=1,
            row=1,
            value="value",
        )
        """
        _response = self._raw_client.update_cell(
            asset_id=asset_id, column=column, row=row, value=value, sheet_id=sheet_id, request_options=request_options
        )
        return _response.data

    def delete_cells(
        self,
        *,
        asset_id: str,
        end_column_index: int,
        end_row_index: int,
        start_column_index: int,
        start_row_index: int,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Delete cells from an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        end_column_index : int
            1-based ending column index

        end_row_index : int
            1-based ending row index

        start_column_index : int
            1-based starting column index

        start_row_index : int
            1-based starting row index

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.sheets.delete_cells(
            asset_id="asset_id",
            end_column_index=1,
            end_row_index=1,
            start_column_index=1,
            start_row_index=1,
        )
        """
        _response = self._raw_client.delete_cells(
            asset_id=asset_id,
            end_column_index=end_column_index,
            end_row_index=end_row_index,
            start_column_index=start_column_index,
            start_row_index=start_row_index,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data

    def delete_column(
        self,
        *,
        asset_id: str,
        column_indexes: typing.Sequence[int],
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Delete columns from an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        column_indexes : typing.Sequence[int]
            List of 1-based column indexes to delete

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.sheets.delete_column(
            asset_id="asset_id",
            column_indexes=[1],
        )
        """
        _response = self._raw_client.delete_column(
            asset_id=asset_id, column_indexes=column_indexes, sheet_id=sheet_id, request_options=request_options
        )
        return _response.data

    def insert_column(
        self,
        *,
        asset_id: str,
        reference_column_index: int,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Insert a column in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        reference_column_index : int
            1-based reference column index where to insert

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.sheets.insert_column(
            asset_id="asset_id",
            reference_column_index=1,
        )
        """
        _response = self._raw_client.insert_column(
            asset_id=asset_id,
            reference_column_index=reference_column_index,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data

    def clear_formatting(
        self,
        *,
        asset_id: str,
        end_column_index: int,
        end_row_index: int,
        start_column_index: int,
        start_row_index: int,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Clear formatting from cells in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        end_column_index : int
            1-based ending column index

        end_row_index : int
            1-based ending row index

        start_column_index : int
            1-based starting column index

        start_row_index : int
            1-based starting row index

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.sheets.clear_formatting(
            asset_id="asset_id",
            end_column_index=1,
            end_row_index=1,
            start_column_index=1,
            start_row_index=1,
        )
        """
        _response = self._raw_client.clear_formatting(
            asset_id=asset_id,
            end_column_index=end_column_index,
            end_row_index=end_row_index,
            start_column_index=start_column_index,
            start_row_index=start_row_index,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data

    def clear_range(
        self,
        *,
        asset_id: str,
        num_columns: int,
        num_rows: int,
        start_column: int,
        start_row: int,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Clear a range of cells in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        num_columns : int
            Number of columns to clear

        num_rows : int
            Number of rows to clear

        start_column : int
            1-based starting column index

        start_row : int
            1-based starting row index

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.sheets.clear_range(
            asset_id="asset_id",
            num_columns=1,
            num_rows=1,
            start_column=1,
            start_row=1,
        )
        """
        _response = self._raw_client.clear_range(
            asset_id=asset_id,
            num_columns=num_columns,
            num_rows=num_rows,
            start_column=start_column,
            start_row=start_row,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data

    def format_range(
        self,
        *,
        asset_id: str,
        end_column: int,
        end_row: int,
        formatting: CellFormat,
        start_column: int,
        start_row: int,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Apply formatting to a range of cells in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        end_column : int
            1-based ending column index

        end_row : int
            1-based ending row index

        formatting : CellFormat
            Cell format

        start_column : int
            1-based starting column index

        start_row : int
            1-based starting row index

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        from athena import Athena, CellFormat

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.sheets.format_range(
            asset_id="asset_id",
            end_column=1,
            end_row=1,
            formatting=CellFormat(),
            start_column=1,
            start_row=1,
        )
        """
        _response = self._raw_client.format_range(
            asset_id=asset_id,
            end_column=end_column,
            end_row=end_row,
            formatting=formatting,
            start_column=start_column,
            start_row=start_row,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data

    def update_range(
        self,
        *,
        asset_id: str,
        start_column: int,
        start_row: int,
        values: typing.Sequence[typing.Sequence[typing.Optional[UpdateSheetRangeRequestValuesItemItem]]],
        formatting: typing.Optional[typing.Sequence[typing.Sequence[typing.Optional[CellFormat]]]] = OMIT,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Update a range of cells in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        start_column : int
            1-based starting column index

        start_row : int
            1-based starting row index

        values : typing.Sequence[typing.Sequence[typing.Optional[UpdateSheetRangeRequestValuesItemItem]]]
            2D list of cells for each row

        formatting : typing.Optional[typing.Sequence[typing.Sequence[typing.Optional[CellFormat]]]]
            Optional 2D list of cell formats matching the structure of values. Each row is a list of CellFormat objects for each cell in that row. Use None for cells without formatting. numberFormat is not required unless user explicity asked to change

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.sheets.update_range(
            asset_id="asset_id",
            start_column=1,
            start_row=1,
            values=[[]],
        )
        """
        _response = self._raw_client.update_range(
            asset_id=asset_id,
            start_column=start_column,
            start_row=start_row,
            values=values,
            formatting=formatting,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data

    def insert_row(
        self,
        *,
        asset_id: str,
        reference_row_index: int,
        num_rows: typing.Optional[int] = OMIT,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Insert a row in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        reference_row_index : int
            1-based reference row index where to insert

        num_rows : typing.Optional[int]
            Number of rows to insert

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.sheets.insert_row(
            asset_id="asset_id",
            reference_row_index=1,
        )
        """
        _response = self._raw_client.insert_row(
            asset_id=asset_id,
            reference_row_index=reference_row_index,
            num_rows=num_rows,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data

    def duplicate_sheet(
        self,
        *,
        asset_id: str,
        new_sheet_id: typing.Optional[int] = OMIT,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Duplicate an existing sheet in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        new_sheet_id : typing.Optional[int]
            New sheet ID for the duplicated sheet (auto-generated if not provided)

        sheet_id : typing.Optional[int]
            Sheet ID to duplicate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.sheets.duplicate_sheet(
            asset_id="asset_id",
        )
        """
        _response = self._raw_client.duplicate_sheet(
            asset_id=asset_id, new_sheet_id=new_sheet_id, sheet_id=sheet_id, request_options=request_options
        )
        return _response.data

    def create_tab(
        self, *, asset_id: str, sheet: Sheet, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateNewSheetTabResponse:
        """
        Create a new tab in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        sheet : Sheet
            Sheet Specification

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateNewSheetTabResponse
            Successful Response

        Examples
        --------
        from athena import Athena, Sheet

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.sheets.create_tab(
            asset_id="asset_id",
            sheet=Sheet(
                column_count=1,
                index=1,
                row_count=1,
                sheet_id=1,
                title="title",
            ),
        )
        """
        _response = self._raw_client.create_tab(asset_id=asset_id, sheet=sheet, request_options=request_options)
        return _response.data

    def delete_table_column(
        self,
        *,
        asset_id: str,
        dimension_index: int,
        table_id: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Delete a column from a table within an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        dimension_index : int
            0-based dimension index within the table

        table_id : str
            Table ID where to delete column

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.sheets.delete_table_column(
            asset_id="asset_id",
            dimension_index=1,
            table_id="table_id",
        )
        """
        _response = self._raw_client.delete_table_column(
            asset_id=asset_id,
            dimension_index=dimension_index,
            table_id=table_id,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data

    def insert_table_column(
        self,
        *,
        asset_id: str,
        dimension_index: int,
        direction: str,
        table_id: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Insert a column in a table within an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        dimension_index : int
            0-based dimension index within the table

        direction : str
            Direction of insertion (left or right)

        table_id : str
            Table ID where to insert column

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.sheets.insert_table_column(
            asset_id="asset_id",
            dimension_index=1,
            direction="direction",
            table_id="table_id",
        )
        """
        _response = self._raw_client.insert_table_column(
            asset_id=asset_id,
            dimension_index=dimension_index,
            direction=direction,
            table_id=table_id,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data

    def create_table(
        self,
        *,
        asset_id: str,
        end_column_index: int,
        end_row_index: int,
        start_column_index: int,
        start_row_index: int,
        table_id: str,
        table_name: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Create a table in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        end_column_index : int
            1-based ending column index

        end_row_index : int
            1-based ending row index

        start_column_index : int
            1-based starting column index

        start_row_index : int
            1-based starting row index

        table_id : str
            Unique table ID

        table_name : str
            Name of the table

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.sheets.create_table(
            asset_id="asset_id",
            end_column_index=1,
            end_row_index=1,
            start_column_index=1,
            start_row_index=1,
            table_id="table_id",
            table_name="table_name",
        )
        """
        _response = self._raw_client.create_table(
            asset_id=asset_id,
            end_column_index=end_column_index,
            end_row_index=end_row_index,
            start_column_index=start_column_index,
            start_row_index=start_row_index,
            table_id=table_id,
            table_name=table_name,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data

    def get_table(
        self,
        *,
        asset_id: str,
        table_name: str,
        table_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetTableResponse:
        """
        Retrieve table data from an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        table_name : str
            Table name to retrieve

        table_id : typing.Optional[str]
            Table ID to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTableResponse
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.sheets.get_table(
            asset_id="asset_id",
            table_name="table_name",
        )
        """
        _response = self._raw_client.get_table(
            asset_id=asset_id, table_name=table_name, table_id=table_id, request_options=request_options
        )
        return _response.data

    def insert_table_row(
        self,
        *,
        asset_id: str,
        row_data: typing.Sequence[TableRowData],
        table_name: str,
        table_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Insert rows into a table in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        row_data : typing.Sequence[TableRowData]
            Array of row objects where keys are column names and values are cell values

        table_name : str
            Table name to insert row into

        table_id : typing.Optional[str]
            Table ID to insert row into

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.sheets.insert_table_row(
            asset_id="asset_id",
            row_data=[{"key": "value"}],
            table_name="table_name",
        )
        """
        _response = self._raw_client.insert_table_row(
            asset_id=asset_id,
            row_data=row_data,
            table_name=table_name,
            table_id=table_id,
            request_options=request_options,
        )
        return _response.data

    def update_table(
        self,
        *,
        asset_id: str,
        end_column_index: int,
        end_row_index: int,
        start_column_index: int,
        start_row_index: int,
        table_id: str,
        table_name: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Update an existing table in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        end_column_index : int
            1-based ending column index

        end_row_index : int
            1-based ending row index

        start_column_index : int
            1-based starting column index

        start_row_index : int
            1-based starting row index

        table_id : str
            Table ID to update

        table_name : str
            Name of the table

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.tools.sheets.update_table(
            asset_id="asset_id",
            end_column_index=1,
            end_row_index=1,
            start_column_index=1,
            start_row_index=1,
            table_id="table_id",
            table_name="table_name",
        )
        """
        _response = self._raw_client.update_table(
            asset_id=asset_id,
            end_column_index=end_column_index,
            end_row_index=end_row_index,
            start_column_index=start_column_index,
            start_row_index=start_row_index,
            table_id=table_id,
            table_name=table_name,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data


class AsyncSheetsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSheetsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSheetsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSheetsClient
        """
        return self._raw_client

    async def update_cell(
        self,
        *,
        asset_id: str,
        column: int,
        row: int,
        value: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Update a single cell in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        column : int
            1-based column index (e.g., 1 = column A)

        row : int
            1-based row index (e.g., 1 = first row)

        value : str
            Value to set in the cell

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.sheets.update_cell(
                asset_id="asset_id",
                column=1,
                row=1,
                value="value",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_cell(
            asset_id=asset_id, column=column, row=row, value=value, sheet_id=sheet_id, request_options=request_options
        )
        return _response.data

    async def delete_cells(
        self,
        *,
        asset_id: str,
        end_column_index: int,
        end_row_index: int,
        start_column_index: int,
        start_row_index: int,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Delete cells from an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        end_column_index : int
            1-based ending column index

        end_row_index : int
            1-based ending row index

        start_column_index : int
            1-based starting column index

        start_row_index : int
            1-based starting row index

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.sheets.delete_cells(
                asset_id="asset_id",
                end_column_index=1,
                end_row_index=1,
                start_column_index=1,
                start_row_index=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_cells(
            asset_id=asset_id,
            end_column_index=end_column_index,
            end_row_index=end_row_index,
            start_column_index=start_column_index,
            start_row_index=start_row_index,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data

    async def delete_column(
        self,
        *,
        asset_id: str,
        column_indexes: typing.Sequence[int],
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Delete columns from an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        column_indexes : typing.Sequence[int]
            List of 1-based column indexes to delete

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.sheets.delete_column(
                asset_id="asset_id",
                column_indexes=[1],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_column(
            asset_id=asset_id, column_indexes=column_indexes, sheet_id=sheet_id, request_options=request_options
        )
        return _response.data

    async def insert_column(
        self,
        *,
        asset_id: str,
        reference_column_index: int,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Insert a column in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        reference_column_index : int
            1-based reference column index where to insert

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.sheets.insert_column(
                asset_id="asset_id",
                reference_column_index=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.insert_column(
            asset_id=asset_id,
            reference_column_index=reference_column_index,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data

    async def clear_formatting(
        self,
        *,
        asset_id: str,
        end_column_index: int,
        end_row_index: int,
        start_column_index: int,
        start_row_index: int,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Clear formatting from cells in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        end_column_index : int
            1-based ending column index

        end_row_index : int
            1-based ending row index

        start_column_index : int
            1-based starting column index

        start_row_index : int
            1-based starting row index

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.sheets.clear_formatting(
                asset_id="asset_id",
                end_column_index=1,
                end_row_index=1,
                start_column_index=1,
                start_row_index=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.clear_formatting(
            asset_id=asset_id,
            end_column_index=end_column_index,
            end_row_index=end_row_index,
            start_column_index=start_column_index,
            start_row_index=start_row_index,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data

    async def clear_range(
        self,
        *,
        asset_id: str,
        num_columns: int,
        num_rows: int,
        start_column: int,
        start_row: int,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Clear a range of cells in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        num_columns : int
            Number of columns to clear

        num_rows : int
            Number of rows to clear

        start_column : int
            1-based starting column index

        start_row : int
            1-based starting row index

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.sheets.clear_range(
                asset_id="asset_id",
                num_columns=1,
                num_rows=1,
                start_column=1,
                start_row=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.clear_range(
            asset_id=asset_id,
            num_columns=num_columns,
            num_rows=num_rows,
            start_column=start_column,
            start_row=start_row,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data

    async def format_range(
        self,
        *,
        asset_id: str,
        end_column: int,
        end_row: int,
        formatting: CellFormat,
        start_column: int,
        start_row: int,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Apply formatting to a range of cells in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        end_column : int
            1-based ending column index

        end_row : int
            1-based ending row index

        formatting : CellFormat
            Cell format

        start_column : int
            1-based starting column index

        start_row : int
            1-based starting row index

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena, CellFormat

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.sheets.format_range(
                asset_id="asset_id",
                end_column=1,
                end_row=1,
                formatting=CellFormat(),
                start_column=1,
                start_row=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.format_range(
            asset_id=asset_id,
            end_column=end_column,
            end_row=end_row,
            formatting=formatting,
            start_column=start_column,
            start_row=start_row,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data

    async def update_range(
        self,
        *,
        asset_id: str,
        start_column: int,
        start_row: int,
        values: typing.Sequence[typing.Sequence[typing.Optional[UpdateSheetRangeRequestValuesItemItem]]],
        formatting: typing.Optional[typing.Sequence[typing.Sequence[typing.Optional[CellFormat]]]] = OMIT,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Update a range of cells in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        start_column : int
            1-based starting column index

        start_row : int
            1-based starting row index

        values : typing.Sequence[typing.Sequence[typing.Optional[UpdateSheetRangeRequestValuesItemItem]]]
            2D list of cells for each row

        formatting : typing.Optional[typing.Sequence[typing.Sequence[typing.Optional[CellFormat]]]]
            Optional 2D list of cell formats matching the structure of values. Each row is a list of CellFormat objects for each cell in that row. Use None for cells without formatting. numberFormat is not required unless user explicity asked to change

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.sheets.update_range(
                asset_id="asset_id",
                start_column=1,
                start_row=1,
                values=[[]],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_range(
            asset_id=asset_id,
            start_column=start_column,
            start_row=start_row,
            values=values,
            formatting=formatting,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data

    async def insert_row(
        self,
        *,
        asset_id: str,
        reference_row_index: int,
        num_rows: typing.Optional[int] = OMIT,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Insert a row in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        reference_row_index : int
            1-based reference row index where to insert

        num_rows : typing.Optional[int]
            Number of rows to insert

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.sheets.insert_row(
                asset_id="asset_id",
                reference_row_index=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.insert_row(
            asset_id=asset_id,
            reference_row_index=reference_row_index,
            num_rows=num_rows,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data

    async def duplicate_sheet(
        self,
        *,
        asset_id: str,
        new_sheet_id: typing.Optional[int] = OMIT,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Duplicate an existing sheet in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        new_sheet_id : typing.Optional[int]
            New sheet ID for the duplicated sheet (auto-generated if not provided)

        sheet_id : typing.Optional[int]
            Sheet ID to duplicate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.sheets.duplicate_sheet(
                asset_id="asset_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.duplicate_sheet(
            asset_id=asset_id, new_sheet_id=new_sheet_id, sheet_id=sheet_id, request_options=request_options
        )
        return _response.data

    async def create_tab(
        self, *, asset_id: str, sheet: Sheet, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateNewSheetTabResponse:
        """
        Create a new tab in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        sheet : Sheet
            Sheet Specification

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateNewSheetTabResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena, Sheet

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.sheets.create_tab(
                asset_id="asset_id",
                sheet=Sheet(
                    column_count=1,
                    index=1,
                    row_count=1,
                    sheet_id=1,
                    title="title",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_tab(asset_id=asset_id, sheet=sheet, request_options=request_options)
        return _response.data

    async def delete_table_column(
        self,
        *,
        asset_id: str,
        dimension_index: int,
        table_id: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Delete a column from a table within an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        dimension_index : int
            0-based dimension index within the table

        table_id : str
            Table ID where to delete column

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.sheets.delete_table_column(
                asset_id="asset_id",
                dimension_index=1,
                table_id="table_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_table_column(
            asset_id=asset_id,
            dimension_index=dimension_index,
            table_id=table_id,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data

    async def insert_table_column(
        self,
        *,
        asset_id: str,
        dimension_index: int,
        direction: str,
        table_id: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Insert a column in a table within an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        dimension_index : int
            0-based dimension index within the table

        direction : str
            Direction of insertion (left or right)

        table_id : str
            Table ID where to insert column

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.sheets.insert_table_column(
                asset_id="asset_id",
                dimension_index=1,
                direction="direction",
                table_id="table_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.insert_table_column(
            asset_id=asset_id,
            dimension_index=dimension_index,
            direction=direction,
            table_id=table_id,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data

    async def create_table(
        self,
        *,
        asset_id: str,
        end_column_index: int,
        end_row_index: int,
        start_column_index: int,
        start_row_index: int,
        table_id: str,
        table_name: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Create a table in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        end_column_index : int
            1-based ending column index

        end_row_index : int
            1-based ending row index

        start_column_index : int
            1-based starting column index

        start_row_index : int
            1-based starting row index

        table_id : str
            Unique table ID

        table_name : str
            Name of the table

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.sheets.create_table(
                asset_id="asset_id",
                end_column_index=1,
                end_row_index=1,
                start_column_index=1,
                start_row_index=1,
                table_id="table_id",
                table_name="table_name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_table(
            asset_id=asset_id,
            end_column_index=end_column_index,
            end_row_index=end_row_index,
            start_column_index=start_column_index,
            start_row_index=start_row_index,
            table_id=table_id,
            table_name=table_name,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data

    async def get_table(
        self,
        *,
        asset_id: str,
        table_name: str,
        table_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetTableResponse:
        """
        Retrieve table data from an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        table_name : str
            Table name to retrieve

        table_id : typing.Optional[str]
            Table ID to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTableResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.sheets.get_table(
                asset_id="asset_id",
                table_name="table_name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_table(
            asset_id=asset_id, table_name=table_name, table_id=table_id, request_options=request_options
        )
        return _response.data

    async def insert_table_row(
        self,
        *,
        asset_id: str,
        row_data: typing.Sequence[TableRowData],
        table_name: str,
        table_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Insert rows into a table in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        row_data : typing.Sequence[TableRowData]
            Array of row objects where keys are column names and values are cell values

        table_name : str
            Table name to insert row into

        table_id : typing.Optional[str]
            Table ID to insert row into

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.sheets.insert_table_row(
                asset_id="asset_id",
                row_data=[{"key": "value"}],
                table_name="table_name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.insert_table_row(
            asset_id=asset_id,
            row_data=row_data,
            table_name=table_name,
            table_id=table_id,
            request_options=request_options,
        )
        return _response.data

    async def update_table(
        self,
        *,
        asset_id: str,
        end_column_index: int,
        end_row_index: int,
        start_column_index: int,
        start_row_index: int,
        table_id: str,
        table_name: str,
        sheet_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SheetOperationResponse:
        """
        Update an existing table in an Athena spreadsheet.

        Parameters
        ----------
        asset_id : str
            The ID of the spreadsheet asset

        end_column_index : int
            1-based ending column index

        end_row_index : int
            1-based ending row index

        start_column_index : int
            1-based starting column index

        start_row_index : int
            1-based starting row index

        table_id : str
            Table ID to update

        table_name : str
            Name of the table

        sheet_id : typing.Optional[int]
            Sheet ID (defaults to 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SheetOperationResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.sheets.update_table(
                asset_id="asset_id",
                end_column_index=1,
                end_row_index=1,
                start_column_index=1,
                start_row_index=1,
                table_id="table_id",
                table_name="table_name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_table(
            asset_id=asset_id,
            end_column_index=end_column_index,
            end_row_index=end_row_index,
            start_column_index=start_column_index,
            start_row_index=start_row_index,
            table_id=table_id,
            table_name=table_name,
            sheet_id=sheet_id,
            request_options=request_options,
        )
        return _response.data
