# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .border_model import BorderModel


class BordersModel(UniversalBaseModel):
    """
    Border configuration for spreadsheet cells. Set individual borders (top, right, bottom, left) to apply borders around cells.

    Common border patterns:
    - All borders: Set all four sides (top, right, bottom, left) to create borders around every cell
    - Outer border only: For a range A1:C3, only the perimeter cells get borders (first row gets top, last row gets bottom, etc.)
    - Inner borders only: Only borders between cells, not on the outer edges
    - Horizontal lines: Set only top and/or bottom borders
    - Vertical lines: Set only left and/or right borders
    - Single side: Set only one border (e.g., just bottom for underline effect)

    Note: Borders are applied per-cell. Each cell's border properties control which edges of that specific cell have borders. Overlapping borders between adjacent cells will appear as a single line.

    Examples:
    - Box around range: Set all four borders on all cells in the range
    - Table with grid: Set all four borders to create a complete grid
    - Underline header: Set only bottom border on header row
    - Separate sections: Set bottom border to divide content
    """

    bottom: typing.Optional[BorderModel] = pydantic.Field(default=None)
    """
    Bottom border of the cell
    """

    left: typing.Optional[BorderModel] = pydantic.Field(default=None)
    """
    Left border of the cell
    """

    right: typing.Optional[BorderModel] = pydantic.Field(default=None)
    """
    Right border of the cell
    """

    top: typing.Optional[BorderModel] = pydantic.Field(default=None)
    """
    Top border of the cell
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
