# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .conversation_message import ConversationMessage


class ConversationAssetInfo(UniversalBaseModel):
    """
    Conversation asset information associated with a thread.
    """

    agent: typing.Optional[str] = pydantic.Field(default=None)
    """
    Agent configuration used in conversation
    """

    athena_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Complete athena metadata for the conversation asset
    """

    conversation_asset_id: str = pydantic.Field()
    """
    ID of the conversation asset
    """

    created_at: str = pydantic.Field()
    """
    ISO timestamp when conversation was created
    """

    created_by: str = pydantic.Field()
    """
    User ID who created the conversation
    """

    last_channel: typing.Optional[str] = pydantic.Field(default=None)
    """
    Last active channel for the conversation
    """

    last_message: typing.Optional[ConversationMessage] = pydantic.Field(default=None)
    """
    Last message in the conversation
    """

    linked_aops: typing.Optional[typing.List[typing.Dict[str, typing.Optional[typing.Any]]]] = pydantic.Field(
        default=None
    )
    """
    List of linked AOP assets
    """

    linked_projects: typing.Optional[typing.List[typing.Dict[str, typing.Optional[typing.Any]]]] = pydantic.Field(
        default=None
    )
    """
    List of linked project assets
    """

    messages: typing.Optional[typing.List[ConversationMessage]] = pydantic.Field(default=None)
    """
    Complete list of messages in the conversation from checkpoints
    """

    model: typing.Optional[str] = pydantic.Field(default=None)
    """
    Model used in conversation
    """

    num_messages: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of messages in the conversation
    """

    start_channel: typing.Optional[str] = pydantic.Field(default=None)
    """
    Channel where conversation was started
    """

    state: typing.Optional[str] = pydantic.Field(default=None)
    """
    Current state of the conversation (e.g., 'running', 'completed')
    """

    title: str = pydantic.Field()
    """
    Title of the conversation
    """

    updated_at: str = pydantic.Field()
    """
    ISO timestamp when conversation was last updated
    """

    workspace_id: str = pydantic.Field()
    """
    Workspace ID where conversation exists
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
