# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .content import Content
from .general_agent_response_message_kwargs import GeneralAgentResponseMessageKwargs
from .id import Id


class GeneralAgentResponseMessage(UniversalBaseModel):
    """
    A response message from the agent.
    """

    additional_kwargs: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Additional keyword arguments for the message.
    """

    content: typing.Optional[Content] = pydantic.Field(default=None)
    """
    The content of the message, can be string or list of content parts.
    """

    id: typing.Optional[Id] = pydantic.Field(default=None)
    """
    Unique identifier for the message or LangChain class identifier.
    """

    kwargs_: typing_extensions.Annotated[
        typing.Optional[GeneralAgentResponseMessageKwargs], FieldMetadata(alias="kwargs")
    ] = pydantic.Field(default=None)
    """
    Structured kwargs field containing known message data.
    """

    langchain_id: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    LangChain class identifier
    """

    lc: typing.Optional[int] = pydantic.Field(default=None)
    """
    LangChain version marker
    """

    message_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The actual message identifier (when id contains LangChain class path).
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name associated with the message.
    """

    response_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Metadata about the response generation.
    """

    role: typing.Optional[str] = pydantic.Field(default=None)
    """
    Role of the message sender (e.g., 'ai', 'human', 'system', 'tool'). Automatically populated from kwargs.type for convenience.
    """

    tool_call_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the tool call this message responds to (for tool messages).
    """

    tool_calls: typing.Optional[typing.List[typing.Dict[str, typing.Optional[typing.Any]]]] = pydantic.Field(
        default=None
    )
    """
    Tool calls made by the message (for AI messages).
    """

    type: str = pydantic.Field()
    """
    The type of the message (e.g., 'human', 'ai', 'system', 'tool').
    """

    usage_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Usage metadata including token counts.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
