# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class GetTableResponse(UniversalBaseModel):
    asset_id: str = pydantic.Field()
    """
    The ID of the spreadsheet asset
    """

    columns: typing.List[typing.Dict[str, str]] = pydantic.Field()
    """
    Array of column objects with name and other metadata
    """

    message: str = pydantic.Field()
    """
    Success message or error description
    """

    rows: typing.List[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field()
    """
    Array of row objects with column names as keys
    """

    success: bool = pydantic.Field()
    """
    Whether the operation was successful
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
