# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class GridRange(UniversalBaseModel):
    end_column_index: typing_extensions.Annotated[int, FieldMetadata(alias="endColumnIndex")] = pydantic.Field()
    """
    End column index (1-based, INCLUSIVE). Last column of the range. For range A1:C5, this would be 3. For single columns, equals startColumnIndex.
    """

    end_row_index: typing_extensions.Annotated[int, FieldMetadata(alias="endRowIndex")] = pydantic.Field()
    """
    End row index (1-based, INCLUSIVE). Last row of the range. For a range A1:A5, this would be 5. For single cells, equals startRowIndex.
    """

    start_column_index: typing_extensions.Annotated[int, FieldMetadata(alias="startColumnIndex")] = pydantic.Field()
    """
    Start column index (1-based, INCLUSIVE). First column of the range. A=1, B=2, C=3, etc. For range A1:C5, this would be 1.
    """

    start_row_index: typing_extensions.Annotated[int, FieldMetadata(alias="startRowIndex")] = pydantic.Field()
    """
    Start row index (1-based, INCLUSIVE). First row of the range. For A1 this would be 1, for A5 this would be 5.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
