# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .number_format_type import NumberFormatType


class NumberFormatModel(UniversalBaseModel):
    pattern: str = pydantic.Field()
    """
    Excel-compatible format string. If omitted, the server will pick a sensible default based on the chosen type (e.g. NUMBER → '#,##0', CURRENCY → '$#,##0.00').
    """

    type: NumberFormatType = pydantic.Field()
    """
    Target number format category (NUMBER, CURRENCY, DATE, etc.)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
