# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .public_asset_out import PublicAssetOut


class PaginatedAssetsOut(UniversalBaseModel):
    """
    Paginated response containing a list of assets with pagination metadata.
    """

    has_more: bool = pydantic.Field()
    """
    Whether there are more assets available beyond this page
    """

    items: typing.List[PublicAssetOut] = pydantic.Field()
    """
    Array of asset objects for the current page
    """

    limit: int = pydantic.Field()
    """
    Maximum number of assets returned in this response (1-500)
    """

    next_offset: typing.Optional[int] = pydantic.Field(default=None)
    """
    Offset value to use for the next page request, null if no more pages
    """

    offset: int = pydantic.Field()
    """
    Number of assets skipped from the beginning of the result set
    """

    total: int = pydantic.Field()
    """
    Total number of assets matching the query filters
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
