# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .dimension_properties import DimensionProperties
from .grid_range import GridRange
from .tabcolor import Tabcolor


class Sheet(UniversalBaseModel):
    column_count: typing_extensions.Annotated[int, FieldMetadata(alias="columnCount")] = pydantic.Field()
    """
    Column count (Defaults to 100)
    """

    column_metadata: typing_extensions.Annotated[
        typing.Optional[typing.List[typing.Optional[DimensionProperties]]], FieldMetadata(alias="columnMetadata")
    ] = pydantic.Field(default=None)
    """
    Array of column properties, one per column (1-indexed). Each entry defines width, visibility for that column. Use to set custom column widths or hide/show specific columns. Example: columnMetadata[1] controls column A, columnMetadata[2] controls column B, etc. To set column C width to 150px: columnMetadata[3] = DimensionProperties(size=150). To hide column B: columnMetadata[2] = DimensionProperties(hiddenByUser=True). Common use case: Auto-size columns with wide content by setting larger size values
    """

    frozen_column_count: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="frozenColumnCount")] = (
        None
    )
    frozen_row_count: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="frozenRowCount")] = None
    hidden: typing.Optional[bool] = None
    index: int = pydantic.Field()
    """
    The order of the new sheet
    """

    merges: typing.Optional[typing.List[GridRange]] = pydantic.Field(default=None)
    """
    List of merged cell ranges in the sheet. Each merge combines multiple cells into a single cell. The top-left cell (startRowIndex, startColumnIndex) becomes the anchor cell that displays the content. Example: To merge cells A1:C3, use GridRange(startRowIndex=1, endRowIndex=3, startColumnIndex=1, endColumnIndex=3). Defaults to empty list (no merged cells).
    """

    row_count: typing_extensions.Annotated[int, FieldMetadata(alias="rowCount")] = pydantic.Field()
    """
    Row count (Defaults to 1000)
    """

    row_metadata: typing_extensions.Annotated[
        typing.Optional[typing.List[typing.Optional[DimensionProperties]]], FieldMetadata(alias="rowMetadata")
    ] = pydantic.Field(default=None)
    """
    Array of row properties, one per row (1-indexed). Each entry defines height, visibility for that row. Use to set custom row heights or hide/show specific rows. Example: rowMetadata[1] controls row 1, rowMetadata[2] controls row 2, etc. To set row 5 height to 50px: rowMetadata[5] = DimensionProperties(size=50). To hide row 3: rowMetadata[3] = DimensionProperties(hiddenByUser=True)
    """

    sheet_id: typing_extensions.Annotated[int, FieldMetadata(alias="sheetId")] = pydantic.Field()
    """
    Sheet ID (required)
    """

    show_grid_lines: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="showGridLines")] = None
    tab_color: typing_extensions.Annotated[typing.Optional[Tabcolor], FieldMetadata(alias="tabColor")] = pydantic.Field(
        default=None
    )
    """
    Tab color in hex format (e.g., '#FF0000' for red) or as a theme
    """

    title: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
