# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .conversation_asset_info import ConversationAssetInfo


class ThreadStatusResponseOut(UniversalBaseModel):
    """
    Response model for thread status check.
    """

    conversation_asset: typing.Optional[ConversationAssetInfo] = pydantic.Field(default=None)
    """
    Information about the associated conversation asset
    """

    created_at: str = pydantic.Field()
    """
    ISO timestamp when thread was created
    """

    status: str = pydantic.Field()
    """
    Current status of the thread (e.g., 'running', 'completed', 'failed')
    """

    thread_id: str = pydantic.Field()
    """
    The thread ID that was checked
    """

    updated_at: str = pydantic.Field()
    """
    ISO timestamp when thread was last updated
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
