class Config:

    def __init__(self):

        self.llm_config = {
            "anthropic": {
                "api_key_env": "ANTHROPIC_API_KEY",
                "sdk": "anthropic",
                "smart_model": "claude-sonnet-4-5",
                "fast_model": "claude-haiku-4-5",
                "reasoning_model": "claude-opus-4-1",
                "vision_model": None, 
                "supports_vision": True,
                "supports_documents": True,
                "response_path": "content[0].text",
                "stream_path": "delta.text",
                "choices_path": None
            },
            "openai": {
                "api_key_env": "OPENAI_API_KEY",
                "sdk": "openai",
                "smart_model": "gpt-4o",
                "fast_model": "gpt-4o-mini",
                "reasoning_model": "o3",
                "vision_model": None,  
                "supports_vision": True,
                "supports_documents": True,
                "response_path": "choices[0].message.content",
                "stream_path": "choices[0].delta.content",
                "choices_path": "choices[0]"
            },
            "gemini": {
                "api_key_env": "GEMINI_API_KEY",
                "sdk": "gemini",
                "smart_model": "gemini-2.5-pro",
                "fast_model": "gemini-2.5-flash",
                "reasoning_model": "gemini-2.5-pro",
                "vision_model": None,  
                "supports_vision": True,
                "supports_documents": True,
                "response_path": "text",
                "stream_path": "text",
                "choices_path": None
            },
            "groq": {
                "api_key_env": "GROQ_API_KEY",
                "sdk": "groq",
                "smart_model": "llama-3.3-70b-versatile",
                "fast_model": "llama-3.1-8b-instant",
                "reasoning_model": "llama-3.3-70b-versatile",
                "vision_model": "meta-llama/llama-4-scout-17b-16e-instruct",
                "supports_vision": True,
                "supports_documents": False,
                "response_path": "choices[0].message.content",
                "stream_path": "choices[0].delta.content",
                "choices_path": "choices[0]"
            },
            "deepseek": {
                "api_key_env": "DEEPSEEK_API_KEY",
                "sdk": "openai",  # Uses OpenAI-compatible API
                "base_url": "https://api.deepseek.com",
                "smart_model": "deepseek-chat",
                "fast_model": "deepseek-chat",
                "reasoning_model": "deepseek-reasoner",
                "vision_model": None,
                "supports_vision": False,
                "supports_documents": False,
                "response_path": "choices[0].message.content",
                "stream_path": "choices[0].delta.content",
                "choices_path": "choices[0]"
            }
        }