# SPDX-FileCopyrightText: 2024 Justin Myers
#
# SPDX-License-Identifier: MIT
"""
Board stub for PYB LR Nano V2
 - port: stm
 - board_id: pyb_nano_v2
 - NVM size: Unknown
 - Included modules: _asyncio, _pixelmap, adafruit_bus_device, adafruit_pixelbuf, aesio, analogio, array, atexit, binascii, bitbangio, bitmapfilter, bitmaptools, board, builtins, builtins.pow3, busdisplay, busio, busio.SPI, busio.UART, codeop, collections, digitalio, displayio, epaperdisplay, errno, fontio, fourwire, framebufferio, getpass, gifio, i2cdisplaybus, io, jpegio, json, keypad, keypad.KeyMatrix, keypad.Keys, keypad.ShiftRegisterKeys, keypad_demux, keypad_demux.DemuxKeyMatrix, locale, math, microcontroller, msgpack, neopixel_write, onewireio, os, os.getenv, pulseio, pwmio, rainbowio, random, re, rtc, sdcardio, select, sharpdisplay, storage, struct, supervisor, sys, terminalio, tilepalettemapper, time, touchio, traceback, usb_cdc, usb_hid, usb_midi, vectorio, warnings, zlib
 - Frozen libraries: 
"""

# Imports
import microcontroller


# Board Info:
board_id: str


# Pins:
Y10: microcontroller.Pin  # PA10
Y9: microcontroller.Pin  # PA13
Y8: microcontroller.Pin  # PA14
Y7: microcontroller.Pin  # PA15
Y6: microcontroller.Pin  # PB03
Y5: microcontroller.Pin  # PB04
Y4: microcontroller.Pin  # PB05
Y3: microcontroller.Pin  # PB06
Y2: microcontroller.Pin  # PB07
Y1: microcontroller.Pin  # PB08
Y0: microcontroller.Pin  # PB09
X15: microcontroller.Pin  # PA08
X14: microcontroller.Pin  # PB15
X13: microcontroller.Pin  # PB14
X12: microcontroller.Pin  # PB13
X11: microcontroller.Pin  # PB12
X10: microcontroller.Pin  # PB10
X9: microcontroller.Pin  # PB01
X8: microcontroller.Pin  # PB00
X7: microcontroller.Pin  # PA07
X6: microcontroller.Pin  # PA06
X5: microcontroller.Pin  # PA05
X4: microcontroller.Pin  # PA04
X3: microcontroller.Pin  # PA03
X2: microcontroller.Pin  # PA02
X1: microcontroller.Pin  # PA01
X0: microcontroller.Pin  # PA00
SDA1: microcontroller.Pin  # PB09
SCL1: microcontroller.Pin  # PB08
SDA2: microcontroller.Pin  # PB03
SCL2: microcontroller.Pin  # PB10
SDA3: microcontroller.Pin  # PB04
SCL3: microcontroller.Pin  # PA08
SCK1: microcontroller.Pin  # PA05
MISO1: microcontroller.Pin  # PA06
MOSI1: microcontroller.Pin  # PA07
SCK2: microcontroller.Pin  # PB13
MISO2: microcontroller.Pin  # PB14
MOSI2: microcontroller.Pin  # PB15
TX1: microcontroller.Pin  # PB07
RX1: microcontroller.Pin  # PB06
TX2: microcontroller.Pin  # PA02
RX2: microcontroller.Pin  # PA03
LED_RED: microcontroller.Pin  # PA00
LED_GREEN: microcontroller.Pin  # PA01
LED_YELLOW: microcontroller.Pin  # PA02
LED_BLUE: microcontroller.Pin  # PA03
SW: microcontroller.Pin  # PC13


# Members:

# Unmapped:
#   none
