#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json

from alipay.aop.api.constant.ParamConstants import *
from alipay.aop.api.domain.ReliableEnterpriseBaseInfoDTO import ReliableEnterpriseBaseInfoDTO
from alipay.aop.api.domain.ReliableEnterpriseProfilesDTO import ReliableEnterpriseProfilesDTO


class AlipayCommerceEcEnterpriseReliableCreateModel(object):

    def __init__(self):
        self._base_info = None
        self._identity = None
        self._identity_type = None
        self._out_biz_no = None
        self._profiles = None

    @property
    def base_info(self):
        return self._base_info

    @base_info.setter
    def base_info(self, value):
        if isinstance(value, ReliableEnterpriseBaseInfoDTO):
            self._base_info = value
        else:
            self._base_info = ReliableEnterpriseBaseInfoDTO.from_alipay_dict(value)
    @property
    def identity(self):
        return self._identity

    @identity.setter
    def identity(self, value):
        self._identity = value
    @property
    def identity_type(self):
        return self._identity_type

    @identity_type.setter
    def identity_type(self, value):
        self._identity_type = value
    @property
    def out_biz_no(self):
        return self._out_biz_no

    @out_biz_no.setter
    def out_biz_no(self, value):
        self._out_biz_no = value
    @property
    def profiles(self):
        return self._profiles

    @profiles.setter
    def profiles(self, value):
        if isinstance(value, ReliableEnterpriseProfilesDTO):
            self._profiles = value
        else:
            self._profiles = ReliableEnterpriseProfilesDTO.from_alipay_dict(value)


    def to_alipay_dict(self):
        params = dict()
        if self.base_info:
            if hasattr(self.base_info, 'to_alipay_dict'):
                params['base_info'] = self.base_info.to_alipay_dict()
            else:
                params['base_info'] = self.base_info
        if self.identity:
            if hasattr(self.identity, 'to_alipay_dict'):
                params['identity'] = self.identity.to_alipay_dict()
            else:
                params['identity'] = self.identity
        if self.identity_type:
            if hasattr(self.identity_type, 'to_alipay_dict'):
                params['identity_type'] = self.identity_type.to_alipay_dict()
            else:
                params['identity_type'] = self.identity_type
        if self.out_biz_no:
            if hasattr(self.out_biz_no, 'to_alipay_dict'):
                params['out_biz_no'] = self.out_biz_no.to_alipay_dict()
            else:
                params['out_biz_no'] = self.out_biz_no
        if self.profiles:
            if hasattr(self.profiles, 'to_alipay_dict'):
                params['profiles'] = self.profiles.to_alipay_dict()
            else:
                params['profiles'] = self.profiles
        return params

    @staticmethod
    def from_alipay_dict(d):
        if not d:
            return None
        o = AlipayCommerceEcEnterpriseReliableCreateModel()
        if 'base_info' in d:
            o.base_info = d['base_info']
        if 'identity' in d:
            o.identity = d['identity']
        if 'identity_type' in d:
            o.identity_type = d['identity_type']
        if 'out_biz_no' in d:
            o.out_biz_no = d['out_biz_no']
        if 'profiles' in d:
            o.profiles = d['profiles']
        return o


