#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json

from alipay.aop.api.constant.ParamConstants import *


class AlipayPcreditLoanSideloanlendCalcConsultModel(object):

    def __init__(self):
        self._alipay_user_id = None
        self._apply_loan_amount = None
        self._calc_time = None
        self._coupon_code_list = None
        self._extension = None
        self._loan_term = None
        self._loan_term_unit = None
        self._loan_type = None
        self._open_id = None
        self._product_code = None
        self._repayment_method = None

    @property
    def alipay_user_id(self):
        return self._alipay_user_id

    @alipay_user_id.setter
    def alipay_user_id(self, value):
        self._alipay_user_id = value
    @property
    def apply_loan_amount(self):
        return self._apply_loan_amount

    @apply_loan_amount.setter
    def apply_loan_amount(self, value):
        self._apply_loan_amount = value
    @property
    def calc_time(self):
        return self._calc_time

    @calc_time.setter
    def calc_time(self, value):
        self._calc_time = value
    @property
    def coupon_code_list(self):
        return self._coupon_code_list

    @coupon_code_list.setter
    def coupon_code_list(self, value):
        if isinstance(value, list):
            self._coupon_code_list = list()
            for i in value:
                self._coupon_code_list.append(i)
    @property
    def extension(self):
        return self._extension

    @extension.setter
    def extension(self, value):
        self._extension = value
    @property
    def loan_term(self):
        return self._loan_term

    @loan_term.setter
    def loan_term(self, value):
        self._loan_term = value
    @property
    def loan_term_unit(self):
        return self._loan_term_unit

    @loan_term_unit.setter
    def loan_term_unit(self, value):
        self._loan_term_unit = value
    @property
    def loan_type(self):
        return self._loan_type

    @loan_type.setter
    def loan_type(self, value):
        self._loan_type = value
    @property
    def open_id(self):
        return self._open_id

    @open_id.setter
    def open_id(self, value):
        self._open_id = value
    @property
    def product_code(self):
        return self._product_code

    @product_code.setter
    def product_code(self, value):
        self._product_code = value
    @property
    def repayment_method(self):
        return self._repayment_method

    @repayment_method.setter
    def repayment_method(self, value):
        self._repayment_method = value


    def to_alipay_dict(self):
        params = dict()
        if self.alipay_user_id:
            if hasattr(self.alipay_user_id, 'to_alipay_dict'):
                params['alipay_user_id'] = self.alipay_user_id.to_alipay_dict()
            else:
                params['alipay_user_id'] = self.alipay_user_id
        if self.apply_loan_amount:
            if hasattr(self.apply_loan_amount, 'to_alipay_dict'):
                params['apply_loan_amount'] = self.apply_loan_amount.to_alipay_dict()
            else:
                params['apply_loan_amount'] = self.apply_loan_amount
        if self.calc_time:
            if hasattr(self.calc_time, 'to_alipay_dict'):
                params['calc_time'] = self.calc_time.to_alipay_dict()
            else:
                params['calc_time'] = self.calc_time
        if self.coupon_code_list:
            if isinstance(self.coupon_code_list, list):
                for i in range(0, len(self.coupon_code_list)):
                    element = self.coupon_code_list[i]
                    if hasattr(element, 'to_alipay_dict'):
                        self.coupon_code_list[i] = element.to_alipay_dict()
            if hasattr(self.coupon_code_list, 'to_alipay_dict'):
                params['coupon_code_list'] = self.coupon_code_list.to_alipay_dict()
            else:
                params['coupon_code_list'] = self.coupon_code_list
        if self.extension:
            if hasattr(self.extension, 'to_alipay_dict'):
                params['extension'] = self.extension.to_alipay_dict()
            else:
                params['extension'] = self.extension
        if self.loan_term:
            if hasattr(self.loan_term, 'to_alipay_dict'):
                params['loan_term'] = self.loan_term.to_alipay_dict()
            else:
                params['loan_term'] = self.loan_term
        if self.loan_term_unit:
            if hasattr(self.loan_term_unit, 'to_alipay_dict'):
                params['loan_term_unit'] = self.loan_term_unit.to_alipay_dict()
            else:
                params['loan_term_unit'] = self.loan_term_unit
        if self.loan_type:
            if hasattr(self.loan_type, 'to_alipay_dict'):
                params['loan_type'] = self.loan_type.to_alipay_dict()
            else:
                params['loan_type'] = self.loan_type
        if self.open_id:
            if hasattr(self.open_id, 'to_alipay_dict'):
                params['open_id'] = self.open_id.to_alipay_dict()
            else:
                params['open_id'] = self.open_id
        if self.product_code:
            if hasattr(self.product_code, 'to_alipay_dict'):
                params['product_code'] = self.product_code.to_alipay_dict()
            else:
                params['product_code'] = self.product_code
        if self.repayment_method:
            if hasattr(self.repayment_method, 'to_alipay_dict'):
                params['repayment_method'] = self.repayment_method.to_alipay_dict()
            else:
                params['repayment_method'] = self.repayment_method
        return params

    @staticmethod
    def from_alipay_dict(d):
        if not d:
            return None
        o = AlipayPcreditLoanSideloanlendCalcConsultModel()
        if 'alipay_user_id' in d:
            o.alipay_user_id = d['alipay_user_id']
        if 'apply_loan_amount' in d:
            o.apply_loan_amount = d['apply_loan_amount']
        if 'calc_time' in d:
            o.calc_time = d['calc_time']
        if 'coupon_code_list' in d:
            o.coupon_code_list = d['coupon_code_list']
        if 'extension' in d:
            o.extension = d['extension']
        if 'loan_term' in d:
            o.loan_term = d['loan_term']
        if 'loan_term_unit' in d:
            o.loan_term_unit = d['loan_term_unit']
        if 'loan_type' in d:
            o.loan_type = d['loan_type']
        if 'open_id' in d:
            o.open_id = d['open_id']
        if 'product_code' in d:
            o.product_code = d['product_code']
        if 'repayment_method' in d:
            o.repayment_method = d['repayment_method']
        return o


