#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json

from alipay.aop.api.constant.ParamConstants import *
from alipay.aop.api.domain.CompanyProductConfigInfo import CompanyProductConfigInfo


class CompanyProductInfo(object):

    def __init__(self):
        self._company_product_config = None
        self._product_id = None
        self._product_name = None

    @property
    def company_product_config(self):
        return self._company_product_config

    @company_product_config.setter
    def company_product_config(self, value):
        if isinstance(value, list):
            self._company_product_config = list()
            for i in value:
                if isinstance(i, CompanyProductConfigInfo):
                    self._company_product_config.append(i)
                else:
                    self._company_product_config.append(CompanyProductConfigInfo.from_alipay_dict(i))
    @property
    def product_id(self):
        return self._product_id

    @product_id.setter
    def product_id(self, value):
        self._product_id = value
    @property
    def product_name(self):
        return self._product_name

    @product_name.setter
    def product_name(self, value):
        self._product_name = value


    def to_alipay_dict(self):
        params = dict()
        if self.company_product_config:
            if isinstance(self.company_product_config, list):
                for i in range(0, len(self.company_product_config)):
                    element = self.company_product_config[i]
                    if hasattr(element, 'to_alipay_dict'):
                        self.company_product_config[i] = element.to_alipay_dict()
            if hasattr(self.company_product_config, 'to_alipay_dict'):
                params['company_product_config'] = self.company_product_config.to_alipay_dict()
            else:
                params['company_product_config'] = self.company_product_config
        if self.product_id:
            if hasattr(self.product_id, 'to_alipay_dict'):
                params['product_id'] = self.product_id.to_alipay_dict()
            else:
                params['product_id'] = self.product_id
        if self.product_name:
            if hasattr(self.product_name, 'to_alipay_dict'):
                params['product_name'] = self.product_name.to_alipay_dict()
            else:
                params['product_name'] = self.product_name
        return params

    @staticmethod
    def from_alipay_dict(d):
        if not d:
            return None
        o = CompanyProductInfo()
        if 'company_product_config' in d:
            o.company_product_config = d['company_product_config']
        if 'product_id' in d:
            o.product_id = d['product_id']
        if 'product_name' in d:
            o.product_name = d['product_name']
        return o


