#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json

from alipay.aop.api.constant.ParamConstants import *
from alipay.aop.api.domain.ContractSignArea import ContractSignArea


class ContractUserInfo(object):

    def __init__(self):
        self._cert_no = None
        self._open_id = None
        self._sign_area = None
        self._user_id = None
        self._user_name = None

    @property
    def cert_no(self):
        return self._cert_no

    @cert_no.setter
    def cert_no(self, value):
        self._cert_no = value
    @property
    def open_id(self):
        return self._open_id

    @open_id.setter
    def open_id(self, value):
        self._open_id = value
    @property
    def sign_area(self):
        return self._sign_area

    @sign_area.setter
    def sign_area(self, value):
        if isinstance(value, ContractSignArea):
            self._sign_area = value
        else:
            self._sign_area = ContractSignArea.from_alipay_dict(value)
    @property
    def user_id(self):
        return self._user_id

    @user_id.setter
    def user_id(self, value):
        self._user_id = value
    @property
    def user_name(self):
        return self._user_name

    @user_name.setter
    def user_name(self, value):
        self._user_name = value


    def to_alipay_dict(self):
        params = dict()
        if self.cert_no:
            if hasattr(self.cert_no, 'to_alipay_dict'):
                params['cert_no'] = self.cert_no.to_alipay_dict()
            else:
                params['cert_no'] = self.cert_no
        if self.open_id:
            if hasattr(self.open_id, 'to_alipay_dict'):
                params['open_id'] = self.open_id.to_alipay_dict()
            else:
                params['open_id'] = self.open_id
        if self.sign_area:
            if hasattr(self.sign_area, 'to_alipay_dict'):
                params['sign_area'] = self.sign_area.to_alipay_dict()
            else:
                params['sign_area'] = self.sign_area
        if self.user_id:
            if hasattr(self.user_id, 'to_alipay_dict'):
                params['user_id'] = self.user_id.to_alipay_dict()
            else:
                params['user_id'] = self.user_id
        if self.user_name:
            if hasattr(self.user_name, 'to_alipay_dict'):
                params['user_name'] = self.user_name.to_alipay_dict()
            else:
                params['user_name'] = self.user_name
        return params

    @staticmethod
    def from_alipay_dict(d):
        if not d:
            return None
        o = ContractUserInfo()
        if 'cert_no' in d:
            o.cert_no = d['cert_no']
        if 'open_id' in d:
            o.open_id = d['open_id']
        if 'sign_area' in d:
            o.sign_area = d['sign_area']
        if 'user_id' in d:
            o.user_id = d['user_id']
        if 'user_name' in d:
            o.user_name = d['user_name']
        return o


