#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json

from alipay.aop.api.constant.ParamConstants import *
from alipay.aop.api.domain.EtravelHotelSupplyPriceDTO import EtravelHotelSupplyPriceDTO


class EtravelHotelSupplyDayPrice(object):

    def __init__(self):
        self._date = None
        self._price = None

    @property
    def date(self):
        return self._date

    @date.setter
    def date(self, value):
        self._date = value
    @property
    def price(self):
        return self._price

    @price.setter
    def price(self, value):
        if isinstance(value, EtravelHotelSupplyPriceDTO):
            self._price = value
        else:
            self._price = EtravelHotelSupplyPriceDTO.from_alipay_dict(value)


    def to_alipay_dict(self):
        params = dict()
        if self.date:
            if hasattr(self.date, 'to_alipay_dict'):
                params['date'] = self.date.to_alipay_dict()
            else:
                params['date'] = self.date
        if self.price:
            if hasattr(self.price, 'to_alipay_dict'):
                params['price'] = self.price.to_alipay_dict()
            else:
                params['price'] = self.price
        return params

    @staticmethod
    def from_alipay_dict(d):
        if not d:
            return None
        o = EtravelHotelSupplyDayPrice()
        if 'date' in d:
            o.date = d['date']
        if 'price' in d:
            o.price = d['price']
        return o


