#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json

from alipay.aop.api.constant.ParamConstants import *


class ItemOrderInfoDTO(object):

    def __init__(self):
        self._barcode = None
        self._item_id = None
        self._item_name = None
        self._quantity = None
        self._quantity_dec = None
        self._sku_id = None
        self._sku_total_price = None
        self._unit_price = None

    @property
    def barcode(self):
        return self._barcode

    @barcode.setter
    def barcode(self, value):
        self._barcode = value
    @property
    def item_id(self):
        return self._item_id

    @item_id.setter
    def item_id(self, value):
        self._item_id = value
    @property
    def item_name(self):
        return self._item_name

    @item_name.setter
    def item_name(self, value):
        self._item_name = value
    @property
    def quantity(self):
        return self._quantity

    @quantity.setter
    def quantity(self, value):
        self._quantity = value
    @property
    def quantity_dec(self):
        return self._quantity_dec

    @quantity_dec.setter
    def quantity_dec(self, value):
        self._quantity_dec = value
    @property
    def sku_id(self):
        return self._sku_id

    @sku_id.setter
    def sku_id(self, value):
        self._sku_id = value
    @property
    def sku_total_price(self):
        return self._sku_total_price

    @sku_total_price.setter
    def sku_total_price(self, value):
        self._sku_total_price = value
    @property
    def unit_price(self):
        return self._unit_price

    @unit_price.setter
    def unit_price(self, value):
        self._unit_price = value


    def to_alipay_dict(self):
        params = dict()
        if self.barcode:
            if hasattr(self.barcode, 'to_alipay_dict'):
                params['barcode'] = self.barcode.to_alipay_dict()
            else:
                params['barcode'] = self.barcode
        if self.item_id:
            if hasattr(self.item_id, 'to_alipay_dict'):
                params['item_id'] = self.item_id.to_alipay_dict()
            else:
                params['item_id'] = self.item_id
        if self.item_name:
            if hasattr(self.item_name, 'to_alipay_dict'):
                params['item_name'] = self.item_name.to_alipay_dict()
            else:
                params['item_name'] = self.item_name
        if self.quantity:
            if hasattr(self.quantity, 'to_alipay_dict'):
                params['quantity'] = self.quantity.to_alipay_dict()
            else:
                params['quantity'] = self.quantity
        if self.quantity_dec:
            if hasattr(self.quantity_dec, 'to_alipay_dict'):
                params['quantity_dec'] = self.quantity_dec.to_alipay_dict()
            else:
                params['quantity_dec'] = self.quantity_dec
        if self.sku_id:
            if hasattr(self.sku_id, 'to_alipay_dict'):
                params['sku_id'] = self.sku_id.to_alipay_dict()
            else:
                params['sku_id'] = self.sku_id
        if self.sku_total_price:
            if hasattr(self.sku_total_price, 'to_alipay_dict'):
                params['sku_total_price'] = self.sku_total_price.to_alipay_dict()
            else:
                params['sku_total_price'] = self.sku_total_price
        if self.unit_price:
            if hasattr(self.unit_price, 'to_alipay_dict'):
                params['unit_price'] = self.unit_price.to_alipay_dict()
            else:
                params['unit_price'] = self.unit_price
        return params

    @staticmethod
    def from_alipay_dict(d):
        if not d:
            return None
        o = ItemOrderInfoDTO()
        if 'barcode' in d:
            o.barcode = d['barcode']
        if 'item_id' in d:
            o.item_id = d['item_id']
        if 'item_name' in d:
            o.item_name = d['item_name']
        if 'quantity' in d:
            o.quantity = d['quantity']
        if 'quantity_dec' in d:
            o.quantity_dec = d['quantity_dec']
        if 'sku_id' in d:
            o.sku_id = d['sku_id']
        if 'sku_total_price' in d:
            o.sku_total_price = d['sku_total_price']
        if 'unit_price' in d:
            o.unit_price = d['unit_price']
        return o


