#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json

from alipay.aop.api.constant.ParamConstants import *
from alipay.aop.api.domain.CreditMoney import CreditMoney


class ZhimaCreditPayafteruseFusionquotaSyncModel(object):

    def __init__(self):
        self._category_id = None
        self._credit_agreement_id = None
        self._request_id = None
        self._total_quota = None
        self._zm_service_id = None

    @property
    def category_id(self):
        return self._category_id

    @category_id.setter
    def category_id(self, value):
        self._category_id = value
    @property
    def credit_agreement_id(self):
        return self._credit_agreement_id

    @credit_agreement_id.setter
    def credit_agreement_id(self, value):
        self._credit_agreement_id = value
    @property
    def request_id(self):
        return self._request_id

    @request_id.setter
    def request_id(self, value):
        self._request_id = value
    @property
    def total_quota(self):
        return self._total_quota

    @total_quota.setter
    def total_quota(self, value):
        if isinstance(value, CreditMoney):
            self._total_quota = value
        else:
            self._total_quota = CreditMoney.from_alipay_dict(value)
    @property
    def zm_service_id(self):
        return self._zm_service_id

    @zm_service_id.setter
    def zm_service_id(self, value):
        self._zm_service_id = value


    def to_alipay_dict(self):
        params = dict()
        if self.category_id:
            if hasattr(self.category_id, 'to_alipay_dict'):
                params['category_id'] = self.category_id.to_alipay_dict()
            else:
                params['category_id'] = self.category_id
        if self.credit_agreement_id:
            if hasattr(self.credit_agreement_id, 'to_alipay_dict'):
                params['credit_agreement_id'] = self.credit_agreement_id.to_alipay_dict()
            else:
                params['credit_agreement_id'] = self.credit_agreement_id
        if self.request_id:
            if hasattr(self.request_id, 'to_alipay_dict'):
                params['request_id'] = self.request_id.to_alipay_dict()
            else:
                params['request_id'] = self.request_id
        if self.total_quota:
            if hasattr(self.total_quota, 'to_alipay_dict'):
                params['total_quota'] = self.total_quota.to_alipay_dict()
            else:
                params['total_quota'] = self.total_quota
        if self.zm_service_id:
            if hasattr(self.zm_service_id, 'to_alipay_dict'):
                params['zm_service_id'] = self.zm_service_id.to_alipay_dict()
            else:
                params['zm_service_id'] = self.zm_service_id
        return params

    @staticmethod
    def from_alipay_dict(d):
        if not d:
            return None
        o = ZhimaCreditPayafteruseFusionquotaSyncModel()
        if 'category_id' in d:
            o.category_id = d['category_id']
        if 'credit_agreement_id' in d:
            o.credit_agreement_id = d['credit_agreement_id']
        if 'request_id' in d:
            o.request_id = d['request_id']
        if 'total_quota' in d:
            o.total_quota = d['total_quota']
        if 'zm_service_id' in d:
            o.zm_service_id = d['zm_service_id']
        return o


