#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json

from alipay.aop.api.response.AlipayResponse import AlipayResponse


class AlipayFundTransUniTransferResponse(AlipayResponse):

    def __init__(self):
        super(AlipayFundTransUniTransferResponse, self).__init__()
        self._amount = None
        self._link = None
        self._order_id = None
        self._out_biz_no = None
        self._pay_fund_order_id = None
        self._settle_serial_no = None
        self._status = None
        self._sub_status = None
        self._trans_date = None

    @property
    def amount(self):
        return self._amount

    @amount.setter
    def amount(self, value):
        self._amount = value
    @property
    def link(self):
        return self._link

    @link.setter
    def link(self, value):
        self._link = value
    @property
    def order_id(self):
        return self._order_id

    @order_id.setter
    def order_id(self, value):
        self._order_id = value
    @property
    def out_biz_no(self):
        return self._out_biz_no

    @out_biz_no.setter
    def out_biz_no(self, value):
        self._out_biz_no = value
    @property
    def pay_fund_order_id(self):
        return self._pay_fund_order_id

    @pay_fund_order_id.setter
    def pay_fund_order_id(self, value):
        self._pay_fund_order_id = value
    @property
    def settle_serial_no(self):
        return self._settle_serial_no

    @settle_serial_no.setter
    def settle_serial_no(self, value):
        self._settle_serial_no = value
    @property
    def status(self):
        return self._status

    @status.setter
    def status(self, value):
        self._status = value
    @property
    def sub_status(self):
        return self._sub_status

    @sub_status.setter
    def sub_status(self, value):
        self._sub_status = value
    @property
    def trans_date(self):
        return self._trans_date

    @trans_date.setter
    def trans_date(self, value):
        self._trans_date = value

    def parse_response_content(self, response_content):
        response = super(AlipayFundTransUniTransferResponse, self).parse_response_content(response_content)
        if 'amount' in response:
            self.amount = response['amount']
        if 'link' in response:
            self.link = response['link']
        if 'order_id' in response:
            self.order_id = response['order_id']
        if 'out_biz_no' in response:
            self.out_biz_no = response['out_biz_no']
        if 'pay_fund_order_id' in response:
            self.pay_fund_order_id = response['pay_fund_order_id']
        if 'settle_serial_no' in response:
            self.settle_serial_no = response['settle_serial_no']
        if 'status' in response:
            self.status = response['status']
        if 'sub_status' in response:
            self.sub_status = response['sub_status']
        if 'trans_date' in response:
            self.trans_date = response['trans_date']
