#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json

from alipay.aop.api.response.AlipayResponse import AlipayResponse
from alipay.aop.api.domain.JhTestResultData import JhTestResultData


class AlipayOpenTestoneJianhuiQueryResponse(AlipayResponse):

    def __init__(self):
        super(AlipayOpenTestoneJianhuiQueryResponse, self).__init__()
        self._data = None
        self._path_name = None

    @property
    def data(self):
        return self._data

    @data.setter
    def data(self, value):
        if isinstance(value, JhTestResultData):
            self._data = value
        else:
            self._data = JhTestResultData.from_alipay_dict(value)
    @property
    def path_name(self):
        return self._path_name

    @path_name.setter
    def path_name(self, value):
        self._path_name = value

    def parse_response_content(self, response_content):
        response = super(AlipayOpenTestoneJianhuiQueryResponse, self).parse_response_content(response_content)
        if 'data' in response:
            self.data = response['data']
        if 'path_name' in response:
            self.path_name = response['path_name']
