# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Dict, Any, List


class AlertEventMetrics(TeaModel):
    def __init__(
        self,
        cur_value: str = None,
        metric_name: str = None,
        metric_name_en: str = None,
        metric_name_zh: str = None,
        operator: str = None,
        statistics: str = None,
        threshold: str = None,
        unit: str = None,
        unit_factor: float = None,
    ):
        self.cur_value = cur_value
        self.metric_name = metric_name
        self.metric_name_en = metric_name_en
        self.metric_name_zh = metric_name_zh
        self.operator = operator
        self.statistics = statistics
        self.threshold = threshold
        self.unit = unit
        self.unit_factor = unit_factor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cur_value is not None:
            result['CurValue'] = self.cur_value
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.metric_name_en is not None:
            result['MetricNameEn'] = self.metric_name_en
        if self.metric_name_zh is not None:
            result['MetricNameZh'] = self.metric_name_zh
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.unit_factor is not None:
            result['UnitFactor'] = self.unit_factor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurValue') is not None:
            self.cur_value = m.get('CurValue')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('MetricNameEn') is not None:
            self.metric_name_en = m.get('MetricNameEn')
        if m.get('MetricNameZh') is not None:
            self.metric_name_zh = m.get('MetricNameZh')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('UnitFactor') is not None:
            self.unit_factor = m.get('UnitFactor')
        return self


class AlertEvent(TeaModel):
    def __init__(
        self,
        alert_name: str = None,
        alert_status: str = None,
        arn: str = None,
        content: str = None,
        custom_labels: Dict[str, Any] = None,
        de_dup_id: str = None,
        details: str = None,
        event_name: str = None,
        event_type: str = None,
        expression: str = None,
        metrics: List[AlertEventMetrics] = None,
        product: str = None,
        resource_info: Dict[str, Any] = None,
        rule_name: str = None,
        severity: str = None,
        source: str = None,
        summary: str = None,
        timestamp: int = None,
        trace_id: str = None,
        user_id: str = None,
    ):
        self.alert_name = alert_name
        self.alert_status = alert_status
        self.arn = arn
        self.content = content
        self.custom_labels = custom_labels
        self.de_dup_id = de_dup_id
        self.details = details
        self.event_name = event_name
        self.event_type = event_type
        self.expression = expression
        self.metrics = metrics
        self.product = product
        self.resource_info = resource_info
        self.rule_name = rule_name
        self.severity = severity
        self.source = source
        self.summary = summary
        self.timestamp = timestamp
        self.trace_id = trace_id
        self.user_id = user_id

    def validate(self):
        if self.metrics:
            for k in self.metrics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_name is not None:
            result['AlertName'] = self.alert_name
        if self.alert_status is not None:
            result['AlertStatus'] = self.alert_status
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.content is not None:
            result['Content'] = self.content
        if self.custom_labels is not None:
            result['CustomLabels'] = self.custom_labels
        if self.de_dup_id is not None:
            result['DeDupId'] = self.de_dup_id
        if self.details is not None:
            result['Details'] = self.details
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.expression is not None:
            result['Expression'] = self.expression
        result['Metrics'] = []
        if self.metrics is not None:
            for k in self.metrics:
                result['Metrics'].append(k.to_map() if k else None)
        if self.product is not None:
            result['Product'] = self.product
        if self.resource_info is not None:
            result['ResourceInfo'] = self.resource_info
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.severity is not None:
            result['Severity'] = self.severity
        if self.source is not None:
            result['Source'] = self.source
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertName') is not None:
            self.alert_name = m.get('AlertName')
        if m.get('AlertStatus') is not None:
            self.alert_status = m.get('AlertStatus')
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CustomLabels') is not None:
            self.custom_labels = m.get('CustomLabels')
        if m.get('DeDupId') is not None:
            self.de_dup_id = m.get('DeDupId')
        if m.get('Details') is not None:
            self.details = m.get('Details')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        self.metrics = []
        if m.get('Metrics') is not None:
            for k in m.get('Metrics'):
                temp_model = AlertEventMetrics()
                self.metrics.append(temp_model.from_map(k))
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('ResourceInfo') is not None:
            self.resource_info = m.get('ResourceInfo')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('Severity') is not None:
            self.severity = m.get('Severity')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class AlertStrategyRelation(TeaModel):
    def __init__(
        self,
        alert_name: str = None,
        strategy_uuid: str = None,
    ):
        self.alert_name = alert_name
        self.strategy_uuid = strategy_uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_name is not None:
            result['AlertName'] = self.alert_name
        if self.strategy_uuid is not None:
            result['StrategyUuid'] = self.strategy_uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertName') is not None:
            self.alert_name = m.get('AlertName')
        if m.get('StrategyUuid') is not None:
            self.strategy_uuid = m.get('StrategyUuid')
        return self


class Dimension(TeaModel):
    def __init__(
        self,
        label: str = None,
        value: str = None,
    ):
        self.label = label
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class EscalationRuleEscalationsContactGroupsByLevel(TeaModel):
    def __init__(
        self,
        critical: List[str] = None,
        error: List[str] = None,
        info: List[str] = None,
        resolve: List[str] = None,
        warning: List[str] = None,
    ):
        self.critical = critical
        self.error = error
        self.info = info
        self.resolve = resolve
        self.warning = warning

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.critical is not None:
            result['Critical'] = self.critical
        if self.error is not None:
            result['Error'] = self.error
        if self.info is not None:
            result['Info'] = self.info
        if self.resolve is not None:
            result['Resolve'] = self.resolve
        if self.warning is not None:
            result['Warning'] = self.warning
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Critical') is not None:
            self.critical = m.get('Critical')
        if m.get('Error') is not None:
            self.error = m.get('Error')
        if m.get('Info') is not None:
            self.info = m.get('Info')
        if m.get('Resolve') is not None:
            self.resolve = m.get('Resolve')
        if m.get('Warning') is not None:
            self.warning = m.get('Warning')
        return self


class EscalationRuleEscalations(TeaModel):
    def __init__(
        self,
        backup_contact_groups: List[str] = None,
        contact_groups: List[str] = None,
        contact_groups_by_level: EscalationRuleEscalationsContactGroupsByLevel = None,
        escalate_min: int = None,
    ):
        self.backup_contact_groups = backup_contact_groups
        self.contact_groups = contact_groups
        self.contact_groups_by_level = contact_groups_by_level
        self.escalate_min = escalate_min

    def validate(self):
        if self.contact_groups_by_level:
            self.contact_groups_by_level.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_contact_groups is not None:
            result['BackupContactGroups'] = self.backup_contact_groups
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups
        if self.contact_groups_by_level is not None:
            result['ContactGroupsByLevel'] = self.contact_groups_by_level.to_map()
        if self.escalate_min is not None:
            result['EscalateMin'] = self.escalate_min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupContactGroups') is not None:
            self.backup_contact_groups = m.get('BackupContactGroups')
        if m.get('ContactGroups') is not None:
            self.contact_groups = m.get('ContactGroups')
        if m.get('ContactGroupsByLevel') is not None:
            temp_model = EscalationRuleEscalationsContactGroupsByLevel()
            self.contact_groups_by_level = temp_model.from_map(m['ContactGroupsByLevel'])
        if m.get('EscalateMin') is not None:
            self.escalate_min = m.get('EscalateMin')
        return self


class EscalationRule(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        description: str = None,
        escalations: List[EscalationRuleEscalations] = None,
        name: str = None,
        update_time: str = None,
        user_id: str = None,
        uuid: str = None,
    ):
        self.create_time = create_time
        self.description = description
        # This parameter is required.
        self.escalations = escalations
        # This parameter is required.
        self.name = name
        self.update_time = update_time
        self.user_id = user_id
        self.uuid = uuid

    def validate(self):
        if self.escalations:
            for k in self.escalations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        result['Escalations'] = []
        if self.escalations is not None:
            for k in self.escalations:
                result['Escalations'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.escalations = []
        if m.get('Escalations') is not None:
            for k in m.get('Escalations'):
                temp_model = EscalationRuleEscalations()
                self.escalations.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class Incident(TeaModel):
    def __init__(
        self,
        action_time: int = None,
        alert_count: int = None,
        end_time: int = None,
        grouping_data: Dict[str, Any] = None,
        grouping_id: str = None,
        grouping_key: str = None,
        incident_id: str = None,
        incident_status: str = None,
        severity: str = None,
        start_time: int = None,
        strategy_uuid: str = None,
        user_id: str = None,
    ):
        self.action_time = action_time
        self.alert_count = alert_count
        self.end_time = end_time
        self.grouping_data = grouping_data
        self.grouping_id = grouping_id
        self.grouping_key = grouping_key
        self.incident_id = incident_id
        self.incident_status = incident_status
        self.severity = severity
        self.start_time = start_time
        self.strategy_uuid = strategy_uuid
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_time is not None:
            result['ActionTime'] = self.action_time
        if self.alert_count is not None:
            result['AlertCount'] = self.alert_count
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.grouping_data is not None:
            result['GroupingData'] = self.grouping_data
        if self.grouping_id is not None:
            result['GroupingId'] = self.grouping_id
        if self.grouping_key is not None:
            result['GroupingKey'] = self.grouping_key
        if self.incident_id is not None:
            result['IncidentId'] = self.incident_id
        if self.incident_status is not None:
            result['IncidentStatus'] = self.incident_status
        if self.severity is not None:
            result['Severity'] = self.severity
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.strategy_uuid is not None:
            result['StrategyUuid'] = self.strategy_uuid
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActionTime') is not None:
            self.action_time = m.get('ActionTime')
        if m.get('AlertCount') is not None:
            self.alert_count = m.get('AlertCount')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupingData') is not None:
            self.grouping_data = m.get('GroupingData')
        if m.get('GroupingId') is not None:
            self.grouping_id = m.get('GroupingId')
        if m.get('GroupingKey') is not None:
            self.grouping_key = m.get('GroupingKey')
        if m.get('IncidentId') is not None:
            self.incident_id = m.get('IncidentId')
        if m.get('IncidentStatus') is not None:
            self.incident_status = m.get('IncidentStatus')
        if m.get('Severity') is not None:
            self.severity = m.get('Severity')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StrategyUuid') is not None:
            self.strategy_uuid = m.get('StrategyUuid')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class Matcher(TeaModel):
    def __init__(
        self,
        label: str = None,
        operator: str = None,
        value: str = None,
    ):
        self.label = label
        self.operator = operator
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class MetricStat(TeaModel):
    def __init__(
        self,
        associated: Dict[str, str] = None,
        dimensions: List[Dimension] = None,
        log_time: int = None,
        measurements: Dict[str, Any] = None,
        metric: str = None,
        namespace: str = None,
        period: int = None,
        timestamp: int = None,
    ):
        self.associated = associated
        self.dimensions = dimensions
        self.log_time = log_time
        self.measurements = measurements
        self.metric = metric
        self.namespace = namespace
        self.period = period
        self.timestamp = timestamp

    def validate(self):
        if self.dimensions:
            for k in self.dimensions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated is not None:
            result['Associated'] = self.associated
        result['Dimensions'] = []
        if self.dimensions is not None:
            for k in self.dimensions:
                result['Dimensions'].append(k.to_map() if k else None)
        if self.log_time is not None:
            result['LogTime'] = self.log_time
        if self.measurements is not None:
            result['Measurements'] = self.measurements
        if self.metric is not None:
            result['Metric'] = self.metric
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.period is not None:
            result['Period'] = self.period
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Associated') is not None:
            self.associated = m.get('Associated')
        self.dimensions = []
        if m.get('Dimensions') is not None:
            for k in m.get('Dimensions'):
                temp_model = Dimension()
                self.dimensions.append(temp_model.from_map(k))
        if m.get('LogTime') is not None:
            self.log_time = m.get('LogTime')
        if m.get('Measurements') is not None:
            self.measurements = m.get('Measurements')
        if m.get('Metric') is not None:
            self.metric = m.get('Metric')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class MigrationJobPlanContactsChannels(TeaModel):
    def __init__(
        self,
        level: int = None,
        type: str = None,
        value: str = None,
    ):
        self.level = level
        self.type = type
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class MigrationJobPlanContacts(TeaModel):
    def __init__(
        self,
        channels: List[MigrationJobPlanContactsChannels] = None,
        name: str = None,
    ):
        self.channels = channels
        self.name = name

    def validate(self):
        if self.channels:
            for k in self.channels:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Channels'] = []
        if self.channels is not None:
            for k in self.channels:
                result['Channels'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.channels = []
        if m.get('Channels') is not None:
            for k in m.get('Channels'):
                temp_model = MigrationJobPlanContactsChannels()
                self.channels.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class MigrationJobPlanEscalationsEscalationsLevelGroups(TeaModel):
    def __init__(
        self,
        critical: List[str] = None,
        info: List[str] = None,
        resolved: List[str] = None,
        warning: List[str] = None,
    ):
        self.critical = critical
        self.info = info
        self.resolved = resolved
        self.warning = warning

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.critical is not None:
            result['Critical'] = self.critical
        if self.info is not None:
            result['Info'] = self.info
        if self.resolved is not None:
            result['Resolved'] = self.resolved
        if self.warning is not None:
            result['Warning'] = self.warning
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Critical') is not None:
            self.critical = m.get('Critical')
        if m.get('Info') is not None:
            self.info = m.get('Info')
        if m.get('Resolved') is not None:
            self.resolved = m.get('Resolved')
        if m.get('Warning') is not None:
            self.warning = m.get('Warning')
        return self


class MigrationJobPlanEscalationsEscalations(TeaModel):
    def __init__(
        self,
        groups: List[str] = None,
        level_groups: MigrationJobPlanEscalationsEscalationsLevelGroups = None,
    ):
        self.groups = groups
        self.level_groups = level_groups

    def validate(self):
        if self.level_groups:
            self.level_groups.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.groups is not None:
            result['Groups'] = self.groups
        if self.level_groups is not None:
            result['LevelGroups'] = self.level_groups.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Groups') is not None:
            self.groups = m.get('Groups')
        if m.get('LevelGroups') is not None:
            temp_model = MigrationJobPlanEscalationsEscalationsLevelGroups()
            self.level_groups = temp_model.from_map(m['LevelGroups'])
        return self


class MigrationJobPlanEscalations(TeaModel):
    def __init__(
        self,
        escalations: List[MigrationJobPlanEscalationsEscalations] = None,
        name: str = None,
        uuid: str = None,
    ):
        self.escalations = escalations
        self.name = name
        self.uuid = uuid

    def validate(self):
        if self.escalations:
            for k in self.escalations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Escalations'] = []
        if self.escalations is not None:
            for k in self.escalations:
                result['Escalations'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.escalations = []
        if m.get('Escalations') is not None:
            for k in m.get('Escalations'):
                temp_model = MigrationJobPlanEscalationsEscalations()
                self.escalations.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class MigrationJobPlanGroups(TeaModel):
    def __init__(
        self,
        contacts: List[str] = None,
        name: str = None,
    ):
        self.contacts = contacts
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contacts is not None:
            result['Contacts'] = self.contacts
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Contacts') is not None:
            self.contacts = m.get('Contacts')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class MigrationJobPlanStrategiesEscalationSetting(TeaModel):
    def __init__(
        self,
        escalation_uuid: str = None,
    ):
        self.escalation_uuid = escalation_uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.escalation_uuid is not None:
            result['escalationUuid'] = self.escalation_uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('escalationUuid') is not None:
            self.escalation_uuid = m.get('escalationUuid')
        return self


class MigrationJobPlanStrategiesPushingSetting(TeaModel):
    def __init__(
        self,
        target_uuids: List[str] = None,
    ):
        self.target_uuids = target_uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_uuids is not None:
            result['TargetUuids'] = self.target_uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TargetUuids') is not None:
            self.target_uuids = m.get('TargetUuids')
        return self


class MigrationJobPlanStrategies(TeaModel):
    def __init__(
        self,
        escalation_setting: MigrationJobPlanStrategiesEscalationSetting = None,
        name: str = None,
        pushing_setting: MigrationJobPlanStrategiesPushingSetting = None,
    ):
        self.escalation_setting = escalation_setting
        self.name = name
        self.pushing_setting = pushing_setting

    def validate(self):
        if self.escalation_setting:
            self.escalation_setting.validate()
        if self.pushing_setting:
            self.pushing_setting.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.escalation_setting is not None:
            result['EscalationSetting'] = self.escalation_setting.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.pushing_setting is not None:
            result['PushingSetting'] = self.pushing_setting.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EscalationSetting') is not None:
            temp_model = MigrationJobPlanStrategiesEscalationSetting()
            self.escalation_setting = temp_model.from_map(m['EscalationSetting'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PushingSetting') is not None:
            temp_model = MigrationJobPlanStrategiesPushingSetting()
            self.pushing_setting = temp_model.from_map(m['PushingSetting'])
        return self


class MigrationJobPlanSubscriptionsConditions(TeaModel):
    def __init__(
        self,
        field: str = None,
        op: str = None,
        value: str = None,
    ):
        self.field = field
        self.op = op
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field is not None:
            result['Field'] = self.field
        if self.op is not None:
            result['Op'] = self.op
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Field') is not None:
            self.field = m.get('Field')
        if m.get('Op') is not None:
            self.op = m.get('Op')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class MigrationJobPlanSubscriptions(TeaModel):
    def __init__(
        self,
        conditions: List[MigrationJobPlanSubscriptionsConditions] = None,
        name: str = None,
        strategy_uuid: str = None,
    ):
        self.conditions = conditions
        self.name = name
        self.strategy_uuid = strategy_uuid

    def validate(self):
        if self.conditions:
            for k in self.conditions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Conditions'] = []
        if self.conditions is not None:
            for k in self.conditions:
                result['Conditions'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        if self.strategy_uuid is not None:
            result['StrategyUuid'] = self.strategy_uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.conditions = []
        if m.get('Conditions') is not None:
            for k in m.get('Conditions'):
                temp_model = MigrationJobPlanSubscriptionsConditions()
                self.conditions.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('StrategyUuid') is not None:
            self.strategy_uuid = m.get('StrategyUuid')
        return self


class MigrationJobPlanTargetsHttpRequestTarget(TeaModel):
    def __init__(
        self,
        content_type: str = None,
        method: str = None,
        url: str = None,
    ):
        self.content_type = content_type
        self.method = method
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content_type is not None:
            result['ContentType'] = self.content_type
        if self.method is not None:
            result['Method'] = self.method
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContentType') is not None:
            self.content_type = m.get('ContentType')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class MigrationJobPlanTargets(TeaModel):
    def __init__(
        self,
        arn: str = None,
        http_request_target: MigrationJobPlanTargetsHttpRequestTarget = None,
        name: str = None,
        type: str = None,
        uuid: str = None,
    ):
        self.arn = arn
        self.http_request_target = http_request_target
        self.name = name
        self.type = type
        self.uuid = uuid

    def validate(self):
        if self.http_request_target:
            self.http_request_target.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.http_request_target is not None:
            result['HttpRequestTarget'] = self.http_request_target.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('HttpRequestTarget') is not None:
            temp_model = MigrationJobPlanTargetsHttpRequestTarget()
            self.http_request_target = temp_model.from_map(m['HttpRequestTarget'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class MigrationJobPlan(TeaModel):
    def __init__(
        self,
        contacts: List[MigrationJobPlanContacts] = None,
        escalations: List[MigrationJobPlanEscalations] = None,
        groups: List[MigrationJobPlanGroups] = None,
        rule_names: List[str] = None,
        strategies: List[MigrationJobPlanStrategies] = None,
        subscriptions: List[MigrationJobPlanSubscriptions] = None,
        targets: List[MigrationJobPlanTargets] = None,
    ):
        self.contacts = contacts
        self.escalations = escalations
        self.groups = groups
        self.rule_names = rule_names
        self.strategies = strategies
        self.subscriptions = subscriptions
        self.targets = targets

    def validate(self):
        if self.contacts:
            for k in self.contacts:
                if k:
                    k.validate()
        if self.escalations:
            for k in self.escalations:
                if k:
                    k.validate()
        if self.groups:
            for k in self.groups:
                if k:
                    k.validate()
        if self.strategies:
            for k in self.strategies:
                if k:
                    k.validate()
        if self.subscriptions:
            for k in self.subscriptions:
                if k:
                    k.validate()
        if self.targets:
            for k in self.targets:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Contacts'] = []
        if self.contacts is not None:
            for k in self.contacts:
                result['Contacts'].append(k.to_map() if k else None)
        result['Escalations'] = []
        if self.escalations is not None:
            for k in self.escalations:
                result['Escalations'].append(k.to_map() if k else None)
        result['Groups'] = []
        if self.groups is not None:
            for k in self.groups:
                result['Groups'].append(k.to_map() if k else None)
        if self.rule_names is not None:
            result['RuleNames'] = self.rule_names
        result['Strategies'] = []
        if self.strategies is not None:
            for k in self.strategies:
                result['Strategies'].append(k.to_map() if k else None)
        result['Subscriptions'] = []
        if self.subscriptions is not None:
            for k in self.subscriptions:
                result['Subscriptions'].append(k.to_map() if k else None)
        result['Targets'] = []
        if self.targets is not None:
            for k in self.targets:
                result['Targets'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.contacts = []
        if m.get('Contacts') is not None:
            for k in m.get('Contacts'):
                temp_model = MigrationJobPlanContacts()
                self.contacts.append(temp_model.from_map(k))
        self.escalations = []
        if m.get('Escalations') is not None:
            for k in m.get('Escalations'):
                temp_model = MigrationJobPlanEscalations()
                self.escalations.append(temp_model.from_map(k))
        self.groups = []
        if m.get('Groups') is not None:
            for k in m.get('Groups'):
                temp_model = MigrationJobPlanGroups()
                self.groups.append(temp_model.from_map(k))
        if m.get('RuleNames') is not None:
            self.rule_names = m.get('RuleNames')
        self.strategies = []
        if m.get('Strategies') is not None:
            for k in m.get('Strategies'):
                temp_model = MigrationJobPlanStrategies()
                self.strategies.append(temp_model.from_map(k))
        self.subscriptions = []
        if m.get('Subscriptions') is not None:
            for k in m.get('Subscriptions'):
                temp_model = MigrationJobPlanSubscriptions()
                self.subscriptions.append(temp_model.from_map(k))
        self.targets = []
        if m.get('Targets') is not None:
            for k in m.get('Targets'):
                temp_model = MigrationJobPlanTargets()
                self.targets.append(temp_model.from_map(k))
        return self


class MigrationJobSourceRuleKeywordFilter(TeaModel):
    def __init__(
        self,
        keywords: List[str] = None,
        relation: str = None,
    ):
        self.keywords = keywords
        self.relation = relation

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keywords is not None:
            result['Keywords'] = self.keywords
        if self.relation is not None:
            result['Relation'] = self.relation
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Keywords') is not None:
            self.keywords = m.get('Keywords')
        if m.get('Relation') is not None:
            self.relation = m.get('Relation')
        return self


class MigrationJobSourceRulePrimaryFilters(TeaModel):
    def __init__(
        self,
        field: str = None,
        op_type: str = None,
        value: str = None,
    ):
        self.field = field
        self.op_type = op_type
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field is not None:
            result['Field'] = self.field
        if self.op_type is not None:
            result['OpType'] = self.op_type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Field') is not None:
            self.field = m.get('Field')
        if m.get('OpType') is not None:
            self.op_type = m.get('OpType')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class MigrationJobSourceRule(TeaModel):
    def __init__(
        self,
        keyword_filter: MigrationJobSourceRuleKeywordFilter = None,
        name: str = None,
        primary_filters: List[MigrationJobSourceRulePrimaryFilters] = None,
    ):
        self.keyword_filter = keyword_filter
        self.name = name
        self.primary_filters = primary_filters

    def validate(self):
        if self.keyword_filter:
            self.keyword_filter.validate()
        if self.primary_filters:
            for k in self.primary_filters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword_filter is not None:
            result['KeywordFilter'] = self.keyword_filter.to_map()
        if self.name is not None:
            result['Name'] = self.name
        result['PrimaryFilters'] = []
        if self.primary_filters is not None:
            for k in self.primary_filters:
                result['PrimaryFilters'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('KeywordFilter') is not None:
            temp_model = MigrationJobSourceRuleKeywordFilter()
            self.keyword_filter = temp_model.from_map(m['KeywordFilter'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.primary_filters = []
        if m.get('PrimaryFilters') is not None:
            for k in m.get('PrimaryFilters'):
                temp_model = MigrationJobSourceRulePrimaryFilters()
                self.primary_filters.append(temp_model.from_map(k))
        return self


class MigrationJobSourceTargetsContent(TeaModel):
    def __init__(
        self,
        group: str = None,
        level: str = None,
        method: str = None,
        region: str = None,
        resource_path: str = None,
        url: str = None,
    ):
        self.group = group
        self.level = level
        self.method = method
        self.region = region
        self.resource_path = resource_path
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group is not None:
            result['Group'] = self.group
        if self.level is not None:
            result['Level'] = self.level
        if self.method is not None:
            result['Method'] = self.method
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_path is not None:
            result['ResourcePath'] = self.resource_path
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Group') is not None:
            self.group = m.get('Group')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourcePath') is not None:
            self.resource_path = m.get('ResourcePath')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class MigrationJobSourceTargets(TeaModel):
    def __init__(
        self,
        content: MigrationJobSourceTargetsContent = None,
        type: str = None,
    ):
        self.content = content
        self.type = type

    def validate(self):
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            temp_model = MigrationJobSourceTargetsContent()
            self.content = temp_model.from_map(m['Content'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class MigrationJobSource(TeaModel):
    def __init__(
        self,
        rule: MigrationJobSourceRule = None,
        targets: List[MigrationJobSourceTargets] = None,
    ):
        self.rule = rule
        self.targets = targets

    def validate(self):
        if self.rule:
            self.rule.validate()
        if self.targets:
            for k in self.targets:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule is not None:
            result['Rule'] = self.rule.to_map()
        result['Targets'] = []
        if self.targets is not None:
            for k in self.targets:
                result['Targets'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Rule') is not None:
            temp_model = MigrationJobSourceRule()
            self.rule = temp_model.from_map(m['Rule'])
        self.targets = []
        if m.get('Targets') is not None:
            for k in m.get('Targets'):
                temp_model = MigrationJobSourceTargets()
                self.targets.append(temp_model.from_map(k))
        return self


class MigrationJob(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        detail: str = None,
        job_status: str = None,
        plan: MigrationJobPlan = None,
        rule_names: List[str] = None,
        source: List[MigrationJobSource] = None,
        update_time: str = None,
        uuid: str = None,
    ):
        self.create_time = create_time
        self.detail = detail
        self.job_status = job_status
        self.plan = plan
        self.rule_names = rule_names
        self.source = source
        self.update_time = update_time
        self.uuid = uuid

    def validate(self):
        if self.plan:
            self.plan.validate()
        if self.source:
            for k in self.source:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.job_status is not None:
            result['JobStatus'] = self.job_status
        if self.plan is not None:
            result['Plan'] = self.plan.to_map()
        if self.rule_names is not None:
            result['RuleNames'] = self.rule_names
        result['Source'] = []
        if self.source is not None:
            for k in self.source:
                result['Source'].append(k.to_map() if k else None)
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        if m.get('JobStatus') is not None:
            self.job_status = m.get('JobStatus')
        if m.get('Plan') is not None:
            temp_model = MigrationJobPlan()
            self.plan = temp_model.from_map(m['Plan'])
        if m.get('RuleNames') is not None:
            self.rule_names = m.get('RuleNames')
        self.source = []
        if m.get('Source') is not None:
            for k in m.get('Source'):
                temp_model = MigrationJobSource()
                self.source.append(temp_model.from_map(k))
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class NotificationStrategyEscalationSettingCustomChannels(TeaModel):
    def __init__(
        self,
        channel_type: str = None,
        severities: List[str] = None,
        template_uuid: str = None,
    ):
        # This parameter is required.
        self.channel_type = channel_type
        self.severities = severities
        self.template_uuid = template_uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.severities is not None:
            result['Severities'] = self.severities
        if self.template_uuid is not None:
            result['TemplateUuid'] = self.template_uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('Severities') is not None:
            self.severities = m.get('Severities')
        if m.get('TemplateUuid') is not None:
            self.template_uuid = m.get('TemplateUuid')
        return self


class NotificationStrategyEscalationSetting(TeaModel):
    def __init__(
        self,
        auto_resolve_min: int = None,
        custom_channels: List[NotificationStrategyEscalationSettingCustomChannels] = None,
        escalation_level: str = None,
        escalation_uuid: str = None,
        range: str = None,
        retrigger_min: int = None,
    ):
        self.auto_resolve_min = auto_resolve_min
        self.custom_channels = custom_channels
        self.escalation_level = escalation_level
        self.escalation_uuid = escalation_uuid
        self.range = range
        self.retrigger_min = retrigger_min

    def validate(self):
        if self.custom_channels:
            for k in self.custom_channels:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_resolve_min is not None:
            result['AutoResolveMin'] = self.auto_resolve_min
        result['CustomChannels'] = []
        if self.custom_channels is not None:
            for k in self.custom_channels:
                result['CustomChannels'].append(k.to_map() if k else None)
        if self.escalation_level is not None:
            result['EscalationLevel'] = self.escalation_level
        if self.escalation_uuid is not None:
            result['EscalationUuid'] = self.escalation_uuid
        if self.range is not None:
            result['Range'] = self.range
        if self.retrigger_min is not None:
            result['RetriggerMin'] = self.retrigger_min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoResolveMin') is not None:
            self.auto_resolve_min = m.get('AutoResolveMin')
        self.custom_channels = []
        if m.get('CustomChannels') is not None:
            for k in m.get('CustomChannels'):
                temp_model = NotificationStrategyEscalationSettingCustomChannels()
                self.custom_channels.append(temp_model.from_map(k))
        if m.get('EscalationLevel') is not None:
            self.escalation_level = m.get('EscalationLevel')
        if m.get('EscalationUuid') is not None:
            self.escalation_uuid = m.get('EscalationUuid')
        if m.get('Range') is not None:
            self.range = m.get('Range')
        if m.get('RetriggerMin') is not None:
            self.retrigger_min = m.get('RetriggerMin')
        return self


class NotificationStrategyFilterSettingBlackList(TeaModel):
    def __init__(
        self,
        field: str = None,
        op: str = None,
        value: str = None,
    ):
        # This parameter is required.
        self.field = field
        # This parameter is required.
        self.op = op
        # This parameter is required.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field is not None:
            result['Field'] = self.field
        if self.op is not None:
            result['Op'] = self.op
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Field') is not None:
            self.field = m.get('Field')
        if m.get('Op') is not None:
            self.op = m.get('Op')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class NotificationStrategyFilterSettingWhiteList(TeaModel):
    def __init__(
        self,
        field: str = None,
        op: str = None,
        value: str = None,
    ):
        # This parameter is required.
        self.field = field
        # This parameter is required.
        self.op = op
        # This parameter is required.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field is not None:
            result['Field'] = self.field
        if self.op is not None:
            result['Op'] = self.op
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Field') is not None:
            self.field = m.get('Field')
        if m.get('Op') is not None:
            self.op = m.get('Op')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class NotificationStrategyFilterSetting(TeaModel):
    def __init__(
        self,
        black_list: List[List[NotificationStrategyFilterSettingBlackList]] = None,
        white_list: List[List[NotificationStrategyFilterSettingWhiteList]] = None,
    ):
        self.black_list = black_list
        self.white_list = white_list

    def validate(self):
        if self.black_list:
            for k in self.black_list:
                for k1 in k:
                    if k1:
                        k1.validate()
        if self.white_list:
            for k in self.white_list:
                for k1 in k:
                    if k1:
                        k1.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BlackList'] = []
        if self.black_list is not None:
            for k in self.black_list:
                l1 = []
                for k1 in k:
                    l1.append(k1.to_map() if k1 else None)
                result['BlackList'].append(l1)
        result['WhiteList'] = []
        if self.white_list is not None:
            for k in self.white_list:
                l1 = []
                for k1 in k:
                    l1.append(k1.to_map() if k1 else None)
                result['WhiteList'].append(l1)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.black_list = []
        if m.get('BlackList') is not None:
            for k in m.get('BlackList'):
                l1 = []
                for k1 in k:
                    temp_model = NotificationStrategyFilterSettingBlackList()
                    l1.append(temp_model.from_map(k1))
                self.black_list.append(l1)
        self.white_list = []
        if m.get('WhiteList') is not None:
            for k in m.get('WhiteList'):
                l1 = []
                for k1 in k:
                    temp_model = NotificationStrategyFilterSettingWhiteList()
                    l1.append(temp_model.from_map(k1))
                self.white_list.append(l1)
        return self


class NotificationStrategyGroupingSettingGroupingItems(TeaModel):
    def __init__(
        self,
        keys: List[str] = None,
        type: str = None,
    ):
        self.keys = keys
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keys is not None:
            result['Keys'] = self.keys
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Keys') is not None:
            self.keys = m.get('Keys')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class NotificationStrategyGroupingSetting(TeaModel):
    def __init__(
        self,
        enable_raw_alert_dispatching: bool = None,
        grouping_items: List[NotificationStrategyGroupingSettingGroupingItems] = None,
        period_min: int = None,
        silence_sec: int = None,
        times: int = None,
    ):
        self.enable_raw_alert_dispatching = enable_raw_alert_dispatching
        self.grouping_items = grouping_items
        self.period_min = period_min
        self.silence_sec = silence_sec
        self.times = times

    def validate(self):
        if self.grouping_items:
            for k in self.grouping_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_raw_alert_dispatching is not None:
            result['EnableRawAlertDispatching'] = self.enable_raw_alert_dispatching
        result['GroupingItems'] = []
        if self.grouping_items is not None:
            for k in self.grouping_items:
                result['GroupingItems'].append(k.to_map() if k else None)
        if self.period_min is not None:
            result['PeriodMin'] = self.period_min
        if self.silence_sec is not None:
            result['SilenceSec'] = self.silence_sec
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnableRawAlertDispatching') is not None:
            self.enable_raw_alert_dispatching = m.get('EnableRawAlertDispatching')
        self.grouping_items = []
        if m.get('GroupingItems') is not None:
            for k in m.get('GroupingItems'):
                temp_model = NotificationStrategyGroupingSettingGroupingItems()
                self.grouping_items.append(temp_model.from_map(k))
        if m.get('PeriodMin') is not None:
            self.period_min = m.get('PeriodMin')
        if m.get('SilenceSec') is not None:
            self.silence_sec = m.get('SilenceSec')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class NotificationStrategyPushingSetting(TeaModel):
    def __init__(
        self,
        pushing_data_format: str = None,
        range: str = None,
        target_uuids: List[str] = None,
        template_uuid: str = None,
    ):
        self.pushing_data_format = pushing_data_format
        self.range = range
        self.target_uuids = target_uuids
        self.template_uuid = template_uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pushing_data_format is not None:
            result['PushingDataFormat'] = self.pushing_data_format
        if self.range is not None:
            result['Range'] = self.range
        if self.target_uuids is not None:
            result['TargetUuids'] = self.target_uuids
        if self.template_uuid is not None:
            result['TemplateUuid'] = self.template_uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PushingDataFormat') is not None:
            self.pushing_data_format = m.get('PushingDataFormat')
        if m.get('Range') is not None:
            self.range = m.get('Range')
        if m.get('TargetUuids') is not None:
            self.target_uuids = m.get('TargetUuids')
        if m.get('TemplateUuid') is not None:
            self.template_uuid = m.get('TemplateUuid')
        return self


class NotificationStrategyRouteSettingRoutesConditions(TeaModel):
    def __init__(
        self,
        field: str = None,
        op: str = None,
        value: str = None,
    ):
        self.field = field
        self.op = op
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field is not None:
            result['Field'] = self.field
        if self.op is not None:
            result['Op'] = self.op
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Field') is not None:
            self.field = m.get('Field')
        if m.get('Op') is not None:
            self.op = m.get('Op')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class NotificationStrategyRouteSettingRoutes(TeaModel):
    def __init__(
        self,
        conditions: List[NotificationStrategyRouteSettingRoutesConditions] = None,
        escalation_uuid: str = None,
    ):
        self.conditions = conditions
        self.escalation_uuid = escalation_uuid

    def validate(self):
        if self.conditions:
            for k in self.conditions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Conditions'] = []
        if self.conditions is not None:
            for k in self.conditions:
                result['Conditions'].append(k.to_map() if k else None)
        if self.escalation_uuid is not None:
            result['EscalationUuid'] = self.escalation_uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.conditions = []
        if m.get('Conditions') is not None:
            for k in m.get('Conditions'):
                temp_model = NotificationStrategyRouteSettingRoutesConditions()
                self.conditions.append(temp_model.from_map(k))
        if m.get('EscalationUuid') is not None:
            self.escalation_uuid = m.get('EscalationUuid')
        return self


class NotificationStrategyRouteSetting(TeaModel):
    def __init__(
        self,
        routes: List[NotificationStrategyRouteSettingRoutes] = None,
    ):
        self.routes = routes

    def validate(self):
        if self.routes:
            for k in self.routes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Routes'] = []
        if self.routes is not None:
            for k in self.routes:
                result['Routes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.routes = []
        if m.get('Routes') is not None:
            for k in m.get('Routes'):
                temp_model = NotificationStrategyRouteSettingRoutes()
                self.routes.append(temp_model.from_map(k))
        return self


class NotificationStrategy(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        description: str = None,
        escalation_setting: NotificationStrategyEscalationSetting = None,
        filter_setting: NotificationStrategyFilterSetting = None,
        grouping_setting: NotificationStrategyGroupingSetting = None,
        name: str = None,
        product: str = None,
        pushing_setting: NotificationStrategyPushingSetting = None,
        route_setting: NotificationStrategyRouteSetting = None,
        update_time: str = None,
        user_id: str = None,
        uuid: str = None,
    ):
        self.create_time = create_time
        self.description = description
        self.escalation_setting = escalation_setting
        self.filter_setting = filter_setting
        self.grouping_setting = grouping_setting
        # This parameter is required.
        self.name = name
        self.product = product
        self.pushing_setting = pushing_setting
        self.route_setting = route_setting
        self.update_time = update_time
        self.user_id = user_id
        self.uuid = uuid

    def validate(self):
        if self.escalation_setting:
            self.escalation_setting.validate()
        if self.filter_setting:
            self.filter_setting.validate()
        if self.grouping_setting:
            self.grouping_setting.validate()
        if self.pushing_setting:
            self.pushing_setting.validate()
        if self.route_setting:
            self.route_setting.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.escalation_setting is not None:
            result['EscalationSetting'] = self.escalation_setting.to_map()
        if self.filter_setting is not None:
            result['FilterSetting'] = self.filter_setting.to_map()
        if self.grouping_setting is not None:
            result['GroupingSetting'] = self.grouping_setting.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.product is not None:
            result['Product'] = self.product
        if self.pushing_setting is not None:
            result['PushingSetting'] = self.pushing_setting.to_map()
        if self.route_setting is not None:
            result['RouteSetting'] = self.route_setting.to_map()
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EscalationSetting') is not None:
            temp_model = NotificationStrategyEscalationSetting()
            self.escalation_setting = temp_model.from_map(m['EscalationSetting'])
        if m.get('FilterSetting') is not None:
            temp_model = NotificationStrategyFilterSetting()
            self.filter_setting = temp_model.from_map(m['FilterSetting'])
        if m.get('GroupingSetting') is not None:
            temp_model = NotificationStrategyGroupingSetting()
            self.grouping_setting = temp_model.from_map(m['GroupingSetting'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('PushingSetting') is not None:
            temp_model = NotificationStrategyPushingSetting()
            self.pushing_setting = temp_model.from_map(m['PushingSetting'])
        if m.get('RouteSetting') is not None:
            temp_model = NotificationStrategyRouteSetting()
            self.route_setting = temp_model.from_map(m['RouteSetting'])
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class NotificationTemplate(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        description: str = None,
        en_content: str = None,
        en_item_content: str = None,
        en_title: str = None,
        name: str = None,
        type: str = None,
        update_time: str = None,
        user_id: str = None,
        uuid: str = None,
        wraper_type: str = None,
        zh_content: str = None,
        zh_item_content: str = None,
        zh_title: str = None,
    ):
        self.create_time = create_time
        self.description = description
        self.en_content = en_content
        self.en_item_content = en_item_content
        self.en_title = en_title
        # This parameter is required.
        self.name = name
        self.type = type
        self.update_time = update_time
        self.user_id = user_id
        self.uuid = uuid
        self.wraper_type = wraper_type
        self.zh_content = zh_content
        self.zh_item_content = zh_item_content
        self.zh_title = zh_title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.en_content is not None:
            result['EnContent'] = self.en_content
        if self.en_item_content is not None:
            result['EnItemContent'] = self.en_item_content
        if self.en_title is not None:
            result['EnTitle'] = self.en_title
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.wraper_type is not None:
            result['WraperType'] = self.wraper_type
        if self.zh_content is not None:
            result['ZhContent'] = self.zh_content
        if self.zh_item_content is not None:
            result['ZhItemContent'] = self.zh_item_content
        if self.zh_title is not None:
            result['ZhTitle'] = self.zh_title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnContent') is not None:
            self.en_content = m.get('EnContent')
        if m.get('EnItemContent') is not None:
            self.en_item_content = m.get('EnItemContent')
        if m.get('EnTitle') is not None:
            self.en_title = m.get('EnTitle')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('WraperType') is not None:
            self.wraper_type = m.get('WraperType')
        if m.get('ZhContent') is not None:
            self.zh_content = m.get('ZhContent')
        if m.get('ZhItemContent') is not None:
            self.zh_item_content = m.get('ZhItemContent')
        if m.get('ZhTitle') is not None:
            self.zh_title = m.get('ZhTitle')
        return self


class PushingTargetHttpRequestTargetHeaders(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class PushingTargetHttpRequestTarget(TeaModel):
    def __init__(
        self,
        content_type: str = None,
        encrypt_signature_key: str = None,
        encrypt_string: str = None,
        encrypt_timestamp_key: str = None,
        headers: List[PushingTargetHttpRequestTargetHeaders] = None,
        method: str = None,
        url: str = None,
    ):
        self.content_type = content_type
        self.encrypt_signature_key = encrypt_signature_key
        self.encrypt_string = encrypt_string
        self.encrypt_timestamp_key = encrypt_timestamp_key
        self.headers = headers
        self.method = method
        self.url = url

    def validate(self):
        if self.headers:
            for k in self.headers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content_type is not None:
            result['ContentType'] = self.content_type
        if self.encrypt_signature_key is not None:
            result['EncryptSignatureKey'] = self.encrypt_signature_key
        if self.encrypt_string is not None:
            result['EncryptString'] = self.encrypt_string
        if self.encrypt_timestamp_key is not None:
            result['EncryptTimestampKey'] = self.encrypt_timestamp_key
        result['Headers'] = []
        if self.headers is not None:
            for k in self.headers:
                result['Headers'].append(k.to_map() if k else None)
        if self.method is not None:
            result['Method'] = self.method
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContentType') is not None:
            self.content_type = m.get('ContentType')
        if m.get('EncryptSignatureKey') is not None:
            self.encrypt_signature_key = m.get('EncryptSignatureKey')
        if m.get('EncryptString') is not None:
            self.encrypt_string = m.get('EncryptString')
        if m.get('EncryptTimestampKey') is not None:
            self.encrypt_timestamp_key = m.get('EncryptTimestampKey')
        self.headers = []
        if m.get('Headers') is not None:
            for k in m.get('Headers'):
                temp_model = PushingTargetHttpRequestTargetHeaders()
                self.headers.append(temp_model.from_map(k))
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class PushingTarget(TeaModel):
    def __init__(
        self,
        arn: str = None,
        create_time: str = None,
        description: str = None,
        http_request_target: PushingTargetHttpRequestTarget = None,
        name: str = None,
        range: str = None,
        template_uuid: str = None,
        type: str = None,
        update_time: str = None,
        user_id: str = None,
        uuid: str = None,
    ):
        self.arn = arn
        self.create_time = create_time
        self.description = description
        self.http_request_target = http_request_target
        # This parameter is required.
        self.name = name
        self.range = range
        self.template_uuid = template_uuid
        self.type = type
        self.update_time = update_time
        self.user_id = user_id
        self.uuid = uuid

    def validate(self):
        if self.http_request_target:
            self.http_request_target.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.http_request_target is not None:
            result['HttpRequestTarget'] = self.http_request_target.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.range is not None:
            result['Range'] = self.range
        if self.template_uuid is not None:
            result['TemplateUuid'] = self.template_uuid
        if self.type is not None:
            result['Type'] = self.type
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('HttpRequestTarget') is not None:
            temp_model = PushingTargetHttpRequestTarget()
            self.http_request_target = temp_model.from_map(m['HttpRequestTarget'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Range') is not None:
            self.range = m.get('Range')
        if m.get('TemplateUuid') is not None:
            self.template_uuid = m.get('TemplateUuid')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class SubscriptionConditions(TeaModel):
    def __init__(
        self,
        field: str = None,
        operator: str = None,
        value: str = None,
    ):
        self.field = field
        self.operator = operator
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field is not None:
            result['Field'] = self.field
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Field') is not None:
            self.field = m.get('Field')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class Subscription(TeaModel):
    def __init__(
        self,
        conditions: List[SubscriptionConditions] = None,
        create_time: str = None,
        description: str = None,
        enabled: bool = None,
        name: str = None,
        product: str = None,
        relation: str = None,
        strategy_uuid: str = None,
        update_time: str = None,
        uuid: str = None,
    ):
        self.conditions = conditions
        self.create_time = create_time
        self.description = description
        self.enabled = enabled
        # This parameter is required.
        self.name = name
        self.product = product
        self.relation = relation
        self.strategy_uuid = strategy_uuid
        self.update_time = update_time
        self.uuid = uuid

    def validate(self):
        if self.conditions:
            for k in self.conditions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Conditions'] = []
        if self.conditions is not None:
            for k in self.conditions:
                result['Conditions'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        if self.name is not None:
            result['Name'] = self.name
        if self.product is not None:
            result['Product'] = self.product
        if self.relation is not None:
            result['Relation'] = self.relation
        if self.strategy_uuid is not None:
            result['StrategyUuid'] = self.strategy_uuid
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.conditions = []
        if m.get('Conditions') is not None:
            for k in m.get('Conditions'):
                temp_model = SubscriptionConditions()
                self.conditions.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('Relation') is not None:
            self.relation = m.get('Relation')
        if m.get('StrategyUuid') is not None:
            self.strategy_uuid = m.get('StrategyUuid')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class AddTagsRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The tag key.
        # 
        # Valid values of N: 1 to 3. A tag key can be 1 to 64 characters in length.
        # 
        # You can create a tag key or specify an existing tag key. For more information about how to obtain a tag key, see [DescribeTagKeyList](https://help.aliyun.com/document_detail/2513189.html).
        # 
        # >  The tag key cannot start with `aliyun` or `acs:`. The tag key (`Tag.N.Key`) and tag value (`Tag.N.Value`) must be specified at the same time.
        # 
        # This parameter is required.
        self.key = key
        # The tag value.
        # 
        # Valid values of N: 1 to 3. A tag value can be 1 to 64 characters in length.
        # 
        # You can create a tag value or specify an existing tag value. For more information about how to obtain a tag value, see [DescribeTagValueList](https://help.aliyun.com/document_detail/2513188.html).
        # 
        # >  The tag value cannot start with `aliyun` or `acs:`. The tag key (`Tag.N.Key`) and tag value (`Tag.N.Value`) must be specified at the same time.
        # 
        # This parameter is required.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class AddTagsRequest(TeaModel):
    def __init__(
        self,
        group_ids: List[str] = None,
        region_id: str = None,
        tag: List[AddTagsRequestTag] = None,
    ):
        # The ID of the application group.
        # 
        # Valid values of N: 1 to 20.
        # 
        # For information about how to query the IDs of application groups, see [DescribeMonitorGroups](https://help.aliyun.com/document_detail/2513168.html).
        # 
        # This parameter is required.
        self.group_ids = group_ids
        self.region_id = region_id
        # The tags.
        # 
        # This parameter is required.
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = AddTagsRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class AddTagsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        # 
        # > The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddTagsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyMetricRuleTemplateRequest(TeaModel):
    def __init__(
        self,
        append_mode: str = None,
        apply_mode: str = None,
        enable_end_time: int = None,
        enable_start_time: int = None,
        group_id: int = None,
        notify_level: int = None,
        silence_time: int = None,
        template_ids: str = None,
        webhook: str = None,
    ):
        # The template application policy. Valid values:
        # 
        # *   all (default): deletes all the rules that are created by using the alert template from the selected application group, and then creates alert rules based on the template.
        # *   append: deletes the rules that are created by using the alert template from the selected application group, and then creates alert rules based on the existing template.
        self.append_mode = append_mode
        # The mode in which the alert template is applied. Valid values:
        # 
        # *   GROUP_INSTANCE_FIRST: The metrics in the application group take precedence. If a metric specified in the alert template does not exist in the application group, the system does not generate an alert rule for the metric based on the alert template.
        # *   ALARM_TEMPLATE_FIRST: The metrics specified in the alert template take precedence. If a metric specified in the alert template does not exist in the application group, the system still generates an alert rule for the metric based on the alert template.
        self.apply_mode = apply_mode
        # The end of the time period during which the alert rule is effective. Valid values: 00 to 23. A value of 00 indicates 00:59 and a value of 23 indicates 23:59.
        self.enable_end_time = enable_end_time
        # The beginning of the time period during which the alert rule is effective. Valid values: 00 to 23. A value of 00 indicates 00:00 and a value of 23 indicates 23:00.
        self.enable_start_time = enable_start_time
        # The ID of the application group to which the alert template is applied.
        # 
        # For more information about how to query the ID of an application group, see [DescribeMonitorGroups](https://help.aliyun.com/document_detail/115032.html).
        # 
        # This parameter is required.
        self.group_id = group_id
        # The alert notification method. Valid values:
        # 
        # Set the value to 4. A value of 4 indicates that alert notifications are sent by using TradeManager and DingTalk chatbots.
        self.notify_level = notify_level
        # The mute period during which notifications are not repeatedly sent for an alert. Unit: seconds. Default value: 86400.
        # 
        # >  Only one alert notification is sent during each mute period even if the metric value exceeds the alert threshold several times.
        self.silence_time = silence_time
        # The ID of the alert template.
        # 
        # For more information about how to query the IDs of alert templates, see [DescribeMetricRuleTemplateList](https://help.aliyun.com/document_detail/114982.html).
        # 
        # This parameter is required.
        self.template_ids = template_ids
        # The callback URL to which a POST request is sent when an alert is triggered based on the alert rule.
        self.webhook = webhook

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.append_mode is not None:
            result['AppendMode'] = self.append_mode
        if self.apply_mode is not None:
            result['ApplyMode'] = self.apply_mode
        if self.enable_end_time is not None:
            result['EnableEndTime'] = self.enable_end_time
        if self.enable_start_time is not None:
            result['EnableStartTime'] = self.enable_start_time
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.notify_level is not None:
            result['NotifyLevel'] = self.notify_level
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.template_ids is not None:
            result['TemplateIds'] = self.template_ids
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppendMode') is not None:
            self.append_mode = m.get('AppendMode')
        if m.get('ApplyMode') is not None:
            self.apply_mode = m.get('ApplyMode')
        if m.get('EnableEndTime') is not None:
            self.enable_end_time = m.get('EnableEndTime')
        if m.get('EnableStartTime') is not None:
            self.enable_start_time = m.get('EnableStartTime')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('NotifyLevel') is not None:
            self.notify_level = m.get('NotifyLevel')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('TemplateIds') is not None:
            self.template_ids = m.get('TemplateIds')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class ApplyMetricRuleTemplateResponseBodyResourceAlertResults(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        rule_id: str = None,
        rule_name: str = None,
        success: bool = None,
    ):
        # The responses code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The returned message.
        self.message = message
        # The ID of the alert rule.
        self.rule_id = rule_id
        # The name of the alert rule.
        self.rule_name = rule_name
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ApplyMetricRuleTemplateResponseBodyResource(TeaModel):
    def __init__(
        self,
        alert_results: List[ApplyMetricRuleTemplateResponseBodyResourceAlertResults] = None,
        group_id: int = None,
    ):
        # The details of the generated alert rule.
        self.alert_results = alert_results
        # The ID of the application group.
        self.group_id = group_id

    def validate(self):
        if self.alert_results:
            for k in self.alert_results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertResults'] = []
        if self.alert_results is not None:
            for k in self.alert_results:
                result['AlertResults'].append(k.to_map() if k else None)
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert_results = []
        if m.get('AlertResults') is not None:
            for k in m.get('AlertResults'):
                temp_model = ApplyMetricRuleTemplateResponseBodyResourceAlertResults()
                self.alert_results.append(temp_model.from_map(k))
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class ApplyMetricRuleTemplateResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        request_id: str = None,
        resource: ApplyMetricRuleTemplateResponseBodyResource = None,
        success: bool = None,
    ):
        # The responses code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # The resources that are affected by the alert rule.
        self.resource = resource
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        if self.resource:
            self.resource.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource is not None:
            result['Resource'] = self.resource.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resource') is not None:
            temp_model = ApplyMetricRuleTemplateResponseBodyResource()
            self.resource = temp_model.from_map(m['Resource'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ApplyMetricRuleTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyMetricRuleTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyMetricRuleTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCreateInstantSiteMonitorRequestTaskList(TeaModel):
    def __init__(
        self,
        address: str = None,
        isp_cities: str = None,
        options_json: str = None,
        task_name: str = None,
        task_type: str = None,
    ):
        # The URL or IP address that is monitored by the task.
        # 
        # >  You must create at least one site monitoring task. You must specify all of the `Address`, `TaskName`, and `TaskType` parameters in each request.
        self.address = address
        # The detection points. If you leave this parameter empty, the system randomly selects three detection points.
        # 
        # The value is a `JSON array`. Example: `{"city":"546","isp":"465"},{"city":"572","isp":"465"},{"city":"738","isp":"465"}`. The values of the city field indicate Beijing, Hangzhou, and Qingdao.
        # 
        # For information about how to obtain detection points, see [DescribeSiteMonitorISPCityList](https://help.aliyun.com/document_detail/115045.html).
        self.isp_cities = isp_cities
        # The extended options of the protocol that is used by the site monitoring task. The options vary based on the protocol.
        self.options_json = options_json
        # The name of the site monitoring task.
        # 
        # The name must be 4 to 100 characters in length, and can contain letters, digits, and underscores (_).
        # 
        # >  You must create at least one site monitoring task. You must specify all of the `Address`, `TaskName`, and `TaskType` parameters in each request.
        self.task_name = task_name
        # The type of the site monitoring task.
        # 
        # Valid values: HTTP, PING, TCP, UDP, DNS, SMTP, POP3, and FTP.
        # 
        # >  You must create at least one site monitoring task. You must specify all of the `Address`, `TaskName`, and `TaskType` parameters in each request.
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.isp_cities is not None:
            result['IspCities'] = self.isp_cities
        if self.options_json is not None:
            result['OptionsJson'] = self.options_json
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('IspCities') is not None:
            self.isp_cities = m.get('IspCities')
        if m.get('OptionsJson') is not None:
            self.options_json = m.get('OptionsJson')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class BatchCreateInstantSiteMonitorRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        task_list: List[BatchCreateInstantSiteMonitorRequestTaskList] = None,
    ):
        self.region_id = region_id
        # The site monitoring tasks.
        # 
        # >  You must create at least one site monitoring task. You must specify all of the `Address`, `TaskName`, and `TaskType` parameters in each request.
        # 
        # This parameter is required.
        self.task_list = task_list

    def validate(self):
        if self.task_list:
            for k in self.task_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['TaskList'] = []
        if self.task_list is not None:
            for k in self.task_list:
                result['TaskList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.task_list = []
        if m.get('TaskList') is not None:
            for k in m.get('TaskList'):
                temp_model = BatchCreateInstantSiteMonitorRequestTaskList()
                self.task_list.append(temp_model.from_map(k))
        return self


class BatchCreateInstantSiteMonitorResponseBodyData(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        task_name: str = None,
    ):
        # The ID of the site monitoring task.
        self.task_id = task_id
        # The name of the site monitoring task.
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class BatchCreateInstantSiteMonitorResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[BatchCreateInstantSiteMonitorResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The information about the site monitoring task.
        self.data = data
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = BatchCreateInstantSiteMonitorResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchCreateInstantSiteMonitorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchCreateInstantSiteMonitorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchCreateInstantSiteMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchExportRequest(TeaModel):
    def __init__(
        self,
        cursor: str = None,
        length: int = None,
        measurements: List[str] = None,
        metric: str = None,
        namespace: str = None,
    ):
        # When you call this operation to export data, you must specify the `Cursor` parameter. You can obtain the value of the `Cursor` parameter by using one of the following methods:
        # 
        # *   When you call this operation for the first time, you must call the Cursor operation to obtain the `Cursor` value. For more information, see [Cursor](https://help.aliyun.com/document_detail/2330730.html).
        # *   When you call this operation again, you can obtain the `Cursor` value from the returned data of the last call.
        # 
        # This parameter is required.
        self.cursor = cursor
        # The maximum number of data entries that can be returned in each response.
        # 
        # Valid values: 1 to 10000.
        # 
        # This parameter is required.
        self.length = length
        # The statistical methods used to customize the returned data. By default, the measurements based on all statistical methods are returned.
        # 
        # For example, the `cpu_idle` metric of ECS (`acs_ecs_dashboard`) has three statistical methods: `Average`, `Maximum`, and `Minimum`. If you want to return only the measurements based on the `Average` and `Maximum` statistical methods, set this parameter to `["Average", "Maximum"]`.
        # 
        # The statistical methods of metrics are displayed in the `Statistics` column on the Metrics page of each cloud service. For more information, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.measurements = measurements
        # The metric that is used to monitor the cloud service.
        # 
        # For more information about the metrics of cloud services, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # >  The value of this parameter must be the same as the value of the request parameter `Metric` in the Cursor operation.
        # 
        # This parameter is required.
        self.metric = metric
        # The namespace of the cloud service.
        # 
        # For more information about the namespaces of cloud services, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # >  The value of this parameter must be the same as the value of the request parameter `Namespace` in the Cursor operation.
        # 
        # This parameter is required.
        self.namespace = namespace

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cursor is not None:
            result['Cursor'] = self.cursor
        if self.length is not None:
            result['Length'] = self.length
        if self.measurements is not None:
            result['Measurements'] = self.measurements
        if self.metric is not None:
            result['Metric'] = self.metric
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cursor') is not None:
            self.cursor = m.get('Cursor')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('Measurements') is not None:
            self.measurements = m.get('Measurements')
        if m.get('Metric') is not None:
            self.metric = m.get('Metric')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        return self


class BatchExportShrinkRequest(TeaModel):
    def __init__(
        self,
        cursor: str = None,
        length: int = None,
        measurements_shrink: str = None,
        metric: str = None,
        namespace: str = None,
    ):
        # When you call this operation to export data, you must specify the `Cursor` parameter. You can obtain the value of the `Cursor` parameter by using one of the following methods:
        # 
        # *   When you call this operation for the first time, you must call the Cursor operation to obtain the `Cursor` value. For more information, see [Cursor](https://help.aliyun.com/document_detail/2330730.html).
        # *   When you call this operation again, you can obtain the `Cursor` value from the returned data of the last call.
        # 
        # This parameter is required.
        self.cursor = cursor
        # The maximum number of data entries that can be returned in each response.
        # 
        # Valid values: 1 to 10000.
        # 
        # This parameter is required.
        self.length = length
        # The statistical methods used to customize the returned data. By default, the measurements based on all statistical methods are returned.
        # 
        # For example, the `cpu_idle` metric of ECS (`acs_ecs_dashboard`) has three statistical methods: `Average`, `Maximum`, and `Minimum`. If you want to return only the measurements based on the `Average` and `Maximum` statistical methods, set this parameter to `["Average", "Maximum"]`.
        # 
        # The statistical methods of metrics are displayed in the `Statistics` column on the Metrics page of each cloud service. For more information, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.measurements_shrink = measurements_shrink
        # The metric that is used to monitor the cloud service.
        # 
        # For more information about the metrics of cloud services, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # >  The value of this parameter must be the same as the value of the request parameter `Metric` in the Cursor operation.
        # 
        # This parameter is required.
        self.metric = metric
        # The namespace of the cloud service.
        # 
        # For more information about the namespaces of cloud services, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # >  The value of this parameter must be the same as the value of the request parameter `Namespace` in the Cursor operation.
        # 
        # This parameter is required.
        self.namespace = namespace

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cursor is not None:
            result['Cursor'] = self.cursor
        if self.length is not None:
            result['Length'] = self.length
        if self.measurements_shrink is not None:
            result['Measurements'] = self.measurements_shrink
        if self.metric is not None:
            result['Metric'] = self.metric
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cursor') is not None:
            self.cursor = m.get('Cursor')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('Measurements') is not None:
            self.measurements_shrink = m.get('Measurements')
        if m.get('Metric') is not None:
            self.metric = m.get('Metric')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        return self


class BatchExportResponseBody(TeaModel):
    def __init__(
        self,
        anchor: int = None,
        code: int = None,
        cursor: str = None,
        data_results: List[MetricStat] = None,
        has_next: bool = None,
        length: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The timestamp of the data requested by the backend. A larger timestamp indicates that the data export time is closer to the current time.
        self.anchor = anchor
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The Cursor information that is used to call this operation again.
        # 
        # >  If `null` is returned, the monitoring data is exported.
        self.cursor = cursor
        # The data returned in this call.
        self.data_results = data_results
        # Indicates whether the data has been exported. Valid values:
        # 
        # *   true: Some data is not exported.
        # *   false: All the data is exported.
        self.has_next = has_next
        # The number of data entries returned in this call.
        self.length = length
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        if self.data_results:
            for k in self.data_results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.anchor is not None:
            result['Anchor'] = self.anchor
        if self.code is not None:
            result['Code'] = self.code
        if self.cursor is not None:
            result['Cursor'] = self.cursor
        result['DataResults'] = []
        if self.data_results is not None:
            for k in self.data_results:
                result['DataResults'].append(k.to_map() if k else None)
        if self.has_next is not None:
            result['HasNext'] = self.has_next
        if self.length is not None:
            result['Length'] = self.length
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Anchor') is not None:
            self.anchor = m.get('Anchor')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Cursor') is not None:
            self.cursor = m.get('Cursor')
        self.data_results = []
        if m.get('DataResults') is not None:
            for k in m.get('DataResults'):
                temp_model = MetricStat()
                self.data_results.append(temp_model.from_map(k))
        if m.get('HasNext') is not None:
            self.has_next = m.get('HasNext')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchExportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchExportResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchExportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDynamicTagGroupRequestMatchExpress(TeaModel):
    def __init__(
        self,
        tag_name: str = None,
        tag_value: str = None,
        tag_value_match_function: str = None,
    ):
        # The keys of the tags that are used to create the application group. If a specified key is attached to multiple resources, the resources that have the same key-value pair are added to the same group.
        self.tag_name = tag_name
        # The tag values of the cloud resources. Set the value of N to 1.
        # 
        # >  If you set the `MatchExpress.N.TagValueMatchFunction` parameter, you must also set the `MatchExpress.N.TagValue` parameter.
        self.tag_value = tag_value
        # The method that is used to match the tag values of the cloud resources. Set the value of N to 1. Valid values:
        # 
        # *   contains: contains
        # *   startWith: starts with a prefix
        # *   endWith: ends with a suffix
        # *   notContains: does not contain
        # *   equals: equals
        # *   all: matches all
        # 
        # >  If you set the `MatchExpress.N.TagValueMatchFunction` parameter, you must also set the `MatchExpress.N.TagValue` parameter.
        self.tag_value_match_function = tag_value_match_function

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_value_match_function is not None:
            result['TagValueMatchFunction'] = self.tag_value_match_function
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagValueMatchFunction') is not None:
            self.tag_value_match_function = m.get('TagValueMatchFunction')
        return self


class CreateDynamicTagGroupRequest(TeaModel):
    def __init__(
        self,
        contact_group_list: List[str] = None,
        enable_install_agent: bool = None,
        enable_subscribe_event: bool = None,
        match_express: List[CreateDynamicTagGroupRequestMatchExpress] = None,
        match_express_filter_relation: str = None,
        region_id: str = None,
        tag_key: str = None,
        tag_region_id: str = None,
        template_id_list: List[str] = None,
    ):
        # This parameter is required.
        self.contact_group_list = contact_group_list
        # Specifies whether the CloudMonitor agent is automatically installed for the application group. CloudMonitor determines whether to automatically install the CloudMonitor agent for the hosts in an application group based on the value of this parameter. Valid values:
        # 
        # *   true: The CloudMonitor agent is automatically installed.
        # *   false (default value): The CloudMonitor agent is not automatically installed.
        self.enable_install_agent = enable_install_agent
        # Specifies whether the application group automatically subscribes to event notifications. If events whose severity level is critical or warning occur on resources in an application group, CloudMonitor sends alert notifications. Valid values:
        # 
        # *   true: The application group automatically subscribes to event notifications.
        # *   false (default value): The application group does not automatically subscribe to event notifications.
        self.enable_subscribe_event = enable_subscribe_event
        # The conditional expressions used to create an application group based on the tag.
        # 
        # This parameter is required.
        self.match_express = match_express
        # The relationship between the conditional expressions for the tag values of the cloud resources. Valid values:
        # 
        # *   and (default)
        # *   or
        self.match_express_filter_relation = match_express_filter_relation
        self.region_id = region_id
        # The tag keys of the cloud resources.
        # 
        # For more information about how to obtain tag keys, see [DescribeTagKeyList](https://help.aliyun.com/document_detail/145558.html).
        # 
        # This parameter is required.
        self.tag_key = tag_key
        # The ID of the region to which the tags belong.
        self.tag_region_id = tag_region_id
        self.template_id_list = template_id_list

    def validate(self):
        if self.match_express:
            for k in self.match_express:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_list is not None:
            result['ContactGroupList'] = self.contact_group_list
        if self.enable_install_agent is not None:
            result['EnableInstallAgent'] = self.enable_install_agent
        if self.enable_subscribe_event is not None:
            result['EnableSubscribeEvent'] = self.enable_subscribe_event
        result['MatchExpress'] = []
        if self.match_express is not None:
            for k in self.match_express:
                result['MatchExpress'].append(k.to_map() if k else None)
        if self.match_express_filter_relation is not None:
            result['MatchExpressFilterRelation'] = self.match_express_filter_relation
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_region_id is not None:
            result['TagRegionId'] = self.tag_region_id
        if self.template_id_list is not None:
            result['TemplateIdList'] = self.template_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroupList') is not None:
            self.contact_group_list = m.get('ContactGroupList')
        if m.get('EnableInstallAgent') is not None:
            self.enable_install_agent = m.get('EnableInstallAgent')
        if m.get('EnableSubscribeEvent') is not None:
            self.enable_subscribe_event = m.get('EnableSubscribeEvent')
        self.match_express = []
        if m.get('MatchExpress') is not None:
            for k in m.get('MatchExpress'):
                temp_model = CreateDynamicTagGroupRequestMatchExpress()
                self.match_express.append(temp_model.from_map(k))
        if m.get('MatchExpressFilterRelation') is not None:
            self.match_express_filter_relation = m.get('MatchExpressFilterRelation')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagRegionId') is not None:
            self.tag_region_id = m.get('TagRegionId')
        if m.get('TemplateIdList') is not None:
            self.template_id_list = m.get('TemplateIdList')
        return self


class CreateDynamicTagGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        id: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the call is successful.
        self.code = code
        # The ID of the tag matching rule.
        self.id = id
        # The error message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the call is successful. Valid values:
        # 
        # *   true: The call is successful.
        # *   false: The call fails.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDynamicTagGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDynamicTagGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDynamicTagGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateGroupMetricRulesRequestGroupMetricRulesEscalationsCritical(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        n: str = None,
        pre_condition: str = None,
        statistics: str = None,
        threshold: str = None,
        times: int = None,
    ):
        self.comparison_operator = comparison_operator
        self.n = n
        self.pre_condition = pre_condition
        self.statistics = statistics
        self.threshold = threshold
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.n is not None:
            result['N'] = self.n
        if self.pre_condition is not None:
            result['PreCondition'] = self.pre_condition
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('N') is not None:
            self.n = m.get('N')
        if m.get('PreCondition') is not None:
            self.pre_condition = m.get('PreCondition')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class CreateGroupMetricRulesRequestGroupMetricRulesEscalationsInfo(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        n: str = None,
        pre_condition: str = None,
        statistics: str = None,
        threshold: str = None,
        times: int = None,
    ):
        self.comparison_operator = comparison_operator
        self.n = n
        self.pre_condition = pre_condition
        self.statistics = statistics
        self.threshold = threshold
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.n is not None:
            result['N'] = self.n
        if self.pre_condition is not None:
            result['PreCondition'] = self.pre_condition
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('N') is not None:
            self.n = m.get('N')
        if m.get('PreCondition') is not None:
            self.pre_condition = m.get('PreCondition')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class CreateGroupMetricRulesRequestGroupMetricRulesEscalationsWarn(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        n: str = None,
        pre_condition: str = None,
        statistics: str = None,
        threshold: str = None,
        times: int = None,
    ):
        self.comparison_operator = comparison_operator
        self.n = n
        self.pre_condition = pre_condition
        self.statistics = statistics
        self.threshold = threshold
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.n is not None:
            result['N'] = self.n
        if self.pre_condition is not None:
            result['PreCondition'] = self.pre_condition
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('N') is not None:
            self.n = m.get('N')
        if m.get('PreCondition') is not None:
            self.pre_condition = m.get('PreCondition')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class CreateGroupMetricRulesRequestGroupMetricRulesEscalations(TeaModel):
    def __init__(
        self,
        critical: CreateGroupMetricRulesRequestGroupMetricRulesEscalationsCritical = None,
        info: CreateGroupMetricRulesRequestGroupMetricRulesEscalationsInfo = None,
        warn: CreateGroupMetricRulesRequestGroupMetricRulesEscalationsWarn = None,
    ):
        self.critical = critical
        self.info = info
        self.warn = warn

    def validate(self):
        if self.critical:
            self.critical.validate()
        if self.info:
            self.info.validate()
        if self.warn:
            self.warn.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.critical is not None:
            result['Critical'] = self.critical.to_map()
        if self.info is not None:
            result['Info'] = self.info.to_map()
        if self.warn is not None:
            result['Warn'] = self.warn.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Critical') is not None:
            temp_model = CreateGroupMetricRulesRequestGroupMetricRulesEscalationsCritical()
            self.critical = temp_model.from_map(m['Critical'])
        if m.get('Info') is not None:
            temp_model = CreateGroupMetricRulesRequestGroupMetricRulesEscalationsInfo()
            self.info = temp_model.from_map(m['Info'])
        if m.get('Warn') is not None:
            temp_model = CreateGroupMetricRulesRequestGroupMetricRulesEscalationsWarn()
            self.warn = temp_model.from_map(m['Warn'])
        return self


class CreateGroupMetricRulesRequestGroupMetricRulesLabels(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The tag key of the alert rule. The specified tag is contained in alert notifications.
        # 
        # Valid values of N: 1 to 200.
        self.key = key
        # The tag value of the alert rule. The specified tag is contained in alert notifications.
        # 
        # Valid values of N: 1 to 200.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateGroupMetricRulesRequestGroupMetricRules(TeaModel):
    def __init__(
        self,
        escalations: CreateGroupMetricRulesRequestGroupMetricRulesEscalations = None,
        category: str = None,
        contact_groups: str = None,
        dimensions: str = None,
        effective_interval: str = None,
        email_subject: str = None,
        interval: str = None,
        labels: List[CreateGroupMetricRulesRequestGroupMetricRulesLabels] = None,
        metric_name: str = None,
        namespace: str = None,
        no_data_policy: str = None,
        no_effective_interval: str = None,
        options: str = None,
        period: str = None,
        rule_id: str = None,
        rule_name: str = None,
        silence_time: int = None,
        webhook: str = None,
    ):
        self.escalations = escalations
        # The name of the cloud service. Valid values of N: 1 to 200. Valid value:
        # 
        # *   PolarDB: PolarDB
        # *   NewBGPDDoS: Anti-DDoS Pro
        # *   IoTDevice: IoT Platform
        # *   DRDS: Distributed Relational Database Service (DRDS)
        # *   VS: Video Surveillance System
        # *   AMQP: Alibaba Cloud Message Queue for AMQP
        # *   ADS: AnalyticDB
        # *   APIGateway: API Gateway
        # *   InternetSharedBandwidth: EIP Bandwidth Plan
        # *   CDN: Alibaba Cloud Content Delivery Network (CDN)
        # *   CEN: Cloud Enterprise Network (CEN)
        # *   DCDN: Dynamic Route for CDN (DCDN)
        # *   DDoS: Anti-DDoS
        # *   ECS: Elastic Compute Service (ECS)
        # *   DirectMail: Direct Mail
        # *   Elasticsearch: Elasticsearch
        # *   EMR: E-MapReduce (EMR)
        # *   ESS: Auto Scaling
        # *   FunctionCompute: Function Compute
        # *   RealtimeCompute: Realtime Compute for Apache Flink
        # *   GlobalAcceleration: Global Accelerator (GA)
        # *   Hbase: ApsaraDB for HBase
        # *   TSDB: Time Series Database (TSDB)
        # *   IPv6trans: IPv6 Translation Service
        # *   Kafka: Message Queue for Apache Kafka
        # *   Kubernetes: Container Service for Kubernetes (ACK)
        # *   KVstore: ApsaraDB for Redis
        # *   MNS: Message Service (MNS)
        # *   MongoDB: ApsaraDB for MongoDB
        # *   MQ: Message Queue
        # *   NAT: NAT Gateway
        # *   OpenAd: Open Ad
        # *   OpenSearch: Open Search
        # *   OSS: Object Storage Service (OSS)
        # *   PCDN: P2P CDN
        # *   petadata: HybridDB for MySQL
        # *   RDS: ApsaraDB RDS
        # *   SCDN: Secure CDN
        # *   SLB: Server Load Balancer (SLB)
        # *   SLS: Log Service
        # *   VideoLive: ApsaraVideo Live
        # *   VOD: ApsaraVideo VOD
        # *   EIP: Elastic IP Address (EIP)
        # *   VPN: VPN Gateway
        # *   AIRec: Artificial Intelligence Recommendation
        # *   GPDB: AnalyticDB for PostgreSQL
        # *   DBS: Database Backup (DBS)
        # *   SAG: Smart Access Gateway (SAG)
        # *   Memcache: ApsaraDB for Memcache
        # *   IOT_EDGE: Link IoT Edge
        # *   OCS: ApsaraDB for Memcache (previous version)
        # *   VPC: Express Connect
        # *   EHPC: Elastic High Performance Computing (E-HPC)
        # *   MPS: ApsaraVideo Media Processing
        # *   ENS: Edge Node Service (ENS)
        # *   MaxCompute_Prepay: MaxCompute
        # *   IoT_Kubernetes: Edge Application Hosting
        # *   CMS: CloudMonitor
        # *   batchcomputenew: Batch Compute
        # *   HBaseUE: ApsaraDB for HBase Performance-enhanced Edition
        # *   UIS: Ultimate Internet Service (UIS)
        # *   nls: Intelligent Speech Interaction
        # *   ots: Tablestore
        # *   NAS: File Storage NAS
        # *   ECI: Elastic Container Instance (ECI)
        # *   OpenAPI: OpenAPI Explorer
        # *   pvtzpost: Alibaba Cloud DNS PrivateZone
        # *   blinkonk8s: Flink on Kubernetes
        # *   FunctionFlow: Serverless Workflow (SWF)
        # *   SMC: Server Migration Center (SMC)
        # *   ddosbgp: Anti-DDoS Origin
        # *   baas: Blockchain as a Service
        # *   privatelink: PrivateLink
        # *   cds: ApsaraDB for Cassandra
        # *   DDH: Dedicated Host
        # *   RocketMQ: Message Queue for Apache RocketMQ
        # *   ECC: Express Cloud Connect
        # *   hbaseserverless: ApsaraDB for HBase Serverless Edition
        # *   mns_tmp: Message Service
        # *   hdr: Hybrid Disaster Recovery (HDR)
        # *   hbr: Hybrid Backup Recovery (HBR)
        # *   ADB: AnalyticDB for MySQL V3.0
        # *   tag: Tag Service
        # *   GDB: Graph Database
        # *   WAF: Web Application Firewall (WAF)
        # *   hcs_sgw: Cloud Storage Gateway (CSG)
        # *   ipv6gateway: IPv6 Gateway
        # *   RDS_SAR: ApsaraDB Exclusive Host Group
        # *   learn: Machine Learning Platform for AI
        # *   ROS: Resource Orchestration Service (ROS)
        # *   OOS: Operation Orchestration Service (OOS)
        # *   bds: Data Synchronization for HBase
        # *   cfw: Cloud Firewall
        # *   ddosDip: Anti-DDoS Premium
        # *   datahub: DataHub
        # *   hologres: Hologres
        # *   ExpressConnect: Express Connect
        # *   dbfs: Database File System (DBFS)
        # *   clickhouse: ApsaraDB for ClickHouse
        # *   k8s: Container Service for Kubernetes (ACK)
        # *   DTS: Data Transmission Service (DTS)
        # *   AnycastEIP: Anycast Elastic IP Address
        # *   Lindorm: ApsaraDB for Lindorm
        # *   config: Cloud Config
        # *   spark: Databricks DataInsight (DDI)
        # *   serverless: Serverless App Engine (SAE)
        # *   alb: Application Load Balancer (ALB)
        # *   oceanbase: ApsaraDB for OceanBase
        # *   KMS: Key Management Service (KMS)
        # *   lvwang: Content Moderation
        # *   LinkVisual: LinkVisual
        # *   tair: ApsaraDB for Redis Enhanced Edition (Tair)
        # *   dlf: Data Lake Formation (DLF)
        # *   networkmonitor: Site Monitoring
        # *   pnc: Physical Network Change
        # *   AIS: Alibaba Cloud Infrastructure
        # *   cloudgame: Cloud Gaming Platform
        # *   RTC: Real-Time Communication
        # *   cloudbox: CloudBox
        # *   actiontrail: ActionTrail
        # *   cc: Cloud Connector
        # *   disk: Elastic Block Storage (EBS)
        # *   easygene: Genomics Computing Platform
        # *   cloudphone: Elastic Cloud Phone
        # *   BMS: Bare Metal Management Service
        # *   swas: Simple Application Server
        # *   AvailabilityMonitoring: Availability Monitoring of CloudMonitor
        # 
        # This parameter is required.
        self.category = category
        # The alert contact groups. Valid values of N: 1 to 200.
        # 
        # For information about how to obtain alert contact groups, see [DescribeContactGroupList](https://help.aliyun.com/document_detail/114922.html).
        self.contact_groups = contact_groups
        # The dimension of the alert rule. Valid values of N: 1 to 200.
        # 
        # Set the value to a set of key-value pairs, for example, `userId:120886317861****` or `instanceId:i-m5e1qg6uo38rztr4****`.
        self.dimensions = dimensions
        # The time period during which the alert rule is effective. Valid values of N: 1 to 200.
        self.effective_interval = effective_interval
        # The subject of the alert notification email. Valid values of N: 1 to 200.
        self.email_subject = email_subject
        # The interval at which CloudMonitor checks whether the alert rule is triggered. Valid values of N: 1 to 200.
        # 
        # Unit: seconds. The default value is the lowest frequency at which the metric is polled.
        # 
        # >  We recommend that you set the interval to the data aggregation period. If the interval is shorter than the data aggregation period, alerts cannot be triggered due to insufficient data.
        self.interval = interval
        self.labels = labels
        # The name of the metric. Valid values of N: 1 to 200.
        # 
        # For information about how to obtain the name of a metric, see [DescribeMetricMetaList](https://help.aliyun.com/document_detail/98846.html) or [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # This parameter is required.
        self.metric_name = metric_name
        # The namespace of the cloud service. Valid values of N: 1 to 200.
        # 
        # For information about how to obtain the namespace of a cloud service, see [DescribeMetricMetaList](https://help.aliyun.com/document_detail/98846.html) or [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # This parameter is required.
        self.namespace = namespace
        # The method that is used to handle alerts when no monitoring data is found. Valid values of N: 1 to 200. Valid value:
        # 
        # *   KEEP_LAST_STATE (default value): No operation is performed.
        # *   INSUFFICIENT_DATA: An alert whose content is "Insufficient data" is triggered.
        # *   OK: The alert rule has no active alerts.
        self.no_data_policy = no_data_policy
        # The time period during which the alert rule is ineffective. Valid values of N: 1 to 200.
        self.no_effective_interval = no_effective_interval
        self.options = options
        # The aggregation period of the metric data. Valid values of N: 1 to 200.
        # 
        # Set the `Period` parameter to an integral multiple of 60. Unit: seconds. Default value: 300.
        self.period = period
        # The ID of the alert rule. Valid values of N: 1 to 200.
        # 
        # This parameter is required.
        self.rule_id = rule_id
        # The name of the alert rule. Valid values of N: 1 to 200.
        # 
        # This parameter is required.
        self.rule_name = rule_name
        # The mute period during which new alerts are not sent even if the trigger conditions are met. Valid values of N: 1 to 200.
        # 
        # Unit: seconds. Default value: 86400. Minimum value: 3600.
        self.silence_time = silence_time
        # The callback URL. Valid values of N: 1 to 200.
        # 
        # The callback URL must be accessible over the Internet. CloudMonitor pushes an alert notification to the specified callback URL by sending an HTTP POST request. Only the HTTP protocol is supported.
        self.webhook = webhook

    def validate(self):
        if self.escalations:
            self.escalations.validate()
        if self.labels:
            for k in self.labels:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.escalations is not None:
            result['Escalations'] = self.escalations.to_map()
        if self.category is not None:
            result['Category'] = self.category
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.effective_interval is not None:
            result['EffectiveInterval'] = self.effective_interval
        if self.email_subject is not None:
            result['EmailSubject'] = self.email_subject
        if self.interval is not None:
            result['Interval'] = self.interval
        result['Labels'] = []
        if self.labels is not None:
            for k in self.labels:
                result['Labels'].append(k.to_map() if k else None)
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.no_data_policy is not None:
            result['NoDataPolicy'] = self.no_data_policy
        if self.no_effective_interval is not None:
            result['NoEffectiveInterval'] = self.no_effective_interval
        if self.options is not None:
            result['Options'] = self.options
        if self.period is not None:
            result['Period'] = self.period
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Escalations') is not None:
            temp_model = CreateGroupMetricRulesRequestGroupMetricRulesEscalations()
            self.escalations = temp_model.from_map(m['Escalations'])
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('ContactGroups') is not None:
            self.contact_groups = m.get('ContactGroups')
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EffectiveInterval') is not None:
            self.effective_interval = m.get('EffectiveInterval')
        if m.get('EmailSubject') is not None:
            self.email_subject = m.get('EmailSubject')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        self.labels = []
        if m.get('Labels') is not None:
            for k in m.get('Labels'):
                temp_model = CreateGroupMetricRulesRequestGroupMetricRulesLabels()
                self.labels.append(temp_model.from_map(k))
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NoDataPolicy') is not None:
            self.no_data_policy = m.get('NoDataPolicy')
        if m.get('NoEffectiveInterval') is not None:
            self.no_effective_interval = m.get('NoEffectiveInterval')
        if m.get('Options') is not None:
            self.options = m.get('Options')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class CreateGroupMetricRulesRequest(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        group_metric_rules: List[CreateGroupMetricRulesRequestGroupMetricRules] = None,
        region_id: str = None,
    ):
        # The ID of the application group.
        # 
        # For information about how to obtain the ID of an application group, see [DescribeMonitorGroups](https://help.aliyun.com/document_detail/115032.html).
        # 
        # This parameter is required.
        self.group_id = group_id
        self.group_metric_rules = group_metric_rules
        self.region_id = region_id

    def validate(self):
        if self.group_metric_rules:
            for k in self.group_metric_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        result['GroupMetricRules'] = []
        if self.group_metric_rules is not None:
            for k in self.group_metric_rules:
                result['GroupMetricRules'].append(k.to_map() if k else None)
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        self.group_metric_rules = []
        if m.get('GroupMetricRules') is not None:
            for k in m.get('GroupMetricRules'):
                temp_model = CreateGroupMetricRulesRequestGroupMetricRules()
                self.group_metric_rules.append(temp_model.from_map(k))
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateGroupMetricRulesResponseBodyResourcesAlertResult(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        rule_id: str = None,
        rule_name: str = None,
        success: bool = None,
    ):
        # The status code that is returned for the alert rule.
        # 
        # >  The status code 200 indicates that the call is successful.
        self.code = code
        # The error message that is returned for the alert rule.
        self.message = message
        # The ID of the alert rule.
        self.rule_id = rule_id
        # The name of the alert rule.
        self.rule_name = rule_name
        # Indicates whether the alert rule was created. Valid value:
        # 
        # - true: The alert rule was created.
        # - false: The alert rule failed to be created.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateGroupMetricRulesResponseBodyResources(TeaModel):
    def __init__(
        self,
        alert_result: List[CreateGroupMetricRulesResponseBodyResourcesAlertResult] = None,
    ):
        self.alert_result = alert_result

    def validate(self):
        if self.alert_result:
            for k in self.alert_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertResult'] = []
        if self.alert_result is not None:
            for k in self.alert_result:
                result['AlertResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert_result = []
        if m.get('AlertResult') is not None:
            for k in m.get('AlertResult'):
                temp_model = CreateGroupMetricRulesResponseBodyResourcesAlertResult()
                self.alert_result.append(temp_model.from_map(k))
        return self


class CreateGroupMetricRulesResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        request_id: str = None,
        resources: CreateGroupMetricRulesResponseBodyResources = None,
        success: bool = None,
    ):
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the call is successful.
        self.code = code
        # The error message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # The details of the alert rules.
        self.resources = resources
        # Indicates whether the call is successful. Valid value:
        # 
        # - true: The call is successful.
        # - false: The call fails.
        self.success = success

    def validate(self):
        if self.resources:
            self.resources.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resources is not None:
            result['Resources'] = self.resources.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resources') is not None:
            temp_model = CreateGroupMetricRulesResponseBodyResources()
            self.resources = temp_model.from_map(m['Resources'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateGroupMetricRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateGroupMetricRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateGroupMetricRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateGroupMonitoringAgentProcessRequestAlertConfigTargetList(TeaModel):
    def __init__(
        self,
        arn: str = None,
        id: str = None,
        json_params: str = None,
        level: str = None,
    ):
        # The Alibaba Cloud Resource Name (ARN) of the resource.
        # 
        # For more information about how to query the ARN of a resource, see [DescribeMetricRuleTargets](https://help.aliyun.com/document_detail/121592.html).
        # 
        # Format: `acs:{Service name abbreviation}:{regionId}:{userId}:/{Resource type}/{Resource name}/message`. Example: `acs:mns:cn-hangzhou:120886317861****:/queues/test123/message`. Fields:
        # 
        # *   {Service name abbreviation}: the abbreviation of the service name. Set the value to Simple Message Queue (formerly MNS) (SMQ).
        # 
        # *   {userId}: the ID of the Alibaba Cloud account.
        # 
        # *   {regionId}: the region ID of the SMQ queue or topic.
        # 
        # *   {Resource type}: the type of the resource that triggers the alert. Valid values:
        # 
        #     *   **queues**\
        #     *   **topics**\
        # 
        # *   {Resource name}: the resource name.
        # 
        #     *   If the resource type is **queues**, the resource name is the queue name.
        #     *   If the resource type is **topics**, the resource name is the topic name.
        self.arn = arn
        # The ID of the resource for which alerts are triggered.
        # 
        # For more information about how to obtain the ID of a resource for which alerts are triggered, see [DescribeMetricRuleTargets](https://help.aliyun.com/document_detail/121592.html).
        self.id = id
        # The parameters of the alert callback. The parameters are in the JSON format.
        self.json_params = json_params
        # The alert level. Valid values:
        # 
        # *   INFO
        # *   WARN
        # *   CRITICAL
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.id is not None:
            result['Id'] = self.id
        if self.json_params is not None:
            result['JsonParams'] = self.json_params
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('JsonParams') is not None:
            self.json_params = m.get('JsonParams')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class CreateGroupMonitoringAgentProcessRequestAlertConfig(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        effective_interval: str = None,
        escalations_level: str = None,
        no_effective_interval: str = None,
        silence_time: str = None,
        statistics: str = None,
        target_list: List[CreateGroupMonitoringAgentProcessRequestAlertConfigTargetList] = None,
        threshold: str = None,
        times: str = None,
        webhook: str = None,
    ):
        # The operator that is used to compare the metric value with the threshold. Valid values:
        # 
        # *   GreaterThanOrEqualToThreshold: greater than or equal to the threshold
        # *   GreaterThanThreshold: greater than the threshold
        # *   LessThanOrEqualToThreshold: less than or equal to the threshold
        # *   LessThanThreshold: less than the threshold
        # *   NotEqualToThreshold: not equal to the threshold
        # *   GreaterThanYesterday: greater than the metric value at the same time yesterday
        # *   LessThanYesterday: less than the metric value at the same time yesterday
        # *   GreaterThanLastWeek: greater than the metric value at the same time last week
        # *   LessThanLastWeek: less than the metric value at the same time last week
        # *   GreaterThanLastPeriod: greater than the metric value in the last monitoring cycle
        # *   LessThanLastPeriod: less than the metric value in the previous monitoring cycle
        # 
        # Valid values of N: 1 to 3.
        # 
        # This parameter is required.
        self.comparison_operator = comparison_operator
        # The period of time during which the alert rule is effective.
        # 
        # Valid values of N: 1 to 3.
        self.effective_interval = effective_interval
        # The alert level. Valid values:
        # 
        # *   critical (default)
        # *   warn
        # *   info
        # 
        # Valid values of N: 1 to 3.
        # 
        # This parameter is required.
        self.escalations_level = escalations_level
        # This parameter is deprecated.
        self.no_effective_interval = no_effective_interval
        # The mute period during which new alert notifications are not sent even if the trigger conditions are met. Unit: seconds. Minimum value: 3600, which is equivalent to one hour. Default value: 86400, which is equivalent to one day.
        # 
        # Valid values of N: 1 to 3.
        # 
        # >  Only one alert notification is sent during a mute period even if the metric value exceeds the alert threshold during consecutive checks.
        self.silence_time = silence_time
        # The statistical aggregation method that is used to calculate the metric values.
        # 
        # Valid values of N: 1 to 3.
        # 
        # >  Set the value to Average.
        # 
        # This parameter is required.
        self.statistics = statistics
        # The alert triggers.
        self.target_list = target_list
        # The alert threshold.
        # 
        # Valid values of N: 1 to 3.
        # 
        # This parameter is required.
        self.threshold = threshold
        # The number of times for which the threshold can be consecutively exceeded. Default value: 3.
        # 
        # Valid values of N: 1 to 3.
        # 
        # >  A metric triggers an alert only after the metric value reaches the threshold consecutively for the specified times.
        # 
        # This parameter is required.
        self.times = times
        # The callback URL.
        # 
        # Valid values of N: 1 to 3.
        self.webhook = webhook

    def validate(self):
        if self.target_list:
            for k in self.target_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.effective_interval is not None:
            result['EffectiveInterval'] = self.effective_interval
        if self.escalations_level is not None:
            result['EscalationsLevel'] = self.escalations_level
        if self.no_effective_interval is not None:
            result['NoEffectiveInterval'] = self.no_effective_interval
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        result['TargetList'] = []
        if self.target_list is not None:
            for k in self.target_list:
                result['TargetList'].append(k.to_map() if k else None)
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('EffectiveInterval') is not None:
            self.effective_interval = m.get('EffectiveInterval')
        if m.get('EscalationsLevel') is not None:
            self.escalations_level = m.get('EscalationsLevel')
        if m.get('NoEffectiveInterval') is not None:
            self.no_effective_interval = m.get('NoEffectiveInterval')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        self.target_list = []
        if m.get('TargetList') is not None:
            for k in m.get('TargetList'):
                temp_model = CreateGroupMonitoringAgentProcessRequestAlertConfigTargetList()
                self.target_list.append(temp_model.from_map(k))
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class CreateGroupMonitoringAgentProcessRequestMatchExpress(TeaModel):
    def __init__(
        self,
        function: str = None,
        name: str = None,
        value: str = None,
    ):
        # The matching condition. Valid values:
        # 
        # *   all (default value): matches all
        # *   startWith: starts with a prefix
        # *   endWith: ends with a suffix
        # *   contains: contains
        # *   notContains: does not contain
        # *   equals: equals
        # 
        # Valid values of N: 1 to 3.
        self.function = function
        # The criteria based on which the instances are matched.
        # 
        # Valid values of N: 1 to 3.
        # 
        # > Set the value to name. The value name indicates that the instances are matched based on the instance name.
        self.name = name
        # The keyword used to match the instance name.
        # 
        # Valid values of N: 1 to 3.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function is not None:
            result['Function'] = self.function
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Function') is not None:
            self.function = m.get('Function')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateGroupMonitoringAgentProcessRequest(TeaModel):
    def __init__(
        self,
        alert_config: List[CreateGroupMonitoringAgentProcessRequestAlertConfig] = None,
        group_id: str = None,
        match_express: List[CreateGroupMonitoringAgentProcessRequestMatchExpress] = None,
        match_express_filter_relation: str = None,
        process_name: str = None,
        region_id: str = None,
    ):
        # The alert rule configurations.
        # 
        # Valid values of N: 1 to 3.
        # 
        # This parameter is required.
        self.alert_config = alert_config
        # The ID of the application group.
        # 
        # For more information about how to obtain the ID of an application group, see [DescribeMonitorGroups](https://help.aliyun.com/document_detail/115032.html).
        # 
        # This parameter is required.
        self.group_id = group_id
        # The expressions used to match instances.
        # 
        # Valid values of N: 1 to 3.
        self.match_express = match_express
        # The logical operator used between conditional expressions that are used to match instances. Valid values:
        # 
        # *   all
        # *   and
        # *   or
        self.match_express_filter_relation = match_express_filter_relation
        # The process name.
        # 
        # This parameter is required.
        self.process_name = process_name
        self.region_id = region_id

    def validate(self):
        if self.alert_config:
            for k in self.alert_config:
                if k:
                    k.validate()
        if self.match_express:
            for k in self.match_express:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertConfig'] = []
        if self.alert_config is not None:
            for k in self.alert_config:
                result['AlertConfig'].append(k.to_map() if k else None)
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        result['MatchExpress'] = []
        if self.match_express is not None:
            for k in self.match_express:
                result['MatchExpress'].append(k.to_map() if k else None)
        if self.match_express_filter_relation is not None:
            result['MatchExpressFilterRelation'] = self.match_express_filter_relation
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert_config = []
        if m.get('AlertConfig') is not None:
            for k in m.get('AlertConfig'):
                temp_model = CreateGroupMonitoringAgentProcessRequestAlertConfig()
                self.alert_config.append(temp_model.from_map(k))
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        self.match_express = []
        if m.get('MatchExpress') is not None:
            for k in m.get('MatchExpress'):
                temp_model = CreateGroupMonitoringAgentProcessRequestMatchExpress()
                self.match_express.append(temp_model.from_map(k))
        if m.get('MatchExpressFilterRelation') is not None:
            self.match_express_filter_relation = m.get('MatchExpressFilterRelation')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateGroupMonitoringAgentProcessResponseBodyResource(TeaModel):
    def __init__(
        self,
        group_process_id: str = None,
    ):
        # The ID of the group process.
        self.group_process_id = group_process_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_process_id is not None:
            result['GroupProcessId'] = self.group_process_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupProcessId') is not None:
            self.group_process_id = m.get('GroupProcessId')
        return self


class CreateGroupMonitoringAgentProcessResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        resource: CreateGroupMonitoringAgentProcessResponseBodyResource = None,
        success: bool = None,
    ):
        # The status code.
        # 
        # > The status code 200 indicates that the call is successful.
        self.code = code
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # The group process information.
        self.resource = resource
        # Indicates whether the call is successful. Valid values:
        # 
        # *   true: The call is successful.
        # *   false: The call fails.
        self.success = success

    def validate(self):
        if self.resource:
            self.resource.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource is not None:
            result['Resource'] = self.resource.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resource') is not None:
            temp_model = CreateGroupMonitoringAgentProcessResponseBodyResource()
            self.resource = temp_model.from_map(m['Resource'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateGroupMonitoringAgentProcessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateGroupMonitoringAgentProcessResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateGroupMonitoringAgentProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHostAvailabilityRequestAlertConfig(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        notify_type: int = None,
        silence_time: int = None,
        start_time: int = None,
        web_hook: str = None,
    ):
        # The end of the time range during which the alert rule is effective. Valid values: 0 to 23.
        # 
        # For example, if the `AlertConfig.StartTime` parameter is set to 0 and the `AlertConfig.EndTime` parameter is set to 22, the alert rule is effective from 00:00:00 to 22:00:00.
        # 
        # > Alert notifications are sent based on the specified threshold only if the alert rule is effective.
        self.end_time = end_time
        # The alert notification methods. Valid values:
        # 
        # 0: Alert notifications are sent by using emails and DingTalk chatbots.
        # 
        # This parameter is required.
        self.notify_type = notify_type
        # The mute period during which new alerts are not sent even if the trigger conditions are met. Unit: seconds. Default value: 86400. The default value indicates one day.
        self.silence_time = silence_time
        # The beginning of the time range during which the alert rule is effective. Valid values: 0 to 23.
        # 
        # For example, if the `AlertConfig.StartTime` parameter is set to 0 and the `AlertConfig.EndTime` parameter is set to 22, the alert rule is effective from 00:00:00 to 22:00:00.
        # 
        # > Alert notifications are sent based on the specified threshold only if the alert rule is effective.
        self.start_time = start_time
        # The callback URL.
        self.web_hook = web_hook

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.notify_type is not None:
            result['NotifyType'] = self.notify_type
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.web_hook is not None:
            result['WebHook'] = self.web_hook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('NotifyType') is not None:
            self.notify_type = m.get('NotifyType')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('WebHook') is not None:
            self.web_hook = m.get('WebHook')
        return self


class CreateHostAvailabilityRequestTaskOption(TeaModel):
    def __init__(
        self,
        http_header: str = None,
        http_method: str = None,
        http_negative: bool = None,
        http_post_content: str = None,
        http_response_charset: str = None,
        http_response_match_content: str = None,
        http_uri: str = None,
        interval: int = None,
        telnet_or_ping_host: str = None,
    ):
        # The header of the HTTP request. Format: `Parameter name:Parameter value`. Separate multiple parameters with carriage return characters. Example:
        # 
        #     params1:value1
        #     params2:value2
        self.http_header = http_header
        # The HTTP request method. Valid values:
        # 
        # *   GET
        # *   POST
        # *   HEAD
        # 
        # > This parameter must be specified when TaskType is set to HTTP.
        self.http_method = http_method
        # The method to trigger an alert. The alert can be triggered based on whether the specified alert rule is included in the response body. Valid values:
        # 
        # *   true: If the HTTP response body includes the alert rule, an alert is triggered.
        # *   false: If the HTTP response does not include the alert rule, an alert is triggered.
        # 
        # > This parameter must be specified when TaskType is set to HTTP.
        self.http_negative = http_negative
        # The content of the HTTP POST request.
        self.http_post_content = http_post_content
        # The character set that is used in the HTTP response.
        # 
        # > Only UTF-8 is supported.
        self.http_response_charset = http_response_charset
        # The response to the HTTP request.
        self.http_response_match_content = http_response_match_content
        # The URI that you want to monitor. This parameter is required if the TaskType parameter is set to HTTP or Telnet.
        self.http_uri = http_uri
        # The interval at which detection requests are sent. Unit: seconds. Valid values: 15, 30, 60, 120, 300, 900, 1800, and 3600.
        # 
        # > This parameter is available only for the CloudMonitor agent V3.5.1 or later.
        self.interval = interval
        # The domain name or IP address that you want to monitor.
        # 
        # >  This parameter is required if the TaskType parameter is set to PING.
        self.telnet_or_ping_host = telnet_or_ping_host

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_header is not None:
            result['HttpHeader'] = self.http_header
        if self.http_method is not None:
            result['HttpMethod'] = self.http_method
        if self.http_negative is not None:
            result['HttpNegative'] = self.http_negative
        if self.http_post_content is not None:
            result['HttpPostContent'] = self.http_post_content
        if self.http_response_charset is not None:
            result['HttpResponseCharset'] = self.http_response_charset
        if self.http_response_match_content is not None:
            result['HttpResponseMatchContent'] = self.http_response_match_content
        if self.http_uri is not None:
            result['HttpURI'] = self.http_uri
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.telnet_or_ping_host is not None:
            result['TelnetOrPingHost'] = self.telnet_or_ping_host
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpHeader') is not None:
            self.http_header = m.get('HttpHeader')
        if m.get('HttpMethod') is not None:
            self.http_method = m.get('HttpMethod')
        if m.get('HttpNegative') is not None:
            self.http_negative = m.get('HttpNegative')
        if m.get('HttpPostContent') is not None:
            self.http_post_content = m.get('HttpPostContent')
        if m.get('HttpResponseCharset') is not None:
            self.http_response_charset = m.get('HttpResponseCharset')
        if m.get('HttpResponseMatchContent') is not None:
            self.http_response_match_content = m.get('HttpResponseMatchContent')
        if m.get('HttpURI') is not None:
            self.http_uri = m.get('HttpURI')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('TelnetOrPingHost') is not None:
            self.telnet_or_ping_host = m.get('TelnetOrPingHost')
        return self


class CreateHostAvailabilityRequestAlertConfigEscalationList(TeaModel):
    def __init__(
        self,
        aggregate: str = None,
        metric_name: str = None,
        operator: str = None,
        times: int = None,
        value: str = None,
    ):
        # The method used to calculate the metric values that trigger alerts. Valid values of N: 1 to 21. Valid values:
        # 
        # *   HttpStatus: Value
        # *   HttpLatency: Average
        # *   TelnetStatus: Value
        # *   TelnetLatency: Average
        # *   PingLostRate: Average
        # 
        # > The value Value indicates the original value and is used for metrics such as status codes. The value Average indicates the average value and is used for metrics such as the latency and packet loss rate.
        self.aggregate = aggregate
        # The metric for which the alert feature is enabled. Valid values of N: 1 to 21. Valid values:
        # 
        # *   HttpStatus: HTTP status code
        # *   HttpLatency: HTTP response time
        # *   TelnetStatus: Telnet status code
        # *   TelnetLatency: Telnet response time
        # *   PingLostRate: Ping packet loss rate
        # 
        # This parameter is required.
        self.metric_name = metric_name
        # The comparison operator that is used in the alert rule. Valid values of N: 1 to 21. Valid values:
        # 
        # *   `>`
        # *   `>=`
        # *   `<`
        # *   `<=`
        # *   `=`
        self.operator = operator
        # The consecutive number of times for which the metric value meets the alert condition before an alert is triggered. Valid values of N: 1 to 21.
        self.times = times
        # The alert threshold. Valid values of N: 1 to 21.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregate is not None:
            result['Aggregate'] = self.aggregate
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.times is not None:
            result['Times'] = self.times
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Aggregate') is not None:
            self.aggregate = m.get('Aggregate')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateHostAvailabilityRequestAlertConfigTargetList(TeaModel):
    def __init__(
        self,
        arn: str = None,
        id: str = None,
        json_params: str = None,
        level: str = None,
    ):
        # The Alibaba Cloud Resource Name (ARN) of the resource. Format: `acs:{Service name abbreviation}:{regionId}:{userId}:/{Resource type}/{Resource name}/message`. Example: `acs:mns:cn-hangzhou:120886317861****:/queues/test123/message`. Fields:
        # 
        # *   {Service name abbreviation}: the abbreviation of the service name. Set the value to Simple Message Queue (formerly MNS) (SMQ).
        # 
        # *   {userId}: the ID of the Alibaba Cloud account.
        # 
        # *   {regionId}: the region ID of the SMQ queue or topic.
        # 
        # *   {Resource type}: the type of the resource for which alerts are triggered. Valid values:
        # 
        #     *   **queues**\
        #     *   **topics**\
        # 
        # *   {Resource name}: the resource name.
        # 
        #     *   If the resource type is **queues**, the resource name is the queue name.
        #     *   If the resource type is **topics**, the resource name is the topic name.
        self.arn = arn
        # The ID of the resource for which alerts are triggered.
        self.id = id
        # The parameters of the alert callback. The parameters are in the JSON format.
        self.json_params = json_params
        # The alert level. Valid values:
        # 
        # *   INFO
        # *   WARN
        # *   CRITICAL
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.id is not None:
            result['Id'] = self.id
        if self.json_params is not None:
            result['JsonParams'] = self.json_params
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('JsonParams') is not None:
            self.json_params = m.get('JsonParams')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class CreateHostAvailabilityRequest(TeaModel):
    def __init__(
        self,
        alert_config: CreateHostAvailabilityRequestAlertConfig = None,
        task_option: CreateHostAvailabilityRequestTaskOption = None,
        alert_config_escalation_list: List[CreateHostAvailabilityRequestAlertConfigEscalationList] = None,
        alert_config_target_list: List[CreateHostAvailabilityRequestAlertConfigTargetList] = None,
        group_id: int = None,
        instance_list: List[str] = None,
        region_id: str = None,
        task_name: str = None,
        task_scope: str = None,
        task_type: str = None,
    ):
        self.alert_config = alert_config
        self.task_option = task_option
        # None
        # 
        # This parameter is required.
        self.alert_config_escalation_list = alert_config_escalation_list
        # The resources for which alerts are triggered.
        self.alert_config_target_list = alert_config_target_list
        # The ID of the application group.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The ECS instances that are monitored. Valid values of N: 1 to 21.
        # 
        # > This parameter must be specified when `TaskScope` is set to `GROUP_SPEC_INSTANCE`.
        self.instance_list = instance_list
        self.region_id = region_id
        # The name of the availability monitoring task. The name must be 4 to 100 characters in length, and can contain letters, digits, and underscores (_).
        # 
        # This parameter is required.
        self.task_name = task_name
        # The range of instances that are monitored by the availability monitoring task. Valid values:
        # 
        # *   GROUP: All ECS instances in the application group are monitored.
        # *   GROUP_SPEC_INSTANCE: Specified ECS instances in the application group are monitored. The TaskScope parameter must be used in combination with the InstanceList parameter. The InstanceList parameter specifies the ECS instances to be monitored.
        self.task_scope = task_scope
        # The monitoring type of the availability monitoring task. Valid values:
        # 
        # *   PING
        # *   TELNET
        # *   HTTP
        # 
        # This parameter is required.
        self.task_type = task_type

    def validate(self):
        if self.alert_config:
            self.alert_config.validate()
        if self.task_option:
            self.task_option.validate()
        if self.alert_config_escalation_list:
            for k in self.alert_config_escalation_list:
                if k:
                    k.validate()
        if self.alert_config_target_list:
            for k in self.alert_config_target_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_config is not None:
            result['AlertConfig'] = self.alert_config.to_map()
        if self.task_option is not None:
            result['TaskOption'] = self.task_option.to_map()
        result['AlertConfigEscalationList'] = []
        if self.alert_config_escalation_list is not None:
            for k in self.alert_config_escalation_list:
                result['AlertConfigEscalationList'].append(k.to_map() if k else None)
        result['AlertConfigTargetList'] = []
        if self.alert_config_target_list is not None:
            for k in self.alert_config_target_list:
                result['AlertConfigTargetList'].append(k.to_map() if k else None)
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_list is not None:
            result['InstanceList'] = self.instance_list
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_scope is not None:
            result['TaskScope'] = self.task_scope
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertConfig') is not None:
            temp_model = CreateHostAvailabilityRequestAlertConfig()
            self.alert_config = temp_model.from_map(m['AlertConfig'])
        if m.get('TaskOption') is not None:
            temp_model = CreateHostAvailabilityRequestTaskOption()
            self.task_option = temp_model.from_map(m['TaskOption'])
        self.alert_config_escalation_list = []
        if m.get('AlertConfigEscalationList') is not None:
            for k in m.get('AlertConfigEscalationList'):
                temp_model = CreateHostAvailabilityRequestAlertConfigEscalationList()
                self.alert_config_escalation_list.append(temp_model.from_map(k))
        self.alert_config_target_list = []
        if m.get('AlertConfigTargetList') is not None:
            for k in m.get('AlertConfigTargetList'):
                temp_model = CreateHostAvailabilityRequestAlertConfigTargetList()
                self.alert_config_target_list.append(temp_model.from_map(k))
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceList') is not None:
            self.instance_list = m.get('InstanceList')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskScope') is not None:
            self.task_scope = m.get('TaskScope')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class CreateHostAvailabilityResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        task_id: int = None,
    ):
        # The status code.
        # 
        # > The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success
        # The ID of the availability monitoring task.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateHostAvailabilityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHostAvailabilityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHostAvailabilityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHybridMonitorNamespaceRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        namespace: str = None,
        namespace_region: str = None,
        namespace_type: str = None,
        region_id: str = None,
        spec: str = None,
    ):
        # The description of the namespace.
        self.description = description
        # The name of the namespace.
        # 
        # The name can contain lowercase letters, digits, and hyphens (-).
        # 
        # This parameter is required.
        self.namespace = namespace
        # The region where the metric data is stored.
        self.namespace_region = namespace_region
        # The storage scheme of metric data. Valid values:
        # 
        # *   m_prom_user: The metric data is stored in Simple Log Service.
        # *   m_prom_pool: The metric data is stored in the private storage space provided by CloudMonitor.
        # 
        # >  For more information about the storage schemes of metric data, see [Data storage schemes for Hybrid Cloud Monitoring](https://help.aliyun.com/document_detail/2594921.html).
        self.namespace_type = namespace_type
        self.region_id = region_id
        # The data retention period. Valid values:
        # 
        # *   cms.s1.large (Retention Period 15 Days)
        # *   cms.s1.xlarge (Retention Period 32 Days)
        # *   cms.s1.2xlarge (Retention Period 63 Days)
        # *   cms.s1.3xlarge (Retention Period 93 Days) (default)
        # *   cms.s1.6xlarge (Retention Period 185 Days)
        # *   cms.s1.12xlarge (Retention Period 367 Days)
        # 
        # For information about the pricing for different retention periods, see the **Pricing** section in [Billing of the dashboard feature](https://help.aliyun.com/document_detail/223532.html).
        self.spec = spec

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_region is not None:
            result['NamespaceRegion'] = self.namespace_region
        if self.namespace_type is not None:
            result['NamespaceType'] = self.namespace_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.spec is not None:
            result['Spec'] = self.spec
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespaceRegion') is not None:
            self.namespace_region = m.get('NamespaceRegion')
        if m.get('NamespaceType') is not None:
            self.namespace_type = m.get('NamespaceType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        return self


class CreateHybridMonitorNamespaceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The response code.
        self.code = code
        # The error message returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateHybridMonitorNamespaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHybridMonitorNamespaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHybridMonitorNamespaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHybridMonitorSLSGroupRequestSLSGroupConfig(TeaModel):
    def __init__(
        self,
        slslogstore: str = None,
        slsproject: str = None,
        slsregion: str = None,
        slsuser_id: str = None,
    ):
        # The Logstore.
        # 
        # Valid values of N: 1 to 25.
        # 
        # This parameter is required.
        self.slslogstore = slslogstore
        # The Simple Log Service project.
        # 
        # Valid values of N: 1 to 25.
        # 
        # This parameter is required.
        self.slsproject = slsproject
        # The region ID.
        # 
        # Valid values of N: 1 to 25.
        # 
        # This parameter is required.
        self.slsregion = slsregion
        # The member ID.
        # 
        # Valid values of N: 1 to 25.
        # 
        # If you call this operation by using the management account of a resource directory, you can connect the Alibaba Cloud services that are activated for all members in the resource directory to Hybrid Cloud Monitoring. You can use the resource directory to monitor Alibaba Cloud services across enterprise accounts.
        # 
        # > If a member uses CloudMonitor for the first time, you must make sure that the service-linked role AliyunServiceRoleForCloudMonitor is attached to the member. For more information, see [Manage the service-linked role for CloudMonitor](https://help.aliyun.com/document_detail/170423.html).
        self.slsuser_id = slsuser_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.slslogstore is not None:
            result['SLSLogstore'] = self.slslogstore
        if self.slsproject is not None:
            result['SLSProject'] = self.slsproject
        if self.slsregion is not None:
            result['SLSRegion'] = self.slsregion
        if self.slsuser_id is not None:
            result['SLSUserId'] = self.slsuser_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SLSLogstore') is not None:
            self.slslogstore = m.get('SLSLogstore')
        if m.get('SLSProject') is not None:
            self.slsproject = m.get('SLSProject')
        if m.get('SLSRegion') is not None:
            self.slsregion = m.get('SLSRegion')
        if m.get('SLSUserId') is not None:
            self.slsuser_id = m.get('SLSUserId')
        return self


class CreateHybridMonitorSLSGroupRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        slsgroup_config: List[CreateHybridMonitorSLSGroupRequestSLSGroupConfig] = None,
        slsgroup_description: str = None,
        slsgroup_name: str = None,
    ):
        self.region_id = region_id
        # The configurations of the Logstore group.
        # 
        # Valid values of N: 1 to 25.
        # 
        # This parameter is required.
        self.slsgroup_config = slsgroup_config
        # The description of the Logstore group.
        self.slsgroup_description = slsgroup_description
        # The name of the Logstore group.
        # 
        # The name must be 2 to 32 characters in length and can contain uppercase letters, lowercase letters, digits, and underscores (_). The name must start with a letter.
        # 
        # This parameter is required.
        self.slsgroup_name = slsgroup_name

    def validate(self):
        if self.slsgroup_config:
            for k in self.slsgroup_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['SLSGroupConfig'] = []
        if self.slsgroup_config is not None:
            for k in self.slsgroup_config:
                result['SLSGroupConfig'].append(k.to_map() if k else None)
        if self.slsgroup_description is not None:
            result['SLSGroupDescription'] = self.slsgroup_description
        if self.slsgroup_name is not None:
            result['SLSGroupName'] = self.slsgroup_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.slsgroup_config = []
        if m.get('SLSGroupConfig') is not None:
            for k in m.get('SLSGroupConfig'):
                temp_model = CreateHybridMonitorSLSGroupRequestSLSGroupConfig()
                self.slsgroup_config.append(temp_model.from_map(k))
        if m.get('SLSGroupDescription') is not None:
            self.slsgroup_description = m.get('SLSGroupDescription')
        if m.get('SLSGroupName') is not None:
            self.slsgroup_name = m.get('SLSGroupName')
        return self


class CreateHybridMonitorSLSGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code.
        # 
        # > The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateHybridMonitorSLSGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHybridMonitorSLSGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHybridMonitorSLSGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHybridMonitorTaskRequestAttachLabels(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # The tag key of the metric.
        self.name = name
        # The tag value of the metric.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateHybridMonitorTaskRequestSLSProcessConfigExpress(TeaModel):
    def __init__(
        self,
        alias: str = None,
        express: str = None,
    ):
        # The alias of the extended field that specifies the result of basic operations performed on aggregation results.
        self.alias = alias
        # The extended field that specifies the result of basic operations performed on aggregation results.
        self.express = express

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.express is not None:
            result['Express'] = self.express
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('Express') is not None:
            self.express = m.get('Express')
        return self


class CreateHybridMonitorTaskRequestSLSProcessConfigFilterFilters(TeaModel):
    def __init__(
        self,
        operator: str = None,
        slskey_name: str = None,
        value: str = None,
    ):
        # The method that is used to filter logs imported from Simple Log Service. Valid values:
        # 
        # *   `contain`: contains
        # *   `notContain`: does not contain
        # *   `>`: greater than
        # *   `<`: less than
        # *   `=`: equal to
        # *   `! =`: not equal to
        # *   `>=`: greater than or equal to
        # *   `<=`: less than or equal to
        self.operator = operator
        # The name of the key that is used to filter logs imported from Simple Log Service.
        self.slskey_name = slskey_name
        # The value of the key that is used to filter logs imported from Simple Log Service.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.slskey_name is not None:
            result['SLSKeyName'] = self.slskey_name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('SLSKeyName') is not None:
            self.slskey_name = m.get('SLSKeyName')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateHybridMonitorTaskRequestSLSProcessConfigFilter(TeaModel):
    def __init__(
        self,
        filters: List[CreateHybridMonitorTaskRequestSLSProcessConfigFilterFilters] = None,
        relation: str = None,
    ):
        # The conditions that are used to filter logs imported from Simple Log Service.
        self.filters = filters
        # The relationship between multiple filter conditions. Valid values:
        # 
        # *   and (default): Logs are processed only if all filter conditions are met.
        # *   or: Logs are processed if one of the filter conditions is met.
        self.relation = relation

    def validate(self):
        if self.filters:
            for k in self.filters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Filters'] = []
        if self.filters is not None:
            for k in self.filters:
                result['Filters'].append(k.to_map() if k else None)
        if self.relation is not None:
            result['Relation'] = self.relation
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.filters = []
        if m.get('Filters') is not None:
            for k in m.get('Filters'):
                temp_model = CreateHybridMonitorTaskRequestSLSProcessConfigFilterFilters()
                self.filters.append(temp_model.from_map(k))
        if m.get('Relation') is not None:
            self.relation = m.get('Relation')
        return self


class CreateHybridMonitorTaskRequestSLSProcessConfigGroupBy(TeaModel):
    def __init__(
        self,
        alias: str = None,
        slskey_name: str = None,
    ):
        # The alias of the aggregation result.
        self.alias = alias
        # The name of the key that is used to aggregate logs imported from Simple Log Service.
        self.slskey_name = slskey_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.slskey_name is not None:
            result['SLSKeyName'] = self.slskey_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('SLSKeyName') is not None:
            self.slskey_name = m.get('SLSKeyName')
        return self


class CreateHybridMonitorTaskRequestSLSProcessConfigStatistics(TeaModel):
    def __init__(
        self,
        alias: str = None,
        function: str = None,
        parameter_1: str = None,
        parameter_2: str = None,
        slskey_name: str = None,
    ):
        # The alias of the aggregation result.
        self.alias = alias
        # The function that is used to aggregate the log data of a statistical period. Valid values:
        # 
        # *   count: counts the number.
        # *   sum: calculates the total value.
        # *   avg: calculates the average value.
        # *   max: calculates the maximum value.
        # *   min: calculates the minimum value.
        # *   value: collects samples within the statistical period.
        # *   countps: calculates the number of values of the specified field divided by the total number of seconds within a statistical period.
        # *   sumps: calculates the sum of the values of the specified field divided by the total number of seconds within a statistical period.
        # *   distinct: calculates the number of unique values of the specified field within a statistical period.
        # *   distribution: calculates the number of logs that meet a specified condition within the statistical period.
        # *   percentile: sorts the values of the specified field in ascending order, and then returns the value that is at the specified percentile within the statistical period. Example: P50.
        self.function = function
        # The value of the function that is used to aggregate logs imported from Simple Log Service.
        # 
        # *   If the `Function` parameter is set to `distribution`, this parameter specifies the lower limit of the statistical interval. For example, if you want to calculate the number of HTTP requests whose status code is 2XX, set this parameter to 200.
        # *   If the `Function` parameter is set to `percentile`, this parameter specifies the percentile at which the expected value is. For example, 0.5 specifies P50.
        self.parameter_1 = parameter_1
        # The value of the function that is used to aggregate logs imported from Simple Log Service.
        # 
        # >  This parameter is required only if the `Function` parameter is set to `distribution`. This parameter specifies the upper limit of the statistical interval. For example, if you want to calculate the number of HTTP requests whose status code is 2XX, set this parameter to 299.
        self.parameter_2 = parameter_2
        # The name of the key that is used to aggregate logs imported from Simple Log Service.
        self.slskey_name = slskey_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.function is not None:
            result['Function'] = self.function
        if self.parameter_1 is not None:
            result['Parameter1'] = self.parameter_1
        if self.parameter_2 is not None:
            result['Parameter2'] = self.parameter_2
        if self.slskey_name is not None:
            result['SLSKeyName'] = self.slskey_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('Function') is not None:
            self.function = m.get('Function')
        if m.get('Parameter1') is not None:
            self.parameter_1 = m.get('Parameter1')
        if m.get('Parameter2') is not None:
            self.parameter_2 = m.get('Parameter2')
        if m.get('SLSKeyName') is not None:
            self.slskey_name = m.get('SLSKeyName')
        return self


class CreateHybridMonitorTaskRequestSLSProcessConfig(TeaModel):
    def __init__(
        self,
        express: List[CreateHybridMonitorTaskRequestSLSProcessConfigExpress] = None,
        filter: CreateHybridMonitorTaskRequestSLSProcessConfigFilter = None,
        group_by: List[CreateHybridMonitorTaskRequestSLSProcessConfigGroupBy] = None,
        statistics: List[CreateHybridMonitorTaskRequestSLSProcessConfigStatistics] = None,
    ):
        # The extended fields that specify the results of basic operations performed on aggregation results.
        self.express = express
        # The conditions that are used to filter logs imported from Simple Log Service.
        self.filter = filter
        # The dimension based on which data is aggregated. This parameter is equivalent to the GROUP BY clause in SQL.
        self.group_by = group_by
        # The method that is used to aggregate logs imported from Simple Log Service.
        self.statistics = statistics

    def validate(self):
        if self.express:
            for k in self.express:
                if k:
                    k.validate()
        if self.filter:
            self.filter.validate()
        if self.group_by:
            for k in self.group_by:
                if k:
                    k.validate()
        if self.statistics:
            for k in self.statistics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Express'] = []
        if self.express is not None:
            for k in self.express:
                result['Express'].append(k.to_map() if k else None)
        if self.filter is not None:
            result['Filter'] = self.filter.to_map()
        result['GroupBy'] = []
        if self.group_by is not None:
            for k in self.group_by:
                result['GroupBy'].append(k.to_map() if k else None)
        result['Statistics'] = []
        if self.statistics is not None:
            for k in self.statistics:
                result['Statistics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.express = []
        if m.get('Express') is not None:
            for k in m.get('Express'):
                temp_model = CreateHybridMonitorTaskRequestSLSProcessConfigExpress()
                self.express.append(temp_model.from_map(k))
        if m.get('Filter') is not None:
            temp_model = CreateHybridMonitorTaskRequestSLSProcessConfigFilter()
            self.filter = temp_model.from_map(m['Filter'])
        self.group_by = []
        if m.get('GroupBy') is not None:
            for k in m.get('GroupBy'):
                temp_model = CreateHybridMonitorTaskRequestSLSProcessConfigGroupBy()
                self.group_by.append(temp_model.from_map(k))
        self.statistics = []
        if m.get('Statistics') is not None:
            for k in m.get('Statistics'):
                temp_model = CreateHybridMonitorTaskRequestSLSProcessConfigStatistics()
                self.statistics.append(temp_model.from_map(k))
        return self


class CreateHybridMonitorTaskRequest(TeaModel):
    def __init__(
        self,
        attach_labels: List[CreateHybridMonitorTaskRequestAttachLabels] = None,
        cloud_access_id: List[str] = None,
        collect_interval: str = None,
        collect_target_type: str = None,
        description: str = None,
        group_id: str = None,
        namespace: str = None,
        region_id: str = None,
        slsprocess_config: CreateHybridMonitorTaskRequestSLSProcessConfig = None,
        target_user_id: str = None,
        target_user_id_list: str = None,
        task_name: str = None,
        task_type: str = None,
        yarmconfig: str = None,
    ):
        # The tags of the metric.
        # 
        # >  This parameter is required only if the `TaskType` parameter is set to `aliyun_sls`.
        self.attach_labels = attach_labels
        self.cloud_access_id = cloud_access_id
        # The collection period of the metric. Valid values:
        # 
        # *   15
        # *   60 (default)
        # 
        # Unit: seconds.
        # 
        # >  This parameter is required only if the `TaskType` parameter is set to `aliyun_sls`.
        self.collect_interval = collect_interval
        # The type of the collection target.
        # 
        # *   If the `TaskType` parameter is set to `aliyun_fc`, enter `aliyun_fc`.
        # *   If the `TaskType` parameter is set to `aliyun_sls`, enter the name of the Logstore group.
        # 
        # This parameter is required.
        self.collect_target_type = collect_target_type
        # The description of the metric import task.
        self.description = description
        # The ID of the application group.
        # 
        # For information about how to obtain the ID of an application group, see [DescribeMonitorGroups](https://help.aliyun.com/document_detail/115032.html).
        # 
        # >  This parameter is required only if the `TaskType` parameter is set to `aliyun_sls`.
        self.group_id = group_id
        # The name of the namespace.
        # 
        # For information about how to obtain the name of a namespace, see [DescribeHybridMonitorNamespaceList](https://help.aliyun.com/document_detail/428880.html).
        # 
        # This parameter is required.
        self.namespace = namespace
        self.region_id = region_id
        # The configurations of the logs that are imported from Simple Log Service.
        # 
        # >  This parameter is required only if the `TaskType` parameter is set to `aliyun_sls`.
        self.slsprocess_config = slsprocess_config
        # The ID of the member account.
        # 
        # If you call this operation by using the management account of a resource directory, you can connect the Alibaba Cloud services that are activated for all members in the resource directory to Hybrid Cloud Monitoring. You can use the resource directory to monitor Alibaba Cloud services across enterprise accounts.
        # 
        # >  This parameter is required only if the `TaskType` parameter is set to `aliyun_fc`.
        self.target_user_id = target_user_id
        # The IDs of the member accounts. Separate multiple member account IDs with commas (,).
        # 
        # >  This parameter is required only if you call this operation by using the management account.
        self.target_user_id_list = target_user_id_list
        # The name of the metric import task.
        # 
        # *   If the `TaskType` parameter is set to `aliyun_fc`, enter the name of the metric import task.
        # *   If the `TaskType` parameter is set to `aliyun_sls`, enter the name of the metric for logs imported from Simple Log Service.
        self.task_name = task_name
        # The type of the metric import task. Valid values:
        # 
        # *   aliyun_fc: metric import tasks for Alibaba Cloud services.
        # *   aliyun_sls: metrics for logs imported from Simple Log Service.
        # 
        # This parameter is required.
        self.task_type = task_type
        # The configuration file of the Alibaba Cloud service that you want to monitor by using Hybrid Cloud Monitoring.
        # 
        # *   namespace: the namespace of the Alibaba Cloud service. For information about how to query the namespace of an Alibaba Cloud service, see [DescribeMetricMetaList](https://help.aliyun.com/document_detail/98846.html).
        # *   metric_list: the metrics of the Alibaba Cloud service. For information about how to query the metrics of an Alibaba Cloud service, see [DescribeMetricMetaList](https://help.aliyun.com/document_detail/98846.html).
        # 
        # The following code shows a sample configuration file:
        # 
        #     products:
        #     - namespace: acs_ecs_dashboard
        #       metric_info:
        #       - metric_list:
        #         - cpu_total
        #         - cpu_idle
        #         - diskusage_utilization
        #         - CPUUtilization
        #         - DiskReadBPS
        #         - InternetOut
        #         - IntranetOut
        #         - cpu_system
        #     - namespace: acs_rds_dashboard
        #       metric_info:
        #       - metric_list:
        #         - MySQL_QPS
        #         - MySQL_TPS
        # 
        # >  This parameter is required only if the `TaskType` parameter is set to `aliyun_fc`.
        self.yarmconfig = yarmconfig

    def validate(self):
        if self.attach_labels:
            for k in self.attach_labels:
                if k:
                    k.validate()
        if self.slsprocess_config:
            self.slsprocess_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AttachLabels'] = []
        if self.attach_labels is not None:
            for k in self.attach_labels:
                result['AttachLabels'].append(k.to_map() if k else None)
        if self.cloud_access_id is not None:
            result['CloudAccessId'] = self.cloud_access_id
        if self.collect_interval is not None:
            result['CollectInterval'] = self.collect_interval
        if self.collect_target_type is not None:
            result['CollectTargetType'] = self.collect_target_type
        if self.description is not None:
            result['Description'] = self.description
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.slsprocess_config is not None:
            result['SLSProcessConfig'] = self.slsprocess_config.to_map()
        if self.target_user_id is not None:
            result['TargetUserId'] = self.target_user_id
        if self.target_user_id_list is not None:
            result['TargetUserIdList'] = self.target_user_id_list
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.yarmconfig is not None:
            result['YARMConfig'] = self.yarmconfig
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attach_labels = []
        if m.get('AttachLabels') is not None:
            for k in m.get('AttachLabels'):
                temp_model = CreateHybridMonitorTaskRequestAttachLabels()
                self.attach_labels.append(temp_model.from_map(k))
        if m.get('CloudAccessId') is not None:
            self.cloud_access_id = m.get('CloudAccessId')
        if m.get('CollectInterval') is not None:
            self.collect_interval = m.get('CollectInterval')
        if m.get('CollectTargetType') is not None:
            self.collect_target_type = m.get('CollectTargetType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SLSProcessConfig') is not None:
            temp_model = CreateHybridMonitorTaskRequestSLSProcessConfig()
            self.slsprocess_config = temp_model.from_map(m['SLSProcessConfig'])
        if m.get('TargetUserId') is not None:
            self.target_user_id = m.get('TargetUserId')
        if m.get('TargetUserIdList') is not None:
            self.target_user_id_list = m.get('TargetUserIdList')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('YARMConfig') is not None:
            self.yarmconfig = m.get('YARMConfig')
        return self


class CreateHybridMonitorTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
        task_id: int = None,
    ):
        # The response code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The error message returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success
        # The ID of the monitoring task.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateHybridMonitorTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHybridMonitorTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHybridMonitorTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInstantSiteMonitorRequest(TeaModel):
    def __init__(
        self,
        address: str = None,
        agent_group: str = None,
        isp_cities: str = None,
        options_json: str = None,
        random_isp_city: int = None,
        region_id: str = None,
        task_name: str = None,
        task_type: str = None,
    ):
        # The URL or IP address that you want to test.
        # 
        # This parameter is required.
        self.address = address
        self.agent_group = agent_group
        # The detection points. If you leave this parameter empty, the system randomly selects three detection points.
        # 
        # The value is a `JSON array`. Example: {"city":"546","isp":"465"},{"city":"572","isp":"465"},{"city":"738","isp":"465"}. The values of the city field indicate Beijing, Hangzhou, and Qingdao.
        # 
        # For information about how to obtain detection points, see [DescribeSiteMonitorISPCityList](https://help.aliyun.com/document_detail/115045.html).
        # 
        # > You must specify one of the `IspCities` and `RandomIspCity` parameters.
        self.isp_cities = isp_cities
        # The extended options of the protocol that is used by the instant test task. The options vary based on the protocol.
        self.options_json = options_json
        # The number of detection points.
        # 
        # > 
        # 
        # *   You must specify one of the `IspCities` and `RandomIspCity` parameters. If you specify the `RandomIspCity` parameter, the `IspCities` parameter automatically becomes invalid.
        self.random_isp_city = random_isp_city
        self.region_id = region_id
        # The name of the instant test task.
        # 
        # The name must be 4 to 100 characters in length, and can contain letters, digits, and underscores (_).
        # 
        # This parameter is required.
        self.task_name = task_name
        # The type of the instant test task. Valid values: HTTP, PING, TCP, UDP, and DNS.
        # 
        # This parameter is required.
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.agent_group is not None:
            result['AgentGroup'] = self.agent_group
        if self.isp_cities is not None:
            result['IspCities'] = self.isp_cities
        if self.options_json is not None:
            result['OptionsJson'] = self.options_json
        if self.random_isp_city is not None:
            result['RandomIspCity'] = self.random_isp_city
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('AgentGroup') is not None:
            self.agent_group = m.get('AgentGroup')
        if m.get('IspCities') is not None:
            self.isp_cities = m.get('IspCities')
        if m.get('OptionsJson') is not None:
            self.options_json = m.get('OptionsJson')
        if m.get('RandomIspCity') is not None:
            self.random_isp_city = m.get('RandomIspCity')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class CreateInstantSiteMonitorResponseBodyCreateResultList(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        task_name: str = None,
    ):
        # The ID of the instant test task.
        self.task_id = task_id
        # The name of the instant test task.
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateInstantSiteMonitorResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        create_result_list: List[CreateInstantSiteMonitorResponseBodyCreateResultList] = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The error code.
        # 
        # > The status code 200 indicates that the call was successful.
        self.code = code
        # The results for creating the instant test task.
        self.create_result_list = create_result_list
        # The returned message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # *   true: The request was successful.
        # *   false: The request failed.
        self.success = success

    def validate(self):
        if self.create_result_list:
            for k in self.create_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['CreateResultList'] = []
        if self.create_result_list is not None:
            for k in self.create_result_list:
                result['CreateResultList'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.create_result_list = []
        if m.get('CreateResultList') is not None:
            for k in m.get('CreateResultList'):
                temp_model = CreateInstantSiteMonitorResponseBodyCreateResultList()
                self.create_result_list.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateInstantSiteMonitorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateInstantSiteMonitorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateInstantSiteMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMetricRuleBlackListRequestMetrics(TeaModel):
    def __init__(
        self,
        metric_name: str = None,
        resource: str = None,
    ):
        # The metric name.
        # 
        # Valid values of N: 1 to 10.
        # 
        # This parameter is required.
        self.metric_name = metric_name
        # The extended dimension of the instance. For example, `{"device":"C:"}` specifies that the blacklist policy is applied to all C disks of the specified Elastic Compute Service (ECS) instance.
        # 
        # Valid values of N: 1 to 10.
        self.resource = resource

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.resource is not None:
            result['Resource'] = self.resource
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Resource') is not None:
            self.resource = m.get('Resource')
        return self


class CreateMetricRuleBlackListRequest(TeaModel):
    def __init__(
        self,
        category: str = None,
        effective_time: str = None,
        enable_end_time: str = None,
        enable_start_time: str = None,
        instances: List[str] = None,
        metrics: List[CreateMetricRuleBlackListRequestMetrics] = None,
        name: str = None,
        namespace: str = None,
        region_id: str = None,
        scope_type: str = None,
        scope_value: str = None,
    ):
        # The category of the cloud service. For example, ApsaraDB for Redis includes the following categories: ApsaraDB for Redis (standard architecture), ApsaraDB for Redis (cluster architecture), and ApsaraDB for Redis (read/write splitting architecture). In this case, the valid values of this parameter for ApsaraDB for Redis include `kvstore_standard`, `kvstore_sharding`, and `kvstore_splitrw`.
        # 
        # This parameter is required.
        self.category = category
        # The time range within which the blacklist policy is effective.
        # 
        # *   If you do not configure this parameter, the blacklist policy is permanently effective.
        # 
        # *   If you configure this parameter, the blacklist policy is effective only within the specified time range. Examples:
        # 
        #     *   `03:00-04:59`: The blacklist policy is effective from 03:00 to 05:00 local time. 05:00 local time is excluded.
        #     *   `03:00-04:59 UTC+0700`: The blacklist policy is effective from 03:00 to 05:00 (UTC+7). 05:00 (UTC+7) is excluded.
        self.effective_time = effective_time
        # The timestamp when the blacklist policy expires.
        # 
        # Unit: milliseconds.
        self.enable_end_time = enable_end_time
        # The timestamp when the blacklist policy starts to take effect.
        # 
        # Unit: milliseconds.
        self.enable_start_time = enable_start_time
        # The IDs of the instances that belong to the specified cloud service.
        # 
        # This parameter is required.
        self.instances = instances
        # The metrics of the instance.
        # 
        # *   If you do not configure this parameter, the blacklist policy applies to all metrics of the specified cloud service.
        # *   If you configure this parameter, the blacklist policy applies only to the current metric.
        self.metrics = metrics
        # The name of the blacklist policy.
        # 
        # This parameter is required.
        self.name = name
        # The namespace of the cloud service.
        # 
        # For more information about the namespaces of different cloud services, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # This parameter is required.
        self.namespace = namespace
        self.region_id = region_id
        # The effective scope of the blacklist policy. Valid values:
        # 
        # *   USER (default): The blacklist policy takes effect only for the current Alibaba Cloud account.
        # *   GROUP: The blacklist policy takes effect only for the specified application group. For information about how to query the IDs of application groups, see [DescribeMonitorGroups](https://help.aliyun.com/document_detail/115032.html).
        self.scope_type = scope_type
        # The ID of the application group. The value of this parameter is a JSON array.
        # 
        # > This parameter must be specified when `ScopeType` is set to `GROUP`.
        self.scope_value = scope_value

    def validate(self):
        if self.metrics:
            for k in self.metrics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.effective_time is not None:
            result['EffectiveTime'] = self.effective_time
        if self.enable_end_time is not None:
            result['EnableEndTime'] = self.enable_end_time
        if self.enable_start_time is not None:
            result['EnableStartTime'] = self.enable_start_time
        if self.instances is not None:
            result['Instances'] = self.instances
        result['Metrics'] = []
        if self.metrics is not None:
            for k in self.metrics:
                result['Metrics'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scope_type is not None:
            result['ScopeType'] = self.scope_type
        if self.scope_value is not None:
            result['ScopeValue'] = self.scope_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('EffectiveTime') is not None:
            self.effective_time = m.get('EffectiveTime')
        if m.get('EnableEndTime') is not None:
            self.enable_end_time = m.get('EnableEndTime')
        if m.get('EnableStartTime') is not None:
            self.enable_start_time = m.get('EnableStartTime')
        if m.get('Instances') is not None:
            self.instances = m.get('Instances')
        self.metrics = []
        if m.get('Metrics') is not None:
            for k in m.get('Metrics'):
                temp_model = CreateMetricRuleBlackListRequestMetrics()
                self.metrics.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ScopeType') is not None:
            self.scope_type = m.get('ScopeType')
        if m.get('ScopeValue') is not None:
            self.scope_value = m.get('ScopeValue')
        return self


class CreateMetricRuleBlackListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        id: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        # 
        # > The status code 200 indicates that the request was successful.
        self.code = code
        # The ID of the blacklist policy.
        self.id = id
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMetricRuleBlackListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMetricRuleBlackListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMetricRuleBlackListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMetricRuleResourcesRequest(TeaModel):
    def __init__(
        self,
        overwrite: str = None,
        resources: str = None,
        rule_id: str = None,
    ):
        # Specifies whether to overwrite existing resources. Valid values:
        # 
        # *   true: The resources submitted this time overwrite the previously associated resources.
        # *   false: The resources submitted this time do not overwrite the previously associated resources. The associated resources after submission include the previously associated resources and the resources submitted this time.
        self.overwrite = overwrite
        # The resources that are associated with the alert rule. Set the value to a JSON array.
        # 
        # >  You can add up to 100 resources each time. An alert rule can be associated with up to 3,000 resources.
        # 
        # This parameter is required.
        self.resources = resources
        # The ID of the alert rule.
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite is not None:
            result['Overwrite'] = self.overwrite
        if self.resources is not None:
            result['Resources'] = self.resources
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Overwrite') is not None:
            self.overwrite = m.get('Overwrite')
        if m.get('Resources') is not None:
            self.resources = m.get('Resources')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class CreateMetricRuleResourcesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values: true: The request was successful. false: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMetricRuleResourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMetricRuleResourcesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMetricRuleResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMetricRuleTemplateRequestAlertTemplatesEscalationsCritical(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        n: int = None,
        statistics: str = None,
        threshold: str = None,
        times: int = None,
    ):
        self.comparison_operator = comparison_operator
        self.n = n
        self.statistics = statistics
        self.threshold = threshold
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.n is not None:
            result['N'] = self.n
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('N') is not None:
            self.n = m.get('N')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class CreateMetricRuleTemplateRequestAlertTemplatesEscalationsInfo(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        n: int = None,
        statistics: str = None,
        threshold: str = None,
        times: int = None,
    ):
        self.comparison_operator = comparison_operator
        self.n = n
        self.statistics = statistics
        self.threshold = threshold
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.n is not None:
            result['N'] = self.n
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('N') is not None:
            self.n = m.get('N')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class CreateMetricRuleTemplateRequestAlertTemplatesEscalationsWarn(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        n: int = None,
        statistics: str = None,
        threshold: str = None,
        times: int = None,
    ):
        self.comparison_operator = comparison_operator
        self.n = n
        self.statistics = statistics
        self.threshold = threshold
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.n is not None:
            result['N'] = self.n
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('N') is not None:
            self.n = m.get('N')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class CreateMetricRuleTemplateRequestAlertTemplatesEscalations(TeaModel):
    def __init__(
        self,
        critical: CreateMetricRuleTemplateRequestAlertTemplatesEscalationsCritical = None,
        info: CreateMetricRuleTemplateRequestAlertTemplatesEscalationsInfo = None,
        warn: CreateMetricRuleTemplateRequestAlertTemplatesEscalationsWarn = None,
    ):
        self.critical = critical
        self.info = info
        self.warn = warn

    def validate(self):
        if self.critical:
            self.critical.validate()
        if self.info:
            self.info.validate()
        if self.warn:
            self.warn.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.critical is not None:
            result['Critical'] = self.critical.to_map()
        if self.info is not None:
            result['Info'] = self.info.to_map()
        if self.warn is not None:
            result['Warn'] = self.warn.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Critical') is not None:
            temp_model = CreateMetricRuleTemplateRequestAlertTemplatesEscalationsCritical()
            self.critical = temp_model.from_map(m['Critical'])
        if m.get('Info') is not None:
            temp_model = CreateMetricRuleTemplateRequestAlertTemplatesEscalationsInfo()
            self.info = temp_model.from_map(m['Info'])
        if m.get('Warn') is not None:
            temp_model = CreateMetricRuleTemplateRequestAlertTemplatesEscalationsWarn()
            self.warn = temp_model.from_map(m['Warn'])
        return self


class CreateMetricRuleTemplateRequestAlertTemplates(TeaModel):
    def __init__(
        self,
        escalations: CreateMetricRuleTemplateRequestAlertTemplatesEscalations = None,
        category: str = None,
        metric_name: str = None,
        namespace: str = None,
        period: int = None,
        rule_name: str = None,
        selector: str = None,
        webhook: str = None,
    ):
        self.escalations = escalations
        # The abbreviation of the cloud service name.
        # 
        # Valid values of N: 1 to 200.
        # 
        # For more information about how to obtain the abbreviation of a cloud service name, see `metricCategory` in the response parameter `Labels` of the [DescribeProjectMeta](https://help.aliyun.com/document_detail/114916.html) operation.
        # 
        # This parameter is required.
        self.category = category
        # The metric name.
        # 
        # Valid values of N: 1 to 200.
        # 
        # For information about how to obtain the name of a metric, see [DescribeMetricMetaList](https://help.aliyun.com/document_detail/98846.html) or [Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # This parameter is required.
        self.metric_name = metric_name
        # The namespace of the cloud service.
        # 
        # Valid values of N: 1 to 200.
        # 
        # For information about how to obtain the namespace of a cloud service, see [DescribeMetricMetaList](https://help.aliyun.com/document_detail/98846.html) or [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # This parameter is required.
        self.namespace = namespace
        # The aggregation period of monitoring data. Unit: seconds.
        # 
        # The default value is the minimum aggregation period. Generally, you do not need to specify the minimum aggregation period.
        # 
        # Valid values of N: 1 to 200.
        self.period = period
        # The name of the alert rule.
        # 
        # Valid values of N: 1 to 200.
        # 
        # This parameter is required.
        self.rule_name = rule_name
        # The dimension of the alert. It is an extended field.
        # 
        # Valid values of N: 1 to 200.
        # 
        # For example, an alert template is applied to an application group, this parameter is set to `{"disk":"/"}`, and the MetricName parameter is set to `DiskUtilization`. In this case, the generated alert rule is applied to the root disk partition (`"/"`) of all instances in the application group to which the alert template is applied.
        # 
        # >  For more information about the values of extended fields, see [DescribeMetricRuleTemplateAttribute](https://help.aliyun.com/document_detail/114979.html).
        self.selector = selector
        # The callback URL.
        # 
        # Valid values of N: 1 to 200.
        # 
        # The callback URL must be accessible over the Internet. CloudMonitor pushes an alert notification to the specified callback URL by sending an HTTP POST request. Only the HTTP protocol is supported.
        self.webhook = webhook

    def validate(self):
        if self.escalations:
            self.escalations.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.escalations is not None:
            result['Escalations'] = self.escalations.to_map()
        if self.category is not None:
            result['Category'] = self.category
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.period is not None:
            result['Period'] = self.period
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.selector is not None:
            result['Selector'] = self.selector
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Escalations') is not None:
            temp_model = CreateMetricRuleTemplateRequestAlertTemplatesEscalations()
            self.escalations = temp_model.from_map(m['Escalations'])
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('Selector') is not None:
            self.selector = m.get('Selector')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class CreateMetricRuleTemplateRequest(TeaModel):
    def __init__(
        self,
        alert_templates: List[CreateMetricRuleTemplateRequestAlertTemplates] = None,
        description: str = None,
        name: str = None,
        region_id: str = None,
    ):
        # The details of the alert template.
        self.alert_templates = alert_templates
        # The description of the alert template.
        self.description = description
        # The name of the alert template.
        # 
        # This parameter is required.
        self.name = name
        self.region_id = region_id

    def validate(self):
        if self.alert_templates:
            for k in self.alert_templates:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertTemplates'] = []
        if self.alert_templates is not None:
            for k in self.alert_templates:
                result['AlertTemplates'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert_templates = []
        if m.get('AlertTemplates') is not None:
            for k in m.get('AlertTemplates'):
                temp_model = CreateMetricRuleTemplateRequestAlertTemplates()
                self.alert_templates.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateMetricRuleTemplateResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        id: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The ID of the alert template.
        self.id = id
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMetricRuleTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMetricRuleTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMetricRuleTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMonitorAgentProcessRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        process_name: str = None,
        process_user: str = None,
        region_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The process name.
        # 
        # This parameter is required.
        self.process_name = process_name
        # The user who launches the process.
        self.process_user = process_user
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.process_user is not None:
            result['ProcessUser'] = self.process_user
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('ProcessUser') is not None:
            self.process_user = m.get('ProcessUser')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateMonitorAgentProcessResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        id: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The process ID.
        self.id = id
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMonitorAgentProcessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMonitorAgentProcessResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMonitorAgentProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMonitorGroupRequest(TeaModel):
    def __init__(
        self,
        contact_groups: str = None,
        group_name: str = None,
        region_id: str = None,
    ):
        # The alert contact group. The alert notifications of the application group are sent to the alert contacts that belong to the alert contact group.
        # 
        # >  An alert contact group can contain one or more alert contacts. For information about how to create alert contacts and alert contact groups, see [PutContact](~~PutContact~~) and [PutContactGroup](~~PutContactGroup~~).
        self.contact_groups = contact_groups
        # The name of the application group.
        # 
        # This parameter is required.
        self.group_name = group_name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroups') is not None:
            self.contact_groups = m.get('ContactGroups')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateMonitorGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        group_id: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The ID of the application group.
        self.group_id = group_id
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMonitorGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMonitorGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMonitorGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMonitorGroupByResourceGroupIdRequest(TeaModel):
    def __init__(
        self,
        contact_group_list: List[str] = None,
        enable_install_agent: bool = None,
        enable_subscribe_event: bool = None,
        region_id: str = None,
        resource_group_id: str = None,
        resource_group_name: str = None,
    ):
        # The alert contact groups. The alert notifications of the application group are sent to the alert contacts that belong to the specified alert contact groups.
        # 
        # An alert contact group can contain one or more alert contacts. For information about how to create alert contacts and alert contact groups, see [PutContact](https://help.aliyun.com/document_detail/114923.html) and [PutContactGroup](https://help.aliyun.com/document_detail/114929.html). For information about how to obtain alert contact groups, see [DescribeContactGroupList](https://help.aliyun.com/document_detail/114922.html).
        # 
        # This parameter is required.
        self.contact_group_list = contact_group_list
        # Specifies whether the CloudMonitor agent is automatically installed for the application group. CloudMonitor determines whether to automatically install the CloudMonitor agent for the hosts in an application group based on the value of this parameter. Valid values:
        # 
        # *   true: The CloudMonitor agent is automatically installed.
        # *   false (default): The CloudMonitor agent is not automatically installed.
        self.enable_install_agent = enable_install_agent
        # Specifies whether the application group automatically subscribes to event notifications. If events whose severity level is critical or warning occur on resources in an application group, CloudMonitor sends alert notifications. Valid values:
        # 
        # *   true: The application group automatically subscribes to event notifications.
        # *   false (default): The application group does not automatically subscribe to event notifications.
        self.enable_subscribe_event = enable_subscribe_event
        # The ID of the region where the resource group resides.
        # 
        # For information about how to obtain the ID of the region where a resource group resides, see [GetResourceGroup](https://help.aliyun.com/document_detail/158866.html).
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the resource group.
        # 
        # For information about how to obtain the ID of a resource group, see [ListResourceGroups](https://help.aliyun.com/document_detail/158855.html).
        # 
        # This parameter is required.
        self.resource_group_id = resource_group_id
        # The name of the resource group.
        # 
        # For information about how to obtain the name of a resource group, see [ListResourceGroups](https://help.aliyun.com/document_detail/158855.html).
        # 
        # This parameter is required.
        self.resource_group_name = resource_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_list is not None:
            result['ContactGroupList'] = self.contact_group_list
        if self.enable_install_agent is not None:
            result['EnableInstallAgent'] = self.enable_install_agent
        if self.enable_subscribe_event is not None:
            result['EnableSubscribeEvent'] = self.enable_subscribe_event
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_group_name is not None:
            result['ResourceGroupName'] = self.resource_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroupList') is not None:
            self.contact_group_list = m.get('ContactGroupList')
        if m.get('EnableInstallAgent') is not None:
            self.enable_install_agent = m.get('EnableInstallAgent')
        if m.get('EnableSubscribeEvent') is not None:
            self.enable_subscribe_event = m.get('EnableSubscribeEvent')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceGroupName') is not None:
            self.resource_group_name = m.get('ResourceGroupName')
        return self


class CreateMonitorGroupByResourceGroupIdResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        id: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        # 
        # > The status code 200 indicates that the request was successful.
        self.code = code
        # The ID of the application group.
        self.id = id
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMonitorGroupByResourceGroupIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMonitorGroupByResourceGroupIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMonitorGroupByResourceGroupIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMonitorGroupInstancesRequestInstances(TeaModel):
    def __init__(
        self,
        category: str = None,
        instance_id: str = None,
        instance_name: str = None,
        region_id: str = None,
    ):
        # The abbreviation of the Alibaba Cloud service name.
        # 
        # To obtain the abbreviation of an Alibaba Cloud service name, call the [DescribeProjectMeta](https://help.aliyun.com/document_detail/114916.html) operation. The `metricCategory` tag in the `Labels` response parameter indicates the abbreviation of the Alibaba Cloud service name.
        # 
        # This parameter is required.
        self.category = category
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The instance name.
        # 
        # This parameter is required.
        self.instance_name = instance_name
        # The region ID of the instance.
        # 
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateMonitorGroupInstancesRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        instances: List[CreateMonitorGroupInstancesRequestInstances] = None,
        region_id: str = None,
    ):
        # The ID of the application group.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The instances that you want to add to the application group.
        # 
        # This parameter is required.
        self.instances = instances
        self.region_id = region_id

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = CreateMonitorGroupInstancesRequestInstances()
                self.instances.append(temp_model.from_map(k))
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateMonitorGroupInstancesResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        # 
        # > The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMonitorGroupInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMonitorGroupInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMonitorGroupInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMonitorGroupNotifyPolicyRequest(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        group_id: str = None,
        policy_type: str = None,
        region_id: str = None,
        start_time: int = None,
    ):
        # The end time of the validity period for the policy.
        # 
        # This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The ID of the application group.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The policy type. Valid value: PauseNotify.
        # 
        # This parameter is required.
        self.policy_type = policy_type
        self.region_id = region_id
        # The start time of the validity period for the policy.
        # 
        # This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class CreateMonitorGroupNotifyPolicyResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        result: int = None,
        success: str = None,
    ):
        # The status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # The total number of entries returned.
        self.result = result
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMonitorGroupNotifyPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMonitorGroupNotifyPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMonitorGroupNotifyPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMonitoringAgentProcessRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        process_name: str = None,
        process_user: str = None,
        region_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The name of the process.
        self.process_name = process_name
        # The user who launches the process.
        self.process_user = process_user
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.process_user is not None:
            result['ProcessUser'] = self.process_user
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('ProcessUser') is not None:
            self.process_user = m.get('ProcessUser')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateMonitoringAgentProcessResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        id: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The process ID.
        self.id = id
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMonitoringAgentProcessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMonitoringAgentProcessResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMonitoringAgentProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSiteMonitorRequest(TeaModel):
    def __init__(
        self,
        address: str = None,
        agent_group: str = None,
        alert_ids: str = None,
        custom_schedule: str = None,
        interval: str = None,
        isp_cities: str = None,
        options_json: str = None,
        region_id: str = None,
        task_name: str = None,
        task_type: str = None,
        vpc_config: str = None,
    ):
        # The URL or IP address that is monitored by the task.
        # 
        # This parameter is required.
        self.address = address
        self.agent_group = agent_group
        # The ID of the alert rule.
        # 
        # For more information about how to obtain the ID of an alert rule, see [DescribeMetricRuleList](https://help.aliyun.com/document_detail/114941.html).
        self.alert_ids = alert_ids
        # The custom detection period. You can only select a time period from Monday to Sunday for detection.
        self.custom_schedule = custom_schedule
        # The interval at which detection requests are sent.
        # 
        # Valid values: 1, 5, 15, 30, and 60. Unit: minutes.
        # 
        # Default value: 1.
        self.interval = interval
        # The information of the detection points. If you leave this parameter empty, the system randomly selects three detection points.
        # 
        # The value is a JSON array. Example: `[{"city":"546","isp":"465"},{"city":"572","isp":"465"},{"city":"738","isp":"465"}]`. The values of the city field indicate Beijing, Hangzhou, and Qingdao.
        # 
        # For information about how to obtain detection points, see [DescribeSiteMonitorISPCityList](https://help.aliyun.com/document_detail/115045.html).
        self.isp_cities = isp_cities
        # The extended options of the protocol that is used by the site monitoring task. The options vary based on the protocol.
        self.options_json = options_json
        self.region_id = region_id
        # The name of the site monitoring task.
        # 
        # The name must be 4 to 100 characters in length, and can contain letters, digits, and underscores (_).
        # 
        # This parameter is required.
        self.task_name = task_name
        # The protocol that is used by the site monitoring task.
        # 
        # Valid values: HTTP, HTTPS, PING, TCP, UDP, DNS, SMTP, POP3, FTP, and WEBSOCKET.
        # 
        # This parameter is required.
        self.task_type = task_type
        self.vpc_config = vpc_config

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.agent_group is not None:
            result['AgentGroup'] = self.agent_group
        if self.alert_ids is not None:
            result['AlertIds'] = self.alert_ids
        if self.custom_schedule is not None:
            result['CustomSchedule'] = self.custom_schedule
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_cities is not None:
            result['IspCities'] = self.isp_cities
        if self.options_json is not None:
            result['OptionsJson'] = self.options_json
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.vpc_config is not None:
            result['VpcConfig'] = self.vpc_config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('AgentGroup') is not None:
            self.agent_group = m.get('AgentGroup')
        if m.get('AlertIds') is not None:
            self.alert_ids = m.get('AlertIds')
        if m.get('CustomSchedule') is not None:
            self.custom_schedule = m.get('CustomSchedule')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspCities') is not None:
            self.isp_cities = m.get('IspCities')
        if m.get('OptionsJson') is not None:
            self.options_json = m.get('OptionsJson')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('VpcConfig') is not None:
            self.vpc_config = m.get('VpcConfig')
        return self


class CreateSiteMonitorResponseBodyCreateResultListCreateResultList(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        task_name: str = None,
    ):
        # The ID of the site monitoring task.
        self.task_id = task_id
        # The name of the site monitoring task.
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateSiteMonitorResponseBodyCreateResultList(TeaModel):
    def __init__(
        self,
        create_result_list: List[CreateSiteMonitorResponseBodyCreateResultListCreateResultList] = None,
    ):
        self.create_result_list = create_result_list

    def validate(self):
        if self.create_result_list:
            for k in self.create_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CreateResultList'] = []
        if self.create_result_list is not None:
            for k in self.create_result_list:
                result['CreateResultList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.create_result_list = []
        if m.get('CreateResultList') is not None:
            for k in m.get('CreateResultList'):
                temp_model = CreateSiteMonitorResponseBodyCreateResultListCreateResultList()
                self.create_result_list.append(temp_model.from_map(k))
        return self


class CreateSiteMonitorResponseBodyDataAttachAlertResultContact(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        rule_id: str = None,
        success: str = None,
    ):
        # The status code that is returned after you associate the existing alert rule with the site monitoring task.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The message that is returned after you associate the existing alert rule with the site monitoring task.
        self.message = message
        # The ID of the request that was sent to associate the existing alert rule with the site monitoring task.
        self.request_id = request_id
        # The ID of the alert rule.
        self.rule_id = rule_id
        # Indicates whether the existing alert rule was associated with the site monitoring task. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSiteMonitorResponseBodyDataAttachAlertResult(TeaModel):
    def __init__(
        self,
        contact: List[CreateSiteMonitorResponseBodyDataAttachAlertResultContact] = None,
    ):
        self.contact = contact

    def validate(self):
        if self.contact:
            for k in self.contact:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Contact'] = []
        if self.contact is not None:
            for k in self.contact:
                result['Contact'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.contact = []
        if m.get('Contact') is not None:
            for k in m.get('Contact'):
                temp_model = CreateSiteMonitorResponseBodyDataAttachAlertResultContact()
                self.contact.append(temp_model.from_map(k))
        return self


class CreateSiteMonitorResponseBodyData(TeaModel):
    def __init__(
        self,
        attach_alert_result: CreateSiteMonitorResponseBodyDataAttachAlertResult = None,
    ):
        # The result that is returned after you associate the existing alert rule with the site monitoring task.
        self.attach_alert_result = attach_alert_result

    def validate(self):
        if self.attach_alert_result:
            self.attach_alert_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attach_alert_result is not None:
            result['AttachAlertResult'] = self.attach_alert_result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttachAlertResult') is not None:
            temp_model = CreateSiteMonitorResponseBodyDataAttachAlertResult()
            self.attach_alert_result = temp_model.from_map(m['AttachAlertResult'])
        return self


class CreateSiteMonitorResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        create_result_list: CreateSiteMonitorResponseBodyCreateResultList = None,
        data: CreateSiteMonitorResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code.
        # 
        # > The status code 200 indicates that the request was successful.
        self.code = code
        # The returned result.
        # 
        # If a site monitoring task is created, the result is returned. If a site monitoring task fails to be created, no result is returned.
        self.create_result_list = create_result_list
        # The result of the site monitoring task.
        self.data = data
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        if self.create_result_list:
            self.create_result_list.validate()
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.create_result_list is not None:
            result['CreateResultList'] = self.create_result_list.to_map()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreateResultList') is not None:
            temp_model = CreateSiteMonitorResponseBodyCreateResultList()
            self.create_result_list = temp_model.from_map(m['CreateResultList'])
        if m.get('Data') is not None:
            temp_model = CreateSiteMonitorResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSiteMonitorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSiteMonitorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSiteMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CursorRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        matchers: List[Matcher] = None,
        metric: str = None,
        namespace: str = None,
        period: int = None,
        start_time: str = None,
    ):
        # The end of the time range to query.
        # 
        # Unit: milliseconds.
        # 
        # > 
        # 
        # *   This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC. For example, 2023-01-01T00:00:00Z indicates January 1, 2023, 00:00:00 UTC.
        # 
        # *   If you do not set the end time, the end time is infinite. You can leave this parameter empty in real-time export scenarios.
        # *   In CloudMonitor, the TTL of monitoring data varies with the time granularity. Specify a proper time interval based on the TTL corresponding to the value of the `Period` parameter.
        self.end_time = end_time
        # The dimension information of the metric.
        self.matchers = matchers
        # The metric that is used to monitor the cloud service.
        # 
        # For more information about the metrics of cloud services, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # This parameter is required.
        self.metric = metric
        # The namespace of the cloud service.
        # 
        # For more information about the namespaces of cloud services, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # This parameter is required.
        self.namespace = namespace
        # The time interval based on which the metric value is measured.
        # 
        # Unit: seconds.
        # 
        # >  Generally, the time interval is 60 seconds. For more information about specific values, see the `Period` parameter in [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # This parameter is required.
        self.period = period
        # The beginning of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC. For example, 2023-01-01T00:00:00Z indicates January 1, 2023, 00:00:00 UTC.
        # 
        # >  In CloudMonitor, the TTL of monitoring data varies with the time granularity. Specify a proper time interval based on the TTL corresponding to the value of the `Period` parameter.
        # 
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        if self.matchers:
            for k in self.matchers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        result['Matchers'] = []
        if self.matchers is not None:
            for k in self.matchers:
                result['Matchers'].append(k.to_map() if k else None)
        if self.metric is not None:
            result['Metric'] = self.metric
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.period is not None:
            result['Period'] = self.period
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        self.matchers = []
        if m.get('Matchers') is not None:
            for k in m.get('Matchers'):
                temp_model = Matcher()
                self.matchers.append(temp_model.from_map(k))
        if m.get('Metric') is not None:
            self.metric = m.get('Metric')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class CursorShrinkRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        matchers_shrink: str = None,
        metric: str = None,
        namespace: str = None,
        period: int = None,
        start_time: str = None,
    ):
        # The end of the time range to query.
        # 
        # Unit: milliseconds.
        # 
        # > 
        # 
        # *   This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC. For example, 2023-01-01T00:00:00Z indicates January 1, 2023, 00:00:00 UTC.
        # 
        # *   If you do not set the end time, the end time is infinite. You can leave this parameter empty in real-time export scenarios.
        # *   In CloudMonitor, the TTL of monitoring data varies with the time granularity. Specify a proper time interval based on the TTL corresponding to the value of the `Period` parameter.
        self.end_time = end_time
        # The dimension information of the metric.
        self.matchers_shrink = matchers_shrink
        # The metric that is used to monitor the cloud service.
        # 
        # For more information about the metrics of cloud services, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # This parameter is required.
        self.metric = metric
        # The namespace of the cloud service.
        # 
        # For more information about the namespaces of cloud services, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # This parameter is required.
        self.namespace = namespace
        # The time interval based on which the metric value is measured.
        # 
        # Unit: seconds.
        # 
        # >  Generally, the time interval is 60 seconds. For more information about specific values, see the `Period` parameter in [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # This parameter is required.
        self.period = period
        # The beginning of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC. For example, 2023-01-01T00:00:00Z indicates January 1, 2023, 00:00:00 UTC.
        # 
        # >  In CloudMonitor, the TTL of monitoring data varies with the time granularity. Specify a proper time interval based on the TTL corresponding to the value of the `Period` parameter.
        # 
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.matchers_shrink is not None:
            result['Matchers'] = self.matchers_shrink
        if self.metric is not None:
            result['Metric'] = self.metric
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.period is not None:
            result['Period'] = self.period
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Matchers') is not None:
            self.matchers_shrink = m.get('Matchers')
        if m.get('Metric') is not None:
            self.metric = m.get('Metric')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class CursorResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        cursor: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # Cursor is used as an input parameter for data export in the [BatchExport](https://help.aliyun.com/document_detail/2329847.html) operation.
        self.cursor = cursor
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.cursor is not None:
            result['Cursor'] = self.cursor
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Cursor') is not None:
            self.cursor = m.get('Cursor')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CursorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CursorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CursorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteContactRequest(TeaModel):
    def __init__(
        self,
        contact_name: str = None,
    ):
        # The name of the alert contact.
        # 
        # This parameter is required.
        self.contact_name = contact_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        return self


class DeleteContactResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values: true and false.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteContactResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteContactResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteContactResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteContactGroupRequest(TeaModel):
    def __init__(
        self,
        contact_group_name: str = None,
    ):
        # The name of the alert contact group.
        # 
        # This parameter is required.
        self.contact_group_name = contact_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_name is not None:
            result['ContactGroupName'] = self.contact_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroupName') is not None:
            self.contact_group_name = m.get('ContactGroupName')
        return self


class DeleteContactGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values: true and false.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteContactGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteContactGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteContactGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomMetricRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        md_5: str = None,
        metric_name: str = None,
        region_id: str = None,
        uuid: str = None,
    ):
        # The ID of the application group.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The MD5 value of the HTTP request body. The MD5 value is a 128-bit hash value used to verify the uniqueness of the reported monitoring data.
        # 
        # >  `Md5` is returned when you query the reported monitoring data of a metric.
        self.md_5 = md_5
        # The name of the metric.
        # 
        # This parameter is required.
        self.metric_name = metric_name
        self.region_id = region_id
        # The ID of the request for reporting monitoring data.
        # 
        # >  `UUID` is returned when you query the reported monitoring data of a metric. We recommend that you specify the `Md5` parameter.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.uuid is not None:
            result['UUID'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('UUID') is not None:
            self.uuid = m.get('UUID')
        return self


class DeleteCustomMetricResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
    ):
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the call is successful.
        self.code = code
        # The returned message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCustomMetricResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCustomMetricResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomMetricResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDynamicTagGroupRequest(TeaModel):
    def __init__(
        self,
        dynamic_tag_rule_id: str = None,
        region_id: str = None,
    ):
        # The ID of the tag rule.
        # 
        # For information about how to obtain the ID of a tag rule, see [DescribeDynamicTagRuleList](https://help.aliyun.com/document_detail/150126.html).
        # 
        # This parameter is required.
        self.dynamic_tag_rule_id = dynamic_tag_rule_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_tag_rule_id is not None:
            result['DynamicTagRuleId'] = self.dynamic_tag_rule_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DynamicTagRuleId') is not None:
            self.dynamic_tag_rule_id = m.get('DynamicTagRuleId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteDynamicTagGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        # 
        # > The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDynamicTagGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDynamicTagGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDynamicTagGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEventRuleTargetsRequest(TeaModel):
    def __init__(
        self,
        ids: List[str] = None,
        region_id: str = None,
        rule_name: str = None,
    ):
        # The IDs of event-triggered alert rules.
        # 
        # This parameter is required.
        self.ids = ids
        self.region_id = region_id
        # The name of the event-triggered alert rule.
        # 
        # For information about how to obtain the name of an event-triggered alert rule, see [DescribeEventRuleList](https://help.aliyun.com/document_detail/114996.html).
        # 
        # This parameter is required.
        self.rule_name = rule_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ids is not None:
            result['Ids'] = self.ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        return self


class DeleteEventRuleTargetsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The returned message.
        self.message = message
        # The request ID. You can use the request ID to query logs and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`
        # *   `false`
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteEventRuleTargetsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEventRuleTargetsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEventRuleTargetsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEventRulesRequest(TeaModel):
    def __init__(
        self,
        rule_names: List[str] = None,
    ):
        # The name of the alert rule. Valid values of N: 1 to 20.
        # 
        # This parameter is required.
        self.rule_names = rule_names

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_names is not None:
            result['RuleNames'] = self.rule_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleNames') is not None:
            self.rule_names = m.get('RuleNames')
        return self


class DeleteEventRulesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values: true and false.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteEventRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEventRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEventRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteExporterOutputRequest(TeaModel):
    def __init__(
        self,
        dest_name: str = None,
        region_id: str = None,
    ):
        # The name of the configuration set.
        # 
        # This parameter is required.
        self.dest_name = dest_name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dest_name is not None:
            result['DestName'] = self.dest_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestName') is not None:
            self.dest_name = m.get('DestName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteExporterOutputResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code.
        # 
        # > The status code 200 indicates that the request was successful. Other status codes indicate that the request failed.
        self.code = code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`
        # *   `false`
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteExporterOutputResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteExporterOutputResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteExporterOutputResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteExporterRuleRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        rule_name: str = None,
    ):
        self.region_id = region_id
        # The name of the data export rule.
        # 
        # This parameter is required.
        self.rule_name = rule_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        return self


class DeleteExporterRuleResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code.
        # 
        # > The status code 200 indicates that the request was successful. Other status codes indicate that the request failed.
        self.code = code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`
        # *   `false`
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteExporterRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteExporterRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteExporterRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGroupMonitoringAgentProcessRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        id: str = None,
        region_id: str = None,
    ):
        # The ID of the application group.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The ID of the process monitoring task.
        # 
        # This parameter is required.
        self.id = id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteGroupMonitoringAgentProcessResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteGroupMonitoringAgentProcessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteGroupMonitoringAgentProcessResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGroupMonitoringAgentProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHostAvailabilityRequest(TeaModel):
    def __init__(
        self,
        id: List[int] = None,
        region_id: str = None,
    ):
        # The task ID. Valid values of N: 1 to 20.
        # 
        # This parameter is required.
        self.id = id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteHostAvailabilityResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values: true and false.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHostAvailabilityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHostAvailabilityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHostAvailabilityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHybridMonitorNamespaceRequest(TeaModel):
    def __init__(
        self,
        namespace: str = None,
        region_id: str = None,
    ):
        # The name of the namespace.
        # 
        # For information about how to obtain the name of a namespace, see [DescribeHybridMonitorNamespaceList](https://help.aliyun.com/document_detail/428880.html).
        # 
        # This parameter is required.
        self.namespace = namespace
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteHybridMonitorNamespaceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The returned message.
        self.code = code
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHybridMonitorNamespaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHybridMonitorNamespaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHybridMonitorNamespaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHybridMonitorSLSGroupRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        slsgroup_name: str = None,
    ):
        self.region_id = region_id
        # The name of the Logstore group.
        # 
        # For information about how to obtain the name of a Logstore group, see [DescribeHybridMonitorSLSGroup](https://help.aliyun.com/document_detail/429526.html).
        # 
        # This parameter is required.
        self.slsgroup_name = slsgroup_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.slsgroup_name is not None:
            result['SLSGroupName'] = self.slsgroup_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SLSGroupName') is not None:
            self.slsgroup_name = m.get('SLSGroupName')
        return self


class DeleteHybridMonitorSLSGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The status code.
        # 
        # > The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHybridMonitorSLSGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHybridMonitorSLSGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHybridMonitorSLSGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHybridMonitorTaskRequest(TeaModel):
    def __init__(
        self,
        namespace: str = None,
        region_id: str = None,
        target_user_id: str = None,
        task_id: str = None,
    ):
        # The name of the namespace.
        # 
        # The name can contain uppercase letters, lowercase letters, digits, and hyphens (-).
        # 
        # > This parameter is required only if you call this operation to delete metric import tasks for Alibaba Cloud services. In this case, the `TaskType` parameter is set to `aliyun_fc`.
        self.namespace = namespace
        self.region_id = region_id
        # The ID of the member account.
        # 
        # > This parameter is required only if you use a management account to call this operation to query metric import tasks that belong to a member in a resource directory. In this case, the `TaskType` parameter is set to `aliyun_fc`.
        self.target_user_id = target_user_id
        # The ID of the metric import task.
        # 
        # For information about how to obtain the ID of a metric import task, see [DescribeHybridMonitorTaskList](https://help.aliyun.com/document_detail/428624.html).
        # 
        # > This parameter is required only if you call this operation to delete metrics for the logs that are imported from Log Service. In this case, the `TaskType` parameter is set to `aliyun_sls`.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.target_user_id is not None:
            result['TargetUserId'] = self.target_user_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TargetUserId') is not None:
            self.target_user_id = m.get('TargetUserId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DeleteHybridMonitorTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The status code.
        # 
        # > The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHybridMonitorTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHybridMonitorTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHybridMonitorTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLogMonitorRequest(TeaModel):
    def __init__(
        self,
        log_id: int = None,
        region_id: str = None,
    ):
        # The ID of the log monitoring metric.
        # 
        # This parameter is required.
        self.log_id = log_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_id is not None:
            result['LogId'] = self.log_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LogId') is not None:
            self.log_id = m.get('LogId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteLogMonitorResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteLogMonitorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLogMonitorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLogMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMetricRuleBlackListRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        region_id: str = None,
    ):
        # The IDs of the blacklist policies. Separate multiple IDs with commas (,). You can specify up to 50 IDs.
        # 
        # For more information about how to obtain the ID of a blacklist policy, see [DescribeMetricRuleBlackList](https://help.aliyun.com/document_detail/457257.html).
        # 
        # >  You can also set this parameter to a JSON array. Example: `["a9ad2ac2-3ed9-11ed-b878-0242ac12****","5cb8a9a4-198f-4651-a353-f8b28788****"]`.
        # 
        # This parameter is required.
        self.id = id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteMetricRuleBlackListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        count: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The number of blacklist policies that are deleted.
        self.count = count
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.count is not None:
            result['Count'] = self.count
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMetricRuleBlackListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMetricRuleBlackListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMetricRuleBlackListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMetricRuleResourcesRequest(TeaModel):
    def __init__(
        self,
        resources: str = None,
        rule_id: str = None,
    ):
        # The resources that are associated with the alert rule.
        # 
        # This parameter is required.
        self.resources = resources
        # The ID of the alert rule.
        # 
        # This parameter is required.
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resources is not None:
            result['Resources'] = self.resources
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Resources') is not None:
            self.resources = m.get('Resources')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteMetricRuleResourcesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The responses code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMetricRuleResourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMetricRuleResourcesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMetricRuleResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMetricRuleTargetsRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        rule_id: str = None,
        target_ids: List[str] = None,
    ):
        self.region_id = region_id
        # The ID of the alert rule.
        # 
        # This parameter is required.
        self.rule_id = rule_id
        # The resource IDs.
        # 
        # This parameter is required.
        self.target_ids = target_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.target_ids is not None:
            result['TargetIds'] = self.target_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('TargetIds') is not None:
            self.target_ids = m.get('TargetIds')
        return self


class DeleteMetricRuleTargetsResponseBodyFailIdsTargetIds(TeaModel):
    def __init__(
        self,
        target_id: List[str] = None,
    ):
        self.target_id = target_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_id is not None:
            result['TargetId'] = self.target_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TargetId') is not None:
            self.target_id = m.get('TargetId')
        return self


class DeleteMetricRuleTargetsResponseBodyFailIds(TeaModel):
    def __init__(
        self,
        target_ids: DeleteMetricRuleTargetsResponseBodyFailIdsTargetIds = None,
    ):
        # The IDs of the resources that failed to be deleted.
        self.target_ids = target_ids

    def validate(self):
        if self.target_ids:
            self.target_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_ids is not None:
            result['TargetIds'] = self.target_ids.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TargetIds') is not None:
            temp_model = DeleteMetricRuleTargetsResponseBodyFailIdsTargetIds()
            self.target_ids = temp_model.from_map(m['TargetIds'])
        return self


class DeleteMetricRuleTargetsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        fail_ids: DeleteMetricRuleTargetsResponseBodyFailIds = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code.
        # 
        # **\
        # 
        # **Description** The status code 200 indicates that the request was successful.
        self.code = code
        # The IDs of the resources that failed to be deleted.
        self.fail_ids = fail_ids
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        if self.fail_ids:
            self.fail_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.fail_ids is not None:
            result['FailIds'] = self.fail_ids.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('FailIds') is not None:
            temp_model = DeleteMetricRuleTargetsResponseBodyFailIds()
            self.fail_ids = temp_model.from_map(m['FailIds'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMetricRuleTargetsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMetricRuleTargetsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMetricRuleTargetsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMetricRuleTemplateRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        template_id: str = None,
    ):
        self.region_id = region_id
        # The ID of the alert template.
        # 
        # This parameter is required.
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteMetricRuleTemplateResponseBodyResource(TeaModel):
    def __init__(
        self,
        template_id: str = None,
    ):
        # The ID of the template.
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteMetricRuleTemplateResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        request_id: str = None,
        resource: DeleteMetricRuleTemplateResponseBodyResource = None,
        success: bool = None,
    ):
        # The status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # The template information.
        self.resource = resource
        # Indicates whether the request was successful. Valid values: true and false.
        self.success = success

    def validate(self):
        if self.resource:
            self.resource.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource is not None:
            result['Resource'] = self.resource.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resource') is not None:
            temp_model = DeleteMetricRuleTemplateResponseBodyResource()
            self.resource = temp_model.from_map(m['Resource'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMetricRuleTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMetricRuleTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMetricRuleTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMetricRulesRequest(TeaModel):
    def __init__(
        self,
        id: List[str] = None,
        region_id: str = None,
    ):
        # This parameter is required.
        self.id = id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteMetricRulesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        # 
        # >  The status code 200 indicates a success.
        self.code = code
        # The returned message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the operation was successful. Valid values:
        # 
        # *   true: successful.
        # *   false: failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMetricRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMetricRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMetricRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMonitorGroupRequest(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        region_id: str = None,
    ):
        # The ID of the application group.
        # 
        # This parameter is required.
        self.group_id = group_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteMonitorGroupResponseBodyGroupContactGroupsContactGroup(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        # The name of the alert group.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DeleteMonitorGroupResponseBodyGroupContactGroups(TeaModel):
    def __init__(
        self,
        contact_group: List[DeleteMonitorGroupResponseBodyGroupContactGroupsContactGroup] = None,
    ):
        self.contact_group = contact_group

    def validate(self):
        if self.contact_group:
            for k in self.contact_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ContactGroup'] = []
        if self.contact_group is not None:
            for k in self.contact_group:
                result['ContactGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.contact_group = []
        if m.get('ContactGroup') is not None:
            for k in m.get('ContactGroup'):
                temp_model = DeleteMonitorGroupResponseBodyGroupContactGroupsContactGroup()
                self.contact_group.append(temp_model.from_map(k))
        return self


class DeleteMonitorGroupResponseBodyGroup(TeaModel):
    def __init__(
        self,
        contact_groups: DeleteMonitorGroupResponseBodyGroupContactGroups = None,
        group_name: str = None,
    ):
        # The alert groups that receive alert notifications for the application group.
        self.contact_groups = contact_groups
        # The name of the application group.
        self.group_name = group_name

    def validate(self):
        if self.contact_groups:
            self.contact_groups.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups.to_map()
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroups') is not None:
            temp_model = DeleteMonitorGroupResponseBodyGroupContactGroups()
            self.contact_groups = temp_model.from_map(m['ContactGroups'])
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class DeleteMonitorGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        group: DeleteMonitorGroupResponseBodyGroup = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the call was successful.
        self.code = code
        # The deleted application group.
        self.group = group
        # The returned message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the call was successful. The value true indicates a success. The value false indicates a failure.
        self.success = success

    def validate(self):
        if self.group:
            self.group.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.group is not None:
            result['Group'] = self.group.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Group') is not None:
            temp_model = DeleteMonitorGroupResponseBodyGroup()
            self.group = temp_model.from_map(m['Group'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMonitorGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMonitorGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMonitorGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMonitorGroupDynamicRuleRequest(TeaModel):
    def __init__(
        self,
        category: str = None,
        group_id: int = None,
        region_id: str = None,
    ):
        # The service to which the rule applies. Valid values: ecs, rds, and slb.
        # 
        # This parameter is required.
        self.category = category
        # The ID of the application group.
        # 
        # This parameter is required.
        self.group_id = group_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteMonitorGroupDynamicRuleResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values: true and false.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMonitorGroupDynamicRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMonitorGroupDynamicRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMonitorGroupDynamicRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMonitorGroupInstancesRequest(TeaModel):
    def __init__(
        self,
        category: str = None,
        group_id: int = None,
        instance_id_list: str = None,
        region_id: str = None,
    ):
        # The abbreviation of the cloud service name.
        # 
        # >  For more information about how to obtain the abbreviation of a cloud service name, see `metricCategory` in the response parameter `Labels` of the [DescribeProjectMeta](https://help.aliyun.com/document_detail/114916.html) operation.
        # 
        # This parameter is required.
        self.category = category
        # The ID of the application group.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The instances to be removed from the application group. Separate multiple instances with commas (,). You can remove a maximum of 20 instances from an application group at a time.
        # 
        # This parameter is required.
        self.instance_id_list = instance_id_list
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_id_list is not None:
            result['InstanceIdList'] = self.instance_id_list
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceIdList') is not None:
            self.instance_id_list = m.get('InstanceIdList')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteMonitorGroupInstancesResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMonitorGroupInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMonitorGroupInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMonitorGroupInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMonitorGroupNotifyPolicyRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        policy_type: str = None,
        region_id: str = None,
    ):
        # The ID of the application group.
        self.group_id = group_id
        # The type of the policy.
        # 
        # Valid value: PauseNotify.
        # 
        # This parameter is required.
        self.policy_type = policy_type
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteMonitorGroupNotifyPolicyResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        result: int = None,
        success: str = None,
    ):
        # The status code.
        # 
        # > The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # The number of affected rows.
        self.result = result
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMonitorGroupNotifyPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMonitorGroupNotifyPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMonitorGroupNotifyPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMonitoringAgentProcessRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        process_id: str = None,
        process_name: str = None,
        region_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The process ID.
        # 
        # > You must configure either `ProcessId` or `ProcessName`.
        self.process_id = process_id
        # The process name.
        # 
        # > You must configure either `ProcessId` or `ProcessName`.
        self.process_name = process_name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteMonitoringAgentProcessResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        # 
        # > The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMonitoringAgentProcessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMonitoringAgentProcessResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMonitoringAgentProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSiteMonitorsRequest(TeaModel):
    def __init__(
        self,
        is_delete_alarms: bool = None,
        region_id: str = None,
        task_ids: str = None,
    ):
        # Specifies whether to delete the alert rules configured for the site monitoring tasks. Valid values:
        # 
        # *   true (default value)
        # *   false
        self.is_delete_alarms = is_delete_alarms
        self.region_id = region_id
        # The IDs of the site monitoring tasks that you want to delete. Separate multiple task IDs with commas (,).
        # 
        # This parameter is required.
        self.task_ids = task_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_delete_alarms is not None:
            result['IsDeleteAlarms'] = self.is_delete_alarms
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_ids is not None:
            result['TaskIds'] = self.task_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsDeleteAlarms') is not None:
            self.is_delete_alarms = m.get('IsDeleteAlarms')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskIds') is not None:
            self.task_ids = m.get('TaskIds')
        return self


class DeleteSiteMonitorsResponseBodyData(TeaModel):
    def __init__(
        self,
        count: int = None,
    ):
        # The number of the site monitoring tasks that were deleted.
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('count') is not None:
            self.count = m.get('count')
        return self


class DeleteSiteMonitorsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DeleteSiteMonitorsResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the call was successful.
        self.code = code
        # The information about the site monitoring tasks that were deleted.
        self.data = data
        # The returned message. If the call was successful, the value success is returned. If the call failed, an error message such as `TaskId not found` is returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the call was successful. The value true indicates success. The value false indicates failure.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DeleteSiteMonitorsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSiteMonitorsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSiteMonitorsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSiteMonitorsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeActiveMetricRuleListRequest(TeaModel):
    def __init__(
        self,
        product: str = None,
    ):
        # The abbreviation of the cloud service that supports initiative alert rules.
        # 
        # For more information about how to obtain the name of a cloud service, see [DescribeProductsOfActiveMetricRule](https://help.aliyun.com/document_detail/114930.html).
        # 
        # This parameter is required.
        self.product = product

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product is not None:
            result['Product'] = self.product
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Product') is not None:
            self.product = m.get('Product')
        return self


class DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsCritical(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        statistics: str = None,
        threshold: str = None,
        times: str = None,
    ):
        # The operator that is used to compare the metric value with the threshold for Critical-level alerts. Valid values:
        # 
        # *   GreaterThanOrEqualToThreshold: greater than or equal to the threshold
        # *   GreaterThanThreshold: greater than the threshold
        # *   LessThanOrEqualToThreshold: less than or equal to the threshold
        # *   LessThanThreshold: less than the threshold
        # *   NotEqualToThreshold: not equal to the threshold
        # *   GreaterThanYesterday: greater than the metric value at the same time yesterday
        # *   LessThanYesterday: less than the metric value at the same time yesterday
        # *   GreaterThanLastWeek: greater than the metric value at the same time last week
        # *   LessThanLastWeek: less than the metric value at the same time last week
        # *   GreaterThanLastPeriod: greater than the metric value in the last monitoring cycle
        # *   LessThanLastPeriod: less than the metric value in the last monitoring cycle
        self.comparison_operator = comparison_operator
        # The statistical methods for Critical-level alerts.
        self.statistics = statistics
        # The threshold for Critical-level alerts.
        self.threshold = threshold
        # The consecutive number of times for which the metric value meets the alert condition before a Critical-level alert is triggered.
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsInfo(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        statistics: str = None,
        threshold: str = None,
        times: str = None,
    ):
        # The operator that is used to compare the metric value with the threshold for Info-level alerts. Valid values:
        # 
        # *   GreaterThanOrEqualToThreshold: greater than or equal to the threshold
        # *   GreaterThanThreshold: greater than the threshold
        # *   LessThanOrEqualToThreshold: less than or equal to the threshold
        # *   LessThanThreshold: less than the threshold
        # *   NotEqualToThreshold: not equal to the threshold
        # *   GreaterThanYesterday: greater than the metric value at the same time yesterday
        # *   LessThanYesterday: less than the metric value at the same time yesterday
        # *   GreaterThanLastWeek: greater than the metric value at the same time last week
        # *   LessThanLastWeek: less than the metric value at the same time last week
        # *   GreaterThanLastPeriod: greater than the metric value in the last monitoring cycle
        # *   LessThanLastPeriod: less than the metric value in the last monitoring cycle
        self.comparison_operator = comparison_operator
        # The statistical methods for Info-level alerts.
        self.statistics = statistics
        # The threshold for Info-level alerts.
        self.threshold = threshold
        # The consecutive number of times
        # 
        # for which the metric value meets the alert condition before an Info-level alert is triggered.
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsWarn(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        statistics: str = None,
        threshold: str = None,
        times: str = None,
    ):
        # The operator that is used to compare the metric value with the threshold for Warn-level alerts. Valid values:
        # 
        # *   GreaterThanOrEqualToThreshold: greater than or equal to the threshold
        # *   GreaterThanThreshold: greater than the threshold
        # *   LessThanOrEqualToThreshold: less than or equal to the threshold
        # *   LessThanThreshold: less than the threshold
        # *   NotEqualToThreshold: not equal to the threshold
        # *   GreaterThanYesterday: greater than the metric value at the same time yesterday
        # *   LessThanYesterday: less than the metric value at the same time yesterday
        # *   GreaterThanLastWeek: greater than the metric value at the same time last week
        # *   LessThanLastWeek: less than the metric value at the same time last week
        # *   GreaterThanLastPeriod: greater than the metric value in the last monitoring cycle
        # *   LessThanLastPeriod: less than the metric value in the last monitoring cycle
        self.comparison_operator = comparison_operator
        # The statistical methods for Warn-level alerts.
        self.statistics = statistics
        # The threshold for Warn-level alerts.
        self.threshold = threshold
        # The consecutive number of times
        # 
        # for which the metric value meets the alert condition before a Warn-level alert is triggered.
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalations(TeaModel):
    def __init__(
        self,
        critical: DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsCritical = None,
        info: DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsInfo = None,
        warn: DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsWarn = None,
    ):
        # The trigger condition for Critical-level alerts.
        self.critical = critical
        # The conditions for triggering Info-level alerts.
        self.info = info
        # The conditions for triggering Warn-level alerts.
        self.warn = warn

    def validate(self):
        if self.critical:
            self.critical.validate()
        if self.info:
            self.info.validate()
        if self.warn:
            self.warn.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.critical is not None:
            result['Critical'] = self.critical.to_map()
        if self.info is not None:
            result['Info'] = self.info.to_map()
        if self.warn is not None:
            result['Warn'] = self.warn.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Critical') is not None:
            temp_model = DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsCritical()
            self.critical = temp_model.from_map(m['Critical'])
        if m.get('Info') is not None:
            temp_model = DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsInfo()
            self.info = temp_model.from_map(m['Info'])
        if m.get('Warn') is not None:
            temp_model = DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsWarn()
            self.warn = temp_model.from_map(m['Warn'])
        return self


class DescribeActiveMetricRuleListResponseBodyAlertListAlert(TeaModel):
    def __init__(
        self,
        alert_state: str = None,
        contact_groups: str = None,
        dimensions: str = None,
        effective_interval: str = None,
        enable_state: bool = None,
        escalations: DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalations = None,
        mail_subject: str = None,
        metric_name: str = None,
        namespace: str = None,
        no_effective_interval: str = None,
        period: str = None,
        resources: str = None,
        rule_id: str = None,
        rule_name: str = None,
        silence_time: str = None,
        webhook: str = None,
    ):
        # The status of the alert rule. Valid values:
        # 
        # *   OK: The alert rule has no active alerts.
        # *   ALARM: The alert rule has active alerts.
        # *   INSUFFICIENT_DATA: No data is found.
        self.alert_state = alert_state
        # The alert contact group.
        self.contact_groups = contact_groups
        # The monitoring data of the specified resource.
        self.dimensions = dimensions
        # The time period during which the alert rule is effective.
        self.effective_interval = effective_interval
        # Indicates whether the alert rule is enabled. Valid values:
        # 
        # *   true: The alert rule is enabled.
        # *   false: The alert rule is disabled.
        self.enable_state = enable_state
        # The conditions for triggering different levels of alerts.
        self.escalations = escalations
        # The subject of the alert notification email.
        self.mail_subject = mail_subject
        # The name of the metric.
        self.metric_name = metric_name
        # The namespace of the Alibaba Cloud service.
        self.namespace = namespace
        # The time period during which the alert rule is ineffective.
        self.no_effective_interval = no_effective_interval
        # The aggregation period of monitoring data.
        # 
        # Unit: seconds.
        self.period = period
        # The resources that are associated with the alert rule.
        self.resources = resources
        # The ID of the alert rule.
        self.rule_id = rule_id
        # The name of the alert rule.
        self.rule_name = rule_name
        # The mute period during which new alerts are not sent even if the trigger conditions are met.
        # 
        # Unit: seconds.
        self.silence_time = silence_time
        # The callback URL.
        self.webhook = webhook

    def validate(self):
        if self.escalations:
            self.escalations.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_state is not None:
            result['AlertState'] = self.alert_state
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.effective_interval is not None:
            result['EffectiveInterval'] = self.effective_interval
        if self.enable_state is not None:
            result['EnableState'] = self.enable_state
        if self.escalations is not None:
            result['Escalations'] = self.escalations.to_map()
        if self.mail_subject is not None:
            result['MailSubject'] = self.mail_subject
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.no_effective_interval is not None:
            result['NoEffectiveInterval'] = self.no_effective_interval
        if self.period is not None:
            result['Period'] = self.period
        if self.resources is not None:
            result['Resources'] = self.resources
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertState') is not None:
            self.alert_state = m.get('AlertState')
        if m.get('ContactGroups') is not None:
            self.contact_groups = m.get('ContactGroups')
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EffectiveInterval') is not None:
            self.effective_interval = m.get('EffectiveInterval')
        if m.get('EnableState') is not None:
            self.enable_state = m.get('EnableState')
        if m.get('Escalations') is not None:
            temp_model = DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalations()
            self.escalations = temp_model.from_map(m['Escalations'])
        if m.get('MailSubject') is not None:
            self.mail_subject = m.get('MailSubject')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NoEffectiveInterval') is not None:
            self.no_effective_interval = m.get('NoEffectiveInterval')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Resources') is not None:
            self.resources = m.get('Resources')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class DescribeActiveMetricRuleListResponseBodyAlertList(TeaModel):
    def __init__(
        self,
        alert: List[DescribeActiveMetricRuleListResponseBodyAlertListAlert] = None,
    ):
        self.alert = alert

    def validate(self):
        if self.alert:
            for k in self.alert:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Alert'] = []
        if self.alert is not None:
            for k in self.alert:
                result['Alert'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert = []
        if m.get('Alert') is not None:
            for k in m.get('Alert'):
                temp_model = DescribeActiveMetricRuleListResponseBodyAlertListAlert()
                self.alert.append(temp_model.from_map(k))
        return self


class DescribeActiveMetricRuleListResponseBodyDatapointsAlarm(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        contact_groups: str = None,
        enable: str = None,
        end_time: str = None,
        evaluation_count: str = None,
        metric_name: str = None,
        namespace: str = None,
        period: str = None,
        rule_id: str = None,
        rule_name: str = None,
        silence_time: str = None,
        start_time: str = None,
        state: str = None,
        statistics: str = None,
        threshold: str = None,
        webhook: str = None,
    ):
        # The comparison operator that is used in the alert rule. Valid values:
        # 
        # *   `>`
        # *   `<`
        # *   `>=`
        # *   `<=`
        # *   `=`
        # *   `=`
        self.comparison_operator = comparison_operator
        # The alert contact group.
        self.contact_groups = contact_groups
        # Indicates whether the alert rule is enabled. Valid values:
        # 
        # *   true: The alert rule is enabled.
        # *   false: The alert rule is disabled.
        self.enable = enable
        # The end of the time period during which the alert rule is effective.
        # 
        # Unit: hours. For example, the value 23 indicates `23:59:59`.
        self.end_time = end_time
        # The consecutive number of times for which the metric value meets the alert condition before an alert is triggered.
        self.evaluation_count = evaluation_count
        # The metric name.
        self.metric_name = metric_name
        # The namespace of the cloud service.
        self.namespace = namespace
        # The aggregation period of monitoring data.
        # 
        # Unit: seconds.
        self.period = period
        # The ID of the alert rule.
        self.rule_id = rule_id
        # The name of the alert rule.
        self.rule_name = rule_name
        # The mute period during which new alerts are not sent even if the trigger conditions are met.
        # 
        # Unit: seconds.
        self.silence_time = silence_time
        # The beginning of the time period during which the alert rule is effective.
        # 
        # Unit: hours. For example, the value 00 indicates `00:00:00`.
        self.start_time = start_time
        # Indicates whether the alert rule is enabled.
        self.state = state
        # The statistical method.
        self.statistics = statistics
        # The alert threshold.
        self.threshold = threshold
        # The callback URL.
        self.webhook = webhook

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.period is not None:
            result['Period'] = self.period
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.state is not None:
            result['State'] = self.state
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('ContactGroups') is not None:
            self.contact_groups = m.get('ContactGroups')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class DescribeActiveMetricRuleListResponseBodyDatapoints(TeaModel):
    def __init__(
        self,
        alarm: List[DescribeActiveMetricRuleListResponseBodyDatapointsAlarm] = None,
    ):
        self.alarm = alarm

    def validate(self):
        if self.alarm:
            for k in self.alarm:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Alarm'] = []
        if self.alarm is not None:
            for k in self.alarm:
                result['Alarm'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alarm = []
        if m.get('Alarm') is not None:
            for k in m.get('Alarm'):
                temp_model = DescribeActiveMetricRuleListResponseBodyDatapointsAlarm()
                self.alarm.append(temp_model.from_map(k))
        return self


class DescribeActiveMetricRuleListResponseBody(TeaModel):
    def __init__(
        self,
        alert_list: DescribeActiveMetricRuleListResponseBodyAlertList = None,
        code: str = None,
        datapoints: DescribeActiveMetricRuleListResponseBodyDatapoints = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The details of the alert rules. The result is in the same structure as that returned by the DescribeMetricRuleList operation.
        self.alert_list = alert_list
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The details of the alert rules.
        self.datapoints = datapoints
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        if self.alert_list:
            self.alert_list.validate()
        if self.datapoints:
            self.datapoints.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_list is not None:
            result['AlertList'] = self.alert_list.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertList') is not None:
            temp_model = DescribeActiveMetricRuleListResponseBodyAlertList()
            self.alert_list = temp_model.from_map(m['AlertList'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            temp_model = DescribeActiveMetricRuleListResponseBodyDatapoints()
            self.datapoints = temp_model.from_map(m['Datapoints'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeActiveMetricRuleListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeActiveMetricRuleListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeActiveMetricRuleListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlertHistoryListRequest(TeaModel):
    def __init__(
        self,
        ascending: bool = None,
        end_time: str = None,
        group_id: str = None,
        metric_name: str = None,
        namespace: str = None,
        page: int = None,
        page_size: int = None,
        region_id: str = None,
        rule_id: str = None,
        rule_name: str = None,
        start_time: str = None,
        state: str = None,
        status: str = None,
    ):
        # The order of alerts. Valid values:
        # 
        # *   true (default value): reverse chronological order
        # *   false: chronological order
        self.ascending = ascending
        # The end timestamp of the historical alerts that you want to query.
        # 
        # Unit: milliseconds.
        self.end_time = end_time
        # The ID of the application group.
        # 
        # For information about how to obtain the ID of an application group, see [DescribeMonitorGroups](https://help.aliyun.com/document_detail/115032.html).
        self.group_id = group_id
        # The metric that is used to monitor the cloud service.
        # 
        # For information about how to query the name of a metric, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.metric_name = metric_name
        # The namespace of the cloud service.
        # 
        # For information about how to query the namespace of a cloud service, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.namespace = namespace
        # The number of the page to return.
        # 
        # Default value: 1.
        self.page = page
        # The number of entries to return on each page.
        # 
        # Default value: 10.
        self.page_size = page_size
        self.region_id = region_id
        # The ID of the alert rule.
        # 
        # For information about how to obtain the ID of an alert rule, see [DescribeMetricRuleList](https://help.aliyun.com/document_detail/114941.html).
        self.rule_id = rule_id
        # The name of the alert rule.
        # 
        # For information about how to query the name of an alert rule, see [DescribeMetricRuleList](https://help.aliyun.com/document_detail/114941.html).
        self.rule_name = rule_name
        # The start timestamp of the historical alerts that you want to query.
        # 
        # Unit: milliseconds.
        self.start_time = start_time
        # The status of the alert. Valid values:
        # 
        # *   ALARM (default value): Alerts are triggered.
        # *   OK: No alerts are triggered.
        self.state = state
        # Specifies whether alerts are muted. Valid values:
        # 
        # *   2 (default value): Alerts are muted and are not triggered within the mute period, even if the condition specified in the alert rule is met.
        # *   0: Alerts are triggered or cleared.
        # *   1: The alert rule is ineffective.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ascending is not None:
            result['Ascending'] = self.ascending
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.state is not None:
            result['State'] = self.state
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ascending') is not None:
            self.ascending = m.get('Ascending')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactALIIMs(TeaModel):
    def __init__(
        self,
        contact_aliim: List[str] = None,
    ):
        self.contact_aliim = contact_aliim

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_aliim is not None:
            result['ContactALIIM'] = self.contact_aliim
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactALIIM') is not None:
            self.contact_aliim = m.get('ContactALIIM')
        return self


class DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactGroups(TeaModel):
    def __init__(
        self,
        contact_group: List[str] = None,
    ):
        self.contact_group = contact_group

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group is not None:
            result['ContactGroup'] = self.contact_group
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroup') is not None:
            self.contact_group = m.get('ContactGroup')
        return self


class DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactMails(TeaModel):
    def __init__(
        self,
        contact_mail: List[str] = None,
    ):
        self.contact_mail = contact_mail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_mail is not None:
            result['ContactMail'] = self.contact_mail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactMail') is not None:
            self.contact_mail = m.get('ContactMail')
        return self


class DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactSmses(TeaModel):
    def __init__(
        self,
        contact_sms: List[str] = None,
    ):
        self.contact_sms = contact_sms

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_sms is not None:
            result['ContactSms'] = self.contact_sms
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactSms') is not None:
            self.contact_sms = m.get('ContactSms')
        return self


class DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContacts(TeaModel):
    def __init__(
        self,
        contact: List[str] = None,
    ):
        self.contact = contact

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact is not None:
            result['Contact'] = self.contact
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Contact') is not None:
            self.contact = m.get('Contact')
        return self


class DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistory(TeaModel):
    def __init__(
        self,
        alert_time: int = None,
        contact_aliims: DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactALIIMs = None,
        contact_groups: DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactGroups = None,
        contact_mails: DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactMails = None,
        contact_smses: DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactSmses = None,
        contacts: DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContacts = None,
        dimensions: str = None,
        evaluation_count: int = None,
        expression: str = None,
        group_id: str = None,
        instance_name: str = None,
        last_time: int = None,
        level: str = None,
        metric_name: str = None,
        namespace: str = None,
        rule_id: str = None,
        rule_name: str = None,
        state: str = None,
        status: int = None,
        value: str = None,
        webhooks: str = None,
    ):
        # The timestamp when the alert was triggered. Unit: milliseconds.
        self.alert_time = alert_time
        # The TradeManager IDs of the alert contacts.
        # 
        # > This parameter is valid only on the China site (aliyun.com).
        self.contact_aliims = contact_aliims
        # The alert contact groups.
        self.contact_groups = contact_groups
        # The email addresses of the alert contacts.
        self.contact_mails = contact_mails
        # The mobile numbers of the alert contacts.
        # 
        # > This parameter is valid only on the China site (aliyun.com).
        self.contact_smses = contact_smses
        # The alert contacts that receive alert notifications.
        self.contacts = contacts
        # The resources that are monitored.
        self.dimensions = dimensions
        # The consecutive number of times for which the metric value meets the alert condition before an alert is triggered.
        self.evaluation_count = evaluation_count
        # The expression that is used to trigger alerts.
        self.expression = expression
        # The ID of the application group.
        self.group_id = group_id
        # The instance name.
        self.instance_name = instance_name
        # The duration of the alert. Unit: milliseconds.
        self.last_time = last_time
        # The severity level and notification methods of the alert. Valid values:
        # 
        # *   P4: Alert notifications are sent by using emails and DingTalk chatbots.
        # *   OK: No alert is generated.
        self.level = level
        # The metric name.
        self.metric_name = metric_name
        # The namespace of the cloud service.
        self.namespace = namespace
        # The ID of the alert rule.
        self.rule_id = rule_id
        # The name of the alert rule.
        self.rule_name = rule_name
        # The alert status. Valid values:
        # 
        # *   ALARM: Alerts are triggered.
        # *   OK: No alerts are triggered.
        self.state = state
        # Indicates whether alerts are muted. Valid values:
        # 
        # *   2 (default): Alerts are muted and are not triggered within the mute period, even if the condition specified in the alert rule is met.
        # *   0: Alerts are triggered or cleared.
        # *   1: The alert rule is ineffective.
        self.status = status
        # The threshold of the metric value to trigger or clear an alert.
        self.value = value
        # The callback URL.
        self.webhooks = webhooks

    def validate(self):
        if self.contact_aliims:
            self.contact_aliims.validate()
        if self.contact_groups:
            self.contact_groups.validate()
        if self.contact_mails:
            self.contact_mails.validate()
        if self.contact_smses:
            self.contact_smses.validate()
        if self.contacts:
            self.contacts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_time is not None:
            result['AlertTime'] = self.alert_time
        if self.contact_aliims is not None:
            result['ContactALIIMs'] = self.contact_aliims.to_map()
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups.to_map()
        if self.contact_mails is not None:
            result['ContactMails'] = self.contact_mails.to_map()
        if self.contact_smses is not None:
            result['ContactSmses'] = self.contact_smses.to_map()
        if self.contacts is not None:
            result['Contacts'] = self.contacts.to_map()
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.last_time is not None:
            result['LastTime'] = self.last_time
        if self.level is not None:
            result['Level'] = self.level
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.state is not None:
            result['State'] = self.state
        if self.status is not None:
            result['Status'] = self.status
        if self.value is not None:
            result['Value'] = self.value
        if self.webhooks is not None:
            result['Webhooks'] = self.webhooks
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertTime') is not None:
            self.alert_time = m.get('AlertTime')
        if m.get('ContactALIIMs') is not None:
            temp_model = DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactALIIMs()
            self.contact_aliims = temp_model.from_map(m['ContactALIIMs'])
        if m.get('ContactGroups') is not None:
            temp_model = DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactGroups()
            self.contact_groups = temp_model.from_map(m['ContactGroups'])
        if m.get('ContactMails') is not None:
            temp_model = DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactMails()
            self.contact_mails = temp_model.from_map(m['ContactMails'])
        if m.get('ContactSmses') is not None:
            temp_model = DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactSmses()
            self.contact_smses = temp_model.from_map(m['ContactSmses'])
        if m.get('Contacts') is not None:
            temp_model = DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContacts()
            self.contacts = temp_model.from_map(m['Contacts'])
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Webhooks') is not None:
            self.webhooks = m.get('Webhooks')
        return self


class DescribeAlertHistoryListResponseBodyAlarmHistoryList(TeaModel):
    def __init__(
        self,
        alarm_history: List[DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistory] = None,
    ):
        self.alarm_history = alarm_history

    def validate(self):
        if self.alarm_history:
            for k in self.alarm_history:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlarmHistory'] = []
        if self.alarm_history is not None:
            for k in self.alarm_history:
                result['AlarmHistory'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alarm_history = []
        if m.get('AlarmHistory') is not None:
            for k in m.get('AlarmHistory'):
                temp_model = DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistory()
                self.alarm_history.append(temp_model.from_map(k))
        return self


class DescribeAlertHistoryListResponseBody(TeaModel):
    def __init__(
        self,
        alarm_history_list: DescribeAlertHistoryListResponseBodyAlarmHistoryList = None,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        total: str = None,
    ):
        # The details of historical alerts.
        self.alarm_history_list = alarm_history_list
        # The status code.
        # 
        # > The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.alarm_history_list:
            self.alarm_history_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_history_list is not None:
            result['AlarmHistoryList'] = self.alarm_history_list.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmHistoryList') is not None:
            temp_model = DescribeAlertHistoryListResponseBodyAlarmHistoryList()
            self.alarm_history_list = temp_model.from_map(m['AlarmHistoryList'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeAlertHistoryListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAlertHistoryListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlertHistoryListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlertLogCountRequest(TeaModel):
    def __init__(
        self,
        contact_group: str = None,
        end_time: int = None,
        event_type: str = None,
        group_by: str = None,
        group_id: str = None,
        last_min: str = None,
        level: str = None,
        metric_name: str = None,
        namespace: str = None,
        page_number: int = None,
        page_size: int = None,
        product: str = None,
        region_id: str = None,
        rule_id: str = None,
        rule_name: str = None,
        search_key: str = None,
        send_status: str = None,
        source_type: str = None,
        start_time: int = None,
    ):
        # The alert group.
        self.contact_group = contact_group
        # The end timestamp of the alert logs to be queried.
        # 
        # Unit: milliseconds.
        # 
        # You can query only the alert logs within the last year. If the query time is longer than one year, the return value of the `AlertLogCount` parameter is empty.
        # 
        # >  The interval between the start time (StartTime) and end time (EndTime) must be less than or equal to 15 days. The start time and end time must be specified or left empty at the same time. If you do not specify the start time and end time, the alert logs within the last 15 minutes are queried by default.
        self.end_time = end_time
        # The type of the alert event. Valid values:
        # 
        # *   TRIGGERED: The alert is triggered.
        # *   RESOLVED: The alert is resolved.
        self.event_type = event_type
        # The dimension based on which data is aggregated. This parameter is similar to the Group By clause of SQL statements. Valid values:
        # 
        # *   `product`: aggregates data by cloud service.
        # *   `level`: aggregates data by alert level.
        # *   `groupId`: aggregates data by application group.
        # *   `contactGroup`: aggregates data by alert group.
        # *   `product,metricName`: aggregates data both by cloud service and by metric.
        # 
        # This parameter is required.
        self.group_by = group_by
        # The ID of the application group.
        self.group_id = group_id
        # The statistical period of alert logs. Unit: minutes.
        self.last_min = last_min
        # The level and notification method of the alert. Valid values:
        # 
        # *   P4: Alert notifications are sent by using emails and DingTalk chatbots.
        # *   OK: No alert is generated.
        self.level = level
        # The name of the metric.
        # 
        # >  For more information about the metrics of different cloud services, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.metric_name = metric_name
        # The namespace of the cloud service.
        # 
        # >  For more information about the namespaces of cloud services, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.namespace = namespace
        # The dimension based on which data is aggregated. This parameter is equivalent to the GROUP BY clause in SQL. Valid values:
        # 
        # *   `product`: aggregates data by cloud service.
        # *   `level`: aggregates data by alert level.
        # *   `groupId`: aggregates data by application group.
        # *   `contactGroup`: aggregates data by alert contact group.
        # *   `product,metricName`: aggregates data both by cloud service and by metric.
        self.page_number = page_number
        # The number of entries to return on each page. Default value: 10.
        self.page_size = page_size
        # The abbreviation of the service name.
        self.product = product
        self.region_id = region_id
        # The ID of the alert rule.
        # 
        # For more information about how to obtain the ID of an alert rule, see [DescribeMetricRuleList](https://help.aliyun.com/document_detail/114941.html).
        self.rule_id = rule_id
        # The name of the alert rule.
        self.rule_name = rule_name
        # The keyword based on which the alert logs to be counted are searched.
        self.search_key = search_key
        # The status of the alert. Valid values:
        # 
        # *   0: The alert is triggered or cleared.
        # *   1: The alert is generated not during the effective period.
        # *   2: The alert is muted and not triggered in a specified period.
        # *   3: The host is restarting.
        # *   4: Notifications are not sent for the alert.
        # 
        # When the value of the SendStatus parameter is 0, the value P4 of the Level parameter indicates a triggered alert and the value OK indicates a cleared alert.
        self.send_status = send_status
        # This parameter is deprecated.
        self.source_type = source_type
        # The start timestamp of the alert logs to be queried.
        # 
        # Unit: milliseconds.
        # 
        # You can query only the alert logs within the last year. If the query time is longer than one year, the return value of the `AlertLogCount` parameter is empty.
        # 
        # >  The interval between the start time (StartTime) and end time (EndTime) must be less than or equal to 15 days. The start time and end time must be specified or left empty at the same time. If you do not specify the start time and end time, the alert logs within the last 15 minutes are queried by default.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group is not None:
            result['ContactGroup'] = self.contact_group
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.group_by is not None:
            result['GroupBy'] = self.group_by
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.last_min is not None:
            result['LastMin'] = self.last_min
        if self.level is not None:
            result['Level'] = self.level
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.search_key is not None:
            result['SearchKey'] = self.search_key
        if self.send_status is not None:
            result['SendStatus'] = self.send_status
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroup') is not None:
            self.contact_group = m.get('ContactGroup')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('GroupBy') is not None:
            self.group_by = m.get('GroupBy')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('LastMin') is not None:
            self.last_min = m.get('LastMin')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SearchKey') is not None:
            self.search_key = m.get('SearchKey')
        if m.get('SendStatus') is not None:
            self.send_status = m.get('SendStatus')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeAlertLogCountResponseBodyAlertLogCountLogs(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # The name of the dimension field based on which alert logs are aggregated.
        self.name = name
        # The value of the dimension field based on which alert logs are aggregated.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAlertLogCountResponseBodyAlertLogCount(TeaModel):
    def __init__(
        self,
        count: int = None,
        logs: List[DescribeAlertLogCountResponseBodyAlertLogCountLogs] = None,
    ):
        # The number of alert logs.
        self.count = count
        # The details about alert logs.
        self.logs = logs

    def validate(self):
        if self.logs:
            for k in self.logs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        result['Logs'] = []
        if self.logs is not None:
            for k in self.logs:
                result['Logs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.logs = []
        if m.get('Logs') is not None:
            for k in m.get('Logs'):
                temp_model = DescribeAlertLogCountResponseBodyAlertLogCountLogs()
                self.logs.append(temp_model.from_map(k))
        return self


class DescribeAlertLogCountResponseBody(TeaModel):
    def __init__(
        self,
        alert_log_count: List[DescribeAlertLogCountResponseBodyAlertLogCount] = None,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The statistics of alert logs.
        self.alert_log_count = alert_log_count
        # The HTTP status code.
        # 
        # > The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        if self.alert_log_count:
            for k in self.alert_log_count:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertLogCount'] = []
        if self.alert_log_count is not None:
            for k in self.alert_log_count:
                result['AlertLogCount'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert_log_count = []
        if m.get('AlertLogCount') is not None:
            for k in m.get('AlertLogCount'):
                temp_model = DescribeAlertLogCountResponseBodyAlertLogCount()
                self.alert_log_count.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeAlertLogCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAlertLogCountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlertLogCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlertLogHistogramRequest(TeaModel):
    def __init__(
        self,
        contact_group: str = None,
        end_time: int = None,
        event_type: str = None,
        group_by: str = None,
        group_id: str = None,
        last_min: str = None,
        level: str = None,
        metric_name: str = None,
        namespace: str = None,
        page_number: int = None,
        page_size: int = None,
        product: str = None,
        region_id: str = None,
        rule_id: str = None,
        rule_name: str = None,
        search_key: str = None,
        send_status: str = None,
        source_type: str = None,
        start_time: int = None,
    ):
        # The alert contact group.
        self.contact_group = contact_group
        # The end timestamp of the alert logs to be queried.
        # 
        # Unit: milliseconds.
        # 
        # > 
        # 
        # *   You can query only the alert logs within the last year.
        # 
        # *   The interval between the start time (`StartTime`) and end time (`EndTime`) must be less than or equal to 15 days.
        self.end_time = end_time
        # The type of the alert event. Valid values:
        # 
        # *   TRIGGERED: The alert is triggered.
        # *   RESOLVED: The alert is resolved.
        self.event_type = event_type
        # The dimensions based on which data is aggregated. This parameter is equivalent to the GROUP BY clause in SQL. Valid values:
        # 
        # *   `product`: aggregates data by cloud service.
        # *   `level`: aggregates data by alert level.
        # *   `groupId`: aggregates data by application group.
        # *   `contactGroup`: aggregates data by alert contact group.
        # *   `product,metricName`: aggregates data both by cloud service and by metric.
        self.group_by = group_by
        # The ID of the application group.
        self.group_id = group_id
        # The statistical period of alert logs. Unit: minutes.
        self.last_min = last_min
        # The severity level and notification methods of the alert. Valid values:
        # 
        # *   P4: Alert notifications are sent by using emails and DingTalk chatbots.
        # *   OK: No alert is generated.
        self.level = level
        # The metric name.
        # 
        # >  For more information about the metrics of different cloud services, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.metric_name = metric_name
        # The namespace of the Alibaba Cloud service.
        # 
        # >  For more information about the namespaces of different cloud services, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.namespace = namespace
        # The page number.
        # 
        # Default value: 1.
        self.page_number = page_number
        # The number of entries per page.
        # 
        # Default value: 10.
        self.page_size = page_size
        # The abbreviation of the Alibaba Cloud service name.
        self.product = product
        self.region_id = region_id
        # The ID of the alert rule.
        # 
        # For more information about how to obtain the ID of an alert rule, see [DescribeMetricRuleList](https://help.aliyun.com/document_detail/114941.html).
        self.rule_id = rule_id
        # The name of the alert rule.
        self.rule_name = rule_name
        # The keyword that is used to query alert logs.
        self.search_key = search_key
        # The alert status. Valid values:
        # 
        # *   0: The alert is triggered or cleared.
        # *   1: The alert is ineffective.
        # *   2: The alert is muted and not triggered in a specified period.
        # *   3: The host is restarting.
        # *   4: No alert notification is sent.
        # 
        # If the value of the SendStatus parameter is 0, the value P4 of the Level parameter indicates a triggered alert and the value OK indicates a cleared alert.
        self.send_status = send_status
        # This parameter is deprecated.
        self.source_type = source_type
        # The start timestamp of the alert logs to be queried.
        # 
        # Unit: milliseconds.
        # 
        # > 
        # 
        # *   You can query only the alert logs within the last year.
        # 
        # *   The interval between the start time (`StartTime`) and end time (`EndTime`) must be less than or equal to 15 days.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group is not None:
            result['ContactGroup'] = self.contact_group
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.group_by is not None:
            result['GroupBy'] = self.group_by
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.last_min is not None:
            result['LastMin'] = self.last_min
        if self.level is not None:
            result['Level'] = self.level
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.search_key is not None:
            result['SearchKey'] = self.search_key
        if self.send_status is not None:
            result['SendStatus'] = self.send_status
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroup') is not None:
            self.contact_group = m.get('ContactGroup')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('GroupBy') is not None:
            self.group_by = m.get('GroupBy')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('LastMin') is not None:
            self.last_min = m.get('LastMin')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SearchKey') is not None:
            self.search_key = m.get('SearchKey')
        if m.get('SendStatus') is not None:
            self.send_status = m.get('SendStatus')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeAlertLogHistogramResponseBodyAlertLogHistogramList(TeaModel):
    def __init__(
        self,
        count: int = None,
        from_: int = None,
        to: int = None,
    ):
        # The number of alert logs.
        self.count = count
        # The start timestamp of the queried alert logs.
        # 
        # Unit: seconds.
        self.from_ = from_
        # The end timestamp of the queried alert logs.
        # 
        # Unit: seconds.
        self.to = to

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.from_ is not None:
            result['From'] = self.from_
        if self.to is not None:
            result['To'] = self.to
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('To') is not None:
            self.to = m.get('To')
        return self


class DescribeAlertLogHistogramResponseBody(TeaModel):
    def __init__(
        self,
        alert_log_histogram_list: List[DescribeAlertLogHistogramResponseBodyAlertLogHistogramList] = None,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The number of alert logs that were generated during each interval of a time period.
        self.alert_log_histogram_list = alert_log_histogram_list
        # The response code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        if self.alert_log_histogram_list:
            for k in self.alert_log_histogram_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertLogHistogramList'] = []
        if self.alert_log_histogram_list is not None:
            for k in self.alert_log_histogram_list:
                result['AlertLogHistogramList'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert_log_histogram_list = []
        if m.get('AlertLogHistogramList') is not None:
            for k in m.get('AlertLogHistogramList'):
                temp_model = DescribeAlertLogHistogramResponseBodyAlertLogHistogramList()
                self.alert_log_histogram_list.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeAlertLogHistogramResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAlertLogHistogramResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlertLogHistogramResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlertLogListRequest(TeaModel):
    def __init__(
        self,
        contact_group: str = None,
        end_time: int = None,
        event_type: str = None,
        group_by: str = None,
        group_id: str = None,
        last_min: str = None,
        level: str = None,
        metric_name: str = None,
        namespace: str = None,
        page_number: int = None,
        page_size: int = None,
        product: str = None,
        region_id: str = None,
        rule_id: str = None,
        rule_name: str = None,
        search_key: str = None,
        send_status: str = None,
        source_type: str = None,
        start_time: int = None,
    ):
        # The alert contact group.
        self.contact_group = contact_group
        # The end timestamp of the alert logs to be queried.
        # 
        # Unit: milliseconds.
        # 
        # You can query only the alert logs within the last year. If the query time is longer than one year, the return value of the `AlertLogList` parameter is empty.
        # 
        # >  The time period between the start time specified by `StartTime` and end time specified by `EndTime` must be less than or equal to 15 days. You must specify StartTime and EndTime at the same time, or leave StartTime and EndTime empty at the same time. If you do not specify this parameter, the alert logs within the last 15 minutes are queried by default.
        self.end_time = end_time
        # The type of the alert event. Valid values:
        # 
        # *   TRIGGERED: The alert is triggered.
        # *   RESOLVED: The alert is resolved.
        self.event_type = event_type
        # The dimensions based on which data is aggregated. This parameter is equivalent to the GROUP BY clause in SQL. Valid values:
        # 
        # *   `product`: aggregates data by cloud service.
        # *   `level`: aggregates data by alert level.
        # *   `groupId`: aggregates data by application group.
        # *   `contactGroup`: aggregates data by alert contact group.
        # *   `product,metricName`: aggregates data both by cloud service and by metric.
        self.group_by = group_by
        # The ID of the application group.
        self.group_id = group_id
        # The statistical period of alert logs. Unit: minutes.
        self.last_min = last_min
        # The severity level and notification methods of the alert. Valid values:
        # 
        # *   P4: Alert notifications are sent by using emails and DingTalk chatbots.
        # *   OK: No alert is generated.
        self.level = level
        # The metric name.
        # 
        # > For more information about the metrics of different cloud services, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.metric_name = metric_name
        # The namespace of the cloud service.
        # 
        # >  For information about how to query the namespace of a cloud service, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.namespace = namespace
        # The page number.
        # 
        # Default value: 1.
        self.page_number = page_number
        # The number of entries per page.
        # 
        # Default value: 10.
        self.page_size = page_size
        # The abbreviation of the service name.
        # 
        # For information about how to obtain the abbreviation of a cloud service name, see [DescribeProductsOfActiveMetricRule](https://help.aliyun.com/document_detail/114930.html).
        self.product = product
        self.region_id = region_id
        # The ID of the alert rule.
        # 
        # For information about how to obtain the ID of an alert rule, see [DescribeMetricRuleList](https://help.aliyun.com/document_detail/114941.html).
        self.rule_id = rule_id
        # The name of the alert rule.
        self.rule_name = rule_name
        # The search keyword that is used to query alert logs.
        self.search_key = search_key
        # The status of the alert. Valid values:
        # 
        # *   0: The alert is triggered or cleared.
        # *   1: The alert is ineffective.
        # *   2: The alert is muted.
        # *   3: The host is restarting.
        # *   4: No alert notification is sent.
        # 
        # If the value of the SendStatus parameter is 0, the value P4 of the Level parameter indicates a triggered alert and the value OK indicates a cleared alert.
        self.send_status = send_status
        # The type of the alert rule. Valid value: METRIC. This value indicates an alert rule for time series metrics.
        self.source_type = source_type
        # The start timestamp of the alert logs to be queried.
        # 
        # Unit: milliseconds.
        # 
        # You can query only the alert logs within the last year. If the query time is longer than one year, the return value of the `AlertLogList` parameter is empty.
        # 
        # >  The time period between the start time specified by `StartTime` and the end time specified by `EndTime` must be less than or equal to 15 days. You must specify StartTime and EndTime at the same time, or leave StartTime and EndTime empty at the same time. If you do not specify this parameter, the alert logs within the last 15 minutes are queried by default.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group is not None:
            result['ContactGroup'] = self.contact_group
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.group_by is not None:
            result['GroupBy'] = self.group_by
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.last_min is not None:
            result['LastMin'] = self.last_min
        if self.level is not None:
            result['Level'] = self.level
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.search_key is not None:
            result['SearchKey'] = self.search_key
        if self.send_status is not None:
            result['SendStatus'] = self.send_status
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroup') is not None:
            self.contact_group = m.get('ContactGroup')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('GroupBy') is not None:
            self.group_by = m.get('GroupBy')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('LastMin') is not None:
            self.last_min = m.get('LastMin')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SearchKey') is not None:
            self.search_key = m.get('SearchKey')
        if m.get('SendStatus') is not None:
            self.send_status = m.get('SendStatus')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeAlertLogListResponseBodyAlertLogListDimensions(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of the dimension.
        self.key = key
        # The value of the dimension.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAlertLogListResponseBodyAlertLogListEscalation(TeaModel):
    def __init__(
        self,
        expression: str = None,
        level: str = None,
        times: int = None,
    ):
        # The description of the alert rule.
        # 
        # >  The content of the alert rule. This parameter indicates the conditions that trigger an alert.
        self.expression = expression
        # The alert level and the methods that are used to send alert notifications. Valid values:
        # 
        # *   P4: Alert notifications are sent by using emails and DingTalk chatbots.
        # *   OK: No alert is generated.
        self.level = level
        # The consecutive number of times for which the metric value meets the alert condition before an alert is triggered.
        self.times = times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.level is not None:
            result['Level'] = self.level
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeAlertLogListResponseBodyAlertLogListExtendedInfo(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # The name of the extended field.
        self.name = name
        # The value of the extended field.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAlertLogListResponseBodyAlertLogListSendDetailChannelResultListResultList(TeaModel):
    def __init__(
        self,
        code: str = None,
        detail: str = None,
        request_id: str = None,
        success: bool = None,
        notify_target_list: List[str] = None,
    ):
        # The HTTP status code.
        # 
        # *   If the value of the `Channel` parameter is `WEBHOOK`, the status code is 200 or 500.
        # *   If the value of the `Channel` parameter is `MAIL`, `SMS`, `SLS`, `ONCALL`, `FC`, or `MNS`, this parameter is empty or not returned.
        self.code = code
        # The details of the returned results.
        self.detail = detail
        # The request ID returned when CloudMonitor calls another cloud service.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success
        self.notify_target_list = notify_target_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.notify_target_list is not None:
            result['notifyTargetList'] = self.notify_target_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('notifyTargetList') is not None:
            self.notify_target_list = m.get('notifyTargetList')
        return self


class DescribeAlertLogListResponseBodyAlertLogListSendDetailChannelResultList(TeaModel):
    def __init__(
        self,
        channel: str = None,
        result_list: List[DescribeAlertLogListResponseBodyAlertLogListSendDetailChannelResultListResultList] = None,
    ):
        # The method that is used to send alert notifications. Valid values:
        # 
        # *   MAIL: email
        # *   SMS: text message
        # *   WEBHOOK: alert callback
        # *   SLS: Simple Log Service
        # *   ONCALL: phone call
        # *   FC: Function Compute
        # *   MNS: Message Service queue
        self.channel = channel
        # The sending results of alert notifications.
        self.result_list = result_list

    def validate(self):
        if self.result_list:
            for k in self.result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel is not None:
            result['Channel'] = self.channel
        result['ResultList'] = []
        if self.result_list is not None:
            for k in self.result_list:
                result['ResultList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Channel') is not None:
            self.channel = m.get('Channel')
        self.result_list = []
        if m.get('ResultList') is not None:
            for k in m.get('ResultList'):
                temp_model = DescribeAlertLogListResponseBodyAlertLogListSendDetailChannelResultListResultList()
                self.result_list.append(temp_model.from_map(k))
        return self


class DescribeAlertLogListResponseBodyAlertLogListSendDetail(TeaModel):
    def __init__(
        self,
        channel_result_list: List[DescribeAlertLogListResponseBodyAlertLogListSendDetailChannelResultList] = None,
        result_code: str = None,
    ):
        # The list of sending results that are categorized by notification method.
        self.channel_result_list = channel_result_list
        # Indicates whether the alert notifications are sent.
        # 
        # *   If the alert notifications are sent, the value "success" is returned.
        # *   If the configuration is invalid, no alert notification is sent and an error code is returned.
        self.result_code = result_code

    def validate(self):
        if self.channel_result_list:
            for k in self.channel_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ChannelResultList'] = []
        if self.channel_result_list is not None:
            for k in self.channel_result_list:
                result['ChannelResultList'].append(k.to_map() if k else None)
        if self.result_code is not None:
            result['ResultCode'] = self.result_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.channel_result_list = []
        if m.get('ChannelResultList') is not None:
            for k in m.get('ChannelResultList'):
                temp_model = DescribeAlertLogListResponseBodyAlertLogListSendDetailChannelResultList()
                self.channel_result_list.append(temp_model.from_map(k))
        if m.get('ResultCode') is not None:
            self.result_code = m.get('ResultCode')
        return self


class DescribeAlertLogListResponseBodyAlertLogListSendResultList(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: List[str] = None,
    ):
        # The category of the alert notification method. Valid values:
        # 
        # *   MAIL: email
        # *   ALIIM: TradeManager
        # *   SMS: text message
        # *   CALL: phone call
        # *   DING: DingTalk chatbot
        # *   Merged: alert merging
        self.key = key
        # The notification object corresponding to the alert notification method.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAlertLogListResponseBodyAlertLogListWebhookList(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        url: str = None,
    ):
        # The status code of the alert callback.
        self.code = code
        # The message returned for the alert callback.
        self.message = message
        # The callback URL.
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.url is not None:
            result['url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('url') is not None:
            self.url = m.get('url')
        return self


class DescribeAlertLogListResponseBodyAlertLogList(TeaModel):
    def __init__(
        self,
        alert_time: str = None,
        black_list_detail: str = None,
        black_list_name: str = None,
        black_list_uuid: str = None,
        contact_aliiwwlist: List[str] = None,
        contact_ding_list: List[str] = None,
        contact_groups: List[str] = None,
        contact_mail_list: List[str] = None,
        contact_on_call_list: List[str] = None,
        contact_smslist: List[str] = None,
        dimensions: List[DescribeAlertLogListResponseBodyAlertLogListDimensions] = None,
        dingding_webhook_list: List[str] = None,
        escalation: DescribeAlertLogListResponseBodyAlertLogListEscalation = None,
        event_name: str = None,
        extended_info: List[DescribeAlertLogListResponseBodyAlertLogListExtendedInfo] = None,
        group_id: str = None,
        group_name: str = None,
        instance_id: str = None,
        instance_name: str = None,
        level: str = None,
        level_change: str = None,
        log_id: str = None,
        message: str = None,
        metric_name: str = None,
        namespace: str = None,
        product: str = None,
        rule_id: str = None,
        rule_name: str = None,
        send_detail: DescribeAlertLogListResponseBodyAlertLogListSendDetail = None,
        send_result_list: List[DescribeAlertLogListResponseBodyAlertLogListSendResultList] = None,
        send_status: str = None,
        webhook_list: List[DescribeAlertLogListResponseBodyAlertLogListWebhookList] = None,
    ):
        # The timestamp that was generated when the alert was triggered.
        # 
        # Unit: milliseconds.
        self.alert_time = alert_time
        # The details of the blacklist policy.
        self.black_list_detail = black_list_detail
        # The name of the blacklist policy.
        self.black_list_name = black_list_name
        # The ID of the blacklist policy.
        self.black_list_uuid = black_list_uuid
        self.contact_aliiwwlist = contact_aliiwwlist
        self.contact_ding_list = contact_ding_list
        self.contact_groups = contact_groups
        self.contact_mail_list = contact_mail_list
        self.contact_on_call_list = contact_on_call_list
        self.contact_smslist = contact_smslist
        # The dimensions of the resource that triggered alerts.
        self.dimensions = dimensions
        self.dingding_webhook_list = dingding_webhook_list
        # The alert rule based on which the alert is triggered.
        self.escalation = escalation
        # The event name.
        self.event_name = event_name
        # The extended fields.
        self.extended_info = extended_info
        # The ID of the application group.
        self.group_id = group_id
        # The name of the application group.
        self.group_name = group_name
        # The resource ID.
        self.instance_id = instance_id
        # The resource name.
        self.instance_name = instance_name
        # The alert level and the methods that are used to send alert notifications. Valid values:
        # 
        # *   P4: Alert notifications are sent by using emails and DingTalk chatbots.
        # *   OK: No alert is generated.
        self.level = level
        # Indicates whether the alert level was changed. Valid values:
        # 
        # *   `P4->OK`: The alert level was changed from P4 to OK.
        # *   `P4->P4`: The alert level was still P4.
        self.level_change = level_change
        # The log ID.
        self.log_id = log_id
        # The alert information in a JSON string.
        self.message = message
        # The metric name.
        self.metric_name = metric_name
        # The namespace of the cloud service.
        self.namespace = namespace
        # The identifier of the cloud service. Valid values:
        # 
        # *   If the cloud service is provided by Alibaba Cloud, the abbreviation of the service name is returned. Example: ECS.
        # *   If the cloud service is not provided by Alibaba Cloud, a value in the `acs_Service keyword` format is returned. Example: acs_networkmonitor.
        self.product = product
        # The ID of the alert rule.
        self.rule_id = rule_id
        # The name of the alert rule.
        self.rule_name = rule_name
        # The details about the sending results of alert notifications.
        self.send_detail = send_detail
        # The sending results of alert notifications.
        self.send_result_list = send_result_list
        # The status of the alert. Valid values:
        # 
        # *   0: The alert is triggered or cleared.
        # *   1: The alert is ineffective.
        # *   2: The alert is muted.
        # *   3: The host is restarting.
        # *   4: No alert notification is sent.
        # 
        # If the value of the SendStatus parameter is 0, the value P4 of the Level parameter indicates a triggered alert and the value OK indicates a cleared alert.
        self.send_status = send_status
        # The callback URLs.
        self.webhook_list = webhook_list

    def validate(self):
        if self.dimensions:
            for k in self.dimensions:
                if k:
                    k.validate()
        if self.escalation:
            self.escalation.validate()
        if self.extended_info:
            for k in self.extended_info:
                if k:
                    k.validate()
        if self.send_detail:
            self.send_detail.validate()
        if self.send_result_list:
            for k in self.send_result_list:
                if k:
                    k.validate()
        if self.webhook_list:
            for k in self.webhook_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_time is not None:
            result['AlertTime'] = self.alert_time
        if self.black_list_detail is not None:
            result['BlackListDetail'] = self.black_list_detail
        if self.black_list_name is not None:
            result['BlackListName'] = self.black_list_name
        if self.black_list_uuid is not None:
            result['BlackListUUID'] = self.black_list_uuid
        if self.contact_aliiwwlist is not None:
            result['ContactALIIWWList'] = self.contact_aliiwwlist
        if self.contact_ding_list is not None:
            result['ContactDingList'] = self.contact_ding_list
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups
        if self.contact_mail_list is not None:
            result['ContactMailList'] = self.contact_mail_list
        if self.contact_on_call_list is not None:
            result['ContactOnCallList'] = self.contact_on_call_list
        if self.contact_smslist is not None:
            result['ContactSMSList'] = self.contact_smslist
        result['Dimensions'] = []
        if self.dimensions is not None:
            for k in self.dimensions:
                result['Dimensions'].append(k.to_map() if k else None)
        if self.dingding_webhook_list is not None:
            result['DingdingWebhookList'] = self.dingding_webhook_list
        if self.escalation is not None:
            result['Escalation'] = self.escalation.to_map()
        if self.event_name is not None:
            result['EventName'] = self.event_name
        result['ExtendedInfo'] = []
        if self.extended_info is not None:
            for k in self.extended_info:
                result['ExtendedInfo'].append(k.to_map() if k else None)
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.level is not None:
            result['Level'] = self.level
        if self.level_change is not None:
            result['LevelChange'] = self.level_change
        if self.log_id is not None:
            result['LogId'] = self.log_id
        if self.message is not None:
            result['Message'] = self.message
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.product is not None:
            result['Product'] = self.product
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.send_detail is not None:
            result['SendDetail'] = self.send_detail.to_map()
        result['SendResultList'] = []
        if self.send_result_list is not None:
            for k in self.send_result_list:
                result['SendResultList'].append(k.to_map() if k else None)
        if self.send_status is not None:
            result['SendStatus'] = self.send_status
        result['WebhookList'] = []
        if self.webhook_list is not None:
            for k in self.webhook_list:
                result['WebhookList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertTime') is not None:
            self.alert_time = m.get('AlertTime')
        if m.get('BlackListDetail') is not None:
            self.black_list_detail = m.get('BlackListDetail')
        if m.get('BlackListName') is not None:
            self.black_list_name = m.get('BlackListName')
        if m.get('BlackListUUID') is not None:
            self.black_list_uuid = m.get('BlackListUUID')
        if m.get('ContactALIIWWList') is not None:
            self.contact_aliiwwlist = m.get('ContactALIIWWList')
        if m.get('ContactDingList') is not None:
            self.contact_ding_list = m.get('ContactDingList')
        if m.get('ContactGroups') is not None:
            self.contact_groups = m.get('ContactGroups')
        if m.get('ContactMailList') is not None:
            self.contact_mail_list = m.get('ContactMailList')
        if m.get('ContactOnCallList') is not None:
            self.contact_on_call_list = m.get('ContactOnCallList')
        if m.get('ContactSMSList') is not None:
            self.contact_smslist = m.get('ContactSMSList')
        self.dimensions = []
        if m.get('Dimensions') is not None:
            for k in m.get('Dimensions'):
                temp_model = DescribeAlertLogListResponseBodyAlertLogListDimensions()
                self.dimensions.append(temp_model.from_map(k))
        if m.get('DingdingWebhookList') is not None:
            self.dingding_webhook_list = m.get('DingdingWebhookList')
        if m.get('Escalation') is not None:
            temp_model = DescribeAlertLogListResponseBodyAlertLogListEscalation()
            self.escalation = temp_model.from_map(m['Escalation'])
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        self.extended_info = []
        if m.get('ExtendedInfo') is not None:
            for k in m.get('ExtendedInfo'):
                temp_model = DescribeAlertLogListResponseBodyAlertLogListExtendedInfo()
                self.extended_info.append(temp_model.from_map(k))
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('LevelChange') is not None:
            self.level_change = m.get('LevelChange')
        if m.get('LogId') is not None:
            self.log_id = m.get('LogId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SendDetail') is not None:
            temp_model = DescribeAlertLogListResponseBodyAlertLogListSendDetail()
            self.send_detail = temp_model.from_map(m['SendDetail'])
        self.send_result_list = []
        if m.get('SendResultList') is not None:
            for k in m.get('SendResultList'):
                temp_model = DescribeAlertLogListResponseBodyAlertLogListSendResultList()
                self.send_result_list.append(temp_model.from_map(k))
        if m.get('SendStatus') is not None:
            self.send_status = m.get('SendStatus')
        self.webhook_list = []
        if m.get('WebhookList') is not None:
            for k in m.get('WebhookList'):
                temp_model = DescribeAlertLogListResponseBodyAlertLogListWebhookList()
                self.webhook_list.append(temp_model.from_map(k))
        return self


class DescribeAlertLogListResponseBody(TeaModel):
    def __init__(
        self,
        alert_log_list: List[DescribeAlertLogListResponseBodyAlertLogList] = None,
        code: str = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The queried alert logs.
        self.alert_log_list = alert_log_list
        # The HTTP status code.
        # 
        # > The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        if self.alert_log_list:
            for k in self.alert_log_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertLogList'] = []
        if self.alert_log_list is not None:
            for k in self.alert_log_list:
                result['AlertLogList'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert_log_list = []
        if m.get('AlertLogList') is not None:
            for k in m.get('AlertLogList'):
                temp_model = DescribeAlertLogListResponseBodyAlertLogList()
                self.alert_log_list.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeAlertLogListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAlertLogListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlertLogListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlertingMetricRuleResourcesRequest(TeaModel):
    def __init__(
        self,
        alert_before_time: str = None,
        dimensions: str = None,
        group_id: str = None,
        namespace: str = None,
        page: int = None,
        page_size: int = None,
        region_id: str = None,
        rule_id: str = None,
    ):
        # Queries the alerts that were triggered before the specified time. Timestamps in milliseconds are supported.
        self.alert_before_time = alert_before_time
        # The dimensions that specify the resources whose monitoring data you want to query.
        self.dimensions = dimensions
        # The ID of the application group. For information about how to obtain the ID of an application group, see [DescribeMonitorGroups](https://help.aliyun.com/document_detail/115032.html).
        self.group_id = group_id
        # The namespace of the cloud service.
        # 
        # For more information about the namespaces of cloud services, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.namespace = namespace
        # The page number.
        # 
        # Default value: 1.
        self.page = page
        # The number of entries per page.
        # 
        # Default value: 10.
        self.page_size = page_size
        self.region_id = region_id
        # The ID of the alert rule. For information about how to obtain the ID of an alert rule, see [DescribeMetricRuleList](https://help.aliyun.com/document_detail/114941.html).
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_before_time is not None:
            result['AlertBeforeTime'] = self.alert_before_time
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertBeforeTime') is not None:
            self.alert_before_time = m.get('AlertBeforeTime')
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResourceExpressionListExpressionList(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        metric_name: str = None,
        period: str = None,
        statistics: str = None,
        threshold: str = None,
    ):
        # The operator that is used to compare the metric value with the threshold. Valid values:
        # 
        # *   GreaterThanOrEqualToThreshold: greater than or equal to the threshold
        # *   GreaterThanThreshold: greater than the threshold
        # *   LessThanOrEqualToThreshold: less than or equal to the threshold
        # *   LessThanThreshold: less than the threshold
        # *   NotEqualToThreshold: not equal to the threshold
        # *   GreaterThanYesterday: greater than the metric value at the same time yesterday
        # *   LessThanYesterday: less than the metric value at the same time yesterday
        # *   GreaterThanLastWeek: greater than the metric value at the same time last week
        # *   LessThanLastWeek: less than the metric value at the same time last week
        # *   GreaterThanLastPeriod: greater than the metric value in the last monitoring cycle
        # *   LessThanLastPeriod: less than the metric value in the last monitoring cycle
        self.comparison_operator = comparison_operator
        # The metric name.
        self.metric_name = metric_name
        # The statistical period of the metric. Unit: seconds. The default value is the interval at which the monitoring data of the metric is collected.
        self.period = period
        # The statistical method of the alert level. Valid values:
        # 
        # *   Maximum
        # *   Minimum
        # *   Average
        self.statistics = statistics
        # The alert threshold.
        self.threshold = threshold

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.period is not None:
            result['Period'] = self.period
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        return self


class DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResourceExpressionList(TeaModel):
    def __init__(
        self,
        expression_list: List[DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResourceExpressionListExpressionList] = None,
    ):
        self.expression_list = expression_list

    def validate(self):
        if self.expression_list:
            for k in self.expression_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExpressionList'] = []
        if self.expression_list is not None:
            for k in self.expression_list:
                result['ExpressionList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.expression_list = []
        if m.get('ExpressionList') is not None:
            for k in m.get('ExpressionList'):
                temp_model = DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResourceExpressionListExpressionList()
                self.expression_list.append(temp_model.from_map(k))
        return self


class DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResource(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        expression: str = None,
        expression_list: DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResourceExpressionList = None,
        expression_list_join: str = None,
        expression_raw: str = None,
        level: int = None,
        pre_condition: str = None,
        tag: str = None,
        threshold: str = None,
        times: int = None,
    ):
        # The operator that is used to compare the metric value with the threshold. Valid values:
        # 
        # *   GreaterThanOrEqualToThreshold: greater than or equal to the threshold
        # *   GreaterThanThreshold: greater than the threshold
        # *   LessThanOrEqualToThreshold: less than or equal to the threshold
        # *   LessThanThreshold: less than the threshold
        # *   NotEqualToThreshold: not equal to the threshold
        # *   GreaterThanYesterday: greater than the metric value at the same time yesterday
        # *   LessThanYesterday: less than the metric value at the same time yesterday
        # *   GreaterThanLastWeek: greater than the metric value at the same time last week
        # *   LessThanLastWeek: less than the metric value at the same time last week
        # *   GreaterThanLastPeriod: greater than the metric value in the last monitoring cycle
        # *   LessThanLastPeriod: less than the metric value in the last monitoring cycle
        self.comparison_operator = comparison_operator
        # The description of the alert rule.
        # 
        # >  This parameter indicates the content of the alert rule. If the metric value meets the alert condition, an alert is triggered.
        self.expression = expression
        # The description of the multi-metric alert rule.
        self.expression_list = expression_list
        # The relationship between multiple metrics. Valid values:
        # 
        # *   &&: If all metrics meet the alert conditions, CloudMonitor sends alert notifications.
        # *   ||: If one of the metrics meets the alert conditions, CloudMonitor sends alert notifications.
        self.expression_list_join = expression_list_join
        # The trigger conditions that are created by using expressions. You can use expressions to create trigger conditions in the following scenarios:
        # 
        # *   Set an alert blacklist for specific resources. For example, if you specify `$instanceId != \\"i-io8kfvcpp7x5****\\" ``&&`` $Average > 50`, no alert is triggered when the `average metric value` of the `i-io8kfvcpp7x5****` instance exceeds 50.
        # *   Set a special alert threshold for a specified instance in the rule. For example, if you specify `$Average > ($instanceId == \\"i-io8kfvcpp7x5****\\"? 80: 50)`, an alert is triggered when the `average metric value` of the `i-io8kfvcpp7x5****` instance exceeds 80 or the `average metric value` of other instances exceeds 50.
        # *   Limit the number of instances whose metric values exceed the threshold. For example, if you specify `count($Average > 20) > 3`, an alert is triggered only when the `average metric value` of more than three instances exceeds 20.
        self.expression_raw = expression_raw
        # The severity level and notification methods of the alert. Valid values:
        # 
        # *   4: Alert notifications are sent by using emails and DingTalk chatbots.
        # *   OK: No alert is generated.
        self.level = level
        # The operator that is used to compare the metric value with the threshold. Valid values:
        # 
        # *   `>=`
        # *   `=`
        # *   `<=`
        # *   `>`
        # *   `<`
        # *   `!=`
        self.pre_condition = pre_condition
        # This parameter is deprecated.
        self.tag = tag
        # The alert threshold.
        self.threshold = threshold
        # The consecutive number of times for which the metric value meets the alert condition before an alert is triggered.
        self.times = times

    def validate(self):
        if self.expression_list:
            self.expression_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.expression_list is not None:
            result['ExpressionList'] = self.expression_list.to_map()
        if self.expression_list_join is not None:
            result['ExpressionListJoin'] = self.expression_list_join
        if self.expression_raw is not None:
            result['ExpressionRaw'] = self.expression_raw
        if self.level is not None:
            result['Level'] = self.level
        if self.pre_condition is not None:
            result['PreCondition'] = self.pre_condition
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('ExpressionList') is not None:
            temp_model = DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResourceExpressionList()
            self.expression_list = temp_model.from_map(m['ExpressionList'])
        if m.get('ExpressionListJoin') is not None:
            self.expression_list_join = m.get('ExpressionListJoin')
        if m.get('ExpressionRaw') is not None:
            self.expression_raw = m.get('ExpressionRaw')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('PreCondition') is not None:
            self.pre_condition = m.get('PreCondition')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalation(TeaModel):
    def __init__(
        self,
        resource: List[DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResource] = None,
    ):
        self.resource = resource

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeAlertingMetricRuleResourcesResponseBodyResourcesResource(TeaModel):
    def __init__(
        self,
        dimensions: str = None,
        enable: str = None,
        escalation: DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalation = None,
        group_id: str = None,
        last_alert_time: str = None,
        last_modify_time: str = None,
        level: int = None,
        metric_name: str = None,
        metric_values: str = None,
        namespace: str = None,
        product_category: str = None,
        resource: str = None,
        retry_times: str = None,
        rule_id: str = None,
        rule_name: str = None,
        start_time: str = None,
        statistics: str = None,
        threshold: str = None,
    ):
        # The dimensions based on which the resources are queried.
        self.dimensions = dimensions
        # Indicates whether the alert rule is enabled. Valid values:
        # 
        # *   true: The alert rule is enabled.
        # *   false: The alert rule is disabled.
        self.enable = enable
        # The alert rule based on which the alert is triggered.
        self.escalation = escalation
        # The ID of the application group.
        # 
        # >  If the alert rule is associated with an application group, the ID of the application group is returned in this parameter.
        self.group_id = group_id
        # The time when the last alert was triggered for the resource based on the alert rule. The value is a timestamp.
        # 
        # Unit: milliseconds.
        self.last_alert_time = last_alert_time
        # The time when the alert rule was last modified. The value is a timestamp.
        # 
        # Unit: milliseconds.
        self.last_modify_time = last_modify_time
        # The severity level and notification methods of the alert. Valid values:
        # 
        # *   4: Alert notifications are sent by using emails and DingTalk chatbots.
        # *   OK: No alert is generated.
        self.level = level
        # The metric name.
        self.metric_name = metric_name
        # The metric value that triggered the alert based on the alert rule. The value is a JSON string.
        self.metric_values = metric_values
        # The namespace of the cloud service.
        self.namespace = namespace
        # The type of the cloud service.
        self.product_category = product_category
        # The resources that are monitored.
        self.resource = resource
        # The consecutive number of times for which the metric value meets the alert condition before an alert is triggered.
        self.retry_times = retry_times
        # The ID of the alert rule.
        self.rule_id = rule_id
        # The name of the alert rule.
        self.rule_name = rule_name
        # The time when the resource was associated with the alert rule. The value is a timestamp.
        # 
        # Unit: milliseconds.
        self.start_time = start_time
        # The method used to calculate the metric values that trigger alerts.
        self.statistics = statistics
        # The alert threshold.
        self.threshold = threshold

    def validate(self):
        if self.escalation:
            self.escalation.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.escalation is not None:
            result['Escalation'] = self.escalation.to_map()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.last_alert_time is not None:
            result['LastAlertTime'] = self.last_alert_time
        if self.last_modify_time is not None:
            result['LastModifyTime'] = self.last_modify_time
        if self.level is not None:
            result['Level'] = self.level
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.metric_values is not None:
            result['MetricValues'] = self.metric_values
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.product_category is not None:
            result['ProductCategory'] = self.product_category
        if self.resource is not None:
            result['Resource'] = self.resource
        if self.retry_times is not None:
            result['RetryTimes'] = self.retry_times
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('Escalation') is not None:
            temp_model = DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalation()
            self.escalation = temp_model.from_map(m['Escalation'])
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('LastAlertTime') is not None:
            self.last_alert_time = m.get('LastAlertTime')
        if m.get('LastModifyTime') is not None:
            self.last_modify_time = m.get('LastModifyTime')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('MetricValues') is not None:
            self.metric_values = m.get('MetricValues')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('ProductCategory') is not None:
            self.product_category = m.get('ProductCategory')
        if m.get('Resource') is not None:
            self.resource = m.get('Resource')
        if m.get('RetryTimes') is not None:
            self.retry_times = m.get('RetryTimes')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        return self


class DescribeAlertingMetricRuleResourcesResponseBodyResources(TeaModel):
    def __init__(
        self,
        resource: List[DescribeAlertingMetricRuleResourcesResponseBodyResourcesResource] = None,
    ):
        self.resource = resource

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeAlertingMetricRuleResourcesResponseBodyResourcesResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeAlertingMetricRuleResourcesResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        request_id: str = None,
        resources: DescribeAlertingMetricRuleResourcesResponseBodyResources = None,
        success: bool = None,
        total: int = None,
    ):
        # The status code.
        # 
        # > The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # The resources that are associated with the alert rule.
        self.resources = resources
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.resources:
            self.resources.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resources is not None:
            result['Resources'] = self.resources.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resources') is not None:
            temp_model = DescribeAlertingMetricRuleResourcesResponseBodyResources()
            self.resources = temp_model.from_map(m['Resources'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeAlertingMetricRuleResourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAlertingMetricRuleResourcesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlertingMetricRuleResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeContactGroupListRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
    ):
        # Page number.
        self.page_number = page_number
        # Number of records per page.
        self.page_size = page_size
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeContactGroupListResponseBodyContactGroupListContactGroupContacts(TeaModel):
    def __init__(
        self,
        contact: List[str] = None,
    ):
        self.contact = contact

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact is not None:
            result['Contact'] = self.contact
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Contact') is not None:
            self.contact = m.get('Contact')
        return self


class DescribeContactGroupListResponseBodyContactGroupListContactGroup(TeaModel):
    def __init__(
        self,
        contacts: DescribeContactGroupListResponseBodyContactGroupListContactGroupContacts = None,
        create_time: int = None,
        describe: str = None,
        enable_subscribed: bool = None,
        enabled_weekly_report: bool = None,
        name: str = None,
        update_time: int = None,
    ):
        # List of contacts.
        self.contacts = contacts
        # Creation time.
        self.create_time = create_time
        # Description information of the alarm contact group.
        self.describe = describe
        # Indicates whether the weekly report subscription function is enabled. Values:
        # 
        # - true: Yes.
        # 
        # - false: No.
        self.enable_subscribed = enable_subscribed
        # Indicates whether the weekly report function is enabled.
        self.enabled_weekly_report = enabled_weekly_report
        # Name.
        self.name = name
        # Update time.
        self.update_time = update_time

    def validate(self):
        if self.contacts:
            self.contacts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contacts is not None:
            result['Contacts'] = self.contacts.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.describe is not None:
            result['Describe'] = self.describe
        if self.enable_subscribed is not None:
            result['EnableSubscribed'] = self.enable_subscribed
        if self.enabled_weekly_report is not None:
            result['EnabledWeeklyReport'] = self.enabled_weekly_report
        if self.name is not None:
            result['Name'] = self.name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Contacts') is not None:
            temp_model = DescribeContactGroupListResponseBodyContactGroupListContactGroupContacts()
            self.contacts = temp_model.from_map(m['Contacts'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Describe') is not None:
            self.describe = m.get('Describe')
        if m.get('EnableSubscribed') is not None:
            self.enable_subscribed = m.get('EnableSubscribed')
        if m.get('EnabledWeeklyReport') is not None:
            self.enabled_weekly_report = m.get('EnabledWeeklyReport')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeContactGroupListResponseBodyContactGroupList(TeaModel):
    def __init__(
        self,
        contact_group: List[DescribeContactGroupListResponseBodyContactGroupListContactGroup] = None,
    ):
        self.contact_group = contact_group

    def validate(self):
        if self.contact_group:
            for k in self.contact_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ContactGroup'] = []
        if self.contact_group is not None:
            for k in self.contact_group:
                result['ContactGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.contact_group = []
        if m.get('ContactGroup') is not None:
            for k in m.get('ContactGroup'):
                temp_model = DescribeContactGroupListResponseBodyContactGroupListContactGroup()
                self.contact_group.append(temp_model.from_map(k))
        return self


class DescribeContactGroupListResponseBodyContactGroups(TeaModel):
    def __init__(
        self,
        contact_group: List[str] = None,
    ):
        self.contact_group = contact_group

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group is not None:
            result['ContactGroup'] = self.contact_group
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroup') is not None:
            self.contact_group = m.get('ContactGroup')
        return self


class DescribeContactGroupListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        contact_group_list: DescribeContactGroupListResponseBodyContactGroupList = None,
        contact_groups: DescribeContactGroupListResponseBodyContactGroups = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        total: int = None,
    ):
        # Status code. Note that 200 indicates success.
        self.code = code
        # List of alarm contact groups.
        self.contact_group_list = contact_group_list
        # List of alarm contact groups.
        self.contact_groups = contact_groups
        # Return message.
        self.message = message
        # The ID of this call request, which is a unique identifier generated by Alibaba Cloud for the request and can be used for troubleshooting and problem localization.
        self.request_id = request_id
        # Indicates whether the operation was successful. Values:
        # 
        # - true: Success.
        # 
        # - false: Failure.
        self.success = success
        # Total number of records.
        self.total = total

    def validate(self):
        if self.contact_group_list:
            self.contact_group_list.validate()
        if self.contact_groups:
            self.contact_groups.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.contact_group_list is not None:
            result['ContactGroupList'] = self.contact_group_list.to_map()
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ContactGroupList') is not None:
            temp_model = DescribeContactGroupListResponseBodyContactGroupList()
            self.contact_group_list = temp_model.from_map(m['ContactGroupList'])
        if m.get('ContactGroups') is not None:
            temp_model = DescribeContactGroupListResponseBodyContactGroups()
            self.contact_groups = temp_model.from_map(m['ContactGroups'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeContactGroupListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeContactGroupListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeContactGroupListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeContactListRequest(TeaModel):
    def __init__(
        self,
        chanel_type: str = None,
        chanel_value: str = None,
        contact_name: str = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
    ):
        # The alert notification method. Valid values:
        # 
        # *   Mail: emails
        # *   DingWebHook: DingTalk chatbots
        self.chanel_type = chanel_type
        # The value specified for the alert notification method.
        # 
        # >  This parameter is required only if you set the `ChanelType` parameter to `Mail`.
        self.chanel_value = chanel_value
        # The name of the alert contact.
        self.contact_name = contact_name
        # The page number.
        # 
        # Default value: 1.
        self.page_number = page_number
        # The number of entries per page.
        # 
        # Default value: 100.
        self.page_size = page_size
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.chanel_type is not None:
            result['ChanelType'] = self.chanel_type
        if self.chanel_value is not None:
            result['ChanelValue'] = self.chanel_value
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChanelType') is not None:
            self.chanel_type = m.get('ChanelType')
        if m.get('ChanelValue') is not None:
            self.chanel_value = m.get('ChanelValue')
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeContactListResponseBodyContactsContactChannels(TeaModel):
    def __init__(
        self,
        ali_im: str = None,
        ding_web_hook: str = None,
        mail: str = None,
        sms: str = None,
    ):
        # The TradeManager ID of the alert contact.
        self.ali_im = ali_im
        # The webhook URL of the DingTalk chatbot.
        self.ding_web_hook = ding_web_hook
        # The email address of the alert contact.
        self.mail = mail
        # The phone number of the alert contac.
        self.sms = sms

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_im is not None:
            result['AliIM'] = self.ali_im
        if self.ding_web_hook is not None:
            result['DingWebHook'] = self.ding_web_hook
        if self.mail is not None:
            result['Mail'] = self.mail
        if self.sms is not None:
            result['SMS'] = self.sms
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliIM') is not None:
            self.ali_im = m.get('AliIM')
        if m.get('DingWebHook') is not None:
            self.ding_web_hook = m.get('DingWebHook')
        if m.get('Mail') is not None:
            self.mail = m.get('Mail')
        if m.get('SMS') is not None:
            self.sms = m.get('SMS')
        return self


class DescribeContactListResponseBodyContactsContactChannelsState(TeaModel):
    def __init__(
        self,
        ali_im: str = None,
        ding_web_hook: str = None,
        mail: str = None,
        sms: str = None,
    ):
        # The status of the TradeManager ID.
        # 
        # Valid value: OK. The value OK indicates that the TradeManager ID is valid and can receive alert notifications.
        # 
        # >  This parameter applies only to the Alibaba Cloud China site (aliyun.com).
        self.ali_im = ali_im
        # The status of the DingTalk chatbot.
        # 
        # Valid value: OK. The value OK indicates that the DingTalk chatbot is normal and alert notifications can be received in a DingTalk group.
        self.ding_web_hook = ding_web_hook
        # The status of the email address. Valid values:
        # 
        # *   PENDING: The phone number is not activated. Alert notifications can be sent to the phone number by using text messages only after the phone number is activated.
        # *   OK: The phone number is activated and can receive alert notifications.
        self.mail = mail
        # The status of the phone number. Valid values:
        # 
        # *   PENDING: The phone number is not activated. Alert notifications can be sent to the phone number by using text messages only after the phone number is activated.
        # *   OK: The phone number is activated and can receive alert notifications.
        # 
        # >  This parameter applies only to the Alibaba Cloud China site (aliyun.com).
        self.sms = sms

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_im is not None:
            result['AliIM'] = self.ali_im
        if self.ding_web_hook is not None:
            result['DingWebHook'] = self.ding_web_hook
        if self.mail is not None:
            result['Mail'] = self.mail
        if self.sms is not None:
            result['SMS'] = self.sms
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliIM') is not None:
            self.ali_im = m.get('AliIM')
        if m.get('DingWebHook') is not None:
            self.ding_web_hook = m.get('DingWebHook')
        if m.get('Mail') is not None:
            self.mail = m.get('Mail')
        if m.get('SMS') is not None:
            self.sms = m.get('SMS')
        return self


class DescribeContactListResponseBodyContactsContactContactGroups(TeaModel):
    def __init__(
        self,
        contact_group: List[str] = None,
    ):
        self.contact_group = contact_group

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group is not None:
            result['ContactGroup'] = self.contact_group
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroup') is not None:
            self.contact_group = m.get('ContactGroup')
        return self


class DescribeContactListResponseBodyContactsContact(TeaModel):
    def __init__(
        self,
        channels: DescribeContactListResponseBodyContactsContactChannels = None,
        channels_state: DescribeContactListResponseBodyContactsContactChannelsState = None,
        contact_groups: DescribeContactListResponseBodyContactsContactContactGroups = None,
        create_time: int = None,
        desc: str = None,
        lang: str = None,
        name: str = None,
        update_time: int = None,
    ):
        # The alert notification method.
        self.channels = channels
        # The status of the alert notification method. Valid values: PENDING and OK.
        # 
        # The email address must be activated after it is added as the value specified for the alert notification method. The value PENDING indicates that the email address is not activated. The value OK indicates that the email address is activated.
        self.channels_state = channels_state
        # None.
        self.contact_groups = contact_groups
        # The timestamp when the alert contact was created.
        # 
        # Unit: milliseconds.
        self.create_time = create_time
        # The description.
        self.desc = desc
        # The language in which the alert information is displayed. Valid values:
        # 
        # *   zh-cn: simplified Chinese
        # *   en: English
        self.lang = lang
        # The name of the alert contact.
        self.name = name
        # The timestamp when the alert contact was updated.
        # 
        # Unit: milliseconds.
        self.update_time = update_time

    def validate(self):
        if self.channels:
            self.channels.validate()
        if self.channels_state:
            self.channels_state.validate()
        if self.contact_groups:
            self.contact_groups.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channels is not None:
            result['Channels'] = self.channels.to_map()
        if self.channels_state is not None:
            result['ChannelsState'] = self.channels_state.to_map()
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.name is not None:
            result['Name'] = self.name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Channels') is not None:
            temp_model = DescribeContactListResponseBodyContactsContactChannels()
            self.channels = temp_model.from_map(m['Channels'])
        if m.get('ChannelsState') is not None:
            temp_model = DescribeContactListResponseBodyContactsContactChannelsState()
            self.channels_state = temp_model.from_map(m['ChannelsState'])
        if m.get('ContactGroups') is not None:
            temp_model = DescribeContactListResponseBodyContactsContactContactGroups()
            self.contact_groups = temp_model.from_map(m['ContactGroups'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeContactListResponseBodyContacts(TeaModel):
    def __init__(
        self,
        contact: List[DescribeContactListResponseBodyContactsContact] = None,
    ):
        self.contact = contact

    def validate(self):
        if self.contact:
            for k in self.contact:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Contact'] = []
        if self.contact is not None:
            for k in self.contact:
                result['Contact'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.contact = []
        if m.get('Contact') is not None:
            for k in m.get('Contact'):
                temp_model = DescribeContactListResponseBodyContactsContact()
                self.contact.append(temp_model.from_map(k))
        return self


class DescribeContactListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        contacts: DescribeContactListResponseBodyContacts = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        total: int = None,
    ):
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The alert contacts.
        self.contacts = contacts
        # The error message returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true: The request was successful.
        # *   false: The request failed.
        self.success = success
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.contacts:
            self.contacts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.contacts is not None:
            result['Contacts'] = self.contacts.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Contacts') is not None:
            temp_model = DescribeContactListResponseBodyContacts()
            self.contacts = temp_model.from_map(m['Contacts'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeContactListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeContactListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeContactListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeContactListByContactGroupRequest(TeaModel):
    def __init__(
        self,
        contact_group_name: str = None,
        region_id: str = None,
    ):
        # The name of the alert contact group.
        # 
        # This parameter is required.
        self.contact_group_name = contact_group_name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_name is not None:
            result['ContactGroupName'] = self.contact_group_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroupName') is not None:
            self.contact_group_name = m.get('ContactGroupName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeContactListByContactGroupResponseBodyContactsContactChannels(TeaModel):
    def __init__(
        self,
        ali_im: str = None,
        ding_web_hook: str = None,
        mail: str = None,
        sms: str = None,
    ):
        # The TradeManager ID of the alert contact.
        # 
        # >  This parameter can be returned only on the China site (aliyun.com).
        self.ali_im = ali_im
        # The webhook URL of the DingTalk chatbot.
        self.ding_web_hook = ding_web_hook
        # The email address of the alert contact.
        self.mail = mail
        # The mobile number of the alert contact.
        # 
        # >  This parameter can be returned only on the China site (aliyun.com).
        self.sms = sms

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_im is not None:
            result['AliIM'] = self.ali_im
        if self.ding_web_hook is not None:
            result['DingWebHook'] = self.ding_web_hook
        if self.mail is not None:
            result['Mail'] = self.mail
        if self.sms is not None:
            result['SMS'] = self.sms
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliIM') is not None:
            self.ali_im = m.get('AliIM')
        if m.get('DingWebHook') is not None:
            self.ding_web_hook = m.get('DingWebHook')
        if m.get('Mail') is not None:
            self.mail = m.get('Mail')
        if m.get('SMS') is not None:
            self.sms = m.get('SMS')
        return self


class DescribeContactListByContactGroupResponseBodyContactsContact(TeaModel):
    def __init__(
        self,
        channels: DescribeContactListByContactGroupResponseBodyContactsContactChannels = None,
        create_time: int = None,
        desc: str = None,
        name: str = None,
        update_time: int = None,
    ):
        # The alert notification methods.
        self.channels = channels
        # The time when the alert contact was created.
        # 
        # Unit: milliseconds.
        self.create_time = create_time
        # The description of the alert contact.
        self.desc = desc
        # The name of the alert contact.
        self.name = name
        # The time when the alert contact was modified.
        # 
        # Unit: milliseconds.
        self.update_time = update_time

    def validate(self):
        if self.channels:
            self.channels.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channels is not None:
            result['Channels'] = self.channels.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.name is not None:
            result['Name'] = self.name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Channels') is not None:
            temp_model = DescribeContactListByContactGroupResponseBodyContactsContactChannels()
            self.channels = temp_model.from_map(m['Channels'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeContactListByContactGroupResponseBodyContacts(TeaModel):
    def __init__(
        self,
        contact: List[DescribeContactListByContactGroupResponseBodyContactsContact] = None,
    ):
        self.contact = contact

    def validate(self):
        if self.contact:
            for k in self.contact:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Contact'] = []
        if self.contact is not None:
            for k in self.contact:
                result['Contact'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.contact = []
        if m.get('Contact') is not None:
            for k in m.get('Contact'):
                temp_model = DescribeContactListByContactGroupResponseBodyContactsContact()
                self.contact.append(temp_model.from_map(k))
        return self


class DescribeContactListByContactGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        contacts: DescribeContactListByContactGroupResponseBodyContacts = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The alert contacts that receive alert notifications.
        self.contacts = contacts
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        if self.contacts:
            self.contacts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.contacts is not None:
            result['Contacts'] = self.contacts.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Contacts') is not None:
            temp_model = DescribeContactListByContactGroupResponseBodyContacts()
            self.contacts = temp_model.from_map(m['Contacts'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeContactListByContactGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeContactListByContactGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeContactListByContactGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomEventAttributeRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        event_id: str = None,
        group_id: str = None,
        name: str = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        search_keywords: str = None,
        start_time: str = None,
    ):
        # The end of the time range to query.
        # 
        # This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.end_time = end_time
        # The event ID.
        self.event_id = event_id
        # The ID of the application group.
        self.group_id = group_id
        # The event name.
        self.name = name
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        self.region_id = region_id
        # The keywords that are used to search for the event.
        # 
        # *   If you need to query the custom event whose content contains a and b, set the value to a and b.
        # *   If you need to query the custom event whose content contains a or b, set the value to a or b.
        self.search_keywords = search_keywords
        # The beginning of the time range to query.
        # 
        # This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.search_keywords is not None:
            result['SearchKeywords'] = self.search_keywords
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SearchKeywords') is not None:
            self.search_keywords = m.get('SearchKeywords')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeCustomEventAttributeResponseBodyCustomEventsCustomEvent(TeaModel):
    def __init__(
        self,
        content: str = None,
        group_id: str = None,
        id: str = None,
        name: str = None,
        time: str = None,
    ):
        # The content of the event.
        self.content = content
        # The ID of the application group.
        self.group_id = group_id
        # The event ID.
        self.id = id
        # The event name.
        self.name = name
        # The time when the event occurred.
        # 
        # This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeCustomEventAttributeResponseBodyCustomEvents(TeaModel):
    def __init__(
        self,
        custom_event: List[DescribeCustomEventAttributeResponseBodyCustomEventsCustomEvent] = None,
    ):
        self.custom_event = custom_event

    def validate(self):
        if self.custom_event:
            for k in self.custom_event:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CustomEvent'] = []
        if self.custom_event is not None:
            for k in self.custom_event:
                result['CustomEvent'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.custom_event = []
        if m.get('CustomEvent') is not None:
            for k in m.get('CustomEvent'):
                temp_model = DescribeCustomEventAttributeResponseBodyCustomEventsCustomEvent()
                self.custom_event.append(temp_model.from_map(k))
        return self


class DescribeCustomEventAttributeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        custom_events: DescribeCustomEventAttributeResponseBodyCustomEvents = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The event details.
        self.custom_events = custom_events
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values: Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        if self.custom_events:
            self.custom_events.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.custom_events is not None:
            result['CustomEvents'] = self.custom_events.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CustomEvents') is not None:
            temp_model = DescribeCustomEventAttributeResponseBodyCustomEvents()
            self.custom_events = temp_model.from_map(m['CustomEvents'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCustomEventAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCustomEventAttributeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCustomEventAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomEventCountRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        event_id: str = None,
        group_id: str = None,
        name: str = None,
        region_id: str = None,
        search_keywords: str = None,
        start_time: str = None,
    ):
        # The end of the time range to query.
        # 
        # This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.end_time = end_time
        # The event ID.
        self.event_id = event_id
        # The ID of the application group.
        self.group_id = group_id
        # The event name.
        self.name = name
        self.region_id = region_id
        # The keywords that are used to search for the event.
        # 
        # *   If you need to query the custom event whose content contains a and b, set the value to a and b.
        # *   If you need to query the custom event whose content contains a or b, set the value to a or b.
        self.search_keywords = search_keywords
        # The beginning of the time range to query.
        # 
        # This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.search_keywords is not None:
            result['SearchKeywords'] = self.search_keywords
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SearchKeywords') is not None:
            self.search_keywords = m.get('SearchKeywords')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeCustomEventCountResponseBodyCustomEventCountsCustomEventCount(TeaModel):
    def __init__(
        self,
        name: str = None,
        num: int = None,
        time: int = None,
    ):
        # The event name.
        self.name = name
        # The number of times that the custom event occurred.
        self.num = num
        # The time when the event occurred.
        # 
        # This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.num is not None:
            result['Num'] = self.num
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Num') is not None:
            self.num = m.get('Num')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeCustomEventCountResponseBodyCustomEventCounts(TeaModel):
    def __init__(
        self,
        custom_event_count: List[DescribeCustomEventCountResponseBodyCustomEventCountsCustomEventCount] = None,
    ):
        self.custom_event_count = custom_event_count

    def validate(self):
        if self.custom_event_count:
            for k in self.custom_event_count:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CustomEventCount'] = []
        if self.custom_event_count is not None:
            for k in self.custom_event_count:
                result['CustomEventCount'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.custom_event_count = []
        if m.get('CustomEventCount') is not None:
            for k in m.get('CustomEventCount'):
                temp_model = DescribeCustomEventCountResponseBodyCustomEventCountsCustomEventCount()
                self.custom_event_count.append(temp_model.from_map(k))
        return self


class DescribeCustomEventCountResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        custom_event_counts: DescribeCustomEventCountResponseBodyCustomEventCounts = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The details of the custom event.
        self.custom_event_counts = custom_event_counts
        # The returned message. If the request was successful, a success message is returned. If the request failed, an error message is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values: true and false.
        self.success = success

    def validate(self):
        if self.custom_event_counts:
            self.custom_event_counts.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.custom_event_counts is not None:
            result['CustomEventCounts'] = self.custom_event_counts.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CustomEventCounts') is not None:
            temp_model = DescribeCustomEventCountResponseBodyCustomEventCounts()
            self.custom_event_counts = temp_model.from_map(m['CustomEventCounts'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCustomEventCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCustomEventCountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCustomEventCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomEventHistogramRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        event_id: str = None,
        group_id: str = None,
        level: str = None,
        name: str = None,
        region_id: str = None,
        search_keywords: str = None,
        start_time: str = None,
    ):
        # The end of the time range to query.
        # 
        # This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.end_time = end_time
        # The event ID.
        self.event_id = event_id
        # The ID of the application group.
        self.group_id = group_id
        # The severity level of the event. Valid values:
        # 
        # *   CRITICAL
        # *   WARN
        # *   INFO
        self.level = level
        # The event name.
        self.name = name
        self.region_id = region_id
        # The keywords that are used to search for the event.
        # 
        # *   If you need to query the custom event whose content contains a and b, set the value to "a and b".
        # *   If you need to query the custom event whose content contains a or b, set the value to "a or b".
        self.search_keywords = search_keywords
        # The beginning of the time range to query.
        # 
        # This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.search_keywords is not None:
            result['SearchKeywords'] = self.search_keywords
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SearchKeywords') is not None:
            self.search_keywords = m.get('SearchKeywords')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeCustomEventHistogramResponseBodyEventHistogramsEventHistogram(TeaModel):
    def __init__(
        self,
        count: int = None,
        end_time: int = None,
        start_time: int = None,
    ):
        # The information about the number of times that the custom event occurred during an interval of the specified time period.
        self.count = count
        # The end time.
        # 
        # This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.end_time = end_time
        # The start time.
        # 
        # This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeCustomEventHistogramResponseBodyEventHistograms(TeaModel):
    def __init__(
        self,
        event_histogram: List[DescribeCustomEventHistogramResponseBodyEventHistogramsEventHistogram] = None,
    ):
        self.event_histogram = event_histogram

    def validate(self):
        if self.event_histogram:
            for k in self.event_histogram:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventHistogram'] = []
        if self.event_histogram is not None:
            for k in self.event_histogram:
                result['EventHistogram'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.event_histogram = []
        if m.get('EventHistogram') is not None:
            for k in m.get('EventHistogram'):
                temp_model = DescribeCustomEventHistogramResponseBodyEventHistogramsEventHistogram()
                self.event_histogram.append(temp_model.from_map(k))
        return self


class DescribeCustomEventHistogramResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        event_histograms: DescribeCustomEventHistogramResponseBodyEventHistograms = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The information about the number of times that the custom event occurred during each interval of the specified time period.
        self.event_histograms = event_histograms
        # The returned message. If the request was successful, a success message is returned. If the request failed, an error message is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values: true and false.
        self.success = success

    def validate(self):
        if self.event_histograms:
            self.event_histograms.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.event_histograms is not None:
            result['EventHistograms'] = self.event_histograms.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EventHistograms') is not None:
            temp_model = DescribeCustomEventHistogramResponseBodyEventHistograms()
            self.event_histograms = temp_model.from_map(m['EventHistograms'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCustomEventHistogramResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCustomEventHistogramResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCustomEventHistogramResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomMetricListRequest(TeaModel):
    def __init__(
        self,
        dimension: str = None,
        group_id: str = None,
        md_5: str = None,
        metric_name: str = None,
        page_number: str = None,
        page_size: str = None,
        region_id: str = None,
    ):
        # The dimensions based on which the resources are queried.
        self.dimension = dimension
        # The ID of the application group.
        # 
        # For information about how to query the IDs of application groups, see [DescribeMonitorGroups](https://help.aliyun.com/document_detail/115032.html).
        self.group_id = group_id
        # The MD5 value of the HTTP request body. The MD5 value is a 128-bit hash value used to verify the uniqueness of the reported monitoring data.
        self.md_5 = md_5
        # The name of the custom metric.
        self.metric_name = metric_name
        # The page number.
        # 
        # Pages start from page 1. Default value: 1.
        self.page_number = page_number
        # The number of entries per page.
        # 
        # Pages start from page 1. Default value: 10.
        self.page_size = page_size
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCustomMetricListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        result: str = None,
    ):
        # The responses code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # The reported custom metrics that are found in the query.
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class DescribeCustomMetricListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCustomMetricListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCustomMetricListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDynamicTagRuleListRequest(TeaModel):
    def __init__(
        self,
        dynamic_tag_rule_id: str = None,
        page_number: str = None,
        page_size: str = None,
        tag_key: str = None,
        tag_region_id: str = None,
        tag_value: str = None,
    ):
        # The ID of the tag rule.
        self.dynamic_tag_rule_id = dynamic_tag_rule_id
        # The number of the page to return.
        # 
        # Pages start from page 1. Default value: 1.
        self.page_number = page_number
        # The number of entries to return on each page.
        # 
        # Minimum value: 1. Default value: 30.
        self.page_size = page_size
        # The tag key.
        # 
        # For more information about how to obtain a tag key, see [DescribeTagKeyList](https://help.aliyun.com/document_detail/145558.html).
        self.tag_key = tag_key
        # The ID of the region to which the tags belong.
        self.tag_region_id = tag_region_id
        # The tag value.
        # 
        # For more information about how to obtain a tag value, see [DescribeTagKeyList](https://help.aliyun.com/document_detail/145557.html).
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_tag_rule_id is not None:
            result['DynamicTagRuleId'] = self.dynamic_tag_rule_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_region_id is not None:
            result['TagRegionId'] = self.tag_region_id
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DynamicTagRuleId') is not None:
            self.dynamic_tag_rule_id = m.get('DynamicTagRuleId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagRegionId') is not None:
            self.tag_region_id = m.get('TagRegionId')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupContactGroupList(TeaModel):
    def __init__(
        self,
        contact_group_list: List[str] = None,
    ):
        self.contact_group_list = contact_group_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_list is not None:
            result['ContactGroupList'] = self.contact_group_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroupList') is not None:
            self.contact_group_list = m.get('ContactGroupList')
        return self


class DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupMatchExpressMatchExpress(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
        tag_value_match_function: str = None,
    ):
        # The tag key.
        self.tag_key = tag_key
        # The tag value.
        # 
        # The `TagValue` and `TagValueMatchFunction` parameters must be used in pairs.
        self.tag_value = tag_value
        # The method that is used to match tag values. Valid values:
        # 
        # *   all: includes all
        # *   startWith: starts with a prefix
        # *   endWith: ends with a suffix
        # *   contains: contains
        # *   notContains: does not contain
        # *   equals: equals
        self.tag_value_match_function = tag_value_match_function

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_value_match_function is not None:
            result['TagValueMatchFunction'] = self.tag_value_match_function
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagValueMatchFunction') is not None:
            self.tag_value_match_function = m.get('TagValueMatchFunction')
        return self


class DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupMatchExpress(TeaModel):
    def __init__(
        self,
        match_express: List[DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupMatchExpressMatchExpress] = None,
    ):
        self.match_express = match_express

    def validate(self):
        if self.match_express:
            for k in self.match_express:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MatchExpress'] = []
        if self.match_express is not None:
            for k in self.match_express:
                result['MatchExpress'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.match_express = []
        if m.get('MatchExpress') is not None:
            for k in m.get('MatchExpress'):
                temp_model = DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupMatchExpressMatchExpress()
                self.match_express.append(temp_model.from_map(k))
        return self


class DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupTagValueBlacklist(TeaModel):
    def __init__(
        self,
        tag_value_blacklist: List[str] = None,
    ):
        self.tag_value_blacklist = tag_value_blacklist

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_value_blacklist is not None:
            result['TagValueBlacklist'] = self.tag_value_blacklist
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagValueBlacklist') is not None:
            self.tag_value_blacklist = m.get('TagValueBlacklist')
        return self


class DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupTemplateIdList(TeaModel):
    def __init__(
        self,
        template_id_list: List[str] = None,
    ):
        self.template_id_list = template_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id_list is not None:
            result['TemplateIdList'] = self.template_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TemplateIdList') is not None:
            self.template_id_list = m.get('TemplateIdList')
        return self


class DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroup(TeaModel):
    def __init__(
        self,
        contact_group_list: DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupContactGroupList = None,
        dynamic_tag_rule_id: str = None,
        match_express: DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupMatchExpress = None,
        match_express_filter_relation: str = None,
        region_id: str = None,
        status: str = None,
        tag_key: str = None,
        tag_value_blacklist: DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupTagValueBlacklist = None,
        template_id_list: DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupTemplateIdList = None,
    ):
        # The alert contact group.
        self.contact_group_list = contact_group_list
        # The ID of the tag rule.
        self.dynamic_tag_rule_id = dynamic_tag_rule_id
        # The conditional expressions used to create an application group based on the tag.
        self.match_express = match_express
        # The logical operator that is used between conditional expressions. Valid values:
        # 
        # *   `and`
        # *   `or`
        # 
        # >  Only one logical operator can be used in a request.
        self.match_express_filter_relation = match_express_filter_relation
        # The ID of the region to which the tags belong.
        self.region_id = region_id
        # The status of adding instances that meet the tag rule to the application group. Valid values:
        # 
        # *   `RUNNING`
        # *   `FINISH`
        self.status = status
        # The tag key.
        self.tag_key = tag_key
        self.tag_value_blacklist = tag_value_blacklist
        # The IDs of the alert templates.
        self.template_id_list = template_id_list

    def validate(self):
        if self.contact_group_list:
            self.contact_group_list.validate()
        if self.match_express:
            self.match_express.validate()
        if self.tag_value_blacklist:
            self.tag_value_blacklist.validate()
        if self.template_id_list:
            self.template_id_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_list is not None:
            result['ContactGroupList'] = self.contact_group_list.to_map()
        if self.dynamic_tag_rule_id is not None:
            result['DynamicTagRuleId'] = self.dynamic_tag_rule_id
        if self.match_express is not None:
            result['MatchExpress'] = self.match_express.to_map()
        if self.match_express_filter_relation is not None:
            result['MatchExpressFilterRelation'] = self.match_express_filter_relation
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value_blacklist is not None:
            result['TagValueBlacklist'] = self.tag_value_blacklist.to_map()
        if self.template_id_list is not None:
            result['TemplateIdList'] = self.template_id_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroupList') is not None:
            temp_model = DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupContactGroupList()
            self.contact_group_list = temp_model.from_map(m['ContactGroupList'])
        if m.get('DynamicTagRuleId') is not None:
            self.dynamic_tag_rule_id = m.get('DynamicTagRuleId')
        if m.get('MatchExpress') is not None:
            temp_model = DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupMatchExpress()
            self.match_express = temp_model.from_map(m['MatchExpress'])
        if m.get('MatchExpressFilterRelation') is not None:
            self.match_express_filter_relation = m.get('MatchExpressFilterRelation')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValueBlacklist') is not None:
            temp_model = DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupTagValueBlacklist()
            self.tag_value_blacklist = temp_model.from_map(m['TagValueBlacklist'])
        if m.get('TemplateIdList') is not None:
            temp_model = DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupTemplateIdList()
            self.template_id_list = temp_model.from_map(m['TemplateIdList'])
        return self


class DescribeDynamicTagRuleListResponseBodyTagGroupList(TeaModel):
    def __init__(
        self,
        tag_group: List[DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroup] = None,
    ):
        self.tag_group = tag_group

    def validate(self):
        if self.tag_group:
            for k in self.tag_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TagGroup'] = []
        if self.tag_group is not None:
            for k in self.tag_group:
                result['TagGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag_group = []
        if m.get('TagGroup') is not None:
            for k in m.get('TagGroup'):
                temp_model = DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroup()
                self.tag_group.append(temp_model.from_map(k))
        return self


class DescribeDynamicTagRuleListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        page_number: str = None,
        page_size: str = None,
        request_id: str = None,
        success: bool = None,
        tag_group_list: DescribeDynamicTagRuleListResponseBodyTagGroupList = None,
        total: int = None,
    ):
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the call was successful.
        self.code = code
        # The error message.
        self.message = message
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the call was successful. Valid values:
        # 
        # *   true: The call was successful.
        # *   false: The call failed.
        self.success = success
        # The tag rules of application groups.
        self.tag_group_list = tag_group_list
        # The total number of returned entries.
        self.total = total

    def validate(self):
        if self.tag_group_list:
            self.tag_group_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.tag_group_list is not None:
            result['TagGroupList'] = self.tag_group_list.to_map()
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TagGroupList') is not None:
            temp_model = DescribeDynamicTagRuleListResponseBodyTagGroupList()
            self.tag_group_list = temp_model.from_map(m['TagGroupList'])
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeDynamicTagRuleListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDynamicTagRuleListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDynamicTagRuleListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEventRuleAttributeRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        rule_name: str = None,
        silence_time: str = None,
    ):
        self.region_id = region_id
        # The name of the event-triggered alert rule.
        # 
        # For information about how to obtain the name of an event-triggered alert rule, see [DescribeEventRuleList](https://help.aliyun.com/document_detail/114996.html).
        # 
        # This parameter is required.
        self.rule_name = rule_name
        # The mute period during which new alert notifications are not sent even if the trigger conditions are met.
        # 
        # Unit: seconds. Default value: 86400, which indicates one day.
        # 
        # >  Only one alert notification is sent during each mute period even if the metric value exceeds the alert threshold several times.
        self.silence_time = silence_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        return self


class DescribeEventRuleAttributeResponseBodyResultEventPatternEventTypeList(TeaModel):
    def __init__(
        self,
        event_type_list: List[str] = None,
    ):
        self.event_type_list = event_type_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_type_list is not None:
            result['EventTypeList'] = self.event_type_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventTypeList') is not None:
            self.event_type_list = m.get('EventTypeList')
        return self


class DescribeEventRuleAttributeResponseBodyResultEventPatternKeywordFilterObjKeywords(TeaModel):
    def __init__(
        self,
        keyword: List[str] = None,
    ):
        self.keyword = keyword

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['keyword'] = self.keyword
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        return self


class DescribeEventRuleAttributeResponseBodyResultEventPatternKeywordFilterObj(TeaModel):
    def __init__(
        self,
        keywords: DescribeEventRuleAttributeResponseBodyResultEventPatternKeywordFilterObjKeywords = None,
        relation: str = None,
    ):
        # The keywords that are used to match events.
        self.keywords = keywords
        # The relationship between multiple keywords in a condition. Valid values:
        # 
        # *   OR: The relationship between keywords is OR.
        # *   NOT: The keyword is excluded. The value NOT indicates that all events that do not contain the keywords are matched.
        self.relation = relation

    def validate(self):
        if self.keywords:
            self.keywords.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keywords is not None:
            result['Keywords'] = self.keywords.to_map()
        if self.relation is not None:
            result['Relation'] = self.relation
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Keywords') is not None:
            temp_model = DescribeEventRuleAttributeResponseBodyResultEventPatternKeywordFilterObjKeywords()
            self.keywords = temp_model.from_map(m['Keywords'])
        if m.get('Relation') is not None:
            self.relation = m.get('Relation')
        return self


class DescribeEventRuleAttributeResponseBodyResultEventPatternLevelList(TeaModel):
    def __init__(
        self,
        level_list: List[str] = None,
    ):
        self.level_list = level_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level_list is not None:
            result['LevelList'] = self.level_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LevelList') is not None:
            self.level_list = m.get('LevelList')
        return self


class DescribeEventRuleAttributeResponseBodyResultEventPatternNameList(TeaModel):
    def __init__(
        self,
        name_list: List[str] = None,
    ):
        self.name_list = name_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name_list is not None:
            result['NameList'] = self.name_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NameList') is not None:
            self.name_list = m.get('NameList')
        return self


class DescribeEventRuleAttributeResponseBodyResultEventPatternStatusList(TeaModel):
    def __init__(
        self,
        status_list: List[str] = None,
    ):
        self.status_list = status_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        return self


class DescribeEventRuleAttributeResponseBodyResultEventPattern(TeaModel):
    def __init__(
        self,
        event_type_list: DescribeEventRuleAttributeResponseBodyResultEventPatternEventTypeList = None,
        keyword_filter_obj: DescribeEventRuleAttributeResponseBodyResultEventPatternKeywordFilterObj = None,
        level_list: DescribeEventRuleAttributeResponseBodyResultEventPatternLevelList = None,
        name_list: DescribeEventRuleAttributeResponseBodyResultEventPatternNameList = None,
        product: str = None,
        sqlfilter: str = None,
        status_list: DescribeEventRuleAttributeResponseBodyResultEventPatternStatusList = None,
    ):
        # The types of the event-triggered alert rules.
        self.event_type_list = event_type_list
        # The keyword for filtering.
        self.keyword_filter_obj = keyword_filter_obj
        self.level_list = level_list
        self.name_list = name_list
        # The name of the cloud service.
        self.product = product
        # Indicates that logs are filtered based on the specified SQL statement. If the specified conditions are met, an alert is triggered.
        self.sqlfilter = sqlfilter
        self.status_list = status_list

    def validate(self):
        if self.event_type_list:
            self.event_type_list.validate()
        if self.keyword_filter_obj:
            self.keyword_filter_obj.validate()
        if self.level_list:
            self.level_list.validate()
        if self.name_list:
            self.name_list.validate()
        if self.status_list:
            self.status_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_type_list is not None:
            result['EventTypeList'] = self.event_type_list.to_map()
        if self.keyword_filter_obj is not None:
            result['KeywordFilterObj'] = self.keyword_filter_obj.to_map()
        if self.level_list is not None:
            result['LevelList'] = self.level_list.to_map()
        if self.name_list is not None:
            result['NameList'] = self.name_list.to_map()
        if self.product is not None:
            result['Product'] = self.product
        if self.sqlfilter is not None:
            result['SQLFilter'] = self.sqlfilter
        if self.status_list is not None:
            result['StatusList'] = self.status_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventTypeList') is not None:
            temp_model = DescribeEventRuleAttributeResponseBodyResultEventPatternEventTypeList()
            self.event_type_list = temp_model.from_map(m['EventTypeList'])
        if m.get('KeywordFilterObj') is not None:
            temp_model = DescribeEventRuleAttributeResponseBodyResultEventPatternKeywordFilterObj()
            self.keyword_filter_obj = temp_model.from_map(m['KeywordFilterObj'])
        if m.get('LevelList') is not None:
            temp_model = DescribeEventRuleAttributeResponseBodyResultEventPatternLevelList()
            self.level_list = temp_model.from_map(m['LevelList'])
        if m.get('NameList') is not None:
            temp_model = DescribeEventRuleAttributeResponseBodyResultEventPatternNameList()
            self.name_list = temp_model.from_map(m['NameList'])
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('SQLFilter') is not None:
            self.sqlfilter = m.get('SQLFilter')
        if m.get('StatusList') is not None:
            temp_model = DescribeEventRuleAttributeResponseBodyResultEventPatternStatusList()
            self.status_list = temp_model.from_map(m['StatusList'])
        return self


class DescribeEventRuleAttributeResponseBodyResult(TeaModel):
    def __init__(
        self,
        description: str = None,
        event_pattern: DescribeEventRuleAttributeResponseBodyResultEventPattern = None,
        event_type: str = None,
        group_id: str = None,
        name: str = None,
        state: str = None,
    ):
        # The description of the event-triggered alert rule.
        self.description = description
        # The event pattern. This parameter describes the trigger conditions of an event.
        self.event_pattern = event_pattern
        # The event type. Valid values:
        # 
        # *   SYSTEM: system event
        # *   CUSTOM: custom event
        self.event_type = event_type
        # The ID of the application group.
        self.group_id = group_id
        # The name of the event-triggered alert rule.
        self.name = name
        # The status of the event-triggered alert rule. Valid values:
        # 
        # *   ENABLED
        # *   DISABLED
        self.state = state

    def validate(self):
        if self.event_pattern:
            self.event_pattern.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.event_pattern is not None:
            result['EventPattern'] = self.event_pattern.to_map()
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EventPattern') is not None:
            temp_model = DescribeEventRuleAttributeResponseBodyResultEventPattern()
            self.event_pattern = temp_model.from_map(m['EventPattern'])
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeEventRuleAttributeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        result: DescribeEventRuleAttributeResponseBodyResult = None,
        success: bool = None,
    ):
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # The details of the event-triggered alert rule.
        self.result = result
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            temp_model = DescribeEventRuleAttributeResponseBodyResult()
            self.result = temp_model.from_map(m['Result'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeEventRuleAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEventRuleAttributeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEventRuleAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEventRuleListRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        is_enable: bool = None,
        name_prefix: str = None,
        page_number: str = None,
        page_size: str = None,
        region_id: str = None,
    ):
        # The ID of the application group.
        self.group_id = group_id
        # Specifies whether to enable the event-triggered alert rule. Valid values:
        # 
        # - true (default)
        # - false
        self.is_enable = is_enable
        # The prefix in the name of the event-triggered alert rule.
        self.name_prefix = name_prefix
        # The page number.
        # 
        # Pages start from page 1. Default value: 1.
        self.page_number = page_number
        # The number of entries per page.
        # 
        # Pages start from page 1. Default value: 10.
        self.page_size = page_size
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.is_enable is not None:
            result['IsEnable'] = self.is_enable
        if self.name_prefix is not None:
            result['NamePrefix'] = self.name_prefix
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('IsEnable') is not None:
            self.is_enable = m.get('IsEnable')
        if m.get('NamePrefix') is not None:
            self.name_prefix = m.get('NamePrefix')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternEventTypeList(TeaModel):
    def __init__(
        self,
        event_type_list: List[str] = None,
    ):
        self.event_type_list = event_type_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_type_list is not None:
            result['EventTypeList'] = self.event_type_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventTypeList') is not None:
            self.event_type_list = m.get('EventTypeList')
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternKeywordFilterKeywords(TeaModel):
    def __init__(
        self,
        keywords: List[str] = None,
    ):
        self.keywords = keywords

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keywords is not None:
            result['Keywords'] = self.keywords
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Keywords') is not None:
            self.keywords = m.get('Keywords')
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternKeywordFilter(TeaModel):
    def __init__(
        self,
        keywords: DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternKeywordFilterKeywords = None,
        relation: str = None,
    ):
        # The keywords that are used to match events.
        self.keywords = keywords
        # The relationship between multiple keywords in a condition. Valid values:
        # 
        # *   OR: The relationship between keywords is OR.
        # *   NOT: The keyword is excluded. The value NOT indicates that all events that do not contain the keywords are matched.
        self.relation = relation

    def validate(self):
        if self.keywords:
            self.keywords.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keywords is not None:
            result['Keywords'] = self.keywords.to_map()
        if self.relation is not None:
            result['Relation'] = self.relation
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Keywords') is not None:
            temp_model = DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternKeywordFilterKeywords()
            self.keywords = temp_model.from_map(m['Keywords'])
        if m.get('Relation') is not None:
            self.relation = m.get('Relation')
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternLevelList(TeaModel):
    def __init__(
        self,
        level_list: List[str] = None,
    ):
        self.level_list = level_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level_list is not None:
            result['LevelList'] = self.level_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LevelList') is not None:
            self.level_list = m.get('LevelList')
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternNameList(TeaModel):
    def __init__(
        self,
        name_list: List[str] = None,
    ):
        self.name_list = name_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name_list is not None:
            result['NameList'] = self.name_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NameList') is not None:
            self.name_list = m.get('NameList')
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPattern(TeaModel):
    def __init__(
        self,
        custom_filters: str = None,
        event_type_list: DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternEventTypeList = None,
        keyword_filter: DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternKeywordFilter = None,
        level_list: DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternLevelList = None,
        name_list: DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternNameList = None,
        product: str = None,
        sqlfilter: str = None,
    ):
        # The custom filter conditions.
        self.custom_filters = custom_filters
        # The types of the event-triggered alert rules.
        self.event_type_list = event_type_list
        # The keyword for filtering.
        self.keyword_filter = keyword_filter
        # The levels of the event-triggered alerts.
        self.level_list = level_list
        # The event names.
        self.name_list = name_list
        # The abbreviation of the Alibaba Cloud service name.
        self.product = product
        # Indicates that logs are filtered based on the specified SQL statement. If the specified conditions are met, an alert is triggered.
        self.sqlfilter = sqlfilter

    def validate(self):
        if self.event_type_list:
            self.event_type_list.validate()
        if self.keyword_filter:
            self.keyword_filter.validate()
        if self.level_list:
            self.level_list.validate()
        if self.name_list:
            self.name_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_filters is not None:
            result['CustomFilters'] = self.custom_filters
        if self.event_type_list is not None:
            result['EventTypeList'] = self.event_type_list.to_map()
        if self.keyword_filter is not None:
            result['KeywordFilter'] = self.keyword_filter.to_map()
        if self.level_list is not None:
            result['LevelList'] = self.level_list.to_map()
        if self.name_list is not None:
            result['NameList'] = self.name_list.to_map()
        if self.product is not None:
            result['Product'] = self.product
        if self.sqlfilter is not None:
            result['SQLFilter'] = self.sqlfilter
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CustomFilters') is not None:
            self.custom_filters = m.get('CustomFilters')
        if m.get('EventTypeList') is not None:
            temp_model = DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternEventTypeList()
            self.event_type_list = temp_model.from_map(m['EventTypeList'])
        if m.get('KeywordFilter') is not None:
            temp_model = DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternKeywordFilter()
            self.keyword_filter = temp_model.from_map(m['KeywordFilter'])
        if m.get('LevelList') is not None:
            temp_model = DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternLevelList()
            self.level_list = temp_model.from_map(m['LevelList'])
        if m.get('NameList') is not None:
            temp_model = DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternNameList()
            self.name_list = temp_model.from_map(m['NameList'])
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('SQLFilter') is not None:
            self.sqlfilter = m.get('SQLFilter')
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRuleEventPattern(TeaModel):
    def __init__(
        self,
        event_pattern: List[DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPattern] = None,
    ):
        self.event_pattern = event_pattern

    def validate(self):
        if self.event_pattern:
            for k in self.event_pattern:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventPattern'] = []
        if self.event_pattern is not None:
            for k in self.event_pattern:
                result['EventPattern'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.event_pattern = []
        if m.get('EventPattern') is not None:
            for k in m.get('EventPattern'):
                temp_model = DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPattern()
                self.event_pattern.append(temp_model.from_map(k))
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRule(TeaModel):
    def __init__(
        self,
        description: str = None,
        event_pattern: DescribeEventRuleListResponseBodyEventRulesEventRuleEventPattern = None,
        event_type: str = None,
        group_id: str = None,
        name: str = None,
        silence_time: int = None,
        state: str = None,
    ):
        # The description of the event-triggered alert rule.
        self.description = description
        # The mode of the event-triggered alert rule.
        self.event_pattern = event_pattern
        # The type of the event-triggered alert rule. Valid values:
        # 
        # *   SYSTEM: system event-triggered alert rule
        # *   CUSTOM: custom event-triggered alert rule
        self.event_type = event_type
        # The ID of the application group.
        self.group_id = group_id
        # The name of the event-triggered alert rule.
        self.name = name
        # The mute period during which new alert notifications are not sent even if the trigger conditions are met.
        self.silence_time = silence_time
        # The status of the event-triggered alert rule. Valid values:
        # 
        # *   ENABLED
        # *   DISABLED
        self.state = state

    def validate(self):
        if self.event_pattern:
            self.event_pattern.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.event_pattern is not None:
            result['EventPattern'] = self.event_pattern.to_map()
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EventPattern') is not None:
            temp_model = DescribeEventRuleListResponseBodyEventRulesEventRuleEventPattern()
            self.event_pattern = temp_model.from_map(m['EventPattern'])
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeEventRuleListResponseBodyEventRules(TeaModel):
    def __init__(
        self,
        event_rule: List[DescribeEventRuleListResponseBodyEventRulesEventRule] = None,
    ):
        self.event_rule = event_rule

    def validate(self):
        if self.event_rule:
            for k in self.event_rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventRule'] = []
        if self.event_rule is not None:
            for k in self.event_rule:
                result['EventRule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.event_rule = []
        if m.get('EventRule') is not None:
            for k in m.get('EventRule'):
                temp_model = DescribeEventRuleListResponseBodyEventRulesEventRule()
                self.event_rule.append(temp_model.from_map(k))
        return self


class DescribeEventRuleListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        event_rules: DescribeEventRuleListResponseBodyEventRules = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        total: int = None,
    ):
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The event-triggered alert rule.
        self.event_rules = event_rules
        # The error message returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.event_rules:
            self.event_rules.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.event_rules is not None:
            result['EventRules'] = self.event_rules.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EventRules') is not None:
            temp_model = DescribeEventRuleListResponseBodyEventRules()
            self.event_rules = temp_model.from_map(m['EventRules'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeEventRuleListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEventRuleListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEventRuleListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEventRuleTargetListRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        rule_name: str = None,
    ):
        self.region_id = region_id
        # The name of the event-triggered alert rule.
        # 
        # This parameter is required.
        self.rule_name = rule_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        return self


class DescribeEventRuleTargetListResponseBodyContactParametersContactParameter(TeaModel):
    def __init__(
        self,
        contact_group_name: str = None,
        id: str = None,
        level: str = None,
    ):
        # The name of the alert group.
        self.contact_group_name = contact_group_name
        # The ID of the recipient.
        self.id = id
        # The alert notification methods. Valid values:
        # 
        # 4: Alert notifications are sent by using DingTalk chatbots and emails.
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_name is not None:
            result['ContactGroupName'] = self.contact_group_name
        if self.id is not None:
            result['Id'] = self.id
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContactGroupName') is not None:
            self.contact_group_name = m.get('ContactGroupName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class DescribeEventRuleTargetListResponseBodyContactParameters(TeaModel):
    def __init__(
        self,
        contact_parameter: List[DescribeEventRuleTargetListResponseBodyContactParametersContactParameter] = None,
    ):
        self.contact_parameter = contact_parameter

    def validate(self):
        if self.contact_parameter:
            for k in self.contact_parameter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ContactParameter'] = []
        if self.contact_parameter is not None:
            for k in self.contact_parameter:
                result['ContactParameter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.contact_parameter = []
        if m.get('ContactParameter') is not None:
            for k in m.get('ContactParameter'):
                temp_model = DescribeEventRuleTargetListResponseBodyContactParametersContactParameter()
                self.contact_parameter.append(temp_model.from_map(k))
        return self


class DescribeEventRuleTargetListResponseBodyFcParametersFCParameter(TeaModel):
    def __init__(
        self,
        arn: str = None,
        function_name: str = None,
        id: str = None,
        region: str = None,
        service_name: str = None,
    ):
        # The Alibaba Cloud Resource Name (ARN) of the function. 
        # 
        # Format: `arn:acs:${Service}:${Region}:${Account}:${ResourceType}/${ResourceId}`. Fields: 
        # 
        # - Service: the code of an Alibaba Cloud service
        # - Region: the region ID
        # - Account: the ID of an Alibaba Cloud account
        # - ResourceType: the resource type
        # - ResourceId: the resource ID
        self.arn = arn
        # The name of the function.
        self.function_name = function_name
        # The ID of the recipient.
        self.id = id
        # The region where Function Compute is deployed.
        self.region = region
        # The name of the Function Compute service.
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.function_name is not None:
            result['FunctionName'] = self.function_name
        if self.id is not None:
            result['Id'] = self.id
        if self.region is not None:
            result['Region'] = self.region
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('FunctionName') is not None:
            self.function_name = m.get('FunctionName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class DescribeEventRuleTargetListResponseBodyFcParameters(TeaModel):
    def __init__(
        self,
        fcparameter: List[DescribeEventRuleTargetListResponseBodyFcParametersFCParameter] = None,
    ):
        self.fcparameter = fcparameter

    def validate(self):
        if self.fcparameter:
            for k in self.fcparameter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FCParameter'] = []
        if self.fcparameter is not None:
            for k in self.fcparameter:
                result['FCParameter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fcparameter = []
        if m.get('FCParameter') is not None:
            for k in m.get('FCParameter'):
                temp_model = DescribeEventRuleTargetListResponseBodyFcParametersFCParameter()
                self.fcparameter.append(temp_model.from_map(k))
        return self


class DescribeEventRuleTargetListResponseBodyMnsParametersMnsParameter(TeaModel):
    def __init__(
        self,
        arn: str = None,
        id: str = None,
        queue: str = None,
        region: str = None,
        topic: str = None,
    ):
        # The ARN of the MNS queue. 
        # 
        # Format: `arn:acs:${Service}:${Region}:${Account}:${ResourceType}/${ResourceId}`. Fields: 
        # 
        # - Service: the code of an Alibaba Cloud service
        # - Region: the region ID
        # - Account: the ID of an Alibaba Cloud account
        # - ResourceType: the resource type
        # - ResourceId: the resource ID
        self.arn = arn
        # The ID of the recipient.
        self.id = id
        # The name of the SMQ queue.
        self.queue = queue
        # The region for SMQ.
        self.region = region
        # The SMQ topic.
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.id is not None:
            result['Id'] = self.id
        if self.queue is not None:
            result['Queue'] = self.queue
        if self.region is not None:
            result['Region'] = self.region
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class DescribeEventRuleTargetListResponseBodyMnsParameters(TeaModel):
    def __init__(
        self,
        mns_parameter: List[DescribeEventRuleTargetListResponseBodyMnsParametersMnsParameter] = None,
    ):
        self.mns_parameter = mns_parameter

    def validate(self):
        if self.mns_parameter:
            for k in self.mns_parameter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MnsParameter'] = []
        if self.mns_parameter is not None:
            for k in self.mns_parameter:
                result['MnsParameter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.mns_parameter = []
        if m.get('MnsParameter') is not None:
            for k in m.get('MnsParameter'):
                temp_model = DescribeEventRuleTargetListResponseBodyMnsParametersMnsParameter()
                self.mns_parameter.append(temp_model.from_map(k))
        return self


class DescribeEventRuleTargetListResponseBodyOpenApiParametersOpenApiParameters(TeaModel):
    def __init__(
        self,
        action: str = None,
        arn: str = None,
        id: str = None,
        product: str = None,
        region: str = None,
        role: str = None,
        version: str = None,
    ):
        # The name of the API operation.
        self.action = action
        # The ARN of the API operation. 
        # 
        # Format: `arn:acs:${Service}:${Region}:${Account}:${ResourceType}/${ResourceId}`. Fields: 
        # 
        # - Service: the code of an Alibaba Cloud service
        # - Region: the region ID
        # - Account: the ID of an Alibaba Cloud account
        # - ResourceType: the resource type
        # - ResourceId: the resource ID The ARN of the Log Service Logstore. 
        # 
        # Format: `arn:acs:${Service}:${Region}:${Account}:${ResourceType}/${ResourceId}`. Fields:
        # - Service: the code of an Alibaba Cloud service
        # - Region: the region ID
        # - Account: the ID of an Alibaba Cloud account
        # - ResourceType: the resource type
        # - ResourceId: the resource ID
        self.arn = arn
        # The ID of the recipient.
        self.id = id
        # The ID of the cloud service to which the API operation belongs.
        self.product = product
        # The region where the resource resides.
        self.region = region
        # The name of the role.
        self.role = role
        # The version of the API.
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.id is not None:
            result['Id'] = self.id
        if self.product is not None:
            result['Product'] = self.product
        if self.region is not None:
            result['Region'] = self.region
        if self.role is not None:
            result['Role'] = self.role
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class DescribeEventRuleTargetListResponseBodyOpenApiParameters(TeaModel):
    def __init__(
        self,
        open_api_parameters: List[DescribeEventRuleTargetListResponseBodyOpenApiParametersOpenApiParameters] = None,
    ):
        self.open_api_parameters = open_api_parameters

    def validate(self):
        if self.open_api_parameters:
            for k in self.open_api_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OpenApiParameters'] = []
        if self.open_api_parameters is not None:
            for k in self.open_api_parameters:
                result['OpenApiParameters'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.open_api_parameters = []
        if m.get('OpenApiParameters') is not None:
            for k in m.get('OpenApiParameters'):
                temp_model = DescribeEventRuleTargetListResponseBodyOpenApiParametersOpenApiParameters()
                self.open_api_parameters.append(temp_model.from_map(k))
        return self


class DescribeEventRuleTargetListResponseBodySlsParametersSlsParameter(TeaModel):
    def __init__(
        self,
        arn: str = None,
        id: str = None,
        log_store: str = None,
        project: str = None,
        region: str = None,
    ):
        # The ARN of the Log Service Logstore. 
        # 
        # Format: `arn:acs:${Service}:${Region}:${Account}:${ResourceType}/${ResourceId}`. Fields: 
        # 
        # - Service: the code of an Alibaba Cloud service
        # - Region: the region ID
        # - Account: the ID of an Alibaba Cloud account
        # - ResourceType: the resource type
        # - ResourceId: the resource ID
        self.arn = arn
        # The ID of the recipient.
        self.id = id
        # The name of the Logstore.
        self.log_store = log_store
        # The name of the project.
        self.project = project
        # The ID of the region where the Log Service project resides.
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.id is not None:
            result['Id'] = self.id
        if self.log_store is not None:
            result['LogStore'] = self.log_store
        if self.project is not None:
            result['Project'] = self.project
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('LogStore') is not None:
            self.log_store = m.get('LogStore')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class DescribeEventRuleTargetListResponseBodySlsParameters(TeaModel):
    def __init__(
        self,
        sls_parameter: List[DescribeEventRuleTargetListResponseBodySlsParametersSlsParameter] = None,
    ):
        self.sls_parameter = sls_parameter

    def validate(self):
        if self.sls_parameter:
            for k in self.sls_parameter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SlsParameter'] = []
        if self.sls_parameter is not None:
            for k in self.sls_parameter:
                result['SlsParameter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.sls_parameter = []
        if m.get('SlsParameter') is not None:
            for k in m.get('SlsParameter'):
                temp_model = DescribeEventRuleTargetListResponseBodySlsParametersSlsParameter()
                self.sls_parameter.append(temp_model.from_map(k))
        return self


class DescribeEventRuleTargetListResponseBodyWebhookParametersWebhookParameter(TeaModel):
    def __init__(
        self,
        id: str = None,
        method: str = None,
        protocol: str = None,
        url: str = None,
    ):
        # The ID of the recipient.
        self.id = id
        # The HTTP request method. Valid values: GET and POST.
        self.method = method
        # The protocol type.
        self.protocol = protocol
        # The callback URL.
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.method is not None:
            result['Method'] = self.method
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class DescribeEventRuleTargetListResponseBodyWebhookParameters(TeaModel):
    def __init__(
        self,
        webhook_parameter: List[DescribeEventRuleTargetListResponseBodyWebhookParametersWebhookParameter] = None,
    ):
        self.webhook_parameter = webhook_parameter

    def validate(self):
        if self.webhook_parameter:
            for k in self.webhook_parameter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['WebhookParameter'] = []
        if self.webhook_parameter is not None:
            for k in self.webhook_parameter:
                result['WebhookParameter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.webhook_parameter = []
        if m.get('WebhookParameter') is not None:
            for k in m.get('WebhookParameter'):
                temp_model = DescribeEventRuleTargetListResponseBodyWebhookParametersWebhookParameter()
                self.webhook_parameter.append(temp_model.from_map(k))
        return self


class DescribeEventRuleTargetListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        contact_parameters: DescribeEventRuleTargetListResponseBodyContactParameters = None,
        fc_parameters: DescribeEventRuleTargetListResponseBodyFcParameters = None,
        message: str = None,
        mns_parameters: DescribeEventRuleTargetListResponseBodyMnsParameters = None,
        open_api_parameters: DescribeEventRuleTargetListResponseBodyOpenApiParameters = None,
        request_id: str = None,
        sls_parameters: DescribeEventRuleTargetListResponseBodySlsParameters = None,
        webhook_parameters: DescribeEventRuleTargetListResponseBodyWebhookParameters = None,
    ):
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the call was successful.
        self.code = code
        # The information about the recipients if alert notifications are sent to the alert contacts of an alert contact group.
        self.contact_parameters = contact_parameters
        # The information about the recipients in Function Compute.
        self.fc_parameters = fc_parameters
        # The error message.
        self.message = message
        # The notifications of Simple Message Queue (formerly MNS) (SMQ).
        self.mns_parameters = mns_parameters
        # The information about the recipients in OpenAPI Explorer.
        self.open_api_parameters = open_api_parameters
        # The ID of the request.
        self.request_id = request_id
        # The information about the recipients in Log Service.
        self.sls_parameters = sls_parameters
        # The information about the recipients if alert notifications are sent by sending a request to a callback URL.
        self.webhook_parameters = webhook_parameters

    def validate(self):
        if self.contact_parameters:
            self.contact_parameters.validate()
        if self.fc_parameters:
            self.fc_parameters.validate()
        if self.mns_parameters:
            self.mns_parameters.validate()
        if self.open_api_parameters:
            self.open_api_parameters.validate()
        if self.sls_parameters:
            self.sls_parameters.validate()
        if self.webhook_parameters:
            self.webhook_parameters.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.contact_parameters is not None:
            result['ContactParameters'] = self.contact_parameters.to_map()
        if self.fc_parameters is not None:
            result['FcParameters'] = self.fc_parameters.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.mns_parameters is not None:
            result['MnsParameters'] = self.mns_parameters.to_map()
        if self.open_api_parameters is not None:
            result['OpenApiParameters'] = self.open_api_parameters.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sls_parameters is not None:
            result['SlsParameters'] = self.sls_parameters.to_map()
        if self.webhook_parameters is not None:
            result['WebhookParameters'] = self.webhook_parameters.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ContactParameters') is not None:
            temp_model = DescribeEventRuleTargetListResponseBodyContactParameters()
            self.contact_parameters = temp_model.from_map(m['ContactParameters'])
        if m.get('FcParameters') is not None:
            temp_model = DescribeEventRuleTargetListResponseBodyFcParameters()
            self.fc_parameters = temp_model.from_map(m['FcParameters'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MnsParameters') is not None:
            temp_model = DescribeEventRuleTargetListResponseBodyMnsParameters()
            self.mns_parameters = temp_model.from_map(m['MnsParameters'])
        if m.get('OpenApiParameters') is not None:
            temp_model = DescribeEventRuleTargetListResponseBodyOpenApiParameters()
            self.open_api_parameters = temp_model.from_map(m['OpenApiParameters'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SlsParameters') is not None:
            temp_model = DescribeEventRuleTargetListResponseBodySlsParameters()
            self.sls_parameters = temp_model.from_map(m['SlsParameters'])
        if m.get('WebhookParameters') is not None:
            temp_model = DescribeEventRuleTargetListResponseBodyWebhookParameters()
            self.webhook_parameters = temp_model.from_map(m['WebhookParameters'])
        return self


class DescribeEventRuleTargetListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEventRuleTargetListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEventRuleTargetListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExporterOutputListRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
    ):
        # The page number. Default value: 1.
        self.page_number = page_number
        # The number of entries per page. Default value: 10.
        self.page_size = page_size
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeExporterOutputListResponseBodyDatapointsDatapointConfigJson(TeaModel):
    def __init__(
        self,
        ak: str = None,
        endpoint: str = None,
        logstore: str = None,
        project: str = None,
    ):
        # The AccessKey ID.
        self.ak = ak
        # The Log Service endpoint to which the monitoring data is exported.
        self.endpoint = endpoint
        # The Logstore.
        self.logstore = logstore
        # The Log Service project to which the monitoring data is exported.
        self.project = project

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ak is not None:
            result['ak'] = self.ak
        if self.endpoint is not None:
            result['endpoint'] = self.endpoint
        if self.logstore is not None:
            result['logstore'] = self.logstore
        if self.project is not None:
            result['project'] = self.project
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ak') is not None:
            self.ak = m.get('ak')
        if m.get('endpoint') is not None:
            self.endpoint = m.get('endpoint')
        if m.get('logstore') is not None:
            self.logstore = m.get('logstore')
        if m.get('project') is not None:
            self.project = m.get('project')
        return self


class DescribeExporterOutputListResponseBodyDatapointsDatapoint(TeaModel):
    def __init__(
        self,
        config_json: DescribeExporterOutputListResponseBodyDatapointsDatapointConfigJson = None,
        create_time: int = None,
        dest_name: str = None,
        dest_type: str = None,
    ):
        # The JSON object that contains the details about the destination to which the monitoring data is exported.
        self.config_json = config_json
        # The time when the configuration set was created. The value is a UNIX timestamp.
        self.create_time = create_time
        # The name of the configuration set.
        self.dest_name = dest_name
        # The service to which the monitoring data is exported.
        # 
        # > Only Log Service is supported. More services will be supported in the future.
        self.dest_type = dest_type

    def validate(self):
        if self.config_json:
            self.config_json.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_json is not None:
            result['ConfigJson'] = self.config_json.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.dest_name is not None:
            result['DestName'] = self.dest_name
        if self.dest_type is not None:
            result['DestType'] = self.dest_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigJson') is not None:
            temp_model = DescribeExporterOutputListResponseBodyDatapointsDatapointConfigJson()
            self.config_json = temp_model.from_map(m['ConfigJson'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DestName') is not None:
            self.dest_name = m.get('DestName')
        if m.get('DestType') is not None:
            self.dest_type = m.get('DestType')
        return self


class DescribeExporterOutputListResponseBodyDatapoints(TeaModel):
    def __init__(
        self,
        datapoint: List[DescribeExporterOutputListResponseBodyDatapointsDatapoint] = None,
    ):
        self.datapoint = datapoint

    def validate(self):
        if self.datapoint:
            for k in self.datapoint:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Datapoint'] = []
        if self.datapoint is not None:
            for k in self.datapoint:
                result['Datapoint'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.datapoint = []
        if m.get('Datapoint') is not None:
            for k in m.get('Datapoint'):
                temp_model = DescribeExporterOutputListResponseBodyDatapointsDatapoint()
                self.datapoint.append(temp_model.from_map(k))
        return self


class DescribeExporterOutputListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        datapoints: DescribeExporterOutputListResponseBodyDatapoints = None,
        message: str = None,
        page_number: int = None,
        request_id: str = None,
        success: bool = None,
        total: int = None,
    ):
        # The HTTP status code.
        # 
        # > The status code 200 indicates that the request was successful. Other status codes indicate that the request failed.
        self.code = code
        # The configuration sets for exporting monitoring data.
        self.datapoints = datapoints
        # The returned message.
        self.message = message
        # The page number of the returned page.
        self.page_number = page_number
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`
        # *   `false`
        self.success = success
        # The total number of returned entries.
        self.total = total

    def validate(self):
        if self.datapoints:
            self.datapoints.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            temp_model = DescribeExporterOutputListResponseBodyDatapoints()
            self.datapoints = temp_model.from_map(m['Datapoints'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeExporterOutputListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeExporterOutputListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExporterOutputListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExporterRuleListRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
    ):
        # The page number. Default value: 1.
        self.page_number = page_number
        # The number of entries per page. Default value: 1000.
        self.page_size = page_size
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeExporterRuleListResponseBodyDatapointsDatapointDstName(TeaModel):
    def __init__(
        self,
        dst_name: List[str] = None,
    ):
        self.dst_name = dst_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_name is not None:
            result['DstName'] = self.dst_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DstName') is not None:
            self.dst_name = m.get('DstName')
        return self


class DescribeExporterRuleListResponseBodyDatapointsDatapoint(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        describe: str = None,
        dimension: str = None,
        dst_name: DescribeExporterRuleListResponseBodyDatapointsDatapointDstName = None,
        enabled: bool = None,
        metric_name: str = None,
        namespace: str = None,
        rule_name: str = None,
        target_windows: str = None,
    ):
        # The time when the rule was created. The value is a UNIX timestamp.
        self.create_time = create_time
        # The description of the rule.
        self.describe = describe
        # The associated dimensions.
        self.dimension = dimension
        self.dst_name = dst_name
        # Indicates whether the rule is enabled.
        self.enabled = enabled
        # The name of the metric.
        # 
        # > For more information, see [DescribeMetricMetaList](https://help.aliyun.com/document_detail/98846.html) or [Appendix 1: Metrics](https://help.aliyun.com/document_detail/28619.html).
        self.metric_name = metric_name
        # The namespace of the service.
        # 
        # > For more information, see [DescribeMetricMetaList](https://help.aliyun.com/document_detail/98846.html) or [Appendix 1: Metrics](https://help.aliyun.com/document_detail/28619.html).
        self.namespace = namespace
        # The name of the data export rule.
        self.rule_name = rule_name
        # The time window of the exported data.\\
        # Multiple windows are separated with commas (,).
        # 
        # > Data in a time window of less than 60 seconds cannot be exported.
        self.target_windows = target_windows

    def validate(self):
        if self.dst_name:
            self.dst_name.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.describe is not None:
            result['Describe'] = self.describe
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        if self.dst_name is not None:
            result['DstName'] = self.dst_name.to_map()
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.target_windows is not None:
            result['TargetWindows'] = self.target_windows
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Describe') is not None:
            self.describe = m.get('Describe')
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        if m.get('DstName') is not None:
            temp_model = DescribeExporterRuleListResponseBodyDatapointsDatapointDstName()
            self.dst_name = temp_model.from_map(m['DstName'])
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('TargetWindows') is not None:
            self.target_windows = m.get('TargetWindows')
        return self


class DescribeExporterRuleListResponseBodyDatapoints(TeaModel):
    def __init__(
        self,
        datapoint: List[DescribeExporterRuleListResponseBodyDatapointsDatapoint] = None,
    ):
        self.datapoint = datapoint

    def validate(self):
        if self.datapoint:
            for k in self.datapoint:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Datapoint'] = []
        if self.datapoint is not None:
            for k in self.datapoint:
                result['Datapoint'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.datapoint = []
        if m.get('Datapoint') is not None:
            for k in m.get('Datapoint'):
                temp_model = DescribeExporterRuleListResponseBodyDatapointsDatapoint()
                self.datapoint.append(temp_model.from_map(k))
        return self


class DescribeExporterRuleListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        datapoints: DescribeExporterRuleListResponseBodyDatapoints = None,
        message: str = None,
        page_number: int = None,
        request_id: str = None,
        success: bool = None,
        total: int = None,
    ):
        # The HTTP status code.
        # 
        # > The status code 200 indicates that the request was successful. Other status codes indicate that the request failed.
        self.code = code
        # The details of the data export rules.
        self.datapoints = datapoints
        # The returned message.
        self.message = message
        # The page number of the returned page.
        self.page_number = page_number
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`
        # *   `false`
        self.success = success
        # The total number of returned entries.
        self.total = total

    def validate(self):
        if self.datapoints:
            self.datapoints.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            temp_model = DescribeExporterRuleListResponseBodyDatapoints()
            self.datapoints = temp_model.from_map(m['Datapoints'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeExporterRuleListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeExporterRuleListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExporterRuleListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupMonitoringAgentProcessRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        page_number: int = None,
        page_size: int = None,
        process_name: str = None,
        region_id: str = None,
    ):
        # The ID of the application group.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The page number. Default value: 1
        self.page_number = page_number
        # The number of entries per page. Default value: 10.
        self.page_size = page_size
        # The process name.
        self.process_name = process_name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfigAlertConfigTargetListTarget(TeaModel):
    def __init__(
        self,
        arn: str = None,
        id: str = None,
        json_parmas: str = None,
        level: str = None,
    ):
        # The Alibaba Cloud Resource Name (ARN) of the resource. Format: acs:{Service name abbreviation}:{regionId}:{userId}:/{Resource type}/{Resource name}/message. Example: acs:mns:cn-hangzhou:120886317861\\*\\*\\*\\*:/queues/test123/message. Fields:
        # 
        # *   {Service name abbreviation}: the abbreviation of the service name. Set the value to Simple Message Queue (formerly MNS) (SMQ).
        # 
        # *   {userId}: the ID of the Alibaba Cloud account.
        # 
        # *   {regionId}: the region ID of the SMQ queue or topic.
        # 
        # *   {Resource type}: the type of the resource for which alerts are triggered. Valid values:
        # 
        #     *   **queues**\
        #     *   **topics**\
        # 
        # *   {Resource name}: the resource name.
        # 
        #     *   If the resource type is **queues**, the resource name is the queue name.
        #     *   If the resource type is **topics**, the resource name is the topic name.
        self.arn = arn
        # The ID of the resource for which alerts are triggered.
        self.id = id
        # The parameters of the alert callback. The parameters are in the JSON format.
        self.json_parmas = json_parmas
        # The alert level. Valid values:
        # 
        # *   INFO
        # *   WARN
        # *   CRITICAL
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.id is not None:
            result['Id'] = self.id
        if self.json_parmas is not None:
            result['JsonParmas'] = self.json_parmas
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('JsonParmas') is not None:
            self.json_parmas = m.get('JsonParmas')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfigAlertConfigTargetList(TeaModel):
    def __init__(
        self,
        target: List[DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfigAlertConfigTargetListTarget] = None,
    ):
        self.target = target

    def validate(self):
        if self.target:
            for k in self.target:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Target'] = []
        if self.target is not None:
            for k in self.target:
                result['Target'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.target = []
        if m.get('Target') is not None:
            for k in m.get('Target'):
                temp_model = DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfigAlertConfigTargetListTarget()
                self.target.append(temp_model.from_map(k))
        return self


class DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfigAlertConfig(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        effective_interval: str = None,
        escalations_level: str = None,
        no_effective_interval: str = None,
        silence_time: str = None,
        statistics: str = None,
        target_list: DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfigAlertConfigTargetList = None,
        threshold: str = None,
        times: str = None,
        webhook: str = None,
    ):
        # The comparison operator that is used to compare the metric value with the threshold. Valid values:
        # 
        # *   GreaterThanOrEqualToThreshold: greater than or equal to the threshold
        # *   GreaterThanThreshold: greater than the threshold
        # *   LessThanOrEqualToThreshold: less than or equal to the threshold
        # *   LessThanThreshold: less than the threshold
        # *   NotEqualToThreshold: not equal to the threshold
        # *   GreaterThanYesterday: greater than the metric value at the same time yesterday.
        # *   LessThanYesterday: less than the metric value at the same time yesterday
        # *   GreaterThanLastWeek: greater than the metric value at the same time last week
        # *   LessThanLastWeek: less than the metric value at the same time last week
        # *   GreaterThanLastPeriod: greater than the metric value in the last monitoring cycle
        # *   LessThanLastPeriod: less than the metric value in the last monitoring cycle
        self.comparison_operator = comparison_operator
        # The time period during which the alert rule is effective.
        self.effective_interval = effective_interval
        # The level of the alert. Valid values:
        # 
        # *   critical
        # *   warn
        # *   Info
        self.escalations_level = escalations_level
        # The time period during which the alert rule is ineffective.
        self.no_effective_interval = no_effective_interval
        # The mute period during which new alert notifications are not sent even if the trigger conditions are met. Unit: seconds. Minimum value: 3600, which is equivalent to one hour. Default value: 86400, which is equivalent to one day.
        # 
        # >  Only one alert notification is sent during each mute period even if the metric value exceeds the alert threshold several times.
        self.silence_time = silence_time
        # The method used to calculate metric values that trigger alerts.
        self.statistics = statistics
        # The resources for which alerts are triggered.
        self.target_list = target_list
        # The alert threshold.
        self.threshold = threshold
        # The number of times for which the threshold can be consecutively exceeded.
        # 
        # >  A metric triggers an alert only after the metric value reaches the threshold consecutively for the specified times.
        self.times = times
        # The callback URL to which a POST request is sent when an alert is triggered based on the alert rule.
        self.webhook = webhook

    def validate(self):
        if self.target_list:
            self.target_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.effective_interval is not None:
            result['EffectiveInterval'] = self.effective_interval
        if self.escalations_level is not None:
            result['EscalationsLevel'] = self.escalations_level
        if self.no_effective_interval is not None:
            result['NoEffectiveInterval'] = self.no_effective_interval
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.target_list is not None:
            result['TargetList'] = self.target_list.to_map()
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('EffectiveInterval') is not None:
            self.effective_interval = m.get('EffectiveInterval')
        if m.get('EscalationsLevel') is not None:
            self.escalations_level = m.get('EscalationsLevel')
        if m.get('NoEffectiveInterval') is not None:
            self.no_effective_interval = m.get('NoEffectiveInterval')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('TargetList') is not None:
            temp_model = DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfigAlertConfigTargetList()
            self.target_list = temp_model.from_map(m['TargetList'])
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfig(TeaModel):
    def __init__(
        self,
        alert_config: List[DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfigAlertConfig] = None,
    ):
        self.alert_config = alert_config

    def validate(self):
        if self.alert_config:
            for k in self.alert_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertConfig'] = []
        if self.alert_config is not None:
            for k in self.alert_config:
                result['AlertConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert_config = []
        if m.get('AlertConfig') is not None:
            for k in m.get('AlertConfig'):
                temp_model = DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfigAlertConfig()
                self.alert_config.append(temp_model.from_map(k))
        return self


class DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessMatchExpressMatchExpress(TeaModel):
    def __init__(
        self,
        function: str = None,
        name: str = None,
        value: str = None,
    ):
        # The matching condition. Valid values:
        # 
        # *   all (default): matches all
        # *   startWith: starts with a prefix
        # *   endWith: ends with a suffix
        # *   contains: contains
        # *   notContains: excludes
        # *   equals: equals
        # 
        # >  The matched instances are monitored by the process monitoring task.
        self.function = function
        # The criteria based on which the instances are matched.
        # 
        # >  Set the value to `name`. The value name indicates that the instances are matched based on the instance name.
        self.name = name
        # The keyword used to match the instance name.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function is not None:
            result['Function'] = self.function
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Function') is not None:
            self.function = m.get('Function')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessMatchExpress(TeaModel):
    def __init__(
        self,
        match_express: List[DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessMatchExpressMatchExpress] = None,
    ):
        self.match_express = match_express

    def validate(self):
        if self.match_express:
            for k in self.match_express:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MatchExpress'] = []
        if self.match_express is not None:
            for k in self.match_express:
                result['MatchExpress'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.match_express = []
        if m.get('MatchExpress') is not None:
            for k in m.get('MatchExpress'):
                temp_model = DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessMatchExpressMatchExpress()
                self.match_express.append(temp_model.from_map(k))
        return self


class DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcess(TeaModel):
    def __init__(
        self,
        alert_config: DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfig = None,
        group_id: str = None,
        id: str = None,
        match_express: DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessMatchExpress = None,
        match_express_filter_relation: str = None,
        process_name: str = None,
    ):
        # The alert rule configurations.
        self.alert_config = alert_config
        # The ID of the application group.
        self.group_id = group_id
        # The ID of the process monitoring task.
        self.id = id
        # The matching conditions.
        # 
        # >  Only the instances that meet the conditional expressions are monitored by the process monitoring task.
        self.match_express = match_express
        # The logical operator used between conditional expressions that are used to match instances. Valid values:
        # 
        # *   all
        # *   and
        # *   or
        self.match_express_filter_relation = match_express_filter_relation
        # The process name.
        self.process_name = process_name

    def validate(self):
        if self.alert_config:
            self.alert_config.validate()
        if self.match_express:
            self.match_express.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_config is not None:
            result['AlertConfig'] = self.alert_config.to_map()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.id is not None:
            result['Id'] = self.id
        if self.match_express is not None:
            result['MatchExpress'] = self.match_express.to_map()
        if self.match_express_filter_relation is not None:
            result['MatchExpressFilterRelation'] = self.match_express_filter_relation
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertConfig') is not None:
            temp_model = DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfig()
            self.alert_config = temp_model.from_map(m['AlertConfig'])
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MatchExpress') is not None:
            temp_model = DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessMatchExpress()
            self.match_express = temp_model.from_map(m['MatchExpress'])
        if m.get('MatchExpressFilterRelation') is not None:
            self.match_express_filter_relation = m.get('MatchExpressFilterRelation')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        return self


class DescribeGroupMonitoringAgentProcessResponseBodyProcesses(TeaModel):
    def __init__(
        self,
        process: List[DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcess] = None,
    ):
        self.process = process

    def validate(self):
        if self.process:
            for k in self.process:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Process'] = []
        if self.process is not None:
            for k in self.process:
                result['Process'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.process = []
        if m.get('Process') is not None:
            for k in m.get('Process'):
                temp_model = DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcess()
                self.process.append(temp_model.from_map(k))
        return self


class DescribeGroupMonitoringAgentProcessResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        page_number: str = None,
        page_size: str = None,
        processes: DescribeGroupMonitoringAgentProcessResponseBodyProcesses = None,
        request_id: str = None,
        success: bool = None,
        total: str = None,
    ):
        # The HTTP status codes.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The page number. Default value: 1
        self.page_number = page_number
        # The number of entries per page. Default value: 10.
        self.page_size = page_size
        # The process monitoring tasks.
        self.processes = processes
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values: Valid values: true and false.
        self.success = success
        # The total number of returned entries.
        self.total = total

    def validate(self):
        if self.processes:
            self.processes.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.processes is not None:
            result['Processes'] = self.processes.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Processes') is not None:
            temp_model = DescribeGroupMonitoringAgentProcessResponseBodyProcesses()
            self.processes = temp_model.from_map(m['Processes'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeGroupMonitoringAgentProcessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGroupMonitoringAgentProcessResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGroupMonitoringAgentProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHostAvailabilityListRequest(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        id: int = None,
        ids: str = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        task_name: str = None,
    ):
        # The ID of the application group.
        self.group_id = group_id
        # The ID of the availability monitoring task.
        self.id = id
        # The IDs of the availability monitoring tasks. Separate multiple IDs with commas (,).
        self.ids = ids
        # The page number.
        # 
        # Pages start from page 1. Default value: 1.
        self.page_number = page_number
        # The number of entries per page.
        # 
        # Minimum value: 1. Default value: 10
        self.page_size = page_size
        self.region_id = region_id
        # The name of the availability monitoring task.
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.id is not None:
            result['Id'] = self.id
        if self.ids is not None:
            result['Ids'] = self.ids
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigEscalationListEscalationList(TeaModel):
    def __init__(
        self,
        aggregate: str = None,
        metric_name: str = None,
        operator: str = None,
        times: str = None,
        value: str = None,
    ):
        # The method used to calculate metric values that trigger alerts. Valid values:
        # 
        # *   Value: the value of the HTTP status code
        # *   Average: the average HTTP response time
        # *   Value: the value of the Telnet status code
        # *   TelnetLatency: the average Telnet response time
        # *   Average: the average Ping packet loss rate
        self.aggregate = aggregate
        # The name of the metric. Valid values:
        # 
        # *   HttpStatus
        # *   HttpLatency
        # *   TelnetStatus
        # *   TelnetLatency
        # *   PingLostRate
        self.metric_name = metric_name
        # The comparison operator that is used in the alert rule. Valid values:
        # 
        # *   `>`
        # *   `>=`
        # *   `<`
        # *   `<=`
        # *   `=`
        self.operator = operator
        # The consecutive number of times for which the metric value is measured before an alert is triggered.
        self.times = times
        # The alert threshold.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregate is not None:
            result['Aggregate'] = self.aggregate
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.times is not None:
            result['Times'] = self.times
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Aggregate') is not None:
            self.aggregate = m.get('Aggregate')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigEscalationList(TeaModel):
    def __init__(
        self,
        escalation_list: List[DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigEscalationListEscalationList] = None,
    ):
        self.escalation_list = escalation_list

    def validate(self):
        if self.escalation_list:
            for k in self.escalation_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['escalationList'] = []
        if self.escalation_list is not None:
            for k in self.escalation_list:
                result['escalationList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.escalation_list = []
        if m.get('escalationList') is not None:
            for k in m.get('escalationList'):
                temp_model = DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigEscalationListEscalationList()
                self.escalation_list.append(temp_model.from_map(k))
        return self


class DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigTargetListTarget(TeaModel):
    def __init__(
        self,
        arn: str = None,
        id: str = None,
        json_params: str = None,
        level: str = None,
    ):
        # The Alibaba Cloud Resource Name (ARN) of the function.
        # 
        # Format: `arn:acs:${Service}:${Region}:${Account}:${ResourceType}/${ResourceId}`. Fields:
        # 
        # *   Service: the service code
        # *   Region: the region ID
        # *   Account: the ID of the Alibaba Cloud account
        # *   ResourceType: the resource type
        # *   ResourceId: the resource ID.
        self.arn = arn
        # The ID of the resource that triggers the alert.
        self.id = id
        # The JSON-formatted parameters of the alert callback.
        self.json_params = json_params
        # The alert level. Valid values:
        # 
        # *   INFO
        # *   WARN
        # *   CRITICAL
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.id is not None:
            result['Id'] = self.id
        if self.json_params is not None:
            result['JsonParams'] = self.json_params
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('JsonParams') is not None:
            self.json_params = m.get('JsonParams')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigTargetList(TeaModel):
    def __init__(
        self,
        target: List[DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigTargetListTarget] = None,
    ):
        self.target = target

    def validate(self):
        if self.target:
            for k in self.target:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Target'] = []
        if self.target is not None:
            for k in self.target:
                result['Target'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.target = []
        if m.get('Target') is not None:
            for k in m.get('Target'):
                temp_model = DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigTargetListTarget()
                self.target.append(temp_model.from_map(k))
        return self


class DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfig(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        escalation_list: DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigEscalationList = None,
        notify_type: int = None,
        silence_time: int = None,
        start_time: int = None,
        target_list: DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigTargetList = None,
        web_hook: str = None,
    ):
        # The end of the time period during which the alert rule is effective. Valid values: 0 to 23.
        # 
        # For example, if the `AlertConfig.StartTime` parameter is set to 0 and the `AlertConfig.EndTime` parameter is set to 22, the alert rule is effective from 00:00:00 to 22:00:00.
        # 
        # >  Alert notifications are sent based on the specified threshold only if the alert rule is effective.
        self.end_time = end_time
        # The trigger conditions of the alert rule.
        self.escalation_list = escalation_list
        # The alert notification methods. Valid values:
        # 
        # *   2: Alert notifications are sent by using emails and DingTalk chatbots.
        # *   1: Alert notifications are sent by using emails and DingTalk chatbots.
        # *   0: Alert notifications are sent by using emails and DingTalk chatbots.
        self.notify_type = notify_type
        # The mute period during which new alerts are not sent even if the trigger conditions are met. Unit: seconds. Default value: 86400.
        self.silence_time = silence_time
        # The beginning of the time period during which the alert rule is effective. Valid values: 0 to 23.
        # 
        # For example, if the `AlertConfig.StartTime` parameter is set to 0 and the `AlertConfig.EndTime` parameter is set to 22, the alert rule is effective from 00:00:00 to 22:00:00.
        # 
        # >  Alert notifications are sent based on the specified threshold only if the alert rule is effective.
        self.start_time = start_time
        # The monitored resources.
        self.target_list = target_list
        # The callback URL.
        # 
        # CloudMonitor pushes an alert notification to the specified callback URL by sending an HTTP POST request. Only the HTTP protocol is supported.
        self.web_hook = web_hook

    def validate(self):
        if self.escalation_list:
            self.escalation_list.validate()
        if self.target_list:
            self.target_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.escalation_list is not None:
            result['EscalationList'] = self.escalation_list.to_map()
        if self.notify_type is not None:
            result['NotifyType'] = self.notify_type
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.target_list is not None:
            result['TargetList'] = self.target_list.to_map()
        if self.web_hook is not None:
            result['WebHook'] = self.web_hook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EscalationList') is not None:
            temp_model = DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigEscalationList()
            self.escalation_list = temp_model.from_map(m['EscalationList'])
        if m.get('NotifyType') is not None:
            self.notify_type = m.get('NotifyType')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TargetList') is not None:
            temp_model = DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigTargetList()
            self.target_list = temp_model.from_map(m['TargetList'])
        if m.get('WebHook') is not None:
            self.web_hook = m.get('WebHook')
        return self


class DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigInstances(TeaModel):
    def __init__(
        self,
        instance: List[str] = None,
    ):
        self.instance = instance

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance is not None:
            result['Instance'] = self.instance
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Instance') is not None:
            self.instance = m.get('Instance')
        return self


class DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigTaskOption(TeaModel):
    def __init__(
        self,
        http_keyword: str = None,
        http_method: str = None,
        http_negative: bool = None,
        http_post_content: str = None,
        http_response_charset: str = None,
        http_uri: str = None,
        interval: int = None,
        telnet_or_ping_host: str = None,
    ):
        # The response to the HTTP request.
        self.http_keyword = http_keyword
        # The HTTP request method. Valid values:
        # 
        # *   GET
        # *   POST
        # *   HEAD
        self.http_method = http_method
        # The method to trigger an alert. The alert can be triggered based on whether the specified alert rule is included in the response body. Valid values:
        # 
        # *   true: If the HTTP response body includes the alert rule, an alert is triggered.
        # *   false: If the HTTP response does not include the alert rule, an alert is triggered.
        self.http_negative = http_negative
        # The content of the HTTP POST request.
        self.http_post_content = http_post_content
        # The character set that is used in the HTTP response.
        self.http_response_charset = http_response_charset
        # The URI that you want to monitor. If the TaskType parameter is set to HTTP, this parameter is required.
        self.http_uri = http_uri
        # The interval at which detection requests are sent. Unit: seconds.
        self.interval = interval
        # The domain name or IP address that you want to monitor.
        self.telnet_or_ping_host = telnet_or_ping_host

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_keyword is not None:
            result['HttpKeyword'] = self.http_keyword
        if self.http_method is not None:
            result['HttpMethod'] = self.http_method
        if self.http_negative is not None:
            result['HttpNegative'] = self.http_negative
        if self.http_post_content is not None:
            result['HttpPostContent'] = self.http_post_content
        if self.http_response_charset is not None:
            result['HttpResponseCharset'] = self.http_response_charset
        if self.http_uri is not None:
            result['HttpURI'] = self.http_uri
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.telnet_or_ping_host is not None:
            result['TelnetOrPingHost'] = self.telnet_or_ping_host
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpKeyword') is not None:
            self.http_keyword = m.get('HttpKeyword')
        if m.get('HttpMethod') is not None:
            self.http_method = m.get('HttpMethod')
        if m.get('HttpNegative') is not None:
            self.http_negative = m.get('HttpNegative')
        if m.get('HttpPostContent') is not None:
            self.http_post_content = m.get('HttpPostContent')
        if m.get('HttpResponseCharset') is not None:
            self.http_response_charset = m.get('HttpResponseCharset')
        if m.get('HttpURI') is not None:
            self.http_uri = m.get('HttpURI')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('TelnetOrPingHost') is not None:
            self.telnet_or_ping_host = m.get('TelnetOrPingHost')
        return self


class DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfig(TeaModel):
    def __init__(
        self,
        alert_config: DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfig = None,
        disabled: bool = None,
        group_id: int = None,
        group_name: str = None,
        id: int = None,
        instances: DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigInstances = None,
        task_name: str = None,
        task_option: DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigTaskOption = None,
        task_scope: str = None,
        task_type: str = None,
    ):
        # The configurations of the alert rule.
        self.alert_config = alert_config
        # Indicates whether the availability monitoring task is disabled. Valid values:
        # 
        # *   true: The availability monitoring task is disabled.
        # *   false: The availability monitoring task is enabled.
        self.disabled = disabled
        # The ID of the application group.
        self.group_id = group_id
        # The name of the application group.
        self.group_name = group_name
        # The ID of the availability monitoring task.
        self.id = id
        # The ECS instances that are monitored.
        self.instances = instances
        # The name of the availability monitoring task.
        self.task_name = task_name
        # The optional parameters of the availability monitoring task.
        self.task_option = task_option
        # The range of instances that are monitored by the availability monitoring task. Valid values:
        # 
        # *   GROUP: All ECS instances in the application group are monitored.
        # *   GROUP_SPEC_INSTANCE: Specified ECS instances in the application group are monitored.
        self.task_scope = task_scope
        # The task type. Valid values:
        # 
        # *   PING
        # *   TELNET
        # *   HTTP
        self.task_type = task_type

    def validate(self):
        if self.alert_config:
            self.alert_config.validate()
        if self.instances:
            self.instances.validate()
        if self.task_option:
            self.task_option.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_config is not None:
            result['AlertConfig'] = self.alert_config.to_map()
        if self.disabled is not None:
            result['Disabled'] = self.disabled
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.id is not None:
            result['Id'] = self.id
        if self.instances is not None:
            result['Instances'] = self.instances.to_map()
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_option is not None:
            result['TaskOption'] = self.task_option.to_map()
        if self.task_scope is not None:
            result['TaskScope'] = self.task_scope
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertConfig') is not None:
            temp_model = DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfig()
            self.alert_config = temp_model.from_map(m['AlertConfig'])
        if m.get('Disabled') is not None:
            self.disabled = m.get('Disabled')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Instances') is not None:
            temp_model = DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigInstances()
            self.instances = temp_model.from_map(m['Instances'])
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskOption') is not None:
            temp_model = DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigTaskOption()
            self.task_option = temp_model.from_map(m['TaskOption'])
        if m.get('TaskScope') is not None:
            self.task_scope = m.get('TaskScope')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeHostAvailabilityListResponseBodyTaskList(TeaModel):
    def __init__(
        self,
        node_task_config: List[DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfig] = None,
    ):
        self.node_task_config = node_task_config

    def validate(self):
        if self.node_task_config:
            for k in self.node_task_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NodeTaskConfig'] = []
        if self.node_task_config is not None:
            for k in self.node_task_config:
                result['NodeTaskConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.node_task_config = []
        if m.get('NodeTaskConfig') is not None:
            for k in m.get('NodeTaskConfig'):
                temp_model = DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfig()
                self.node_task_config.append(temp_model.from_map(k))
        return self


class DescribeHostAvailabilityListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        task_list: DescribeHostAvailabilityListResponseBodyTaskList = None,
        total: int = None,
    ):
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success
        # The details of the availability monitoring tasks.
        self.task_list = task_list
        # The total number of returned entries.
        self.total = total

    def validate(self):
        if self.task_list:
            self.task_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_list is not None:
            result['TaskList'] = self.task_list.to_map()
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskList') is not None:
            temp_model = DescribeHostAvailabilityListResponseBodyTaskList()
            self.task_list = temp_model.from_map(m['TaskList'])
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeHostAvailabilityListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHostAvailabilityListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHostAvailabilityListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHybridMonitorDataListRequest(TeaModel):
    def __init__(
        self,
        end: int = None,
        namespace: str = None,
        period: str = None,
        prom_sql: str = None,
        region_id: str = None,
        start: int = None,
    ):
        # The end of the time range to query.
        # 
        # Unit: seconds.
        # 
        # This parameter is required.
        self.end = end
        # The name of the namespace.
        # 
        # For more information about how to query the names of namespaces, see [DescribeHybridMonitorNamespaceList](https://help.aliyun.com/document_detail/428880.html).
        # 
        # This parameter is required.
        self.namespace = namespace
        # The statistical period of the monitoring data.
        # 
        # Unit: seconds.
        self.period = period
        # The metric name.
        # 
        # >  PromQL statements are supported.
        # 
        # This parameter is required.
        self.prom_sql = prom_sql
        self.region_id = region_id
        # The start of the time range to query.
        # 
        # Unit: seconds.
        # 
        # This parameter is required.
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['End'] = self.end
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.period is not None:
            result['Period'] = self.period
        if self.prom_sql is not None:
            result['PromSQL'] = self.prom_sql
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PromSQL') is not None:
            self.prom_sql = m.get('PromSQL')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class DescribeHybridMonitorDataListResponseBodyTimeSeriesLabels(TeaModel):
    def __init__(
        self,
        k: str = None,
        v: str = None,
    ):
        # The tag key.
        self.k = k
        # The tag value.
        self.v = v

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.k is not None:
            result['K'] = self.k
        if self.v is not None:
            result['V'] = self.v
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('K') is not None:
            self.k = m.get('K')
        if m.get('V') is not None:
            self.v = m.get('V')
        return self


class DescribeHybridMonitorDataListResponseBodyTimeSeriesValues(TeaModel):
    def __init__(
        self,
        ts: str = None,
        v: str = None,
    ):
        # The timestamp that indicates the time when the metric value is collected.
        # 
        # Unit: seconds.
        self.ts = ts
        # The metric value.
        self.v = v

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ts is not None:
            result['Ts'] = self.ts
        if self.v is not None:
            result['V'] = self.v
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ts') is not None:
            self.ts = m.get('Ts')
        if m.get('V') is not None:
            self.v = m.get('V')
        return self


class DescribeHybridMonitorDataListResponseBodyTimeSeries(TeaModel):
    def __init__(
        self,
        labels: List[DescribeHybridMonitorDataListResponseBodyTimeSeriesLabels] = None,
        metric_name: str = None,
        values: List[DescribeHybridMonitorDataListResponseBodyTimeSeriesValues] = None,
    ):
        # The tags of the time dimension.
        self.labels = labels
        # The metric name.
        self.metric_name = metric_name
        # The metric values that are collected at different timestamps.
        self.values = values

    def validate(self):
        if self.labels:
            for k in self.labels:
                if k:
                    k.validate()
        if self.values:
            for k in self.values:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Labels'] = []
        if self.labels is not None:
            for k in self.labels:
                result['Labels'].append(k.to_map() if k else None)
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        result['Values'] = []
        if self.values is not None:
            for k in self.values:
                result['Values'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.labels = []
        if m.get('Labels') is not None:
            for k in m.get('Labels'):
                temp_model = DescribeHybridMonitorDataListResponseBodyTimeSeriesLabels()
                self.labels.append(temp_model.from_map(k))
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        self.values = []
        if m.get('Values') is not None:
            for k in m.get('Values'):
                temp_model = DescribeHybridMonitorDataListResponseBodyTimeSeriesValues()
                self.values.append(temp_model.from_map(k))
        return self


class DescribeHybridMonitorDataListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
        time_series: List[DescribeHybridMonitorDataListResponseBodyTimeSeries] = None,
    ):
        # The response code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success
        # The returned monitoring data.
        self.time_series = time_series

    def validate(self):
        if self.time_series:
            for k in self.time_series:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        result['TimeSeries'] = []
        if self.time_series is not None:
            for k in self.time_series:
                result['TimeSeries'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.time_series = []
        if m.get('TimeSeries') is not None:
            for k in m.get('TimeSeries'):
                temp_model = DescribeHybridMonitorDataListResponseBodyTimeSeries()
                self.time_series.append(temp_model.from_map(k))
        return self


class DescribeHybridMonitorDataListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHybridMonitorDataListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHybridMonitorDataListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHybridMonitorNamespaceListRequest(TeaModel):
    def __init__(
        self,
        keyword: str = None,
        namespace: str = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        show_task_statistic: bool = None,
    ):
        # The search keyword.
        self.keyword = keyword
        # The name of the namespace.
        # 
        # The name can contain letters, digits, and hyphens (-).
        self.namespace = namespace
        # The page number.
        # 
        # Page numbers start from 1. Default value: 1.
        self.page_number = page_number
        # The number of entries per page.
        # 
        # Page numbers start from 1. Default value: 10.
        self.page_size = page_size
        self.region_id = region_id
        # Specifies whether to return the configuration details of metric import tasks for Alibaba Cloud services and the number of metric import tasks for third-party services. Valid values:
        # 
        # *   true
        # *   false (default)
        self.show_task_statistic = show_task_statistic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.show_task_statistic is not None:
            result['ShowTaskStatistic'] = self.show_task_statistic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ShowTaskStatistic') is not None:
            self.show_task_statistic = m.get('ShowTaskStatistic')
        return self


class DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricListNamespaceListMetricList(TeaModel):
    def __init__(
        self,
        list: List[str] = None,
        period: int = None,
    ):
        # The metrics.
        self.list = list
        # The collection period of the metric.
        # 
        # Unit: seconds.
        self.period = period

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list is not None:
            result['List'] = self.list
        if self.period is not None:
            result['Period'] = self.period
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('List') is not None:
            self.list = m.get('List')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        return self


class DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricListNamespaceList(TeaModel):
    def __init__(
        self,
        metric_list: List[DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricListNamespaceListMetricList] = None,
        namespace: str = None,
    ):
        # The metrics for the Alibaba Cloud service.
        self.metric_list = metric_list
        # The namespace for the Alibaba Cloud service.
        self.namespace = namespace

    def validate(self):
        if self.metric_list:
            for k in self.metric_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MetricList'] = []
        if self.metric_list is not None:
            for k in self.metric_list:
                result['MetricList'].append(k.to_map() if k else None)
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.metric_list = []
        if m.get('MetricList') is not None:
            for k in m.get('MetricList'):
                temp_model = DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricListNamespaceListMetricList()
                self.metric_list.append(temp_model.from_map(k))
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        return self


class DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricList(TeaModel):
    def __init__(
        self,
        namespace_list: List[DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricListNamespaceList] = None,
        user_id: int = None,
        yamlconfig: str = None,
    ):
        # The namespaces.
        self.namespace_list = namespace_list
        # The account that is used to create the namespace.
        self.user_id = user_id
        # The configuration file of the Alibaba Cloud service that you want to monitor by using Hybrid Cloud Monitoring.
        # 
        # *   namespace: the namespace of the Alibaba Cloud service.
        # *   metric_list: the metrics of the Alibaba Cloud service.
        # *   dimension: the resources of the Alibaba Cloud service that you want to monitor by using Hybrid Cloud Monitoring. If you do not specify a dimension, all resources of the Alibaba Cloud service are monitored.
        self.yamlconfig = yamlconfig

    def validate(self):
        if self.namespace_list:
            for k in self.namespace_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NamespaceList'] = []
        if self.namespace_list is not None:
            for k in self.namespace_list:
                result['NamespaceList'].append(k.to_map() if k else None)
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.yamlconfig is not None:
            result['YAMLConfig'] = self.yamlconfig
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.namespace_list = []
        if m.get('NamespaceList') is not None:
            for k in m.get('NamespaceList'):
                temp_model = DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricListNamespaceList()
                self.namespace_list.append(temp_model.from_map(k))
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('YAMLConfig') is not None:
            self.yamlconfig = m.get('YAMLConfig')
        return self


class DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceDetail(TeaModel):
    def __init__(
        self,
        namespace_region: str = None,
        prometheus_instance_id: str = None,
        slsproject: str = None,
        spec: str = None,
    ):
        # The region where the metric data is stored.
        # 
        # >  This parameter is returned if you select `m_prom_user` for `NamespaceType` when you create a namespace.
        self.namespace_region = namespace_region
        self.prometheus_instance_id = prometheus_instance_id
        # The project where the metric data is located.
        # 
        # >  This parameter is returned if you select `m_prom_user` for `NamespaceType` when you create a namespace.
        self.slsproject = slsproject
        # The data retention period. Valid values:
        # 
        # *   cms.s1.large (Retention Period 15 Days)
        # *   cms.s1.xlarge (Retention Period 32 Days)
        # *   cms.s1.2xlarge (Retention Period 63 Days)
        # *   cms.s1.3xlarge (Retention Period 93 Days)
        # *   cms.s1.6xlarge (Retention Period 185 Days)
        # *   cms.s1.12xlarge (Retention Period 367 Days)
        self.spec = spec

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace_region is not None:
            result['NamespaceRegion'] = self.namespace_region
        if self.prometheus_instance_id is not None:
            result['PrometheusInstanceId'] = self.prometheus_instance_id
        if self.slsproject is not None:
            result['SLSProject'] = self.slsproject
        if self.spec is not None:
            result['Spec'] = self.spec
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NamespaceRegion') is not None:
            self.namespace_region = m.get('NamespaceRegion')
        if m.get('PrometheusInstanceId') is not None:
            self.prometheus_instance_id = m.get('PrometheusInstanceId')
        if m.get('SLSProject') is not None:
            self.slsproject = m.get('SLSProject')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        return self


class DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespace(TeaModel):
    def __init__(
        self,
        aliyun_product_metric_list: List[DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricList] = None,
        create_time: str = None,
        description: str = None,
        detail: DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceDetail = None,
        id: str = None,
        is_delete: int = None,
        modify_time: str = None,
        namespace: str = None,
        namespace_type: str = None,
        not_aliyun_task_number: int = None,
    ):
        # The configuration details of metric import tasks for Alibaba Cloud services.
        self.aliyun_product_metric_list = aliyun_product_metric_list
        # The timestamp that was generated when the namespace was created.
        # 
        # Unit: milliseconds.
        self.create_time = create_time
        # The description of the namespace.
        self.description = description
        # The details of the data retention period.
        self.detail = detail
        # The ID of the namespace.
        self.id = id
        # Indicates whether the namespace is deleted. Valid values:
        # 
        # *   0: The namespace is not deleted.
        # *   1: The namespace is deleted.
        self.is_delete = is_delete
        # The timestamp that was generated when the namespace was last modified.
        self.modify_time = modify_time
        # The name of the namespace.
        self.namespace = namespace
        # The storage scheme of metric data. Valid values:
        # 
        # *   m_prom_user: The metric data is stored in Simple Log Service.
        # *   m_prom_pool: The metric data is stored in the storage space provided by CloudMonitor.
        self.namespace_type = namespace_type
        # The number of metric import tasks for third-party services.
        self.not_aliyun_task_number = not_aliyun_task_number

    def validate(self):
        if self.aliyun_product_metric_list:
            for k in self.aliyun_product_metric_list:
                if k:
                    k.validate()
        if self.detail:
            self.detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AliyunProductMetricList'] = []
        if self.aliyun_product_metric_list is not None:
            for k in self.aliyun_product_metric_list:
                result['AliyunProductMetricList'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.detail is not None:
            result['Detail'] = self.detail.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.is_delete is not None:
            result['IsDelete'] = self.is_delete
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_type is not None:
            result['NamespaceType'] = self.namespace_type
        if self.not_aliyun_task_number is not None:
            result['NotAliyunTaskNumber'] = self.not_aliyun_task_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.aliyun_product_metric_list = []
        if m.get('AliyunProductMetricList') is not None:
            for k in m.get('AliyunProductMetricList'):
                temp_model = DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricList()
                self.aliyun_product_metric_list.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Detail') is not None:
            temp_model = DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceDetail()
            self.detail = temp_model.from_map(m['Detail'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IsDelete') is not None:
            self.is_delete = m.get('IsDelete')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespaceType') is not None:
            self.namespace_type = m.get('NamespaceType')
        if m.get('NotAliyunTaskNumber') is not None:
            self.not_aliyun_task_number = m.get('NotAliyunTaskNumber')
        return self


class DescribeHybridMonitorNamespaceListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        describe_hybrid_monitor_namespace: List[DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespace] = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: str = None,
        total: int = None,
    ):
        # The response code.
        self.code = code
        # The details of the namespaces.
        self.describe_hybrid_monitor_namespace = describe_hybrid_monitor_namespace
        # The returned message.
        self.message = message
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.describe_hybrid_monitor_namespace:
            for k in self.describe_hybrid_monitor_namespace:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['DescribeHybridMonitorNamespace'] = []
        if self.describe_hybrid_monitor_namespace is not None:
            for k in self.describe_hybrid_monitor_namespace:
                result['DescribeHybridMonitorNamespace'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.describe_hybrid_monitor_namespace = []
        if m.get('DescribeHybridMonitorNamespace') is not None:
            for k in m.get('DescribeHybridMonitorNamespace'):
                temp_model = DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespace()
                self.describe_hybrid_monitor_namespace.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeHybridMonitorNamespaceListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHybridMonitorNamespaceListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHybridMonitorNamespaceListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHybridMonitorSLSGroupRequest(TeaModel):
    def __init__(
        self,
        keyword: str = None,
        page_number: str = None,
        page_size: str = None,
        region_id: str = None,
        slsgroup_name: str = None,
    ):
        # The keyword that is used to search for Logstore groups.
        self.keyword = keyword
        # The page number.
        # 
        # Pages start from page 1. Default value: 1.
        self.page_number = page_number
        # The number of entries per page.
        # 
        # Minimum value: 1. Default value: 10.
        self.page_size = page_size
        self.region_id = region_id
        # The name of the Logstore group.
        self.slsgroup_name = slsgroup_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.slsgroup_name is not None:
            result['SLSGroupName'] = self.slsgroup_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SLSGroupName') is not None:
            self.slsgroup_name = m.get('SLSGroupName')
        return self


class DescribeHybridMonitorSLSGroupResponseBodyListSLSGroupConfig(TeaModel):
    def __init__(
        self,
        slslogstore: str = None,
        slsproject: str = None,
        slsregion: str = None,
        slsuser_id: str = None,
    ):
        # The Logstore.
        self.slslogstore = slslogstore
        # The Simple Log Service project.
        self.slsproject = slsproject
        # The region ID.
        self.slsregion = slsregion
        # The member ID.
        # 
        # **Description** This parameter is returned when you call the operation by using an administrative account.
        self.slsuser_id = slsuser_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.slslogstore is not None:
            result['SLSLogstore'] = self.slslogstore
        if self.slsproject is not None:
            result['SLSProject'] = self.slsproject
        if self.slsregion is not None:
            result['SLSRegion'] = self.slsregion
        if self.slsuser_id is not None:
            result['SLSUserId'] = self.slsuser_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SLSLogstore') is not None:
            self.slslogstore = m.get('SLSLogstore')
        if m.get('SLSProject') is not None:
            self.slsproject = m.get('SLSProject')
        if m.get('SLSRegion') is not None:
            self.slsregion = m.get('SLSRegion')
        if m.get('SLSUserId') is not None:
            self.slsuser_id = m.get('SLSUserId')
        return self


class DescribeHybridMonitorSLSGroupResponseBodyList(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        slsgroup_config: List[DescribeHybridMonitorSLSGroupResponseBodyListSLSGroupConfig] = None,
        slsgroup_description: str = None,
        slsgroup_name: str = None,
        update_time: str = None,
    ):
        # The time when the Logstore group was created.
        # 
        # Unit: milliseconds.
        self.create_time = create_time
        # The configurations of the Logstore group.
        self.slsgroup_config = slsgroup_config
        # The description of the Logstore group.
        self.slsgroup_description = slsgroup_description
        # The name of the Logstore group.
        self.slsgroup_name = slsgroup_name
        # The time when the Logstore group was modified.
        # 
        # Unit: milliseconds.
        self.update_time = update_time

    def validate(self):
        if self.slsgroup_config:
            for k in self.slsgroup_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        result['SLSGroupConfig'] = []
        if self.slsgroup_config is not None:
            for k in self.slsgroup_config:
                result['SLSGroupConfig'].append(k.to_map() if k else None)
        if self.slsgroup_description is not None:
            result['SLSGroupDescription'] = self.slsgroup_description
        if self.slsgroup_name is not None:
            result['SLSGroupName'] = self.slsgroup_name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        self.slsgroup_config = []
        if m.get('SLSGroupConfig') is not None:
            for k in m.get('SLSGroupConfig'):
                temp_model = DescribeHybridMonitorSLSGroupResponseBodyListSLSGroupConfig()
                self.slsgroup_config.append(temp_model.from_map(k))
        if m.get('SLSGroupDescription') is not None:
            self.slsgroup_description = m.get('SLSGroupDescription')
        if m.get('SLSGroupName') is not None:
            self.slsgroup_name = m.get('SLSGroupName')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeHybridMonitorSLSGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        list: List[DescribeHybridMonitorSLSGroupResponseBodyList] = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: str = None,
        total: int = None,
    ):
        # The HTTP status code.
        # 
        # > The status code 200 indicates that the request was successful.
        self.code = code
        # The queried Logstore groups.
        self.list = list
        # The error message.
        self.message = message
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = DescribeHybridMonitorSLSGroupResponseBodyList()
                self.list.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeHybridMonitorSLSGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHybridMonitorSLSGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHybridMonitorSLSGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHybridMonitorTaskListRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        include_aliyun_task: bool = None,
        keyword: str = None,
        namespace: str = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        target_user_id: int = None,
        task_id: str = None,
        task_type: str = None,
    ):
        # The ID of the application group.
        # 
        # For information about how to obtain the ID of an application group, see [DescribeMonitorGroups](https://help.aliyun.com/document_detail/115032.html).
        self.group_id = group_id
        # Specifies whether the returned result includes metric import tasks for Alibaba Cloud services. Valid values:
        # 
        # *   true (default): The returned result includes metric import tasks for Alibaba Cloud services.
        # *   false: The returned result excludes metric import tasks for Alibaba Cloud services.
        self.include_aliyun_task = include_aliyun_task
        # The keyword that is used for the search.
        self.keyword = keyword
        # The name of the namespace.
        # 
        # For information about how to obtain the name of a namespace, see [DescribeHybridMonitorNamespaceList](https://help.aliyun.com/document_detail/428880.html).
        self.namespace = namespace
        # The page number.
        # 
        # Pages start from page 1. Default value: 1.
        self.page_number = page_number
        # The number of entries per page.
        # 
        # Pages start from page 1. Default value: 10.
        self.page_size = page_size
        self.region_id = region_id
        # The ID of the member account.
        # 
        # > This parameter is required only if you use a management account to call this operation to delete the metric import tasks that belong to a member in a resource directory. In this case, the `TaskType` parameter is set to `aliyun_fc`.
        self.target_user_id = target_user_id
        # The ID of the metric import task.
        self.task_id = task_id
        # The type of the metric import task. Valid values:
        # 
        # *   aliyun_fc: metric import tasks for Alibaba Cloud services
        # *   aliyun_sls: metrics for logs imported from Log Service
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.include_aliyun_task is not None:
            result['IncludeAliyunTask'] = self.include_aliyun_task
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.target_user_id is not None:
            result['TargetUserId'] = self.target_user_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('IncludeAliyunTask') is not None:
            self.include_aliyun_task = m.get('IncludeAliyunTask')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TargetUserId') is not None:
            self.target_user_id = m.get('TargetUserId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeHybridMonitorTaskListResponseBodyTaskListAttachLabels(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # The tag key.
        self.name = name
        # The tag value.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHybridMonitorTaskListResponseBodyTaskListMatchExpress(TeaModel):
    def __init__(
        self,
        function: str = None,
        name: str = None,
        value: str = None,
    ):
        # The method that is used to match the instance name. Valid values:
        # 
        # *   startWith: starts with a prefix
        # *   endWith: ends with a suffix
        # *   all: matches all
        # *   equals: equals
        # *   contains: contains
        # *   notContains: does not contain
        self.function = function
        # The instance name.
        self.name = name
        # The keyword that corresponds to the instance name.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function is not None:
            result['Function'] = self.function
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Function') is not None:
            self.function = m.get('Function')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHybridMonitorTaskListResponseBodyTaskListSLSProcessConfigExpress(TeaModel):
    def __init__(
        self,
        alias: str = None,
        express: str = None,
    ):
        # The alias of the extended field that indicates the result of basic operations that are performed on aggregation results.
        self.alias = alias
        # The extended field that indicates the result of basic operations that are performed on aggregation results.
        self.express = express

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.express is not None:
            result['Express'] = self.express
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('Express') is not None:
            self.express = m.get('Express')
        return self


class DescribeHybridMonitorTaskListResponseBodyTaskListSLSProcessConfigFilterFilters(TeaModel):
    def __init__(
        self,
        operator: str = None,
        slskey_name: str = None,
        value: str = None,
    ):
        # The method that is used to filter logs imported from Log Service. Valid values:
        # 
        # *   `contain`: contains
        # *   `notContain`: does not contain
        # *   `>`: greater than
        # *   `<`: less than
        # *   `=`: equal to
        # *   `! =`: not equal to
        # *   `>=`: greater than or equal to
        # *   `<=`: less than or equal to
        self.operator = operator
        # The name of the key that is used to filter logs imported from Log Service.
        self.slskey_name = slskey_name
        # The value of the key that is used to filter logs imported from Log Service.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.slskey_name is not None:
            result['SLSKeyName'] = self.slskey_name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('SLSKeyName') is not None:
            self.slskey_name = m.get('SLSKeyName')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHybridMonitorTaskListResponseBodyTaskListSLSProcessConfigFilter(TeaModel):
    def __init__(
        self,
        filters: List[DescribeHybridMonitorTaskListResponseBodyTaskListSLSProcessConfigFilterFilters] = None,
        relation: str = None,
    ):
        # The conditions that are used to filter logs imported from Log Service.
        self.filters = filters
        # The relationship between multiple filter conditions. Valid values:
        # 
        # *   and (default): Logs are processed only if all filter conditions are met.
        # *   or: Logs are processed if one of the filter conditions is met.
        self.relation = relation

    def validate(self):
        if self.filters:
            for k in self.filters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Filters'] = []
        if self.filters is not None:
            for k in self.filters:
                result['Filters'].append(k.to_map() if k else None)
        if self.relation is not None:
            result['Relation'] = self.relation
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.filters = []
        if m.get('Filters') is not None:
            for k in m.get('Filters'):
                temp_model = DescribeHybridMonitorTaskListResponseBodyTaskListSLSProcessConfigFilterFilters()
                self.filters.append(temp_model.from_map(k))
        if m.get('Relation') is not None:
            self.relation = m.get('Relation')
        return self


class DescribeHybridMonitorTaskListResponseBodyTaskListSLSProcessConfigGroupBy(TeaModel):
    def __init__(
        self,
        alias: str = None,
        slskey_name: str = None,
    ):
        # The alias of the aggregation result.
        self.alias = alias
        # The name of the key that is used to aggregate logs imported from Log Service.
        self.slskey_name = slskey_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.slskey_name is not None:
            result['SLSKeyName'] = self.slskey_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('SLSKeyName') is not None:
            self.slskey_name = m.get('SLSKeyName')
        return self


class DescribeHybridMonitorTaskListResponseBodyTaskListSLSProcessConfigStatistics(TeaModel):
    def __init__(
        self,
        alias: str = None,
        function: str = None,
        parameter_1: str = None,
        parameter_2: str = None,
        slskey_name: str = None,
    ):
        # The alias of the aggregation result.
        self.alias = alias
        # The function that is used to aggregate log data within a statistical period. Valid values:
        # 
        # *   count: counts the number.
        # *   sum: calculates the total value.
        # *   avg: calculates the average value.
        # *   max: calculates the maximum value.
        # *   min: calculates the minimum value.
        # *   value: collects samples within the statistical period.
        # *   countps: calculates the average number of the specified field per second by using the following formula: Counted number of the specified field/Total number of seconds within the statistical period.
        # *   sumps: calculates the average number of the specified field per second by using the following formula: Total value of the specified field/Total number of seconds within the statistical period.
        # *   distinct: counts the number of logs where the specified field appears within the statistical period.
        # *   distribution: counts the number of logs that meet a specified condition within the statistical period.
        # *   percentile: sorts the values of the specified field in ascending order, and then returns the value that is at the specified percentile within the statistical period. Example: P50.
        self.function = function
        # The value of the function that is used to aggregate logs imported from Log Service.
        # 
        # *   If the `Function` parameter is set to `distribution`, this parameter indicates the lower limit of the statistical interval. For example, 200 indicates that the number of HTTP requests whose status code is 2XX is calculated.
        # *   If the `Function` parameter is set to `percentile`, this parameter specifies the percentile at which the expected value is. For example, 0.5 specifies P50.
        self.parameter_1 = parameter_1
        # The value of the function that is used to aggregate logs imported from Log Service.
        # 
        # > This parameter is returned only if the `Function` parameter is set to `distribution`. This parameter indicates the upper limit of the statistical interval. For example, 299 indicates that the number of HTTP requests whose status code is 2XX is calculated.
        self.parameter_2 = parameter_2
        # The name of the key that is used to aggregate logs imported from Log Service.
        self.slskey_name = slskey_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.function is not None:
            result['Function'] = self.function
        if self.parameter_1 is not None:
            result['Parameter1'] = self.parameter_1
        if self.parameter_2 is not None:
            result['Parameter2'] = self.parameter_2
        if self.slskey_name is not None:
            result['SLSKeyName'] = self.slskey_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('Function') is not None:
            self.function = m.get('Function')
        if m.get('Parameter1') is not None:
            self.parameter_1 = m.get('Parameter1')
        if m.get('Parameter2') is not None:
            self.parameter_2 = m.get('Parameter2')
        if m.get('SLSKeyName') is not None:
            self.slskey_name = m.get('SLSKeyName')
        return self


class DescribeHybridMonitorTaskListResponseBodyTaskListSLSProcessConfig(TeaModel):
    def __init__(
        self,
        express: List[DescribeHybridMonitorTaskListResponseBodyTaskListSLSProcessConfigExpress] = None,
        filter: DescribeHybridMonitorTaskListResponseBodyTaskListSLSProcessConfigFilter = None,
        group_by: List[DescribeHybridMonitorTaskListResponseBodyTaskListSLSProcessConfigGroupBy] = None,
        statistics: List[DescribeHybridMonitorTaskListResponseBodyTaskListSLSProcessConfigStatistics] = None,
    ):
        # The extended fields that indicate the results of basic operations that are performed on aggregation results.
        self.express = express
        # The conditions that are used to filter logs imported from Log Service.
        self.filter = filter
        # The dimensions based on which data is aggregated. This parameter is equivalent to the GROUP BY clause in SQL.
        self.group_by = group_by
        # The methods that are used to aggregate logs imported from Log Service.
        self.statistics = statistics

    def validate(self):
        if self.express:
            for k in self.express:
                if k:
                    k.validate()
        if self.filter:
            self.filter.validate()
        if self.group_by:
            for k in self.group_by:
                if k:
                    k.validate()
        if self.statistics:
            for k in self.statistics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Express'] = []
        if self.express is not None:
            for k in self.express:
                result['Express'].append(k.to_map() if k else None)
        if self.filter is not None:
            result['Filter'] = self.filter.to_map()
        result['GroupBy'] = []
        if self.group_by is not None:
            for k in self.group_by:
                result['GroupBy'].append(k.to_map() if k else None)
        result['Statistics'] = []
        if self.statistics is not None:
            for k in self.statistics:
                result['Statistics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.express = []
        if m.get('Express') is not None:
            for k in m.get('Express'):
                temp_model = DescribeHybridMonitorTaskListResponseBodyTaskListSLSProcessConfigExpress()
                self.express.append(temp_model.from_map(k))
        if m.get('Filter') is not None:
            temp_model = DescribeHybridMonitorTaskListResponseBodyTaskListSLSProcessConfigFilter()
            self.filter = temp_model.from_map(m['Filter'])
        self.group_by = []
        if m.get('GroupBy') is not None:
            for k in m.get('GroupBy'):
                temp_model = DescribeHybridMonitorTaskListResponseBodyTaskListSLSProcessConfigGroupBy()
                self.group_by.append(temp_model.from_map(k))
        self.statistics = []
        if m.get('Statistics') is not None:
            for k in m.get('Statistics'):
                temp_model = DescribeHybridMonitorTaskListResponseBodyTaskListSLSProcessConfigStatistics()
                self.statistics.append(temp_model.from_map(k))
        return self


class DescribeHybridMonitorTaskListResponseBodyTaskList(TeaModel):
    def __init__(
        self,
        attach_labels: List[DescribeHybridMonitorTaskListResponseBodyTaskListAttachLabels] = None,
        collect_interval: int = None,
        collect_target_endpoint: str = None,
        collect_target_path: str = None,
        collect_target_type: str = None,
        collect_timout: int = None,
        create_time: str = None,
        description: str = None,
        extra_info: str = None,
        group_id: str = None,
        instances: List[str] = None,
        log_file_path: str = None,
        log_process: str = None,
        log_sample: str = None,
        log_split: str = None,
        match_express: List[DescribeHybridMonitorTaskListResponseBodyTaskListMatchExpress] = None,
        match_express_relation: str = None,
        namespace: str = None,
        network_type: str = None,
        slsprocess: str = None,
        slsprocess_config: DescribeHybridMonitorTaskListResponseBodyTaskListSLSProcessConfig = None,
        target_user_id: str = None,
        task_id: str = None,
        task_name: str = None,
        task_type: str = None,
        upload_region: str = None,
        yarmconfig: str = None,
    ):
        # The tags of the metric import task.
        self.attach_labels = attach_labels
        # The interval at which the CloudMonitor agent collects host monitoring data. Valid values:
        # 
        # *   15
        # *   30
        # *   60
        # 
        # Unit: seconds.
        self.collect_interval = collect_interval
        # The URL of the destination from which the CloudMonitor agent collects host monitoring data.
        self.collect_target_endpoint = collect_target_endpoint
        # The relative path from which the CloudMonitor agent collects monitoring data.
        self.collect_target_path = collect_target_path
        # The type of the monitoring data. Valid values: Spring, Tomcat, Nginx, Tengine, JVM, Redis, and MySQL.
        self.collect_target_type = collect_target_type
        # The timeout period during which the CloudMonitor agent collects host monitoring data. Valid values:
        # 
        # *   0
        # *   15
        # *   30
        # *   60
        # 
        # Unit: seconds.
        self.collect_timout = collect_timout
        # The timestamp when the metric import task was created.
        # 
        # Unit: milliseconds.
        self.create_time = create_time
        # The description of the metric import task.
        self.description = description
        # The additional information of the instance.
        self.extra_info = extra_info
        # The ID of the application group.
        self.group_id = group_id
        # The instances where monitoring data is collected in batches.
        self.instances = instances
        self.log_file_path = log_file_path
        # The method that is used to aggregate on-premises log data.
        self.log_process = log_process
        # The sample on-premises log.
        self.log_sample = log_sample
        # The result that is returned after on-premises log data is split based on the specified matching mode.
        # 
        # > The matching modes of on-premises log data include full regex mode, delimiter mode, and JSON mode.
        self.log_split = log_split
        # The conditions that are used to match the instances in the application group.
        self.match_express = match_express
        # The relationship between the conditions that are used to filter metric import tasks. Valid values:
        # 
        # *   or
        # *   and
        self.match_express_relation = match_express_relation
        # The namespace to which the host belongs.
        self.namespace = namespace
        # The network type of the host. Valid values:
        # 
        # *   `vpc`
        # *   `Internet`
        self.network_type = network_type
        # The configurations of the logs that are imported from Log Service.
        self.slsprocess = slsprocess
        # The configurations of the logs that are imported from Log Service.
        # 
        # > This parameter is returned only if the `TaskType` parameter is set to `aliyun_sls`.
        self.slsprocess_config = slsprocess_config
        # The ID of the member account.
        # 
        # > This parameter is displayed only when you call this operation by using a management account.
        self.target_user_id = target_user_id
        # The ID of the metric import task.
        self.task_id = task_id
        # The name of the metric import task.
        self.task_name = task_name
        # The type of the metric import task. Valid values:
        # 
        # *   aliyun_fc: metric import tasks for Alibaba Cloud services
        # *   aliyun_sls: metrics for logs imported from Log Service
        self.task_type = task_type
        # The region where the host resides.
        self.upload_region = upload_region
        # The configuration file of the Alibaba Cloud service that you want to monitor by using Hybrid Cloud Monitoring.
        # 
        # *   namespace: the namespace of the Alibaba Cloud service.
        # *   metric_list: the metrics of the Alibaba Cloud service.
        self.yarmconfig = yarmconfig

    def validate(self):
        if self.attach_labels:
            for k in self.attach_labels:
                if k:
                    k.validate()
        if self.match_express:
            for k in self.match_express:
                if k:
                    k.validate()
        if self.slsprocess_config:
            self.slsprocess_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AttachLabels'] = []
        if self.attach_labels is not None:
            for k in self.attach_labels:
                result['AttachLabels'].append(k.to_map() if k else None)
        if self.collect_interval is not None:
            result['CollectInterval'] = self.collect_interval
        if self.collect_target_endpoint is not None:
            result['CollectTargetEndpoint'] = self.collect_target_endpoint
        if self.collect_target_path is not None:
            result['CollectTargetPath'] = self.collect_target_path
        if self.collect_target_type is not None:
            result['CollectTargetType'] = self.collect_target_type
        if self.collect_timout is not None:
            result['CollectTimout'] = self.collect_timout
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.extra_info is not None:
            result['ExtraInfo'] = self.extra_info
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instances is not None:
            result['Instances'] = self.instances
        if self.log_file_path is not None:
            result['LogFilePath'] = self.log_file_path
        if self.log_process is not None:
            result['LogProcess'] = self.log_process
        if self.log_sample is not None:
            result['LogSample'] = self.log_sample
        if self.log_split is not None:
            result['LogSplit'] = self.log_split
        result['MatchExpress'] = []
        if self.match_express is not None:
            for k in self.match_express:
                result['MatchExpress'].append(k.to_map() if k else None)
        if self.match_express_relation is not None:
            result['MatchExpressRelation'] = self.match_express_relation
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.slsprocess is not None:
            result['SLSProcess'] = self.slsprocess
        if self.slsprocess_config is not None:
            result['SLSProcessConfig'] = self.slsprocess_config.to_map()
        if self.target_user_id is not None:
            result['TargetUserId'] = self.target_user_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.upload_region is not None:
            result['UploadRegion'] = self.upload_region
        if self.yarmconfig is not None:
            result['YARMConfig'] = self.yarmconfig
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attach_labels = []
        if m.get('AttachLabels') is not None:
            for k in m.get('AttachLabels'):
                temp_model = DescribeHybridMonitorTaskListResponseBodyTaskListAttachLabels()
                self.attach_labels.append(temp_model.from_map(k))
        if m.get('CollectInterval') is not None:
            self.collect_interval = m.get('CollectInterval')
        if m.get('CollectTargetEndpoint') is not None:
            self.collect_target_endpoint = m.get('CollectTargetEndpoint')
        if m.get('CollectTargetPath') is not None:
            self.collect_target_path = m.get('CollectTargetPath')
        if m.get('CollectTargetType') is not None:
            self.collect_target_type = m.get('CollectTargetType')
        if m.get('CollectTimout') is not None:
            self.collect_timout = m.get('CollectTimout')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExtraInfo') is not None:
            self.extra_info = m.get('ExtraInfo')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Instances') is not None:
            self.instances = m.get('Instances')
        if m.get('LogFilePath') is not None:
            self.log_file_path = m.get('LogFilePath')
        if m.get('LogProcess') is not None:
            self.log_process = m.get('LogProcess')
        if m.get('LogSample') is not None:
            self.log_sample = m.get('LogSample')
        if m.get('LogSplit') is not None:
            self.log_split = m.get('LogSplit')
        self.match_express = []
        if m.get('MatchExpress') is not None:
            for k in m.get('MatchExpress'):
                temp_model = DescribeHybridMonitorTaskListResponseBodyTaskListMatchExpress()
                self.match_express.append(temp_model.from_map(k))
        if m.get('MatchExpressRelation') is not None:
            self.match_express_relation = m.get('MatchExpressRelation')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('SLSProcess') is not None:
            self.slsprocess = m.get('SLSProcess')
        if m.get('SLSProcessConfig') is not None:
            temp_model = DescribeHybridMonitorTaskListResponseBodyTaskListSLSProcessConfig()
            self.slsprocess_config = temp_model.from_map(m['SLSProcessConfig'])
        if m.get('TargetUserId') is not None:
            self.target_user_id = m.get('TargetUserId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('UploadRegion') is not None:
            self.upload_region = m.get('UploadRegion')
        if m.get('YARMConfig') is not None:
            self.yarmconfig = m.get('YARMConfig')
        return self


class DescribeHybridMonitorTaskListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: str = None,
        task_list: List[DescribeHybridMonitorTaskListResponseBodyTaskList] = None,
        total: int = None,
    ):
        # The status code.
        # 
        # > The status code 200 indicates that the request was successful.
        self.code = code
        # The returned message.
        # 
        # *   If the request was successful, the value `successful` is returned.
        # *   If the request failed, an error message is returned.
        self.message = message
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success
        # The metric import tasks.
        self.task_list = task_list
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.task_list:
            for k in self.task_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        result['TaskList'] = []
        if self.task_list is not None:
            for k in self.task_list:
                result['TaskList'].append(k.to_map() if k else None)
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.task_list = []
        if m.get('TaskList') is not None:
            for k in m.get('TaskList'):
                temp_model = DescribeHybridMonitorTaskListResponseBodyTaskList()
                self.task_list.append(temp_model.from_map(k))
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeHybridMonitorTaskListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHybridMonitorTaskListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHybridMonitorTaskListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLogMonitorAttributeRequest(TeaModel):
    def __init__(
        self,
        metric_name: str = None,
        region_id: str = None,
    ):
        # The metric name. Exact match is supported.
        # 
        # For more information, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # This parameter is required.
        self.metric_name = metric_name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeLogMonitorAttributeResponseBodyLogMonitorAggregates(TeaModel):
    def __init__(
        self,
        alias: str = None,
        field_name: str = None,
        function: str = None,
        max: str = None,
        min: str = None,
    ):
        # The alias of the field.
        self.alias = alias
        # The name of the field in logs.
        self.field_name = field_name
        # The function that is used to aggregate the monitoring data of logs within a statistical period. Valid values:
        # 
        # *   count: counts the number
        # *   sum: calculates the total value
        # *   avg: calculates the average value
        # *   max: calculates the maximum value
        # *   min: calculates the minimum value
        # *   countps: calculates the number of values of the specified field divided by the total number of seconds within a statistical period
        # *   sumps: calculates the sum of the values of the specified field divided by the total number of seconds within a statistical period
        # *   distinct: calculates the number of unique values of the specified field within a statistical period
        self.function = function
        # The maximum value.
        self.max = max
        # The minimum value.
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.function is not None:
            result['Function'] = self.function
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('Function') is not None:
            self.function = m.get('Function')
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        return self


class DescribeLogMonitorAttributeResponseBodyLogMonitorValueFilter(TeaModel):
    def __init__(
        self,
        key: str = None,
        operator: str = None,
        value: str = None,
    ):
        # The name of the log field used for matching in the filter condition.
        self.key = key
        # The method that is used to match the field value. Valid values:
        # 
        # *   `contain`: contains
        # *   `notContain`: does not contain
        # *   `>`: greater than
        # *   `<`: less than
        # *   `>=`: greater than or equal to
        # *   `<=`: less than or equal to
        self.operator = operator
        # The field value to be matched in the filter condition.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeLogMonitorAttributeResponseBodyLogMonitor(TeaModel):
    def __init__(
        self,
        aggregates: List[DescribeLogMonitorAttributeResponseBodyLogMonitorAggregates] = None,
        gmt_create: int = None,
        group_id: int = None,
        groupbys: List[str] = None,
        log_id: int = None,
        metric_express: str = None,
        metric_name: str = None,
        sls_logstore: str = None,
        sls_project: str = None,
        sls_region_id: str = None,
        tumblingwindows: List[str] = None,
        value_filter: List[DescribeLogMonitorAttributeResponseBodyLogMonitorValueFilter] = None,
        value_filter_relation: str = None,
    ):
        # The aggregation logic.
        self.aggregates = aggregates
        # The time when the metric was created.
        # 
        # This value is a UNIX timestamp that represents the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.gmt_create = gmt_create
        # The ID of the application group.
        self.group_id = group_id
        self.groupbys = groupbys
        # The ID of the log.
        self.log_id = log_id
        # The extended field. The extended field allows you to perform basic operations on the aggregation results.
        # 
        # For example, if you have calculated TotalNumber and 5XXNumber by aggregating the data. TotalNumber indicates the total number of HTTP requests, and 5XXNumber indicates the number of HTTP requests whose status code is greater than 499. You can calculate the server error rate by adding the following formula to the extended field: 5XXNumber/TotalNumber\\*100.
        self.metric_express = metric_express
        # The metric name. For more information, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.metric_name = metric_name
        # The name of the Simple Log Service Logstore.
        self.sls_logstore = sls_logstore
        # The name of the SLS project.
        self.sls_project = sls_project
        # The ID of the region where the Simple Log Service (SLS) Logstore resides.
        self.sls_region_id = sls_region_id
        self.tumblingwindows = tumblingwindows
        # The condition that is used to filter logs. The ValueFilter and ValueFilterRelation parameters are used in pair. The filter condition is equivalent to the WHERE clause in SQL statements.
        # 
        # If no filter condition is specified, all logs are processed. For example, logs contain the Level and Error fields. If you need to calculate the number of times that logs of the Error level appear every minute, you can set the filter condition to Level=Error and count the number of logs that meet this condition.
        self.value_filter = value_filter
        # The logical operator that is used between log filter conditions. The ValueFilter and ValueFilterRelation parameters must be used in pair. Valid values:
        # 
        # *   and
        # *   or
        self.value_filter_relation = value_filter_relation

    def validate(self):
        if self.aggregates:
            for k in self.aggregates:
                if k:
                    k.validate()
        if self.value_filter:
            for k in self.value_filter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Aggregates'] = []
        if self.aggregates is not None:
            for k in self.aggregates:
                result['Aggregates'].append(k.to_map() if k else None)
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.groupbys is not None:
            result['Groupbys'] = self.groupbys
        if self.log_id is not None:
            result['LogId'] = self.log_id
        if self.metric_express is not None:
            result['MetricExpress'] = self.metric_express
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.sls_logstore is not None:
            result['SlsLogstore'] = self.sls_logstore
        if self.sls_project is not None:
            result['SlsProject'] = self.sls_project
        if self.sls_region_id is not None:
            result['SlsRegionId'] = self.sls_region_id
        if self.tumblingwindows is not None:
            result['Tumblingwindows'] = self.tumblingwindows
        result['ValueFilter'] = []
        if self.value_filter is not None:
            for k in self.value_filter:
                result['ValueFilter'].append(k.to_map() if k else None)
        if self.value_filter_relation is not None:
            result['ValueFilterRelation'] = self.value_filter_relation
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.aggregates = []
        if m.get('Aggregates') is not None:
            for k in m.get('Aggregates'):
                temp_model = DescribeLogMonitorAttributeResponseBodyLogMonitorAggregates()
                self.aggregates.append(temp_model.from_map(k))
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Groupbys') is not None:
            self.groupbys = m.get('Groupbys')
        if m.get('LogId') is not None:
            self.log_id = m.get('LogId')
        if m.get('MetricExpress') is not None:
            self.metric_express = m.get('MetricExpress')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('SlsLogstore') is not None:
            self.sls_logstore = m.get('SlsLogstore')
        if m.get('SlsProject') is not None:
            self.sls_project = m.get('SlsProject')
        if m.get('SlsRegionId') is not None:
            self.sls_region_id = m.get('SlsRegionId')
        if m.get('Tumblingwindows') is not None:
            self.tumblingwindows = m.get('Tumblingwindows')
        self.value_filter = []
        if m.get('ValueFilter') is not None:
            for k in m.get('ValueFilter'):
                temp_model = DescribeLogMonitorAttributeResponseBodyLogMonitorValueFilter()
                self.value_filter.append(temp_model.from_map(k))
        if m.get('ValueFilterRelation') is not None:
            self.value_filter_relation = m.get('ValueFilterRelation')
        return self


class DescribeLogMonitorAttributeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        log_monitor: DescribeLogMonitorAttributeResponseBodyLogMonitor = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The details of the log monitoring metric.
        self.log_monitor = log_monitor
        # The returned message. If the request was successful, a success message is returned. If the request failed, an error message is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        if self.log_monitor:
            self.log_monitor.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.log_monitor is not None:
            result['LogMonitor'] = self.log_monitor.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('LogMonitor') is not None:
            temp_model = DescribeLogMonitorAttributeResponseBodyLogMonitor()
            self.log_monitor = temp_model.from_map(m['LogMonitor'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeLogMonitorAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeLogMonitorAttributeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLogMonitorAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLogMonitorListRequest(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        search_value: str = None,
    ):
        # The ID of the application group.
        self.group_id = group_id
        # The page number.
        self.page_number = page_number
        # The number of entries per page. Default value: 10.
        self.page_size = page_size
        self.region_id = region_id
        # The keyword that is used to search for log monitoring metrics. Fuzzy match is supported.
        self.search_value = search_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.search_value is not None:
            result['SearchValue'] = self.search_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SearchValue') is not None:
            self.search_value = m.get('SearchValue')
        return self


class DescribeLogMonitorListResponseBodyLogMonitorListValueFilter(TeaModel):
    def __init__(
        self,
        key: str = None,
        operator: str = None,
        value: str = None,
    ):
        # The name of the log field used for matching in the filter condition.
        self.key = key
        # The method that is used to match the field value. Valid values:
        # 
        # *   contain: contains
        # *   notContain: does not contain
        # *   `>`: greater than
        # *   `<`: less than
        # *   `>=`: greater than or equal to
        # *   `<=`: less than or equal to
        self.operator = operator
        # The field value to be matched in the filter condition.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeLogMonitorListResponseBodyLogMonitorList(TeaModel):
    def __init__(
        self,
        gmt_create: int = None,
        group_id: int = None,
        log_id: int = None,
        metric_name: str = None,
        sls_logstore: str = None,
        sls_project: str = None,
        sls_region_id: str = None,
        value_filter: List[DescribeLogMonitorListResponseBodyLogMonitorListValueFilter] = None,
        value_filter_relation: str = None,
    ):
        # The time when the log monitoring metric was created.
        # 
        # This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.gmt_create = gmt_create
        # The ID of the application group.
        self.group_id = group_id
        # The ID of the log monitoring metric.
        self.log_id = log_id
        # The metric name. For more information, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.metric_name = metric_name
        # The name of the Simple Log Service (SLS) Logstore.
        self.sls_logstore = sls_logstore
        # The name of the SLS project.
        self.sls_project = sls_project
        # The ID of the region where the SLS Logstore resides.
        self.sls_region_id = sls_region_id
        # The condition that is used to filter logs. The ValueFilter and ValueFilterRelation parameters are used in pair. The filter condition is equivalent to the WHERE clause in SQL statements. If no filter condition is specified, all logs are processed. For example, logs contain the Level and Error fields. If you need to calculate the number of times that logs of the Error level appear every minute, you can set the filter condition to Level=Error and count the number of logs that meet this condition.
        self.value_filter = value_filter
        # The logical operator that is used between log filter conditions. The ValueFilter and ValueFilterRelation parameters are used in pair. Valid values:
        # 
        # *   and
        # *   or
        self.value_filter_relation = value_filter_relation

    def validate(self):
        if self.value_filter:
            for k in self.value_filter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.log_id is not None:
            result['LogId'] = self.log_id
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.sls_logstore is not None:
            result['SlsLogstore'] = self.sls_logstore
        if self.sls_project is not None:
            result['SlsProject'] = self.sls_project
        if self.sls_region_id is not None:
            result['SlsRegionId'] = self.sls_region_id
        result['ValueFilter'] = []
        if self.value_filter is not None:
            for k in self.value_filter:
                result['ValueFilter'].append(k.to_map() if k else None)
        if self.value_filter_relation is not None:
            result['ValueFilterRelation'] = self.value_filter_relation
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('LogId') is not None:
            self.log_id = m.get('LogId')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('SlsLogstore') is not None:
            self.sls_logstore = m.get('SlsLogstore')
        if m.get('SlsProject') is not None:
            self.sls_project = m.get('SlsProject')
        if m.get('SlsRegionId') is not None:
            self.sls_region_id = m.get('SlsRegionId')
        self.value_filter = []
        if m.get('ValueFilter') is not None:
            for k in m.get('ValueFilter'):
                temp_model = DescribeLogMonitorListResponseBodyLogMonitorListValueFilter()
                self.value_filter.append(temp_model.from_map(k))
        if m.get('ValueFilterRelation') is not None:
            self.value_filter_relation = m.get('ValueFilterRelation')
        return self


class DescribeLogMonitorListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        log_monitor_list: List[DescribeLogMonitorListResponseBodyLogMonitorList] = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total: int = None,
    ):
        # The status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The log monitoring metrics.
        self.log_monitor_list = log_monitor_list
        # The returned message.
        self.message = message
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.log_monitor_list:
            for k in self.log_monitor_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['LogMonitorList'] = []
        if self.log_monitor_list is not None:
            for k in self.log_monitor_list:
                result['LogMonitorList'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.log_monitor_list = []
        if m.get('LogMonitorList') is not None:
            for k in m.get('LogMonitorList'):
                temp_model = DescribeLogMonitorListResponseBodyLogMonitorList()
                self.log_monitor_list.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeLogMonitorListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeLogMonitorListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLogMonitorListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricDataRequest(TeaModel):
    def __init__(
        self,
        dimensions: str = None,
        end_time: str = None,
        express: str = None,
        length: str = None,
        metric_name: str = None,
        namespace: str = None,
        period: str = None,
        region_id: str = None,
        start_time: str = None,
    ):
        # The dimensions based on which the resources are queried.
        # 
        # Set the value to a collection of key-value pairs. A typical key-value pair is `instanceId:i-2ze2d6j5uhg20x47****`.
        # 
        # >  You can query a maximum of 50 instances in a single request.
        self.dimensions = dimensions
        # The end of the time range to query monitoring data.
        # 
        # *   If the `StartTime` and `EndTime` parameters are not specified, the monitoring data of the last statistical period is queried.``
        # 
        # *   If the `StartTime` and `EndTime` parameters are specified, the monitoring data of the last statistical period in the specified time range is queried.```` The following examples demonstrate how to determine the period in which monitoring data is queried:
        # 
        #     *   If you set the `Period` parameter to 15, the specified time range must be less than or equal to 20 minutes. For example, if you set the StartTime parameter to 2021-05-08 08:10:00 and the EndTime parameter to 2021-05-08 08:30:00, the monitoring data of the last 15 seconds in the time range is queried.
        #     *   If you set the `Period` to 60 or 900, the specified time range must be less than or equal to 2 hours. For example, if you set the Period parameter to 60, the StartTime parameter to 2021-05-08 08:00:00, and the EndTime parameter to 2021-05-08 10:00:00, the monitoring data of the last 60 seconds in the time range is queried.
        #     *   If you set the `Period` parameter to 3600, the specified time range must be less than or equal to 2 days. For example, if you set the StartTime parameter to 2021-05-08 08:00:00 and the EndTime parameter to 2021-05-10 08:00:00, the monitoring data of the last 3,600 seconds in the time range is queried.
        # 
        # The following formats are supported:
        # 
        # *   UNIX timestamp: the number of milliseconds that have elapsed since 00:00:00 UTC on Thursday, January 1, 1970.
        # *   UTC time: the UTC time that follows the YYYY-MM-DDThh:mm:ssZ format.
        # 
        # >  We recommend that you use UNIX timestamps to prevent time zone-related issues.
        self.end_time = end_time
        # The expression that is used to compute the query results in real time.
        # 
        # >  Only the `groupby` expression is supported. This expression is similar to the `GROUP BY` statement that is used in databases.
        self.express = express
        # The number of entries per page.
        # 
        # Default value: 1000.
        # 
        # >  The maximum value of the Length parameter in a request is 1440.
        self.length = length
        # The metric that is used to monitor the cloud service.
        # 
        # For more information about the metrics of cloud services, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # This parameter is required.
        self.metric_name = metric_name
        # The namespace of the cloud service.
        # 
        # For more information about the namespaces of cloud services, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # This parameter is required.
        self.namespace = namespace
        # The statistical period of the metric.
        # 
        # Valid values: 15, 60, 900, and 3600.
        # 
        # Unit: seconds.
        # 
        # > 
        # 
        # *   If this parameter is not specified, monitoring data is queried based on the period in which metric values are reported.
        # 
        # *   For more information about the statistical period of a metric that is specified by the `MetricName` parameter, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.period = period
        self.region_id = region_id
        # The start of the time range to query monitoring data.
        # 
        # *   If the `StartTime` and `EndTime` parameters are not specified, the monitoring data of the last statistical period is queried.``
        # 
        # *   If the `StartTime` and `EndTime` parameters are specified, the monitoring data of the last statistical period in the specified time range is queried.```` The following examples demonstrate how to determine the period in which monitoring data is queried:
        # 
        #     *   If you set the `Period` parameter to 15, the specified time range must be less than or equal to 20 minutes. For example, if you set the StartTime parameter to 2021-05-08 08:10:00 and the EndTime parameter to 2021-05-08 08:30:00, the monitoring data of the last 15 seconds in the time range is queried.
        #     *   If you set the `Period` to 60 or 900, the specified time range must be less than or equal to 2 hours. For example, if you set the Period parameter to 60, the StartTime parameter to 2021-05-08 08:00:00, and the EndTime parameter to 2021-05-08 10:00:00, the monitoring data of the last 60 seconds in the time range is queried.
        #     *   If you set the `Period` parameter to 3600, the specified time range must be less than or equal to 2 days. For example, if you set the StartTime parameter to 2021-05-08 08:00:00 and the EndTime parameter to 2021-05-10 08:00:00, the monitoring data of the last 3,600 seconds in the time range is queried.
        # 
        # The following formats are supported:
        # 
        # *   UNIX timestamp: the number of milliseconds that have elapsed since 00:00:00 UTC on Thursday, January 1, 1970.
        # *   UTC time: the UTC time that follows the YYYY-MM-DDThh:mm:ssZ format.
        # 
        # > 
        # 
        # *   You must set the `StartTime` parameter to a point in time that is later than 00:00:00 UTC on Thursday, January 1, 1970. Otherwise, this parameter is invalid.
        # 
        # *   We recommend that you use UNIX timestamps to prevent time zone-related issues.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.express is not None:
            result['Express'] = self.express
        if self.length is not None:
            result['Length'] = self.length
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.period is not None:
            result['Period'] = self.period
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Express') is not None:
            self.express = m.get('Express')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeMetricDataResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        datapoints: str = None,
        message: str = None,
        period: str = None,
        request_id: str = None,
    ):
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The monitoring data. The value includes the following fields:
        # 
        # *   `timestamp`: the time when the alert was triggered.
        # *   `userId`: the ID of the user for which the alert was triggered.
        # *   `instanceId`: the ID of the instance for which the alert was triggered.
        # *   `Minimum`, `Average`, and `Maximum`: the aggregation methods.
        self.datapoints = datapoints
        # The returned message.
        self.message = message
        # The statistical period of the monitoring data.
        # 
        # Valid values: 15, 60, 900, and 3600.
        # 
        # Unit: seconds.
        self.period = period
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints
        if self.message is not None:
            result['Message'] = self.message
        if self.period is not None:
            result['Period'] = self.period
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            self.datapoints = m.get('Datapoints')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMetricDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMetricDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricLastRequest(TeaModel):
    def __init__(
        self,
        dimensions: str = None,
        end_time: str = None,
        express: str = None,
        length: str = None,
        metric_name: str = None,
        namespace: str = None,
        next_token: str = None,
        period: str = None,
        region_id: str = None,
        start_time: str = None,
    ):
        # The monitoring dimensions of the specified resource.
        # 
        # Set the value to a collection of `key:value` pairs. Example: `{"userId":"120886317861****"}` or `{"instanceId":"i-2ze2d6j5uhg20x47****"}`.
        # 
        # >  You can query a maximum of 50 instances in each request.
        self.dimensions = dimensions
        # The end of the time range to query monitoring data.
        # 
        # *   For second-level data, the start time is obtained by comparing the time that is specified by the StartTime parameter and 20 minutes earlier of the time that is specified by the EndTime parameter. The earlier one of the compared points in time is used as the start time.
        # *   For minute-level data, the start time is obtained by comparing the time that is specified by the StartTime parameter and 2 hours earlier of the time that is specified by the EndTime parameter. The earlier one of the compared points in time is used as the start time.
        # *   For hour-level data, the start time is obtained by comparing the time that is specified by the StartTime parameter and two days earlier of the time that is specified by the EndTime parameter. The earlier one of the compared points in time is used as the start time.
        self.end_time = end_time
        # The expression that is used to calculate the query results in real time.
        self.express = express
        # The number of entries per page.
        # 
        # Default value: 1000. This value indicates that a maximum of 1,000 entries of monitoring data can be returned on each page.
        # 
        # >  The maximum value of the Length parameter for each request is 1440.
        self.length = length
        # The metric that is used to monitor the cloud service.
        # 
        # For more information about metric names, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # This parameter is required.
        self.metric_name = metric_name
        # The namespace of the cloud service.
        # 
        # For more information about the namespaces of cloud services, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # This parameter is required.
        self.namespace = namespace
        # The pagination token.
        # 
        # *   If the number of results exceeds the maximum number of entries allowed on a single page, a pagination token is returned.
        # *   This token can be used as an input parameter to obtain the next page of results. If all results are obtained, no token is returned.
        self.next_token = next_token
        # The statistical period of the monitoring data.
        # 
        # Valid values: 15, 60, 900, and 3600.
        # 
        # Unit: seconds.
        # 
        # > 
        # 
        # *   If this parameter is not specified, monitoring data is queried based on the period in which metric values are reported. The statistical period of metrics (`MetricName`) varies for each cloud service. The statistical period of metrics is displayed in the `MinPeriods` column on the **Metrics** page for each cloud service. For more information, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.period = period
        self.region_id = region_id
        # The start of the time range to query monitoring data.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.express is not None:
            result['Express'] = self.express
        if self.length is not None:
            result['Length'] = self.length
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.period is not None:
            result['Period'] = self.period
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Express') is not None:
            self.express = m.get('Express')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeMetricLastResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        datapoints: str = None,
        message: str = None,
        next_token: str = None,
        period: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The monitoring data.
        self.datapoints = datapoints
        # The error message.
        self.message = message
        # The pagination token.
        self.next_token = next_token
        # The time interval.
        # 
        # Unit: seconds.
        self.period = period
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.period is not None:
            result['Period'] = self.period
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            self.datapoints = m.get('Datapoints')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMetricLastResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMetricLastResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricLastResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricListRequest(TeaModel):
    def __init__(
        self,
        dimensions: str = None,
        end_time: str = None,
        express: str = None,
        length: str = None,
        metric_name: str = None,
        namespace: str = None,
        next_token: str = None,
        period: str = None,
        region_id: str = None,
        start_time: str = None,
    ):
        # The dimensions that specify the resources whose monitoring data you want to query.
        # 
        # Set the value to a collection of key-value pairs. A typical key-value pair is `instanceId:i-2ze2d6j5uhg20x47****`.
        # 
        # >  You can query a maximum of 50 instances in a single request.
        self.dimensions = dimensions
        # The end of the time range to query. The following formats are supported:
        # 
        # *   UNIX timestamp: the number of milliseconds that have elapsed since 00:00:00 Thursday, January 1, 1970
        # *   UTC time: the UTC time that follows the YYYY-MM-DDThh:mm:ssZ format
        self.end_time = end_time
        # The expression that is used to compute the query results in real time.
        # 
        # >  Only the groupby expression is supported. This expression is similar to the GROUP BY statement that is used in databases.
        self.express = express
        # The number of entries to return on each page.
        # 
        # >  The maximum value of the Length parameter in a request is 1440.
        self.length = length
        # The name of the metric.
        # 
        # For more information about metric names, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # This parameter is required.
        self.metric_name = metric_name
        # The namespace of the cloud service. Format: acs_service name.
        # 
        # For more information about the namespaces of cloud services, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        # 
        # This parameter is required.
        self.namespace = namespace
        # The paging token.
        # 
        # >  If this parameter is not specified, the data on the first page is returned. A return value other than Null of this parameter indicates that not all entries have been returned. You can use this value as an input parameter to obtain entries on the next page. The value Null indicates that all query results have been returned.
        self.next_token = next_token
        # The interval at which the monitoring data is queried.
        # 
        # Valid values: 60, 300, and 900.
        # 
        # Unit: seconds.
        # 
        # >  Configure this parameter based on your business scenario.
        self.period = period
        self.region_id = region_id
        # The beginning of the time range to query. The following formats are supported:
        # 
        # *   UNIX timestamp: the number of milliseconds that have elapsed since 00:00:00 Thursday, January 1, 1970
        # *   UTC time: the UTC time that follows the YYYY-MM-DDThh:mm:ssZ format
        # 
        # >  The specified period includes the end time and excludes the start time. The start time must be earlier than the end time.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.express is not None:
            result['Express'] = self.express
        if self.length is not None:
            result['Length'] = self.length
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.period is not None:
            result['Period'] = self.period
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Express') is not None:
            self.express = m.get('Express')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeMetricListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        datapoints: str = None,
        message: str = None,
        next_token: str = None,
        period: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the call was successful.
        self.code = code
        # The monitoring data.
        self.datapoints = datapoints
        # The error message.
        self.message = message
        # The paging token.
        self.next_token = next_token
        # The interval at which the monitoring data is queried. Unit: seconds. Valid values: 60, 300, and 900.
        self.period = period
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the call was successful. Valid values:
        # 
        # *   true: The call was successful.
        # *   false: The call failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.period is not None:
            result['Period'] = self.period
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            self.datapoints = m.get('Datapoints')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMetricListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMetricListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricMetaListRequest(TeaModel):
    def __init__(
        self,
        labels: str = None,
        metric_name: str = None,
        namespace: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The tags for filtering metrics. Specify a JSON string.
        # 
        # Format: ` [{"name":"tag key","value":"tag value"},{"name":"tag key","value":"tag value"}]  `. The following tags are available:
        # 
        # *   metricCategory: the category of the metric.
        # *   alertEnable: specifies whether to report alerts for the metric.
        # *   alertUnit: the unit of the metric in the alerts.
        # *   unitFactor: the factor for metric unit conversion.
        # *   minAlertPeriod: the minimum interval at which the alert is reported.
        # *   productCategory: the category of the service.
        self.labels = labels
        # The metric name. For more information, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.metric_name = metric_name
        # The namespace of the cloud service.
        # 
        # For more information about the namespaces of cloud services, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.namespace = namespace
        # The page number. Default value: 1.
        self.page_number = page_number
        # The number of entries per page. Default value: 30.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.labels is not None:
            result['Labels'] = self.labels
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Labels') is not None:
            self.labels = m.get('Labels')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeMetricMetaListResponseBodyResourcesResource(TeaModel):
    def __init__(
        self,
        description: str = None,
        dimensions: str = None,
        labels: str = None,
        metric_name: str = None,
        namespace: str = None,
        periods: str = None,
        statistics: str = None,
        unit: str = None,
    ):
        # The metric description.
        self.description = description
        # The monitoring dimensions of the resource. Multiple monitoring dimensions are separated with commas (,).
        self.dimensions = dimensions
        # The tags of the metric, including one or more JSON strings.
        # 
        # Format: `[{"name":"tag key","value":"tag value"}]`. The `name` can be repeated. The following tags are available:
        # 
        # *   metricCategory: the category of the metric.
        # *   alertEnable: indicates whether to report alerts for the metric.
        # *   alertUnit: the unit of the metric in the alerts.
        # *   unitFactor: the factor for metric unit conversion.
        # *   minAlertPeriod: the minimum interval at which the alert is reported.
        # *   productCategory: the category of the service.
        self.labels = labels
        # The metric name.
        self.metric_name = metric_name
        # The namespace of the cloud service.
        self.namespace = namespace
        # The statistical periods of the metric. Multiple statistical periods are separated with commas (,).
        # 
        # Unit: seconds.
        self.periods = periods
        # The statistical method. Multiple statistical methods are separated with commas (,).
        self.statistics = statistics
        # The unit of the metric.
        self.unit = unit

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.labels is not None:
            result['Labels'] = self.labels
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.periods is not None:
            result['Periods'] = self.periods
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.unit is not None:
            result['Unit'] = self.unit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('Labels') is not None:
            self.labels = m.get('Labels')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Periods') is not None:
            self.periods = m.get('Periods')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        return self


class DescribeMetricMetaListResponseBodyResources(TeaModel):
    def __init__(
        self,
        resource: List[DescribeMetricMetaListResponseBodyResourcesResource] = None,
    ):
        self.resource = resource

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeMetricMetaListResponseBodyResourcesResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeMetricMetaListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        resources: DescribeMetricMetaListResponseBodyResources = None,
        success: bool = None,
        total_count: str = None,
    ):
        # The response code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # The configuration of the metrics in the resources.
        self.resources = resources
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.resources:
            self.resources.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resources is not None:
            result['Resources'] = self.resources.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resources') is not None:
            temp_model = DescribeMetricMetaListResponseBodyResources()
            self.resources = temp_model.from_map(m['Resources'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeMetricMetaListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMetricMetaListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricMetaListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricRuleBlackListRequest(TeaModel):
    def __init__(
        self,
        category: str = None,
        ids: List[str] = None,
        instance_ids: List[str] = None,
        is_enable: bool = None,
        name: str = None,
        namespace: str = None,
        order: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        scope_type: str = None,
    ):
        # The ID of the blacklist policy.
        self.category = category
        self.ids = ids
        # The IDs of the instances in the blacklist policy.
        # 
        # Valid values of N: 0 to 10.
        self.instance_ids = instance_ids
        # The status of the blacklist policy. Valid values:
        # 
        # *   true: The blacklist policy is enabled.
        # *   false: The blacklist policy is disabled.
        self.is_enable = is_enable
        # The name of the blacklist policy.
        # 
        # This parameter supports fuzzy match.
        self.name = name
        # The timestamp when the blacklist policy expired.
        # 
        # Unit: milliseconds.
        self.namespace = namespace
        # The HTTP status code.
        # 
        # >  The status code 200 indicates that the call was successful.
        self.order = order
        # The name of the metric.
        self.page_number = page_number
        # The categories of the Alibaba Cloud service. For example, ApsaraDB for Redis includes the following categories: ApsaraDB for Redis (standard architecture), ApsaraDB for Redis (cluster architecture), and ApsaraDB for Redis (read/write splitting architecture). In this case, the valid values of this parameter for ApsaraDB for Redis include `kvstore_standard`, `kvstore_sharding`, and `kvstore_splitrw`.
        self.page_size = page_size
        self.region_id = region_id
        # The effective scope of the blacklist policy. Valid values:
        # 
        # *   USER: The blacklist policy takes effect only within the current Alibaba Cloud account.
        # *   GROUP: The blacklist policy takes effect only within the specified application group.
        self.scope_type = scope_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.ids is not None:
            result['Ids'] = self.ids
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.is_enable is not None:
            result['IsEnable'] = self.is_enable
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.order is not None:
            result['Order'] = self.order
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scope_type is not None:
            result['ScopeType'] = self.scope_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('IsEnable') is not None:
            self.is_enable = m.get('IsEnable')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ScopeType') is not None:
            self.scope_type = m.get('ScopeType')
        return self


class DescribeMetricRuleBlackListResponseBodyDescribeMetricRuleBlackListMetrics(TeaModel):
    def __init__(
        self,
        metric_name: str = None,
        resource: str = None,
    ):
        # The metric name.
        self.metric_name = metric_name
        # The extended dimension of the instance. For example, `{"device":"C:"}` specifies that the blacklist policy is applied to all C disks of the specified Elastic Compute Service (ECS) instance.
        self.resource = resource

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.resource is not None:
            result['Resource'] = self.resource
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Resource') is not None:
            self.resource = m.get('Resource')
        return self


class DescribeMetricRuleBlackListResponseBodyDescribeMetricRuleBlackList(TeaModel):
    def __init__(
        self,
        category: str = None,
        create_time: str = None,
        effective_time: str = None,
        enable_end_time: int = None,
        enable_start_time: int = None,
        id: str = None,
        instances: List[str] = None,
        is_enable: bool = None,
        metrics: List[DescribeMetricRuleBlackListResponseBodyDescribeMetricRuleBlackListMetrics] = None,
        name: str = None,
        namespace: str = None,
        scope_type: str = None,
        scope_value: List[str] = None,
        update_time: str = None,
    ):
        # The category of the cloud service. For example, ApsaraDB for Redis includes the following categories: ApsaraDB for Redis (standard architecture), ApsaraDB for Redis (cluster architecture), and ApsaraDB for Redis (read/write splitting architecture). In this case, the valid values of this parameter for ApsaraDB for Redis include `kvstore_standard`, `kvstore_sharding`, and `kvstore_splitrw`.
        self.category = category
        # The timestamp when the blacklist policy was created.
        # 
        # Unit: milliseconds.
        self.create_time = create_time
        # The time range within which the blacklist policy is effective.
        self.effective_time = effective_time
        # The timestamp when the blacklist policy started to take effect.
        # 
        # Unit: milliseconds.
        self.enable_end_time = enable_end_time
        # The timestamp when the blacklist policy expired.
        # 
        # Unit: milliseconds.
        self.enable_start_time = enable_start_time
        # The ID of the blacklist policy.
        self.id = id
        # The IDs of the instances that belong to the specified cloud service.
        self.instances = instances
        # The status of the blacklist policy. Valid values:
        # 
        # *   true: The blacklist policy is enabled.
        # *   false: The blacklist policy is disabled.
        self.is_enable = is_enable
        # The metrics of the instance.
        self.metrics = metrics
        # The name of the blacklist policy.
        self.name = name
        # The namespace of the cloud service.
        self.namespace = namespace
        # The effective scope of the blacklist policy. Valid values:
        # 
        # *   USER: The blacklist policy takes effect only within the current Alibaba Cloud account.
        # *   GROUP: The blacklist policy takes effect only within the specified application group.
        self.scope_type = scope_type
        # The IDs of the application groups.
        self.scope_value = scope_value
        # The timestamp when the blacklist policy was modified.
        # 
        # Unit: milliseconds.
        self.update_time = update_time

    def validate(self):
        if self.metrics:
            for k in self.metrics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.effective_time is not None:
            result['EffectiveTime'] = self.effective_time
        if self.enable_end_time is not None:
            result['EnableEndTime'] = self.enable_end_time
        if self.enable_start_time is not None:
            result['EnableStartTime'] = self.enable_start_time
        if self.id is not None:
            result['Id'] = self.id
        if self.instances is not None:
            result['Instances'] = self.instances
        if self.is_enable is not None:
            result['IsEnable'] = self.is_enable
        result['Metrics'] = []
        if self.metrics is not None:
            for k in self.metrics:
                result['Metrics'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.scope_type is not None:
            result['ScopeType'] = self.scope_type
        if self.scope_value is not None:
            result['ScopeValue'] = self.scope_value
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('EffectiveTime') is not None:
            self.effective_time = m.get('EffectiveTime')
        if m.get('EnableEndTime') is not None:
            self.enable_end_time = m.get('EnableEndTime')
        if m.get('EnableStartTime') is not None:
            self.enable_start_time = m.get('EnableStartTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Instances') is not None:
            self.instances = m.get('Instances')
        if m.get('IsEnable') is not None:
            self.is_enable = m.get('IsEnable')
        self.metrics = []
        if m.get('Metrics') is not None:
            for k in m.get('Metrics'):
                temp_model = DescribeMetricRuleBlackListResponseBodyDescribeMetricRuleBlackListMetrics()
                self.metrics.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('ScopeType') is not None:
            self.scope_type = m.get('ScopeType')
        if m.get('ScopeValue') is not None:
            self.scope_value = m.get('ScopeValue')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeMetricRuleBlackListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        describe_metric_rule_black_list: List[DescribeMetricRuleBlackListResponseBodyDescribeMetricRuleBlackList] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        total: int = None,
    ):
        # The categories of the Alibaba Cloud service. For example, ApsaraDB for Redis includes the following categories: ApsaraDB for Redis (standard architecture), ApsaraDB for Redis (cluster architecture), and ApsaraDB for Redis (read/write splitting architecture). In this case, the valid values of this parameter for ApsaraDB for Redis include `kvstore_standard`, `kvstore_sharding`, and `kvstore_splitrw`.
        self.code = code
        # The queried blacklist policies.
        self.describe_metric_rule_black_list = describe_metric_rule_black_list
        # The error message.
        self.message = message
        # The namespace of the cloud service.
        self.request_id = request_id
        # The namespace of the cloud service.
        # 
        # For more information about the namespaces of different cloud services, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.success = success
        # The timestamp when the blacklist policy was created.
        # 
        # Unit: milliseconds.
        self.total = total

    def validate(self):
        if self.describe_metric_rule_black_list:
            for k in self.describe_metric_rule_black_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['DescribeMetricRuleBlackList'] = []
        if self.describe_metric_rule_black_list is not None:
            for k in self.describe_metric_rule_black_list:
                result['DescribeMetricRuleBlackList'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.describe_metric_rule_black_list = []
        if m.get('DescribeMetricRuleBlackList') is not None:
            for k in m.get('DescribeMetricRuleBlackList'):
                temp_model = DescribeMetricRuleBlackListResponseBodyDescribeMetricRuleBlackList()
                self.describe_metric_rule_black_list.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeMetricRuleBlackListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMetricRuleBlackListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricRuleBlackListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricRuleCountRequest(TeaModel):
    def __init__(
        self,
        metric_name: str = None,
        namespace: str = None,
        region_id: str = None,
    ):
        # The metric name. For more information, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.metric_name = metric_name
        # The namespace of the cloud service. For more information, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.namespace = namespace
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMetricRuleCountResponseBodyMetricRuleCount(TeaModel):
    def __init__(
        self,
        alarm: int = None,
        disable: int = None,
        nodata: int = None,
        ok: int = None,
        total: int = None,
    ):
        # The number of alert rules with active alerts.
        self.alarm = alarm
        # The number of disabled alert rules.
        self.disable = disable
        # The number of alert rules without data.
        self.nodata = nodata
        # The number of alert rules without active alerts.
        self.ok = ok
        # The total number of alert rules.
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm is not None:
            result['Alarm'] = self.alarm
        if self.disable is not None:
            result['Disable'] = self.disable
        if self.nodata is not None:
            result['Nodata'] = self.nodata
        if self.ok is not None:
            result['Ok'] = self.ok
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alarm') is not None:
            self.alarm = m.get('Alarm')
        if m.get('Disable') is not None:
            self.disable = m.get('Disable')
        if m.get('Nodata') is not None:
            self.nodata = m.get('Nodata')
        if m.get('Ok') is not None:
            self.ok = m.get('Ok')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeMetricRuleCountResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        metric_rule_count: DescribeMetricRuleCountResponseBodyMetricRuleCount = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The responses code.
        # 
        # >  The status code 200 indicates that the request was successful.
        self.code = code
        # The error message.
        self.message = message
        # The number of alert rules in each state.
        self.metric_rule_count = metric_rule_count
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        if self.metric_rule_count:
            self.metric_rule_count.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.metric_rule_count is not None:
            result['MetricRuleCount'] = self.metric_rule_count.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MetricRuleCount') is not None:
            temp_model = DescribeMetricRuleCountResponseBodyMetricRuleCount()
            self.metric_rule_count = temp_model.from_map(m['MetricRuleCount'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMetricRuleCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMetricRuleCountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricRuleCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricRuleListRequest(TeaModel):
    def __init__(
        self,
        alert_state: str = None,
        dimensions: str = None,
        enable_state: bool = None,
        group_id: str = None,
        metric_name: str = None,
        namespace: str = None,
        page: int = None,
        page_size: int = None,
        region_id: str = None,
        rule_ids: str = None,
        rule_name: str = None,
    ):
        # The status of the alert rule. Valid values:
        # 
        # *   OK: The alert rule has no active alerts.
        # *   ALARM: The alert rule has active alerts.
        # *   INSUFFICIENT_DATA: No data is available.
        self.alert_state = alert_state
        # The monitoring dimensions of the specified resource.
        # 
        # Set the value to a collection of `key:value` pairs. Example: `{"userId":"120886317861****"}` or `{"instanceId":"i-2ze2d6j5uhg20x47****"}`.
        self.dimensions = dimensions
        # Specifies whether to query enabled or disabled alert rules. Valid values:
        # 
        # *   true: queries enabled alert rules.
        # *   false: queries disabled alert rules.
        self.enable_state = enable_state
        # The ID of the application group.
        # 
        # For information about how to obtain the ID of an application group, see [DescribeMonitorGroups](https://help.aliyun.com/document_detail/115032.html).
        self.group_id = group_id
        # The name of the metric.
        # 
        # For information about how to obtain the name of a metric, see [DescribeMetricMetaList](https://help.aliyun.com/document_detail/98846.html) or [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.metric_name = metric_name
        # The namespace of the cloud service.
        # 
        # For information about how to obtain the namespace of a cloud service, see [DescribeMetricMetaList](https://help.aliyun.com/document_detail/98846.html) or [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.namespace = namespace
        # The page number of the page to return.
        # 
        # Minimum value: 1. Default value: 1.
        self.page = page
        # The number of entries to return on each page.
        # 
        # Minimum value: 1. Default value: 10.
        self.page_size = page_size
        self.region_id = region_id
        # The ID of the alert rule. You can specify up to 20 IDs at a time. Separate multiple IDs with commas (,).
        self.rule_ids = rule_ids
        # The name of the alert rule.
        # 
        # This parameter supports fuzzy match.
        self.rule_name = rule_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_state is not None:
            result['AlertState'] = self.alert_state
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.enable_state is not None:
            result['EnableState'] = self.enable_state
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_ids is not None:
            result['RuleIds'] = self.rule_ids
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertState') is not None:
            self.alert_state = m.get('AlertState')
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EnableState') is not None:
            self.enable_state = m.get('EnableState')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleIds') is not None:
            self.rule_ids = m.get('RuleIds')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpressionExpressionListExpressionList(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        metric_name: str = None,
        period: int = None,
        statistics: str = None,
        threshold: str = None,
    ):
        # The operator that is used to compare the metric value with the threshold. Valid values:
        # 
        # *   GreaterThanOrEqualToThreshold: greater than or equal to the threshold
        # *   GreaterThanThreshold: greater than the threshold
        # *   LessThanOrEqualToThreshold: less than or equal to the threshold
        # *   LessThanThreshold: less than the threshold
        # *   NotEqualToThreshold: not equal to the threshold
        # *   GreaterThanYesterday: greater than the metric value at the same time yesterday
        # *   LessThanYesterday: less than the metric value at the same time yesterday
        # *   GreaterThanLastWeek: greater than the metric value at the same time last week
        # *   LessThanLastWeek: less than the metric value at the same time last week
        # *   GreaterThanLastPeriod: greater than the metric value in the last monitoring cycle
        # *   LessThanLastPeriod: less than the metric value in the last monitoring cycle
        self.comparison_operator = comparison_operator
        # The metric that is used to monitor the cloud service.
        self.metric_name = metric_name
        # The aggregation period of the metric.
        # 
        # Unit: seconds.
        self.period = period
        # The statistical method of the metric. Valid values:
        # 
        # *   $Maximum: the maximum value
        # *   $Minimum: the minimum value
        # *   $Average: the average value
        # *   $Availability: the availability rate (usually used for site monitoring)
        # 
        # >  `$` is the prefix of the metric. For information about the Alibaba Cloud services that are supported by CloudMonitor, see [Appendix 1: Metrics](https://help.aliyun.com/document_detail/163515.html).
        self.statistics = statistics
        # The alert threshold.
        self.threshold = threshold

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.period is not None:
            result['Period'] = self.period
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpressionExpressionList(TeaModel):
    def __init__(
        self,
        expression_list: List[DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpressionExpressionListExpressionList] = None,
    ):
        self.expression_list = expression_list

    def validate(self):
        if self.expression_list:
            for k in self.expression_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExpressionList'] = []
        if self.expression_list is not None:
            for k in self.expression_list:
                result['ExpressionList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.expression_list = []
        if m.get('ExpressionList') is not None:
            for k in m.get('ExpressionList'):
                temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpressionExpressionListExpressionList()
                self.expression_list.append(temp_model.from_map(k))
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpression(TeaModel):
    def __init__(
        self,
        expression_list: DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpressionExpressionList = None,
        expression_list_join: str = None,
        expression_raw: str = None,
        level: str = None,
        times: int = None,
    ):
        # The trigger conditions that are created in standard mode.
        self.expression_list = expression_list
        # The relationship between the trigger conditions for multiple metrics. Valid values:
        # 
        # *   `&&`: An alert is triggered only if all metrics meet the trigger conditions. An alert is triggered only if the results of all expressions specified in the ExpressionList parameter are `true`.
        # *   `||`: An alert is triggered if one of the metrics meets the trigger conditions.
        self.expression_list_join = expression_list_join
        # The trigger conditions that are created by using expressions. You can use expressions to create trigger conditions in the following scenarios:
        # 
        # *   Set an alert blacklist for specific resources. For example, if you specify `$instanceId != \\"i-io8kfvcpp7x5****\\" ``&&`` $Average > 50`, no alert is triggered when the `average metric value` of the `i-io8kfvcpp7x5****` instance exceeds 50.
        # *   Set a special alert threshold for a specified instance in the rule. For example, if you specify `$Average > ($instanceId == \\"i-io8kfvcpp7x5****\\"? 80: 50)`, an alert is triggered when the `average metric value` of the `i-io8kfvcpp7x5****` instance exceeds 80 or the `average metric value` of other instances exceeds 50.
        # *   Limit the number of instances whose metric values exceed the threshold. For example, if you specify `count($Average > 20) > 3`, an alert is triggered only when the number of instances whose `average metric value` exceeds 20 exceeds three.
        self.expression_raw = expression_raw
        # The alert level. Valid values:
        # 
        # *   CRITICAL
        # *   WARN
        # *   INFO
        self.level = level
        # The number of consecutive triggers. If the number of times that the metric values meet the trigger conditions reaches the value of this parameter, CloudMonitor sends alert notifications.
        self.times = times

    def validate(self):
        if self.expression_list:
            self.expression_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expression_list is not None:
            result['ExpressionList'] = self.expression_list.to_map()
        if self.expression_list_join is not None:
            result['ExpressionListJoin'] = self.expression_list_join
        if self.expression_raw is not None:
            result['ExpressionRaw'] = self.expression_raw
        if self.level is not None:
            result['Level'] = self.level
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExpressionList') is not None:
            temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpressionExpressionList()
            self.expression_list = temp_model.from_map(m['ExpressionList'])
        if m.get('ExpressionListJoin') is not None:
            self.expression_list_join = m.get('ExpressionListJoin')
        if m.get('ExpressionRaw') is not None:
            self.expression_raw = m.get('ExpressionRaw')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsCritical(TeaModel):
    def __init__(
        self,
 