# OUTLINE

- intro (5 min)
  - motivation: standard methodology
  - hard, slow, error prone
  - difficult to scale the expressive power of the language
  - logos is a unified artificial language
  - TheoryLib
- programmatic semantics (10 min)
  - SMT solvers (Z3)
  - bitvectors as states
  - primitive sorts in Z3
  - model-checker to facilitate
    - translate into Z3 constraints
    - find a model if there is one
    - use model to interpret and print
  - can't survey all models (just finite ones below a certain size)
    - countermodels give certainty in invalidity
    - theoremhood is supported by ruling out models below a given N
    - higher N means more higher certainty in theoremhood
  - DEMO 1: IMPOSITION SEMANTICS
    - semantics and operators
    - run examples
    - unit tests
- computational complexity as a theoretical virtue (10 min) -- MIGUEL
  - data structure that stores functions that depend on state space grows exponentially with N
    - computability becomes a new theoretical virtue
    - for reasons of speed (bigger data structures take more time), but also in the entire "higher N means higher certainty in theoremhood" convo: size of the model it handles also matters
  - where this matters: primitive functions with the state space as input. TL;DR cost of a primitive scales exponentially with arity
    - how Z3 stores functions (worst case: basically an array)
    - DEMO WITH -z FLAG
    - array with larger _input space_ has larger _space complexity_ 
      - go over space complexity here. 
      - MENTION how L doesn't matter. 
      - NOTE how runtime can increase with arity (1 goes to 3) or with a larger N
    - larger _space_ complexity means longer runtime to fill that space up: slower programs
      - ONCE TIME ESTABLISHED, go over example math with N=5
    - TL;DR cost of a primitive scales exponentially with arity
  - computational costs in action
    - imposition 10x slower than logos for N=4 for most theorems in the examples.py files
      - when talking about 0.01 vs 0.1 or even 0.1 vs 1 seconds, not too bad. For countermodels, low N (<5) often suffices
      - but, remember: more N good N. at N=5 many of theorems imposition (relevant fact: 3 place primitive) took more than 100 seconds. logos (relevant fact: no 3 place primitive) could do them in less (from 1 ish second to 70 ish seconds)
      - ofc these qns will not become the end all be all, but just shows that a maybe previously overlooked aspect—arity of primitives—starts to matter
  - so if we are to use this tool for making theories, we should seek to make theories that we can easily reason about with the tools we have. so computability is now a virtue
  - compare with simplicity (kinda like intuitive computability for humans)
    - often no objective measure on simplicity. Not the case for computability: time is very easy, even before that space complexity
  - DEMO MAXIMIZER FOR IMPOSITION SEMANTICS
- imposition defined (5 min)
  - maximal compatible parts
  - alternative worlds
  - semantics for counterfactuals
  - DEMO COMPARISON
- modality defined (5 min)
  - `\Box A := \top \boxright A` over `\Box A := \neg A \boxright \bot`
    - iterated modals don't force counterfactuals into the antecedent
    - intuitive reading: if anything were the case, A would be the case
  - imposition theory admits countermodels to this definition
    - many vacuous countermodels
    - but good logic
