"""Classes to convert between coordinate systems. Also contains
routines for interpolating or downsampling in time."""

from .abstractconverter import CoordinateTransform
from .line_of_sight import LineOfSightTransform
from .spot_weightings import SpotWeightings
from .time import bin_to_time_labels
from .time import convert_in_time
from .transect import TransectCoordinates
from .trivial import TrivialTransform

__all__ = [
    "CoordinateTransform",
    "LineOfSightTransform",
    "SpotWeightings",
    "TransectCoordinates",
    "TrivialTransform",
    "bin_to_time_labels",
    "convert_in_time",
]
