---
name: 機能要求 (Feature Request)
about: 新機能の提案や既存機能の拡張
title: '[FEATURE] '
labels: ['enhancement', 'feature-request']
assignees: ''
---

## 📋 機能概要 (Feature Summary)
<!-- 実装したい機能を簡潔に説明してください -->

## 🎯 動機・ユースケース (Motivation & Use Case)  
<!-- なぜこの機能が必要なのか、どのような場面で使用されるかを説明してください -->

## 📝 詳細仕様 (Detailed Specification)

### 機能要件 (Functional Requirements)
<!-- FR-XX 形式で該当する機能要件を記載 -->
- [ ] FR-XX: 

### 実装場所 (Implementation Location)
<!-- 想定される実装ファイル/モジュール -->
- [ ] `strataregula/[module]/[file].py`

### CLI例 (CLI Examples)
```bash
# 使用例をここに記載
sr command --option value
```

### API例 (API Examples)  
```python
# Python API の使用例
processor = SomeProcessor()
result = processor.process(data)
```

## ✅ 受け入れ基準 (Acceptance Criteria)
<!-- この機能が完成したと判断する基準 -->
- [ ] AC-XX: 
- [ ] 機能テストが通る
- [ ] パフォーマンステストが通る (該当する場合)
- [ ] ドキュメントが更新されている

## 🔗 関連課題 (Related Issues)
<!-- 関連するissueやPRがあれば記載 -->
- Closes #
- Related to #

## 📊 優先度 (Priority)
- [ ] 🔥 高 (MVP必須)
- [ ] 📊 中 (拡張機能)  
- [ ] 🔧 低 (将来的)

## 💡 実装案 (Implementation Ideas)
<!-- 実装についてのアイデアや考慮点があれば記載 -->

## 📝 その他 (Additional Notes)
<!-- その他補足情報 -->