# zaiq - AI Capacity Orchestrator

**Steady distribution of surplus AI capacity**

---

## What is zaiq?

**zaiq** is a Docker-deployable service that orchestrates AI development tasks across rate-limited APIs, starting with Claude Code and expanding to universal AI provider support.

### Etymology
- **zai** (在) - Hokkien/Singlish for "steady, capable"
- **zā'id** (زائد) - Arabic for "surplus, additional" 
- **q** - Queue management
- **zaiq** = Steady distribution of surplus capacity through intelligent queueing

---

## Development Roadmap

### Phase 2: Claude Code Supplement (Months 1-3)
Single-user orchestrator to maximize Claude Code utilization during downtime periods.

### Phase 4: Team Time-Share Platform (Months 7-12)  
Multi-user capacity sharing and time-block marketplace for teams.

### Phase 5: Universal AI Orchestrator (Year 2+)
Generic rate-limit workaround for all AI providers (GPT, Gemini, Claude, etc.).

---

## Installation (Coming Soon)

### Recommended: uv (Fast & Modern)
```bash
uv tool install zaiq
zaiq --help
```

### Alternative: pip
```bash
pip install zaiq
zaiq --help
```

---

## Project Status

**Current Phase:** Foundation & Planning  
**Documentation:** Complete project brief available in `docs/zaiq-project/`  
**Next Steps:** Technical architecture design and MVP development  

---

## Repository Structure

```
docs/zaiq-project/
├── README.md           # Project overview & session continuity
├── ETYMOLOGY.md        # Story behind the name 'zaiq'  
├── brief-complete.md   # Full project brief
├── sections/           # Individual brief sections
└── checkpoint-status.md # Development progress tracking
```

---

## Vision

*"From the steady hands of Singapore developers, to the surplus capacity in your team—zaiq makes every moment count."*

**zaiq** bridges cultures like Singapore bridges East and West, turning surplus into steady progress through intelligent orchestration.

---

**Private Development Phase** - Securing name across package registries before public release.