from enum import StrEnum


class Error(StrEnum):
    BAD_REQUEST = "MAL-ERR-CLI-BDR-001"
    UNAUTHORIZED = "MAL-ERR-CLI-ATH-001"
    FORBIDDEN = "MAL-ERR-CLI-FBD-001"
    NOT_FOUND = "MAL-ERR-CLI-NTF-001"
    METHOD_NOT_ALLOWED = "MAL-ERR-CLI-MNA-001"
    CONFLICT = "MAL-ERR-CLI-CFL-001"
    UNPROCESSABLE_ENTITY = "MAL-ERR-CLI-UPE-001"
    TOO_MANY_REQUESTS = "MAL-ERR-CLI-TMR-001"
    INTERNAL_SERVER_ERROR = "MAL-ERR-SRV-ISE-001"
    DATABASE_ERROR = "MAL-ERR-SRV-ISE-002"
    NOT_IMPLEMENTED = "MAL-ERR-SRV-NIM-001"
    BAD_GATEWAY = "MAL-ERR-SRV-BDG-001"
    SERVICE_UNAVAILABLE = "MAL-ERR-SRV-SUN-001"


class Result(StrEnum):
    ANY_DATA = "MAL-RES-ADT-001"
    NO_DATA = "MAL-RES-NDT-001"
    SINGLE_DATA = "MAL-RES-SGD-001"
    CREATE_SINGLE_DATA = "MAL-RES-SGD-002"
    UPDATE_SINGLE_DATA = "MAL-RES-SGD-003"
    OPTIONAL_SINGLE_DATA = "MAL-RES-OSD-001"
    READ_SINGLE_DATA = "MAL-RES-OSD-002"
    DELETE_SINGLE_DATA = "MAL-RES-OSD-003"
    MULTIPLE_DATA = "MAL-RES-MTD-001"
    CREATE_MULTIPLE_DATA = "MAL-RES-MTD-002"
    UPDATE_MULTIPLE_DATA = "MAL-RES-MTD-003"
    OPTIONAL_MULTIPLE_DATA = "MAL-RES-OMD-001"
    READ_MULTIPLE_DATA = "MAL-RES-OMD-002"
    DELETE_MULTIPLE_DATA = "MAL-RES-OMD-003"
