window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = [{"fullname": "taulu", "modulename": "taulu", "kind": "module", "doc": "<p>Taulu - <em>segment tables from images</em></p>\n\n<p>Taulu is a Python package designed to segment images of tables into their constituent rows and columns (and cells).</p>\n\n<p>To use this package, you first need to make an annotation of the headers in your table images.\nThe idea is that these headers will be similar across your full set of images, and they will be\nused as a starting point for the search algorithm that finds the table grid.</p>\n\n<p>Here is an example python script of how to use Taulu:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">taulu</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">Taulu</span>\n<span class=\"kn\">import</span><span class=\"w\"> </span><span class=\"nn\">os</span>\n\n\n<span class=\"k\">def</span><span class=\"w\"> </span><span class=\"nf\">setup</span><span class=\"p\">():</span>\n    <span class=\"c1\"># create an Annotation file of the headers in the image</span>\n    <span class=\"c1\"># (one for the left header, one for the right)</span>\n    <span class=\"c1\"># and store them in the examples directory</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;Annotating the LEFT header...&quot;</span><span class=\"p\">)</span>\n    <span class=\"n\">Taulu</span><span class=\"o\">.</span><span class=\"n\">annotate</span><span class=\"p\">(</span><span class=\"s2\">&quot;../data/table_00.png&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;table_00_header_left.png&quot;</span><span class=\"p\">)</span>\n\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;Annotating the RIGHT header...&quot;</span><span class=\"p\">)</span>\n    <span class=\"n\">Taulu</span><span class=\"o\">.</span><span class=\"n\">annotate</span><span class=\"p\">(</span><span class=\"s2\">&quot;../data/table_00.png&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;table_00_header_right.png&quot;</span><span class=\"p\">)</span>\n\n\n<span class=\"k\">def</span><span class=\"w\"> </span><span class=\"nf\">main</span><span class=\"p\">():</span>\n    <span class=\"n\">taulu</span> <span class=\"o\">=</span> <span class=\"n\">Taulu</span><span class=\"p\">((</span><span class=\"s2\">&quot;table_00_header_left.png&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;table_00_header_right.png&quot;</span><span class=\"p\">))</span>\n    <span class=\"n\">table</span> <span class=\"o\">=</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">segment_table</span><span class=\"p\">(</span><span class=\"s2\">&quot;../data/table_00.png&quot;</span><span class=\"p\">,</span>  <span class=\"n\">cell_height_factor</span><span class=\"o\">=</span><span class=\"mf\">0.8</span><span class=\"p\">,</span> <span class=\"n\">debug_view</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n\n    <span class=\"n\">table</span><span class=\"o\">.</span><span class=\"n\">show_cells</span><span class=\"p\">(</span><span class=\"s2\">&quot;../data/table_00.png&quot;</span><span class=\"p\">)</span>\n\n\n<span class=\"k\">if</span> <span class=\"vm\">__name__</span> <span class=\"o\">==</span> <span class=\"s2\">&quot;__main__&quot;</span><span class=\"p\">:</span>\n    <span class=\"k\">if</span> <span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">path</span><span class=\"o\">.</span><span class=\"n\">exists</span><span class=\"p\">(</span><span class=\"s2\">&quot;table_00_header_left.png&quot;</span><span class=\"p\">)</span> <span class=\"ow\">and</span> <span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">path</span><span class=\"o\">.</span><span class=\"n\">exists</span><span class=\"p\">(</span>\n        <span class=\"s2\">&quot;table_00_header_right.png&quot;</span>\n    <span class=\"p\">):</span>\n        <span class=\"n\">main</span><span class=\"p\">()</span>\n    <span class=\"k\">else</span><span class=\"p\">:</span>\n        <span class=\"n\">setup</span><span class=\"p\">()</span>\n        <span class=\"n\">main</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<p>If you want a high-level overview of how to use Taulu, see <a href=\"./taulu.html#taulu.taulu.Taulu\">the Taulu class</a></p>\n"}, {"fullname": "taulu.GridDetector", "modulename": "taulu", "qualname": "GridDetector", "kind": "class", "doc": "<p>Detects table grid intersections using morphological filtering and template matching.</p>\n\n<p>This detector implements a multi-stage pipeline:</p>\n\n<ol>\n<li><strong>Binarization</strong>: Sauvola adaptive thresholding to handle varying lighting</li>\n<li><strong>Morphological operations</strong>: Dilation to connect broken rule segments</li>\n<li><strong>Cross-kernel matching</strong>: Template matching with a cross-shaped kernel to find\nrule intersections where horizontal and vertical lines meet</li>\n<li><strong>Grid growing</strong>: Iterative point detection starting from a known seed point</li>\n</ol>\n\n<p>The cross-kernel is designed to match the specific geometry of your table rules.\nIt should be sized so that after morphology, it aligns with actual corner shapes.</p>\n\n<h2 id=\"tuning-guidelines\">Tuning Guidelines</h2>\n\n<ul>\n<li><strong>kernel_size</strong>: Increase if you need more selectivity (fewer false positives)</li>\n<li><strong>cross_width/height</strong>: Should match rule thickness after morphology</li>\n<li><strong>morph_size</strong>: Increase to connect more broken lines, but this thickens rules</li>\n<li><strong>sauvola_k</strong>: Increase to threshold more aggressively (remove noise)</li>\n<li><strong>search_region</strong>: Increase for documents with more warping/distortion</li>\n<li><strong>distance_penalty</strong>: Increase to prefer corners closer to expected positions</li>\n</ul>\n\n<h2 id=\"visual-debugging\">Visual Debugging</h2>\n\n<p>Set <code>visual=True</code> in methods to see intermediate results and tune parameters.</p>\n"}, {"fullname": "taulu.GridDetector.__init__", "modulename": "taulu", "qualname": "GridDetector.__init__", "kind": "function", "doc": "<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>kernel_size (int):</strong>  the size of the cross kernel\na larger kernel size often means that more penalty is applied, often leading\nto more sparse results</li>\n<li><strong>cross_width (int):</strong>  the width of one of the edges in the cross filter, should be\nroughly equal to the width of the rules in the image after morphology is applied</li>\n<li><strong>cross_height (int | None):</strong>  useful if the horizontal rules and vertical rules\nhave different sizes</li>\n<li><strong>morph_size (int | None):</strong>  the size of the morphology operators that are applied before\nthe cross kernel. 'bridges the gaps' of broken-up lines</li>\n<li><strong>sauvola_k (float):</strong>  threshold parameter for sauvola thresholding</li>\n<li><strong>sauvola_window (int):</strong>  window_size parameter for sauvola thresholding</li>\n<li><strong>scale (float):</strong>  image scale factor to do calculations on (useful for increasing calculation speed mostly)</li>\n<li><strong>search_region (int):</strong>  area in which to search for a new max value in <code>find_nearest</code> etc.</li>\n<li><strong>distance_penalty (float):</strong>  how much the point finding algorithm penalizes points that are further in the region [0, 1]</li>\n<li><strong>min_rows (int):</strong>  minimum number of rows to find before stopping the table finding algorithm</li>\n<li><strong>grow_threshold (float):</strong>  the threshold for accepting a new point when growing the table</li>\n<li><strong>look_distance (int):</strong>  how many points away to look when calculating the median slope</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">kernel_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">21</span>,</span><span class=\"param\">\t<span class=\"n\">cross_width</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">6</span>,</span><span class=\"param\">\t<span class=\"n\">cross_height</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">morph_size</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sauvola_k</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.04</span>,</span><span class=\"param\">\t<span class=\"n\">sauvola_window</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">15</span>,</span><span class=\"param\">\t<span class=\"n\">scale</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">1.0</span>,</span><span class=\"param\">\t<span class=\"n\">search_region</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">40</span>,</span><span class=\"param\">\t<span class=\"n\">distance_penalty</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.4</span>,</span><span class=\"param\">\t<span class=\"n\">min_rows</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">5</span>,</span><span class=\"param\">\t<span class=\"n\">grow_threshold</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.3</span>,</span><span class=\"param\">\t<span class=\"n\">look_distance</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">4</span></span>)</span>"}, {"fullname": "taulu.GridDetector.apply", "modulename": "taulu", "qualname": "GridDetector.apply", "kind": "function", "doc": "<p>Apply the grid detection filter to the input image.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>img (MatLike):</strong>  the input image</li>\n<li><strong>visual (bool):</strong>  whether to show intermediate steps</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>MatLike: the filtered image, with high values (whiter pixels) at intersections of horizontal and vertical rules</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">img</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">Mat</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">visual</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">Mat</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.GridDetector.find_nearest", "modulename": "taulu", "qualname": "GridDetector.find_nearest", "kind": "function", "doc": "<p>Find the nearest 'corner match' in the image, along with its score [0,1]</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>filtered (MatLike):</strong>  the filtered image (obtained through <code>apply</code>)</li>\n<li><strong>point (tuple[int, int]):</strong>  the approximate target point (x, y)</li>\n<li><strong>region (None | int):</strong>  alternative value for search region,\noverwriting the <code>__init__</code> parameter <code>region</code></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">filtered</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">Mat</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">point</span><span class=\"p\">:</span> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">region</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.GridDetector.find_table_points", "modulename": "taulu", "qualname": "GridDetector.find_table_points", "kind": "function", "doc": "<p>Parse the image to a <code>TableGrid</code> structure that holds all of the\nintersections between horizontal and vertical rules, starting near the <code>left_top</code> point</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>img (MatLike):</strong>  the input image of a table</li>\n<li><strong>left_top (tuple[int, int]):</strong>  the starting point of the algorithm</li>\n<li><strong>cell_widths (list[int]):</strong>  the expected widths of the cells (based on a header template)</li>\n<li><strong>cell_heights (list[int]):</strong>  the expected height of the rows of data.\nThe last value from this list is used until the image has no more vertical space.</li>\n<li><strong>visual (bool):</strong>  whether to show intermediate steps</li>\n<li><strong>window (str):</strong>  the name of the OpenCV window to use for visualization</li>\n<li><strong>goals_width (int | None):</strong>  the width of the goal region when searching for the next point.\nIf None, defaults to 1.5 * search_region</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>a TableGrid object</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">img</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">Mat</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">PathLike</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">left_top</span><span class=\"p\">:</span> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">cell_widths</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">cell_heights</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">visual</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">window</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;taulu&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">goals_width</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">grid</span><span class=\"o\">.</span><span class=\"n\">TableGrid</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.TableGrid", "modulename": "taulu", "qualname": "TableGrid", "kind": "class", "doc": "<p>A data class that allows segmenting the image into cells</p>\n", "bases": "taulu.table_indexer.TableIndexer"}, {"fullname": "taulu.TableGrid.__init__", "modulename": "taulu", "qualname": "TableGrid.__init__", "kind": "function", "doc": "<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>points:</strong>  a 2D list of intersections between hor. and vert. rules</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">points</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]]]</span>,</span><span class=\"param\">\t<span class=\"n\">right_offset</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, {"fullname": "taulu.TableGrid.points", "modulename": "taulu", "qualname": "TableGrid.points", "kind": "variable", "doc": "<p></p>\n", "annotation": ": list[list[typing.Tuple[int, int]]]"}, {"fullname": "taulu.TableGrid.row", "modulename": "taulu", "qualname": "TableGrid.row", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">i</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.TableGrid.cols", "modulename": "taulu", "qualname": "TableGrid.cols", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int"}, {"fullname": "taulu.TableGrid.rows", "modulename": "taulu", "qualname": "TableGrid.rows", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int"}, {"fullname": "taulu.TableGrid.from_split", "modulename": "taulu", "qualname": "TableGrid.from_split", "kind": "function", "doc": "<p>Convert two <code>TableGrid</code> objects into one, that is able to segment the original (non-cropped) image</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>split_grids (Split[TableGrid]):</strong>  a Split of TableGrid objects of the left and right part of the table</li>\n<li><strong>offsets (Split[tuple[int, int]]):</strong>  a Split of the offsets in the image where the crop happened</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">split_grids</span><span class=\"p\">:</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">split</span><span class=\"o\">.</span><span class=\"n\">Split</span><span class=\"p\">[</span><span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">grid</span><span class=\"o\">.</span><span class=\"n\">TableGrid</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">offsets</span><span class=\"p\">:</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">split</span><span class=\"o\">.</span><span class=\"n\">Split</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">grid</span><span class=\"o\">.</span><span class=\"n\">TableGrid</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.TableGrid.save", "modulename": "taulu", "qualname": "TableGrid.save", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "taulu.TableGrid.from_saved", "modulename": "taulu", "qualname": "TableGrid.from_saved", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">) -> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">grid</span><span class=\"o\">.</span><span class=\"n\">TableGrid</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.TableGrid.add_left_col", "modulename": "taulu", "qualname": "TableGrid.add_left_col", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">width</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "taulu.TableGrid.add_top_row", "modulename": "taulu", "qualname": "TableGrid.add_top_row", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">height</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "taulu.TableGrid.cell", "modulename": "taulu", "qualname": "TableGrid.cell", "kind": "function", "doc": "<p>Returns the coordinate (row, col) of the cell that contains the given position</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>point (tuple[float, float]):</strong>  a location in the input image</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>tuple[int, int]: the cell index (row, col) that contains the given point</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">point</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.TableGrid.cell_polygon", "modulename": "taulu", "qualname": "TableGrid.cell_polygon", "kind": "function", "doc": "<p>returns the polygon (used in e.g. opencv) that enscribes the cell at the given cell position</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">cell</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.TableGrid.region", "modulename": "taulu", "qualname": "TableGrid.region", "kind": "function", "doc": "<p>Get the bounding box for the rectangular region that goes from start to end</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>4 points: lt, rt, rb, lb, in format (x, y)</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">end</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.TableGrid.visualize_points", "modulename": "taulu", "qualname": "TableGrid.visualize_points", "kind": "function", "doc": "<p>Draw the detected table points on the image for visual verification</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">img</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">Mat</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "taulu.TableGrid.text_regions", "modulename": "taulu", "qualname": "TableGrid.text_regions", "kind": "function", "doc": "<p>Split the row into regions of continuous text</p>\n\n<p>Returns\n    list[tuple[int, int]]: a list of spans (start col, end col)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">img</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">Mat</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">row</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">margin_x</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">10</span>,</span><span class=\"param\">\t<span class=\"n\">margin_y</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mi\">3</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]]]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.HeaderAligner", "modulename": "taulu", "qualname": "HeaderAligner", "kind": "class", "doc": "<p>Aligns table header templates to subject images using feature-based registration.</p>\n\n<p>This class uses ORB (Oriented FAST and Rotated BRIEF) feature detection and\nmatching to compute a homography transformation that maps points from a header\ntemplate image to their corresponding locations in full table images.</p>\n\n<h2 id=\"how-it-works\">How it Works</h2>\n\n<ol>\n<li><strong>Feature Detection</strong>: Extracts ORB keypoints from both template and subject</li>\n<li><strong>Feature Matching</strong>: Finds correspondences using Hamming distance</li>\n<li><strong>Filtering</strong>: Keeps top matches and prunes based on spatial consistency</li>\n<li><strong>Homography Estimation</strong>: Computes perspective transform using RANSAC</li>\n</ol>\n\n<p>The computed homography can then transform any point from template space to\nimage space, allowing you to locate table structures based on your annotation.</p>\n\n<h2 id=\"preprocessing-options\">Preprocessing Options</h2>\n\n<ul>\n<li>Set <code>k</code> parameter to apply Sauvola thresholding before feature detection.\nThis can improve matching on documents with variable lighting.</li>\n<li>Set <code>k=None</code> to use raw images (just extract blue channel for BGR images)</li>\n</ul>\n\n<h2 id=\"tuning-guidelines\">Tuning Guidelines</h2>\n\n<ul>\n<li><strong>max_features</strong>: Increase if matching fails on complex templates</li>\n<li><strong>match_fraction</strong>: Decrease if you get many incorrect matches</li>\n<li><strong>max_dist</strong>: Increase for documents with more warping/distortion</li>\n<li><strong>scale</strong>: Decrease (&lt;1.0) to speed up on high-resolution images</li>\n</ul>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>template (MatLike | PathLike[str] | str | None):</strong>  Header template image or path.\nThis should contain a clear, representative view of the table header.</li>\n<li><strong>max_features (int):</strong>  Maximum ORB features to detect. More features = slower\nbut potentially more robust matching.</li>\n<li><strong>patch_size (int):</strong>  ORB patch size for feature extraction.</li>\n<li><strong>match_fraction (float):</strong>  Fraction [0, 1] of matches to keep after sorting by\nquality. Higher = more matches but potentially more outliers.</li>\n<li><strong>scale (float):</strong>  Image downscaling factor (0, 1] for processing speed.</li>\n<li><strong>max_dist (float):</strong>  Maximum allowed distance (relative to image size) between\nmatched keypoints. Filters out spatially inconsistent matches.</li>\n<li><strong>k (float | None):</strong>  Sauvola threshold parameter for preprocessing. If None,\nno thresholding is applied. Typical range: 0.03-0.15.</li>\n</ul>\n"}, {"fullname": "taulu.HeaderAligner.__init__", "modulename": "taulu", "qualname": "HeaderAligner.__init__", "kind": "function", "doc": "<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>template (MatLike | str):</strong>  (path of) template image, with the table template clearly visible</li>\n<li><strong>max_features (int):</strong>  maximal number of features that will be extracted by ORB</li>\n<li><strong>patch_size (int):</strong>  for ORB feature extractor</li>\n<li><strong>match_fraction (float):</strong>  best fraction of matches that are kept</li>\n<li><strong>scale (float):</strong>  image scale factor to do calculations on (useful for increasing calculation speed mostly)</li>\n<li><strong>max_dist (float):</strong>  maximum distance (relative to image size) of matched features.\nIncrease this value if the warping between image and template needs to be more agressive</li>\n<li><strong>k (float | None):</strong>  sauvola thresholding threshold value. If None, no sauvola thresholding is done</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">template</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">Mat</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">PathLike</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">max_features</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">25000</span>,</span><span class=\"param\">\t<span class=\"n\">patch_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">31</span>,</span><span class=\"param\">\t<span class=\"n\">match_fraction</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.6</span>,</span><span class=\"param\">\t<span class=\"n\">scale</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">1.0</span>,</span><span class=\"param\">\t<span class=\"n\">max_dist</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">1.0</span>,</span><span class=\"param\">\t<span class=\"n\">k</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"mf\">0.05</span></span>)</span>"}, {"fullname": "taulu.HeaderAligner.template", "modulename": "taulu", "qualname": "HeaderAligner.template", "kind": "variable", "doc": "<p>The template image that subject images are aligned to</p>\n"}, {"fullname": "taulu.HeaderAligner.view_alignment", "modulename": "taulu", "qualname": "HeaderAligner.view_alignment", "kind": "function", "doc": "<p>Show the alignment of the template on the given image\nby transforming it using the supplied transformation matrix <code>h</code>\nand visualising both on different channels</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>img (MatLike):</strong>  the image on which the template is transformed</li>\n<li><strong>h (NDArray):</strong>  the transformation matrix</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">img</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">Mat</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">h</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">[</span><span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">],</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">dtype</span><span class=\"p\">[</span><span class=\"o\">+</span><span class=\"n\">_ScalarType_co</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "taulu.HeaderAligner.align", "modulename": "taulu", "qualname": "HeaderAligner.align", "kind": "function", "doc": "<p>Calculates a homogeneous transformation matrix that maps pixels of\nthe template to the given image</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">img</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">Mat</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">visual</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">window</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;taulu&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">[</span><span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">],</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">dtype</span><span class=\"p\">[</span><span class=\"o\">+</span><span class=\"n\">_ScalarType_co</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.HeaderAligner.template_to_img", "modulename": "taulu", "qualname": "HeaderAligner.template_to_img", "kind": "function", "doc": "<p>Transform the given point (in template-space) using the transformation h\n(obtained through the <code>align</code> method)</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>h (NDArray):</strong>  transformation matrix of shape (3, 3)</li>\n<li><strong>point (Iterable[int]):</strong>  the to-be-transformed point, should conform to (x, y)</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">h</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">[</span><span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">],</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">dtype</span><span class=\"p\">[</span><span class=\"o\">+</span><span class=\"n\">_ScalarType_co</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">point</span><span class=\"p\">:</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.HeaderTemplate", "modulename": "taulu", "qualname": "HeaderTemplate", "kind": "class", "doc": "<p>Subclasses implement methods for going from a pixel in the input image to a table cell index,\nand cropping an image to the given table cell index.</p>\n", "bases": "taulu.table_indexer.TableIndexer"}, {"fullname": "taulu.HeaderTemplate.__init__", "modulename": "taulu", "qualname": "HeaderTemplate.__init__", "kind": "function", "doc": "<p>A TableTemplate is a collection of rules of a table. This class implements methods\nfor finding cell positions in a table image, given the template the image adheres to.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>rules:</strong>  2D array of lines, where each line is represented as [x0, y0, x1, y1]</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">rules</span><span class=\"p\">:</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]]</span></span>)</span>"}, {"fullname": "taulu.HeaderTemplate.save", "modulename": "taulu", "qualname": "HeaderTemplate.save", "kind": "function", "doc": "<p>Save the HeaderTemplate to the given path, as a json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">PathLike</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "taulu.HeaderTemplate.from_saved", "modulename": "taulu", "qualname": "HeaderTemplate.from_saved", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">PathLike</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">header_template</span><span class=\"o\">.</span><span class=\"n\">HeaderTemplate</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.HeaderTemplate.cols", "modulename": "taulu", "qualname": "HeaderTemplate.cols", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int"}, {"fullname": "taulu.HeaderTemplate.rows", "modulename": "taulu", "qualname": "HeaderTemplate.rows", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int"}, {"fullname": "taulu.HeaderTemplate.annotate_image", "modulename": "taulu", "qualname": "HeaderTemplate.annotate_image", "kind": "function", "doc": "<p>Utility method that allows users to create a template form a template image.</p>\n\n<p>The user is asked to click to annotate lines (two clicks per line).</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>template:</strong>  the image on which to annotate the header lines</li>\n<li><strong>crop (str | None):</strong>  if str, crop the template image first, then do the annotation.\nThe cropped image will be stored at the supplied path</li>\n<li><strong>margin (int):</strong>  margin to add around the cropping of the header</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">template</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">Mat</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">crop</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">PathLike</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">margin</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">10</span></span><span class=\"return-annotation\">) -> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">header_template</span><span class=\"o\">.</span><span class=\"n\">HeaderTemplate</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.HeaderTemplate.from_vgg_annotation", "modulename": "taulu", "qualname": "HeaderTemplate.from_vgg_annotation", "kind": "function", "doc": "<p>Create a TableTemplate from annotations made in <a href=\"https://annotate.officialstatistics.org/\">vgg</a>, using the polylines tool.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>annotation (str):</strong>  the path of the annotation csv file</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">annotation</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">header_template</span><span class=\"o\">.</span><span class=\"n\">HeaderTemplate</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.HeaderTemplate.cell_width", "modulename": "taulu", "qualname": "HeaderTemplate.cell_width", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">i</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.HeaderTemplate.cell_widths", "modulename": "taulu", "qualname": "HeaderTemplate.cell_widths", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.HeaderTemplate.cell_height", "modulename": "taulu", "qualname": "HeaderTemplate.cell_height", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">header_factor</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.8</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.HeaderTemplate.cell_heights", "modulename": "taulu", "qualname": "HeaderTemplate.cell_heights", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">header_factors</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">float</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.HeaderTemplate.intersection", "modulename": "taulu", "qualname": "HeaderTemplate.intersection", "kind": "function", "doc": "<p>Returns the interaction of the index[0]th horizontal rule and the\nindex[1]th vertical rule</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">index</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.HeaderTemplate.cell", "modulename": "taulu", "qualname": "HeaderTemplate.cell", "kind": "function", "doc": "<p>Get the cell index (row, col) that corresponds with the point (x, y) in the template image</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>point (tuple[float, float]):</strong>  the coordinates in the template image</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>tuple[int, int]: (row, col)</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">point</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.HeaderTemplate.cell_polygon", "modulename": "taulu", "qualname": "HeaderTemplate.cell_polygon", "kind": "function", "doc": "<p>Return points (x,y) that make up a polygon around the requested cell\n(top left, top right, bottom right, bottom left)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">cell</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.HeaderTemplate.region", "modulename": "taulu", "qualname": "HeaderTemplate.region", "kind": "function", "doc": "<p>Get the bounding box for the rectangular region that goes from start to end</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>4 points: lt, rt, rb, lb, in format (x, y)</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">end</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.HeaderTemplate.text_regions", "modulename": "taulu", "qualname": "HeaderTemplate.text_regions", "kind": "function", "doc": "<p>Split the row into regions of continuous text</p>\n\n<p>Returns\n    list[tuple[int, int]]: a list of spans (start col, end col)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">img</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">Mat</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">row</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">margin_x</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">10</span>,</span><span class=\"param\">\t<span class=\"n\">margin_y</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mi\">20</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]]]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.TableIndexer", "modulename": "taulu", "qualname": "TableIndexer", "kind": "class", "doc": "<p>Subclasses implement methods for going from a pixel in the input image to a table cell index,\nand cropping an image to the given table cell index.</p>\n", "bases": "abc.ABC"}, {"fullname": "taulu.TableIndexer.col_offset", "modulename": "taulu", "qualname": "TableIndexer.col_offset", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int"}, {"fullname": "taulu.TableIndexer.cols", "modulename": "taulu", "qualname": "TableIndexer.cols", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int"}, {"fullname": "taulu.TableIndexer.rows", "modulename": "taulu", "qualname": "TableIndexer.rows", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int"}, {"fullname": "taulu.TableIndexer.cells", "modulename": "taulu", "qualname": "TableIndexer.cells", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Generator</span><span class=\"p\">[</span><span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.TableIndexer.cell", "modulename": "taulu", "qualname": "TableIndexer.cell", "kind": "function", "doc": "<p>Returns the coordinate (row, col) of the cell that contains the given position</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>point (tuple[float, float]):</strong>  a location in the input image</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>tuple[int, int]: the cell index (row, col) that contains the given point</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">point</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.TableIndexer.cell_polygon", "modulename": "taulu", "qualname": "TableIndexer.cell_polygon", "kind": "function", "doc": "<p>returns the polygon (used in e.g. opencv) that enscribes the cell at the given cell position</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">cell</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.TableIndexer.highlight_all_cells", "modulename": "taulu", "qualname": "TableIndexer.highlight_all_cells", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">image</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">Mat</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">color</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">(</span><span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"mi\">255</span><span class=\"p\">)</span>,</span><span class=\"param\">\t<span class=\"n\">thickness</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">1</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">Mat</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.TableIndexer.select_one_cell", "modulename": "taulu", "qualname": "TableIndexer.select_one_cell", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">image</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">Mat</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;taulu&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">color</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">(</span><span class=\"mi\">255</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">)</span>,</span><span class=\"param\">\t<span class=\"n\">thickness</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">2</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.TableIndexer.show_cells", "modulename": "taulu", "qualname": "TableIndexer.show_cells", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">image</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">Mat</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">PathLike</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">window</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;taulu&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.TableIndexer.region", "modulename": "taulu", "qualname": "TableIndexer.region", "kind": "function", "doc": "<p>Get the bounding box for the rectangular region that goes from start to end</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>4 points: lt, rt, rb, lb, in format (x, y)</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">end</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.TableIndexer.crop_region", "modulename": "taulu", "qualname": "TableIndexer.crop_region", "kind": "function", "doc": "<p>Crop the input image to a rectangular region with the start and end cells as extremes</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">image</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">Mat</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">end</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">margin</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">margin_top</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">margin_bottom</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">margin_left</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">margin_right</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">margin_y</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">margin_x</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">Mat</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.TableIndexer.text_regions", "modulename": "taulu", "qualname": "TableIndexer.text_regions", "kind": "function", "doc": "<p>Split the row into regions of continuous text</p>\n\n<p>Returns\n    list[tuple[int, int]]: a list of spans (start col, end col)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">img</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">Mat</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">row</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">margin_x</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">margin_y</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">],</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]]]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.TableIndexer.crop_cell", "modulename": "taulu", "qualname": "TableIndexer.crop_cell", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">image</span>,</span><span class=\"param\">\t<span class=\"n\">cell</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">margin</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">Mat</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.Split", "modulename": "taulu", "qualname": "Split", "kind": "class", "doc": "<p>Container for paired left/right data with convenient manipulation methods.</p>\n\n<p>The Split class is designed for working with table images that span two pages\nor have distinct left and right sections. It allows you to:</p>\n\n<ul>\n<li>Store related data for both sides</li>\n<li>Apply functions to both sides simultaneously</li>\n<li>Access attributes/methods of contained objects transparently</li>\n</ul>\n\n<h6 id=\"examples\">Examples:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># Create a split with different parameters for each side</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">thresholds</span> <span class=\"o\">=</span> <span class=\"n\">Split</span><span class=\"p\">(</span><span class=\"mf\">0.25</span><span class=\"p\">,</span> <span class=\"mf\">0.30</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># Apply a function to both sides</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">images</span> <span class=\"o\">=</span> <span class=\"n\">Split</span><span class=\"p\">(</span><span class=\"n\">left_img</span><span class=\"p\">,</span> <span class=\"n\">right_img</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">processed</span> <span class=\"o\">=</span> <span class=\"n\">images</span><span class=\"o\">.</span><span class=\"n\">apply</span><span class=\"p\">(</span><span class=\"k\">lambda</span> <span class=\"n\">img</span><span class=\"p\">:</span> <span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">blur</span><span class=\"p\">(</span><span class=\"n\">img</span><span class=\"p\">,</span> <span class=\"p\">(</span><span class=\"mi\">5</span><span class=\"p\">,</span> <span class=\"mi\">5</span><span class=\"p\">)))</span>\n<span class=\"gp\">&gt;&gt;&gt;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># Use with different parameters per side</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">results</span> <span class=\"o\">=</span> <span class=\"n\">images</span><span class=\"o\">.</span><span class=\"n\">apply</span><span class=\"p\">(</span>\n<span class=\"gp\">... </span>    <span class=\"k\">lambda</span> <span class=\"n\">img</span><span class=\"p\">,</span> <span class=\"n\">k</span><span class=\"p\">:</span> <span class=\"n\">sauvola_threshold</span><span class=\"p\">(</span><span class=\"n\">img</span><span class=\"p\">,</span> <span class=\"n\">k</span><span class=\"p\">),</span>\n<span class=\"gp\">... </span>    <span class=\"n\">k</span><span class=\"o\">=</span><span class=\"n\">thresholds</span>  <span class=\"c1\"># k.left used for left img, k.right for right</span>\n<span class=\"gp\">... </span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># Access methods of contained objects directly</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">templates</span> <span class=\"o\">=</span> <span class=\"n\">Split</span><span class=\"p\">(</span><span class=\"n\">template_left</span><span class=\"p\">,</span> <span class=\"n\">template_right</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">widths</span> <span class=\"o\">=</span> <span class=\"n\">templates</span><span class=\"o\">.</span><span class=\"n\">cell_widths</span><span class=\"p\">(</span><span class=\"mi\">0</span><span class=\"p\">)</span>  <span class=\"c1\"># Calls on both templates</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"type-parameters\">Type Parameters:</h6>\n\n<blockquote>\n  <p>T: The type of objects stored in left and right</p>\n</blockquote>\n", "bases": "typing.Generic[~T]"}, {"fullname": "taulu.Split.__init__", "modulename": "taulu", "qualname": "Split.__init__", "kind": "function", "doc": "<p>Initialize a Split container.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>left:</strong>  Data for the left side</li>\n<li><strong>right:</strong>  Data for the right side</li>\n</ul>\n\n<h6 id=\"note\">Note:</h6>\n\n<blockquote>\n  <p>Both can initially be None. Use the <code>append</code> method or set\n  properties directly to populate.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">left</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">T</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">right</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">T</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, {"fullname": "taulu.Split.left", "modulename": "taulu", "qualname": "Split.left", "kind": "variable", "doc": "<p></p>\n", "annotation": ": ~T"}, {"fullname": "taulu.Split.right", "modulename": "taulu", "qualname": "Split.right", "kind": "variable", "doc": "<p></p>\n", "annotation": ": ~T"}, {"fullname": "taulu.Split.append", "modulename": "taulu", "qualname": "Split.append", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">T</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "taulu.Split.apply", "modulename": "taulu", "qualname": "Split.apply", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">funcs</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Split[Callable[[T, *Any], V]] | Callable[[T, *Any], V]&#39;</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">split</span><span class=\"o\">.</span><span class=\"n\">Split</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">V</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "taulu.Taulu", "modulename": "taulu", "qualname": "Taulu", "kind": "class", "doc": "<p>High-level API for table segmentation from images.</p>\n\n<p>Taulu provides a simplified interface that orchestrates header alignment,\ngrid detection, and table segmentation into a single workflow. It's designed\nto hide complexity while still allowing fine-tuned control through parameters.</p>\n\n<h2 id=\"workflow-overview\">Workflow Overview</h2>\n\n<ol>\n<li><strong>Header Template Creation</strong>: Use <code>Taulu.annotate()</code> to create annotated\nheader images that define your table structure</li>\n<li><strong>Initialization</strong>: Create a Taulu instance with your header(s) and parameters</li>\n<li><strong>Segmentation</strong>: Call <code>segment_table()</code> on your table images to get a\n<code>TableGrid</code> object containing all detected cell boundaries</li>\n</ol>\n\n<h2 id=\"single-vs-split-tables\">Single vs Split Tables</h2>\n\n<p>Taulu supports two modes:</p>\n\n<ul>\n<li><strong>Single header</strong>: For tables that fit on one page or have consistent structure</li>\n<li><strong>Split header</strong>: For tables that span two pages (left/right) with potentially\ndifferent parameters for each side</li>\n</ul>\n\n<p>Use <code>Split[T]</code> objects to provide different parameters for left and right sides.</p>\n\n<h2 id=\"parameter-tuning-strategy\">Parameter Tuning Strategy</h2>\n\n<p>If segmentation fails or is inaccurate:</p>\n\n<ol>\n<li><strong>Visual debugging</strong>: Set <code>debug_view=True</code> in <code>segment_table()</code> to see\nintermediate results</li>\n<li><strong>Adjust thresholding</strong>: Modify <code>sauvola_k</code> to change binarization sensitivity\n<ul>\n<li>Increase to remove more noise (more aggressive)</li>\n<li>Decrease to preserve faint lines</li>\n</ul></li>\n<li><strong>Tune cross-kernel</strong>: Adjust <code>cross_width</code>, <code>cross_height</code>, <code>kernel_size</code>\nto match your rule thickness after morphology</li>\n<li><strong>Morphology</strong>: Increase <code>morph_size</code> to connect broken lines, but be aware\nthis also thickens lines (requiring larger cross_width)</li>\n<li><strong>Search parameters</strong>: Increase <code>search_region</code> for warped documents,\nadjust <code>distance_penalty</code> to control how strictly positions are enforced</li>\n<li><strong>Growth parameters</strong>: Lower <code>grow_threshold</code> if the algorithm stops too early,\nincrease <code>look_distance</code> for better extrapolation</li>\n</ol>\n\n<h6 id=\"examples\">Examples:</h6>\n\n<blockquote>\n  <p>Basic usage with a single header:</p>\n  \n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">taulu</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">Taulu</span>\n<span class=\"gp\">&gt;&gt;&gt;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># First, create annotated header (one-time setup)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Taulu</span><span class=\"o\">.</span><span class=\"n\">annotate</span><span class=\"p\">(</span><span class=\"s2\">&quot;table_image.png&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;header.png&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># This creates header.png and header.json</span>\n<span class=\"gp\">&gt;&gt;&gt;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># Initialize Taulu with the header</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">taulu</span> <span class=\"o\">=</span> <span class=\"n\">Taulu</span><span class=\"p\">(</span>\n<span class=\"gp\">... </span>    <span class=\"n\">header_image_path</span><span class=\"o\">=</span><span class=\"s2\">&quot;header.png&quot;</span><span class=\"p\">,</span>\n<span class=\"gp\">... </span>    <span class=\"n\">cell_height_factor</span><span class=\"o\">=</span><span class=\"mf\">0.8</span><span class=\"p\">,</span>  <span class=\"c1\"># Rows are 80% of header height</span>\n<span class=\"gp\">... </span>    <span class=\"n\">sauvola_k</span><span class=\"o\">=</span><span class=\"mf\">0.25</span><span class=\"p\">,</span>\n<span class=\"gp\">... </span>    <span class=\"n\">search_region</span><span class=\"o\">=</span><span class=\"mi\">60</span><span class=\"p\">,</span>\n<span class=\"gp\">... </span>    <span class=\"n\">cross_width</span><span class=\"o\">=</span><span class=\"mi\">10</span>\n<span class=\"gp\">... </span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># Segment a table image</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">grid</span> <span class=\"o\">=</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">segment_table</span><span class=\"p\">(</span><span class=\"s2\">&quot;table_page_01.png&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># Use the grid to extract cells</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">import</span><span class=\"w\"> </span><span class=\"nn\">cv2</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">img</span> <span class=\"o\">=</span> <span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">imread</span><span class=\"p\">(</span><span class=\"s2\">&quot;table_page_01.png&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">cell_image</span> <span class=\"o\">=</span> <span class=\"n\">grid</span><span class=\"o\">.</span><span class=\"n\">crop_cell</span><span class=\"p\">(</span><span class=\"n\">img</span><span class=\"p\">,</span> <span class=\"p\">(</span><span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">))</span>  <span class=\"c1\"># First cell</span>\n</code></pre>\n  </div>\n  \n  <p>Using split headers for two-page tables:</p>\n  \n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">taulu</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">Taulu</span><span class=\"p\">,</span> <span class=\"n\">Split</span>\n<span class=\"gp\">&gt;&gt;&gt;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># Annotate both headers</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Taulu</span><span class=\"o\">.</span><span class=\"n\">annotate</span><span class=\"p\">(</span><span class=\"s2\">&quot;scan_01.png&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;header_left.png&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Taulu</span><span class=\"o\">.</span><span class=\"n\">annotate</span><span class=\"p\">(</span><span class=\"s2\">&quot;scan_01.png&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;header_right.png&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># Use different parameters for each side</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">taulu</span> <span class=\"o\">=</span> <span class=\"n\">Taulu</span><span class=\"p\">(</span>\n<span class=\"gp\">... </span>    <span class=\"n\">header_image_path</span><span class=\"o\">=</span><span class=\"n\">Split</span><span class=\"p\">(</span><span class=\"s2\">&quot;header_left.png&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;header_right.png&quot;</span><span class=\"p\">),</span>\n<span class=\"gp\">... </span>    <span class=\"n\">cell_height_factor</span><span class=\"o\">=</span><span class=\"n\">Split</span><span class=\"p\">([</span><span class=\"mf\">0.8</span><span class=\"p\">,</span> <span class=\"mf\">0.9</span><span class=\"p\">],</span> <span class=\"p\">[</span><span class=\"mf\">0.75</span><span class=\"p\">]),</span>  <span class=\"c1\"># Different row heights</span>\n<span class=\"gp\">... </span>    <span class=\"n\">sauvola_k</span><span class=\"o\">=</span><span class=\"n\">Split</span><span class=\"p\">(</span><span class=\"mf\">0.25</span><span class=\"p\">,</span> <span class=\"mf\">0.30</span><span class=\"p\">),</span>  <span class=\"c1\"># Different thresholds</span>\n<span class=\"gp\">... </span>    <span class=\"n\">cross_width</span><span class=\"o\">=</span><span class=\"mi\">10</span>  <span class=\"c1\"># Same for both sides</span>\n<span class=\"gp\">... </span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># Segment returns a unified grid</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">grid</span> <span class=\"o\">=</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">segment_table</span><span class=\"p\">(</span><span class=\"s2\">&quot;scan_01.png&quot;</span><span class=\"p\">)</span>\n</code></pre>\n  </div>\n  \n  <p>Debug visualization to tune parameters:</p>\n  \n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">taulu</span> <span class=\"o\">=</span> <span class=\"n\">Taulu</span><span class=\"p\">(</span><span class=\"s2\">&quot;header.png&quot;</span><span class=\"p\">,</span> <span class=\"n\">sauvola_k</span><span class=\"o\">=</span><span class=\"mf\">0.15</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># Opens windows showing each processing step</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># Press &#39;n&#39; to advance, &#39;q&#39; to quit</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">grid</span> <span class=\"o\">=</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">segment_table</span><span class=\"p\">(</span><span class=\"s2\">&quot;table.png&quot;</span><span class=\"p\">,</span> <span class=\"n\">debug_view</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># Adjust parameters based on what you see:</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># - If binarization is too noisy: increase sauvola_k</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># - If lines are broken after morphology: increase morph_size</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># - If filtered image has &quot;undefined&quot; corners: adjust cross_width to match line thickness (after morphology)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># - If corners are missed during search: decrease grow_threshold or increase search_region</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"attributes\">Attributes:</h6>\n\n<ul>\n<li><strong>_header (MatLike | Split[MatLike]):</strong>  Loaded header image(s)</li>\n<li><strong>_aligner (HeaderAligner | Split[HeaderAligner]):</strong>  Header alignment engine(s)</li>\n<li><strong>_template (HeaderTemplate | Split[HeaderTemplate]):</strong>  Parsed header structure(s)</li>\n<li><strong>_grid_detector (GridDetector | Split[GridDetector]):</strong>  Grid detection engine(s)</li>\n<li><strong>_cell_heights (list[int] | Split[list[int]]):</strong>  Computed cell heights in pixels</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>TauluException:</strong>  If header files don't exist, annotation is missing, or\nSplit parameters are used incorrectly with single headers</li>\n</ul>\n\n<h6 id=\"see-also\">See Also:</h6>\n\n<blockquote>\n  <ul>\n  <li><code>TableGrid</code>: The result object with methods for accessing cells</li>\n  <li><code>Split</code>: Container for paired left/right parameters</li>\n  <li><code>GridDetector</code>: Lower-level grid detection (for advanced usage)</li>\n  <li><code>HeaderAligner</code>: Lower-level header alignment (for advanced usage)</li>\n  </ul>\n</blockquote>\n"}, {"fullname": "taulu.Taulu.__init__", "modulename": "taulu", "qualname": "Taulu.__init__", "kind": "function", "doc": "<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>header_image_path:</strong>  Path to the header template image(s). The header should be a cropped\nimage showing a clear view of the table's first row. An annotation\nfile (.json) must exist alongside the image, created via <code>Taulu.annotate()</code>.\nFor split tables, provide a <code>Split</code> containing left and right header paths.</li>\n<li><p><strong>cell_height_factor:</strong>  Height of data rows relative to header height. For example, if your\nheader is 100px tall and data rows are 80px tall, use 0.8.</p>\n\n<ul>\n<li><strong>float</strong>: All rows have the same height</li>\n<li><strong>list[float]</strong>: Different heights for different rows. The last value\nis repeated for any additional rows beyond the list length. Useful when\nthe first data row is taller than subsequent rows.</li>\n<li><strong>Split</strong>: Different height factors for left and right sides</li>\n</ul>\n\n<p>Default: [1.0]</p></li>\n<li><strong>header_anno_path (PathLike[str] | str | Split[PathLike[str] | str] | None):</strong>  Optional explicit path to header annotation JSON file(s). If None,\nlooks for a .json file with the same name as <code>header_image_path</code>.\nDefault: None</li>\n<li><p><strong>sauvola_k (float | Split[float]):</strong>  Threshold sensitivity for Sauvola adaptive binarization (0.0-1.0).\nControls how aggressively the algorithm converts the image to binary.</p>\n\n<ul>\n<li><strong>Lower values</strong> (0.04-0.15): Preserve faint lines, more noise</li>\n<li><strong>Higher values</strong> (0.20-0.35): Remove noise, may lose faint lines</li>\n</ul>\n\n<p>Start with 0.25 and adjust based on your image quality.\nDefault: 0.25</p></li>\n<li><p><strong>search_region (int | Split[int]):</strong>  Size in pixels of the square region to search for the next corner point.\nThe algorithm estimates where a corner should be, then searches within\nthis region for the best match.</p>\n\n<ul>\n<li><strong>Smaller values</strong> (20-40): Faster, requires well-aligned tables</li>\n<li><strong>Larger values</strong> (60-100): More robust to warping and distortion</li>\n</ul>\n\n<p>Default: 60</p></li>\n<li><p><strong>distance_penalty (float | Split[float]):</strong>  Weight factor [0, 1] for penalizing corners far from expected position.\nUses Gaussian weighting within the search region.</p>\n\n<ul>\n<li><strong>0.0</strong>: No penalty, any position in search region is equally valid</li>\n<li><strong>0.5</strong>: Moderate preference for positions near the expected location</li>\n<li><strong>1.0</strong>: Strong preference, only accepts positions very close to expected</li>\n</ul>\n\n<p>Default: 0.4</p></li>\n<li><p><strong>cross_width (int | Split[int]):</strong>  Width in pixels of the cross-shaped kernel used to detect intersections.\nShould approximately match the thickness of your table rules AFTER\nmorphological dilation.</p>\n\n<p><strong>Tuning</strong>: Look at the dilated image in debug_view. The cross_width\nshould match the thickness of the black lines you see.\nDefault: 10</p></li>\n<li><p><strong>morph_size (int | Split[int]):</strong>  Size of morphological structuring element for dilation. Controls how\nmuch gap-bridging occurs to connect broken line segments.</p>\n\n<ul>\n<li><strong>Smaller values</strong> (2-4): Minimal connection, preserves thin lines</li>\n<li><strong>Larger values</strong> (6-10): Connects larger gaps, but thickens lines</li>\n</ul>\n\n<p>Note: Increasing this requires increasing <code>cross_width</code> proportionally.\nDefault: 4</p></li>\n<li><p><strong>kernel_size (int | Split[int]):</strong>  Size of the cross-shaped kernel (must be odd). Larger kernels are more\nselective, reducing false positives but potentially missing valid corners.</p>\n\n<ul>\n<li><strong>Smaller values</strong> (21-31): More sensitive, finds more candidates</li>\n<li><strong>Larger values</strong> (41-61): More selective, fewer false positives</li>\n</ul>\n\n<p>Default: 41</p></li>\n<li><p><strong>processing_scale (float | Split[float]):</strong>  Image downscaling factor (0, 1] for processing speed. Processing is done\non scaled images, then results are scaled back to original size.</p>\n\n<ul>\n<li><strong>1.0</strong>: Full resolution (slowest, most accurate)</li>\n<li><strong>0.5-0.75</strong>: Good balance for high-res scans (2x-4x speedup)</li>\n<li><strong>0.25-0.5</strong>: Fast processing for very large images</li>\n</ul>\n\n<p>Default: 1.0</p></li>\n<li><strong>min_rows (int | Split[int]):</strong>  Minimum number of rows required before the algorithm considers the\ntable complete. Prevents stopping too early on tables with initial\nlow-confidence detections.\nDefault: 5</li>\n<li><p><strong>look_distance (int | Split[int]):</strong>  Number of adjacent rows/columns to examine when extrapolating missing\ncorners using polynomial regression. Higher values provide more context\nbut may smooth over legitimate variations.</p>\n\n<ul>\n<li><strong>2-3</strong>: Good for consistent grids</li>\n<li><strong>4-6</strong>: Better for grids with some irregularity</li>\n</ul>\n\n<p>Default: 3</p></li>\n<li><p><strong>grow_threshold (float | Split[float]):</strong>  Initial minimum confidence [0, 1] required to accept a detected corner\nduring the growing phase. The algorithm may adaptively lower this\nthreshold if growth stalls.</p>\n\n<ul>\n<li><strong>Higher values</strong> (0.5-0.8): Stricter, fewer errors but may miss valid corners</li>\n<li><strong>Lower values</strong> (0.2-0.4): More permissive, finds more corners but more errors</li>\n</ul>\n\n<p>Default: 0.3</p></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">header_image_path</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">PathLike</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">split</span><span class=\"o\">.</span><span class=\"n\">Split</span><span class=\"p\">[</span><span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">PathLike</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">str</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">cell_height_factor</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">],</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">split</span><span class=\"o\">.</span><span class=\"n\">Split</span><span class=\"p\">[</span><span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"p\">[</span><span class=\"mf\">1.0</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">header_anno_path</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">PathLike</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">split</span><span class=\"o\">.</span><span class=\"n\">Split</span><span class=\"p\">[</span><span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">PathLike</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sauvola_k</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">split</span><span class=\"o\">.</span><span class=\"n\">Split</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"mf\">0.25</span>,</span><span class=\"param\">\t<span class=\"n\">search_region</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">split</span><span class=\"o\">.</span><span class=\"n\">Split</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"mi\">60</span>,</span><span class=\"param\">\t<span class=\"n\">distance_penalty</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">split</span><span class=\"o\">.</span><span class=\"n\">Split</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"mf\">0.4</span>,</span><span class=\"param\">\t<span class=\"n\">cross_width</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">split</span><span class=\"o\">.</span><span class=\"n\">Split</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"mi\">10</span>,</span><span class=\"param\">\t<span class=\"n\">morph_size</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">split</span><span class=\"o\">.</span><span class=\"n\">Split</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"mi\">4</span>,</span><span class=\"param\">\t<span class=\"n\">kernel_size</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">split</span><span class=\"o\">.</span><span class=\"n\">Split</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"mi\">41</span>,</span><span class=\"param\">\t<span class=\"n\">processing_scale</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">split</span><span class=\"o\">.</span><span class=\"n\">Split</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"mf\">1.0</span>,</span><span class=\"param\">\t<span class=\"n\">min_rows</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">split</span><span class=\"o\">.</span><span class=\"n\">Split</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"mi\">5</span>,</span><span class=\"param\">\t<span class=\"n\">look_distance</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">split</span><span class=\"o\">.</span><span class=\"n\">Split</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"mi\">3</span>,</span><span class=\"param\">\t<span class=\"n\">grow_threshold</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">split</span><span class=\"o\">.</span><span class=\"n\">Split</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"mf\">0.3</span></span>)</span>"}, {"fullname": "taulu.Taulu.annotate", "modulename": "taulu", "qualname": "Taulu.annotate", "kind": "function", "doc": "<p>Interactive tool to create header annotations for table segmentation.</p>\n\n<p>This method guides you through a two-step annotation process:</p>\n\n<ol>\n<li><strong>Crop the header</strong>: Click four corners to define the header region</li>\n<li><strong>Annotate lines</strong>: Click pairs of points to define each vertical and\nhorizontal line in the header</li>\n</ol>\n\n<p>The annotations are saved as:</p>\n\n<ul>\n<li>A cropped header image (.png) at <code>output_path</code></li>\n<li>A JSON file (.json) containing line coordinates</li>\n</ul>\n\n<h2 id=\"annotation-guidelines\">Annotation Guidelines</h2>\n\n<p><strong>Which lines to annotate:</strong></p>\n\n<ul>\n<li>All vertical lines that extend into the table body (column separators)</li>\n<li>The top horizontal line of the header</li>\n<li>The bottom horizontal line of the header (top of data rows)</li>\n</ul>\n\n<p><strong>Order doesn't matter</strong> - annotate lines in any order that's convenient.</p>\n\n<p><strong>To annotate a line:</strong></p>\n\n<ol>\n<li>Click once at one endpoint</li>\n<li>Click again at the other endpoint</li>\n<li>A green line appears showing your annotation</li>\n</ol>\n\n<p><strong>To undo:</strong></p>\n\n<ul>\n<li>Right-click anywhere to remove the last line you drew</li>\n</ul>\n\n<p><strong>When finished:</strong></p>\n\n<ul>\n<li>Press 'n' to save and exit</li>\n<li>Press 'q' to quit without saving</li>\n</ul>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>image_path (PathLike[str] | str):</strong>  Path to a table image containing\na clear view of the header. This can be a full table image.</li>\n<li><strong>output_path (PathLike[str] | str):</strong>  Where to save the cropped header\nimage. The annotation JSON will be saved with the same name but\n.json extension.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>TauluException:</strong>  If image_path doesn't exist or output_path is a directory</li>\n</ul>\n\n<h6 id=\"examples\">Examples:</h6>\n\n<blockquote>\n  <p>Annotate a single header:</p>\n  \n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">taulu</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">Taulu</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Taulu</span><span class=\"o\">.</span><span class=\"n\">annotate</span><span class=\"p\">(</span><span class=\"s2\">&quot;scan_page_01.png&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;header.png&quot;</span><span class=\"p\">)</span>\n<span class=\"go\">&lt;h1 id=&quot;interactive-window-opens&quot;&gt;Interactive window opens&lt;/h1&gt;</span>\n</code></pre>\n  </div>\n  \n  <h1 id=\"after-annotation-creates-headerpng-and-headerjson\">After annotation: creates header.png and header.json</h1>\n  \n  <p>Annotate left and right headers for a split table:</p>\n  \n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Taulu</span><span class=\"o\">.</span><span class=\"n\">annotate</span><span class=\"p\">(</span><span class=\"s2\">&quot;scan_page_01.png&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;header_left.png&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Taulu</span><span class=\"o\">.</span><span class=\"n\">annotate</span><span class=\"p\">(</span><span class=\"s2\">&quot;scan_page_01.png&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;header_right.png&quot;</span><span class=\"p\">)</span>\n<span class=\"go\">&lt;h1 id=&quot;creates-header_leftpngjson-and-header_rightpngjson&quot;&gt;Creates header_left.{png,json} and header_right.{png,json}&lt;/h1&gt;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"notes\">Notes:</h6>\n\n<blockquote>\n  <ul>\n  <li>The header image doesn't need to be perfectly cropped initially -\n  the tool will help you crop it precisely</li>\n  <li>Annotation accuracy is important: misaligned lines will cause\n  segmentation errors</li>\n  <li>You can re-run this method to update annotations if needed</li>\n  </ul>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">image_path</span><span class=\"p\">:</span> <span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">PathLike</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">output_path</span><span class=\"p\">:</span> <span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">PathLike</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "taulu.Taulu.segment_table", "modulename": "taulu", "qualname": "Taulu.segment_table", "kind": "function", "doc": "<p>Segment a table image into a grid of cells.</p>\n\n<p>This is the main entry point for the taulu package. It orchestrates:</p>\n\n<ol>\n<li><strong>Header alignment</strong>: Locates the table by matching the header template\nto the image using feature-based registration (ORB features + homography)</li>\n<li><strong>Grid detection</strong>: Applies morphological filtering and cross-correlation\nto find corner intersections</li>\n<li><strong>Grid growing</strong>: Iteratively detects corners row-by-row and column-by-column,\nstarting from the aligned header position</li>\n<li><strong>Extrapolation</strong>: Fills in any missing corners using polynomial regression\nbased on neighboring detected points</li>\n<li><strong>Smoothing</strong>: Refines corner positions for consistency</li>\n</ol>\n\n<h2 id=\"performance-notes\">Performance Notes</h2>\n\n<p>Processing time depends on:</p>\n\n<ul>\n<li>Image resolution (use <code>processing_scale &lt; 1.0</code> for large images)</li>\n<li>Table complexity (more rows/columns = longer processing)</li>\n<li>Parameter tuning (lower thresholds = more computation)</li>\n</ul>\n\n<p>Typical processing times:</p>\n\n<ul>\n<li>Small tables (10 rows, 5 cols, 2000x1500px): 1-3 seconds</li>\n<li>Large tables (50 rows, 10 cols, 4000x3000px): 5-15 seconds</li>\n</ul>\n\n<h2 id=\"troubleshooting\">Troubleshooting</h2>\n\n<p><strong>If segmentation fails (returns incomplete grid):</strong></p>\n\n<ol>\n<li>Enable <code>debug_view=True</code> to see where it stops</li>\n<li>Check if header alignment is correct (first debug image)</li>\n<li>Verify cross-correlation shows bright spots at corners</li>\n<li>Adjust <code>grow_threshold</code> (lower if stopping too early)</li>\n<li>Increase <code>search_region</code> if corners are far from expected positions</li>\n</ol>\n\n<p><strong>If segmentation is inaccurate (corners in wrong positions):</strong></p>\n\n<ol>\n<li>Check binarization quality (adjust <code>sauvola_k</code>)</li>\n<li>Verify cross-kernel size matches line thickness (adjust <code>cross_width</code>)</li>\n<li>Ensure morphology isn't over-connecting (reduce <code>morph_size</code>)</li>\n<li>Increase <code>distance_penalty</code> to enforce expected positions more strictly</li>\n</ol>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>image (MatLike | PathLike[str] | str):</strong>  Table image to segment.\nCan be a file path or a numpy array (BGR or grayscale).</li>\n<li><p><strong>debug_view (bool):</strong>  If True, opens OpenCV windows showing intermediate\nprocessing steps:</p>\n\n<ul>\n<li>Header alignment overlay</li>\n<li>Binarized image</li>\n<li>After morphological operations</li>\n<li>Cross-correlation result</li>\n<li>Growing progress (corner-by-corner)</li>\n</ul>\n\n<p><strong>Controls:</strong></p>\n\n<ul>\n<li>Press 'n' to advance to next step</li>\n<li>Press 'q' to quit immediately</li>\n</ul>\n\n<p>Useful for parameter tuning and understanding failures.\nDefault: False</p></li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>TableGrid: A grid structure containing detected corner positions with\n      methods for:</p>\n\n<pre><code>**Position queries:**\n- `cell(point)`: Get (row, col) at pixel coordinates (x, y)\n- `cell_polygon(cell)`: Get 4 corners of a cell as (lt, rt, rb, lb)\n- `region(start, end)`: Get bounding box for a cell range\n\n**Image extraction:**\n- `crop_cell(img, cell, margin=0)`: Extract single cell with optional margin\n- `crop_region(img, start, end, margin=0)`: Extract rectangular region\n\n**Visualization:**\n- `show_cells(img)`: Interactive cell viewer (click to highlight)\n- `highlight_all_cells(img)`: Draw all cell boundaries\n- `visualize_points(img)`: Show detected corner points\n\n**Analysis:**\n- `text_regions(img, row)`: Find continuous text regions in a row\n- `cells()`: Generator yielding all (row, col) indices\n\n**Persistence:**\n- `save(path)`: Save grid to JSON file\n- `TableGrid.from_saved(path)`: Load grid from JSON\n\n**Properties:**\n- `rows`: Number of data rows (header not included)\n- `cols`: Number of columns\n- `points`: Raw list of detected corner coordinates\n</code></pre>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>TauluException:</strong>  If image cannot be loaded, header alignment fails,\nor grid detection produces no results</li>\n</ul>\n\n<h6 id=\"examples\">Examples:</h6>\n\n<blockquote>\n  <p>Basic segmentation:</p>\n  \n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">taulu</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">Taulu</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">import</span><span class=\"w\"> </span><span class=\"nn\">cv2</span>\n<span class=\"gp\">&gt;&gt;&gt; </span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">taulu</span> <span class=\"o\">=</span> <span class=\"n\">Taulu</span><span class=\"p\">(</span><span class=\"s2\">&quot;header.png&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">grid</span> <span class=\"o\">=</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">segment_table</span><span class=\"p\">(</span><span class=\"s2\">&quot;table_page_01.png&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"sa\">f</span><span class=\"s2\">&quot;Detected </span><span class=\"si\">{</span><span class=\"n\">grid</span><span class=\"o\">.</span><span class=\"n\">rows</span><span class=\"si\">}</span><span class=\"s2\"> rows and </span><span class=\"si\">{</span><span class=\"n\">grid</span><span class=\"o\">.</span><span class=\"n\">cols</span><span class=\"si\">}</span><span class=\"s2\"> columns&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># Extract first cell</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">img</span> <span class=\"o\">=</span> <span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">imread</span><span class=\"p\">(</span><span class=\"s2\">&quot;table_page_01.png&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">cell_img</span> <span class=\"o\">=</span> <span class=\"n\">grid</span><span class=\"o\">.</span><span class=\"n\">crop_cell</span><span class=\"p\">(</span><span class=\"n\">img</span><span class=\"p\">,</span> <span class=\"p\">(</span><span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">))</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">imwrite</span><span class=\"p\">(</span><span class=\"s2\">&quot;cell_0_0.png&quot;</span><span class=\"p\">,</span> <span class=\"n\">cell_img</span><span class=\"p\">)</span>\n</code></pre>\n  </div>\n  \n  <p>Debug mode for parameter tuning:</p>\n  \n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">grid</span> <span class=\"o\">=</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">segment_table</span><span class=\"p\">(</span><span class=\"s2\">&quot;table_page_01.png&quot;</span><span class=\"p\">,</span> <span class=\"n\">debug_view</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"go\">&lt;h1 id=&quot;windows-open-showing-each-step&quot;&gt;Windows open showing each step&lt;/h1&gt;</span>\n</code></pre>\n  </div>\n  \n  <h1 id=\"adjust-parameters-based-on-what-you-see\">Adjust parameters based on what you see</h1>\n  \n  <p>Process multiple images with the same header:</p>\n  \n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">taulu</span> <span class=\"o\">=</span> <span class=\"n\">Taulu</span><span class=\"p\">(</span><span class=\"s2\">&quot;header.png&quot;</span><span class=\"p\">,</span> <span class=\"n\">sauvola_k</span><span class=\"o\">=</span><span class=\"mf\">0.25</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"k\">for</span> <span class=\"n\">i</span> <span class=\"ow\">in</span> <span class=\"nb\">range</span><span class=\"p\">(</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">11</span><span class=\"p\">):</span>\n<span class=\"gp\">... </span>    <span class=\"n\">img_path</span> <span class=\"o\">=</span> <span class=\"sa\">f</span><span class=\"s2\">&quot;table_page_</span><span class=\"si\">{</span><span class=\"n\">i</span><span class=\"si\">:</span><span class=\"s2\">02d</span><span class=\"si\">}</span><span class=\"s2\">.png&quot;</span>\n<span class=\"gp\">... </span>    <span class=\"n\">grid</span> <span class=\"o\">=</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">segment_table</span><span class=\"p\">(</span><span class=\"n\">img_path</span><span class=\"p\">)</span>\n<span class=\"gp\">... </span>    <span class=\"n\">grid</span><span class=\"o\">.</span><span class=\"n\">save</span><span class=\"p\">(</span><span class=\"sa\">f</span><span class=\"s2\">&quot;grid_</span><span class=\"si\">{</span><span class=\"n\">i</span><span class=\"si\">:</span><span class=\"s2\">02d</span><span class=\"si\">}</span><span class=\"s2\">.json&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">... </span>    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"sa\">f</span><span class=\"s2\">&quot;Page </span><span class=\"si\">{</span><span class=\"n\">i</span><span class=\"si\">}</span><span class=\"s2\">: </span><span class=\"si\">{</span><span class=\"n\">grid</span><span class=\"o\">.</span><span class=\"n\">rows</span><span class=\"si\">}</span><span class=\"s2\"> rows detected&quot;</span><span class=\"p\">)</span>\n</code></pre>\n  </div>\n  \n  <p>Extract all cells from a table:</p>\n  \n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">img</span> <span class=\"o\">=</span> <span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">imread</span><span class=\"p\">(</span><span class=\"s2\">&quot;table.png&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">grid</span> <span class=\"o\">=</span> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">segment_table</span><span class=\"p\">(</span><span class=\"s2\">&quot;table.png&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"k\">for</span> <span class=\"n\">row</span><span class=\"p\">,</span> <span class=\"n\">col</span> <span class=\"ow\">in</span> <span class=\"n\">grid</span><span class=\"o\">.</span><span class=\"n\">cells</span><span class=\"p\">():</span>\n<span class=\"gp\">... </span>    <span class=\"n\">cell_img</span> <span class=\"o\">=</span> <span class=\"n\">grid</span><span class=\"o\">.</span><span class=\"n\">crop_cell</span><span class=\"p\">(</span><span class=\"n\">img</span><span class=\"p\">,</span> <span class=\"p\">(</span><span class=\"n\">row</span><span class=\"p\">,</span> <span class=\"n\">col</span><span class=\"p\">),</span> <span class=\"n\">margin</span><span class=\"o\">=</span><span class=\"mi\">5</span><span class=\"p\">)</span>\n<span class=\"gp\">... </span>    <span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">imwrite</span><span class=\"p\">(</span><span class=\"sa\">f</span><span class=\"s2\">&quot;cell_</span><span class=\"si\">{</span><span class=\"n\">row</span><span class=\"si\">}</span><span class=\"s2\">_</span><span class=\"si\">{</span><span class=\"n\">col</span><span class=\"si\">}</span><span class=\"s2\">.png&quot;</span><span class=\"p\">,</span> <span class=\"n\">cell_img</span><span class=\"p\">)</span>\n</code></pre>\n  </div>\n  \n  <p>Find text regions for OCR:</p>\n  \n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"k\">for</span> <span class=\"n\">row</span> <span class=\"ow\">in</span> <span class=\"nb\">range</span><span class=\"p\">(</span><span class=\"n\">grid</span><span class=\"o\">.</span><span class=\"n\">rows</span><span class=\"p\">):</span>\n<span class=\"gp\">... </span>    <span class=\"n\">text_regions</span> <span class=\"o\">=</span> <span class=\"n\">grid</span><span class=\"o\">.</span><span class=\"n\">text_regions</span><span class=\"p\">(</span><span class=\"n\">img</span><span class=\"p\">,</span> <span class=\"n\">row</span><span class=\"p\">)</span>\n<span class=\"gp\">... </span>    <span class=\"k\">for</span> <span class=\"n\">start_cell</span><span class=\"p\">,</span> <span class=\"n\">end_cell</span> <span class=\"ow\">in</span> <span class=\"n\">text_regions</span><span class=\"p\">:</span>\n<span class=\"gp\">... </span>        <span class=\"c1\"># Extract region spanning multiple cells</span>\n<span class=\"gp\">... </span>        <span class=\"n\">region_img</span> <span class=\"o\">=</span> <span class=\"n\">grid</span><span class=\"o\">.</span><span class=\"n\">crop_region</span><span class=\"p\">(</span><span class=\"n\">img</span><span class=\"p\">,</span> <span class=\"n\">start_cell</span><span class=\"p\">,</span> <span class=\"n\">end_cell</span><span class=\"p\">)</span>\n<span class=\"gp\">... </span>        <span class=\"c1\"># Run OCR on region_img...</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"see-also\">See Also:</h6>\n\n<blockquote>\n  <ul>\n  <li><code>TableGrid</code>: Complete documentation of the returned object</li>\n  <li><code>GridDetector.find_table_points()</code>: Lower-level grid detection</li>\n  <li><code>HeaderAligner.align()</code>: Lower-level header alignment</li>\n  </ul>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">image</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">cv2</span><span class=\"o\">.</span><span class=\"n\">Mat</span><span class=\"p\">,</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">,</span> <span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">PathLike</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">debug_view</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">taulu</span><span class=\"o\">.</span><span class=\"n\">grid</span><span class=\"o\">.</span><span class=\"n\">TableGrid</span>:</span></span>", "funcdef": "def"}];

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();