# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictStr, conint, conlist, constr, validator

from typing import Optional

from lusid.models.closed_period import ClosedPeriod
from lusid.models.create_closed_period_request import CreateClosedPeriodRequest
from lusid.models.create_timeline_request import CreateTimelineRequest
from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.paged_resource_list_of_closed_period import PagedResourceListOfClosedPeriod
from lusid.models.paged_resource_list_of_timeline import PagedResourceListOfTimeline
from lusid.models.post_close_activities_request import PostCloseActivitiesRequest
from lusid.models.timeline import Timeline
from lusid.models.update_timeline_request import UpdateTimelineRequest

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class TimelinesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def create_closed_period(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Timeline. Together with the domain and scope this uniquely identifies the Timeline.")], create_closed_period_request : Annotated[Optional[CreateClosedPeriodRequest], Field(description="The request containing the details of the Closed Period")] = None, **kwargs) -> ClosedPeriod:  # noqa: E501
        ...

    @overload
    def create_closed_period(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Timeline. Together with the domain and scope this uniquely identifies the Timeline.")], create_closed_period_request : Annotated[Optional[CreateClosedPeriodRequest], Field(description="The request containing the details of the Closed Period")] = None, async_req: Optional[bool]=True, **kwargs) -> ClosedPeriod:  # noqa: E501
        ...

    @validate_arguments
    def create_closed_period(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Timeline. Together with the domain and scope this uniquely identifies the Timeline.")], create_closed_period_request : Annotated[Optional[CreateClosedPeriodRequest], Field(description="The request containing the details of the Closed Period")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ClosedPeriod, Awaitable[ClosedPeriod]]:  # noqa: E501
        """[EXPERIMENTAL] CreateClosedPeriod: Create a new closed period against a timeline entity  # noqa: E501

        Creates a new closed period against a timeline entity  Returns the newly created closed period entity with properties  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_closed_period(scope, code, create_closed_period_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the specified Timeline. (required)
        :type scope: str
        :param code: The code of the specified Timeline. Together with the domain and scope this uniquely identifies the Timeline. (required)
        :type code: str
        :param create_closed_period_request: The request containing the details of the Closed Period
        :type create_closed_period_request: CreateClosedPeriodRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ClosedPeriod
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_closed_period_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_closed_period_with_http_info(scope, code, create_closed_period_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_closed_period_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Timeline. Together with the domain and scope this uniquely identifies the Timeline.")], create_closed_period_request : Annotated[Optional[CreateClosedPeriodRequest], Field(description="The request containing the details of the Closed Period")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] CreateClosedPeriod: Create a new closed period against a timeline entity  # noqa: E501

        Creates a new closed period against a timeline entity  Returns the newly created closed period entity with properties  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_closed_period_with_http_info(scope, code, create_closed_period_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the specified Timeline. (required)
        :type scope: str
        :param code: The code of the specified Timeline. Together with the domain and scope this uniquely identifies the Timeline. (required)
        :type code: str
        :param create_closed_period_request: The request containing the details of the Closed Period
        :type create_closed_period_request: CreateClosedPeriodRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ClosedPeriod, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'create_closed_period_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_closed_period" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_closed_period_request'] is not None:
            _body_params = _params['create_closed_period_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "ClosedPeriod",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/timelines/{scope}/{code}/closedperiods', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def create_timeline(self, create_timeline_request : Annotated[Optional[CreateTimelineRequest], Field(description="The request containing the details of the Timeline")] = None, **kwargs) -> Timeline:  # noqa: E501
        ...

    @overload
    def create_timeline(self, create_timeline_request : Annotated[Optional[CreateTimelineRequest], Field(description="The request containing the details of the Timeline")] = None, async_req: Optional[bool]=True, **kwargs) -> Timeline:  # noqa: E501
        ...

    @validate_arguments
    def create_timeline(self, create_timeline_request : Annotated[Optional[CreateTimelineRequest], Field(description="The request containing the details of the Timeline")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Timeline, Awaitable[Timeline]]:  # noqa: E501
        """[EXPERIMENTAL] CreateTimeline: Create a Timeline  # noqa: E501

        Creates a Timeline. Returns the created Timeline at the current effectiveAt.  Note that Timelines are mono-temporal, however they can have Time-Variant Properties.  Upserted Properties will be returned at the latest AsAt and EffectiveAt  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_timeline(create_timeline_request, async_req=True)
        >>> result = thread.get()

        :param create_timeline_request: The request containing the details of the Timeline
        :type create_timeline_request: CreateTimelineRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Timeline
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_timeline_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_timeline_with_http_info(create_timeline_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_timeline_with_http_info(self, create_timeline_request : Annotated[Optional[CreateTimelineRequest], Field(description="The request containing the details of the Timeline")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] CreateTimeline: Create a Timeline  # noqa: E501

        Creates a Timeline. Returns the created Timeline at the current effectiveAt.  Note that Timelines are mono-temporal, however they can have Time-Variant Properties.  Upserted Properties will be returned at the latest AsAt and EffectiveAt  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_timeline_with_http_info(create_timeline_request, async_req=True)
        >>> result = thread.get()

        :param create_timeline_request: The request containing the details of the Timeline
        :type create_timeline_request: CreateTimelineRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Timeline, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_timeline_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_timeline" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_timeline_request'] is not None:
            _body_params = _params['create_timeline_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "Timeline",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/timelines', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_timeline(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Timeline. Together with the domain and scope this uniquely              identifies the Timeline.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_timeline(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Timeline. Together with the domain and scope this uniquely              identifies the Timeline.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_timeline(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Timeline. Together with the domain and scope this uniquely              identifies the Timeline.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteTimeline: Deletes a particular Timeline  # noqa: E501

        The deletion will take effect from the Timeline deletion datetime.  i.e. will no longer exist at any asAt datetime after the asAt datetime of deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_timeline(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the specified Timeline. (required)
        :type scope: str
        :param code: The code of the specified Timeline. Together with the domain and scope this uniquely              identifies the Timeline. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_timeline_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_timeline_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_timeline_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Timeline. Together with the domain and scope this uniquely              identifies the Timeline.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteTimeline: Deletes a particular Timeline  # noqa: E501

        The deletion will take effect from the Timeline deletion datetime.  i.e. will no longer exist at any asAt datetime after the asAt datetime of deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_timeline_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the specified Timeline. (required)
        :type scope: str
        :param code: The code of the specified Timeline. Together with the domain and scope this uniquely              identifies the Timeline. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_timeline" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/timelines/{scope}/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_closed_period(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the Timeline. Together with the scope this uniquely              identifies the Timeline.")], closed_period_id : Annotated[StrictStr, Field(..., description="The id of the Closed Period. Together with the scope and code of the Timeline,              this uniquely identifies the ClosedPeriod")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the ClosedPeriod definition. Defaults to return              the latest version of the definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'ClosedPeriod' domain to decorate onto              the ClosedPeriod.              These must have the format {domain}/{scope}/{code}, for example 'ClosedPeriod/system/Name'.")] = None, **kwargs) -> ClosedPeriod:  # noqa: E501
        ...

    @overload
    def get_closed_period(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the Timeline. Together with the scope this uniquely              identifies the Timeline.")], closed_period_id : Annotated[StrictStr, Field(..., description="The id of the Closed Period. Together with the scope and code of the Timeline,              this uniquely identifies the ClosedPeriod")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the ClosedPeriod definition. Defaults to return              the latest version of the definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'ClosedPeriod' domain to decorate onto              the ClosedPeriod.              These must have the format {domain}/{scope}/{code}, for example 'ClosedPeriod/system/Name'.")] = None, async_req: Optional[bool]=True, **kwargs) -> ClosedPeriod:  # noqa: E501
        ...

    @validate_arguments
    def get_closed_period(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the Timeline. Together with the scope this uniquely              identifies the Timeline.")], closed_period_id : Annotated[StrictStr, Field(..., description="The id of the Closed Period. Together with the scope and code of the Timeline,              this uniquely identifies the ClosedPeriod")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the ClosedPeriod definition. Defaults to return              the latest version of the definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'ClosedPeriod' domain to decorate onto              the ClosedPeriod.              These must have the format {domain}/{scope}/{code}, for example 'ClosedPeriod/system/Name'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ClosedPeriod, Awaitable[ClosedPeriod]]:  # noqa: E501
        """[EXPERIMENTAL] GetClosedPeriod: Gets a Closed Period entity.  # noqa: E501

        Retrieves one ClosedPeriod uniquely defined by the Timelines Scope/Code and a ClosedPeriodId.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_closed_period(scope, code, closed_period_id, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Timeline. (required)
        :type scope: str
        :param code: The code of the Timeline. Together with the scope this uniquely              identifies the Timeline. (required)
        :type code: str
        :param closed_period_id: The id of the Closed Period. Together with the scope and code of the Timeline,              this uniquely identifies the ClosedPeriod (required)
        :type closed_period_id: str
        :param as_at: The asAt datetime at which to retrieve the ClosedPeriod definition. Defaults to return              the latest version of the definition if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'ClosedPeriod' domain to decorate onto              the ClosedPeriod.              These must have the format {domain}/{scope}/{code}, for example 'ClosedPeriod/system/Name'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ClosedPeriod
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_closed_period_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_closed_period_with_http_info(scope, code, closed_period_id, as_at, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def get_closed_period_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the Timeline. Together with the scope this uniquely              identifies the Timeline.")], closed_period_id : Annotated[StrictStr, Field(..., description="The id of the Closed Period. Together with the scope and code of the Timeline,              this uniquely identifies the ClosedPeriod")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the ClosedPeriod definition. Defaults to return              the latest version of the definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'ClosedPeriod' domain to decorate onto              the ClosedPeriod.              These must have the format {domain}/{scope}/{code}, for example 'ClosedPeriod/system/Name'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetClosedPeriod: Gets a Closed Period entity.  # noqa: E501

        Retrieves one ClosedPeriod uniquely defined by the Timelines Scope/Code and a ClosedPeriodId.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_closed_period_with_http_info(scope, code, closed_period_id, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Timeline. (required)
        :type scope: str
        :param code: The code of the Timeline. Together with the scope this uniquely              identifies the Timeline. (required)
        :type code: str
        :param closed_period_id: The id of the Closed Period. Together with the scope and code of the Timeline,              this uniquely identifies the ClosedPeriod (required)
        :type closed_period_id: str
        :param as_at: The asAt datetime at which to retrieve the ClosedPeriod definition. Defaults to return              the latest version of the definition if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'ClosedPeriod' domain to decorate onto              the ClosedPeriod.              These must have the format {domain}/{scope}/{code}, for example 'ClosedPeriod/system/Name'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ClosedPeriod, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'closed_period_id',
            'as_at',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_closed_period" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['closed_period_id']:
            _path_params['closedPeriodId'] = _params['closed_period_id']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ClosedPeriod",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/timelines/{scope}/{code}/closedperiods/{closedPeriodId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_timeline(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Timeline. Together with the scope this uniquely              identifies the Timeline.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Timeline definition. Defaults to return              the latest version of the definition if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the timeline properties.              Defaults to the current LUSID system datetime if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Timeline' domain to decorate onto              the Timeline.              These must have the format {domain}/{scope}/{code}, for example 'Timeline/system/Name'.")] = None, **kwargs) -> Timeline:  # noqa: E501
        ...

    @overload
    def get_timeline(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Timeline. Together with the scope this uniquely              identifies the Timeline.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Timeline definition. Defaults to return              the latest version of the definition if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the timeline properties.              Defaults to the current LUSID system datetime if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Timeline' domain to decorate onto              the Timeline.              These must have the format {domain}/{scope}/{code}, for example 'Timeline/system/Name'.")] = None, async_req: Optional[bool]=True, **kwargs) -> Timeline:  # noqa: E501
        ...

    @validate_arguments
    def get_timeline(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Timeline. Together with the scope this uniquely              identifies the Timeline.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Timeline definition. Defaults to return              the latest version of the definition if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the timeline properties.              Defaults to the current LUSID system datetime if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Timeline' domain to decorate onto              the Timeline.              These must have the format {domain}/{scope}/{code}, for example 'Timeline/system/Name'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Timeline, Awaitable[Timeline]]:  # noqa: E501
        """[EXPERIMENTAL] GetTimeline: Get a single Timeline by scope and code.  # noqa: E501

        Retrieves one Timeline by scope and code.  Timelines are mono-temporal. The EffectiveAt is only applied to Time-Variant Properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_timeline(scope, code, as_at, effective_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the specified Timeline. (required)
        :type scope: str
        :param code: The code of the specified Timeline. Together with the scope this uniquely              identifies the Timeline. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the Timeline definition. Defaults to return              the latest version of the definition if not specified.
        :type as_at: datetime
        :param effective_at: The effective datetime or cut label at which to retrieve the timeline properties.              Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param property_keys: A list of property keys from the 'Timeline' domain to decorate onto              the Timeline.              These must have the format {domain}/{scope}/{code}, for example 'Timeline/system/Name'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Timeline
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_timeline_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_timeline_with_http_info(scope, code, as_at, effective_at, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def get_timeline_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Timeline. Together with the scope this uniquely              identifies the Timeline.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Timeline definition. Defaults to return              the latest version of the definition if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the timeline properties.              Defaults to the current LUSID system datetime if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Timeline' domain to decorate onto              the Timeline.              These must have the format {domain}/{scope}/{code}, for example 'Timeline/system/Name'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetTimeline: Get a single Timeline by scope and code.  # noqa: E501

        Retrieves one Timeline by scope and code.  Timelines are mono-temporal. The EffectiveAt is only applied to Time-Variant Properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_timeline_with_http_info(scope, code, as_at, effective_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the specified Timeline. (required)
        :type scope: str
        :param code: The code of the specified Timeline. Together with the scope this uniquely              identifies the Timeline. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the Timeline definition. Defaults to return              the latest version of the definition if not specified.
        :type as_at: datetime
        :param effective_at: The effective datetime or cut label at which to retrieve the timeline properties.              Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param property_keys: A list of property keys from the 'Timeline' domain to decorate onto              the Timeline.              These must have the format {domain}/{scope}/{code}, for example 'Timeline/system/Name'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Timeline, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'as_at',
            'effective_at',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_timeline" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Timeline",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/timelines/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_closed_periods(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the Timeline.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the ClosedPeriods. Defaults to returning the latest version of each ClosedPeriod if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing ClosedPeriods; this              value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.              For example, to filter on the effectiveEnd, specify \"effectiveEnd gt 2019-01-15T10:00:00\". For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'ClosedPeriod' domain to decorate onto each ClosedPeriod.              These must take the format {domain}/{scope}/{code}, for example 'ClosedPeriod/Account/id'.")] = None, **kwargs) -> PagedResourceListOfClosedPeriod:  # noqa: E501
        ...

    @overload
    def list_closed_periods(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the Timeline.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the ClosedPeriods. Defaults to returning the latest version of each ClosedPeriod if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing ClosedPeriods; this              value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.              For example, to filter on the effectiveEnd, specify \"effectiveEnd gt 2019-01-15T10:00:00\". For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'ClosedPeriod' domain to decorate onto each ClosedPeriod.              These must take the format {domain}/{scope}/{code}, for example 'ClosedPeriod/Account/id'.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfClosedPeriod:  # noqa: E501
        ...

    @validate_arguments
    def list_closed_periods(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the Timeline.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the ClosedPeriods. Defaults to returning the latest version of each ClosedPeriod if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing ClosedPeriods; this              value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.              For example, to filter on the effectiveEnd, specify \"effectiveEnd gt 2019-01-15T10:00:00\". For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'ClosedPeriod' domain to decorate onto each ClosedPeriod.              These must take the format {domain}/{scope}/{code}, for example 'ClosedPeriod/Account/id'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfClosedPeriod, Awaitable[PagedResourceListOfClosedPeriod]]:  # noqa: E501
        """[EXPERIMENTAL] ListClosedPeriods: List ClosedPeriods for a specified Timeline.  # noqa: E501

        List all the ClosedPeriods matching a particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_closed_periods(scope, code, as_at, page, limit, filter, sort_by, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Timeline. (required)
        :type scope: str
        :param code: The code of the Timeline. (required)
        :type code: str
        :param as_at: The asAt datetime at which to list the ClosedPeriods. Defaults to returning the latest version of each ClosedPeriod if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing ClosedPeriods; this              value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt              and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.              For example, to filter on the effectiveEnd, specify \"effectiveEnd gt 2019-01-15T10:00:00\". For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param property_keys: A list of property keys from the 'ClosedPeriod' domain to decorate onto each ClosedPeriod.              These must take the format {domain}/{scope}/{code}, for example 'ClosedPeriod/Account/id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfClosedPeriod
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_closed_periods_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_closed_periods_with_http_info(scope, code, as_at, page, limit, filter, sort_by, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def list_closed_periods_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the Timeline.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the ClosedPeriods. Defaults to returning the latest version of each ClosedPeriod if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing ClosedPeriods; this              value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.              For example, to filter on the effectiveEnd, specify \"effectiveEnd gt 2019-01-15T10:00:00\". For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'ClosedPeriod' domain to decorate onto each ClosedPeriod.              These must take the format {domain}/{scope}/{code}, for example 'ClosedPeriod/Account/id'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListClosedPeriods: List ClosedPeriods for a specified Timeline.  # noqa: E501

        List all the ClosedPeriods matching a particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_closed_periods_with_http_info(scope, code, as_at, page, limit, filter, sort_by, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Timeline. (required)
        :type scope: str
        :param code: The code of the Timeline. (required)
        :type code: str
        :param as_at: The asAt datetime at which to list the ClosedPeriods. Defaults to returning the latest version of each ClosedPeriod if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing ClosedPeriods; this              value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt              and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.              For example, to filter on the effectiveEnd, specify \"effectiveEnd gt 2019-01-15T10:00:00\". For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param property_keys: A list of property keys from the 'ClosedPeriod' domain to decorate onto each ClosedPeriod.              These must take the format {domain}/{scope}/{code}, for example 'ClosedPeriod/Account/id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfClosedPeriod, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'as_at',
            'page',
            'limit',
            'filter',
            'sort_by',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_closed_periods" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfClosedPeriod",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/timelines/{scope}/{code}/closedperiods', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_timelines(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Timelines. Defaults to returning the latest version of each Timeline if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Timelines.              Note that Timelines are monotemporal, the effectiveAt is for Timevariant Properties on the Timeline only.              Defaults to the current LUSID system datetime if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Timelines; this              value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.              For example, to filter on the displayName, specify \"displayName eq 'AccountingTimeline'\". For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Timeline' domain to decorate onto each Timeline.              These must take the format {domain}/{scope}/{code}, for example 'Timeline/Account/id'.")] = None, **kwargs) -> PagedResourceListOfTimeline:  # noqa: E501
        ...

    @overload
    def list_timelines(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Timelines. Defaults to returning the latest version of each Timeline if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Timelines.              Note that Timelines are monotemporal, the effectiveAt is for Timevariant Properties on the Timeline only.              Defaults to the current LUSID system datetime if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Timelines; this              value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.              For example, to filter on the displayName, specify \"displayName eq 'AccountingTimeline'\". For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Timeline' domain to decorate onto each Timeline.              These must take the format {domain}/{scope}/{code}, for example 'Timeline/Account/id'.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfTimeline:  # noqa: E501
        ...

    @validate_arguments
    def list_timelines(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Timelines. Defaults to returning the latest version of each Timeline if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Timelines.              Note that Timelines are monotemporal, the effectiveAt is for Timevariant Properties on the Timeline only.              Defaults to the current LUSID system datetime if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Timelines; this              value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.              For example, to filter on the displayName, specify \"displayName eq 'AccountingTimeline'\". For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Timeline' domain to decorate onto each Timeline.              These must take the format {domain}/{scope}/{code}, for example 'Timeline/Account/id'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfTimeline, Awaitable[PagedResourceListOfTimeline]]:  # noqa: E501
        """[EXPERIMENTAL] ListTimelines: List Timelines  # noqa: E501

        List all the Timelines matching a particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_timelines(as_at, effective_at, page, limit, filter, sort_by, property_keys, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to list the Timelines. Defaults to returning the latest version of each Timeline if not specified.
        :type as_at: datetime
        :param effective_at: The effective datetime or cut label at which to list the Timelines.              Note that Timelines are monotemporal, the effectiveAt is for Timevariant Properties on the Timeline only.              Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param page: The pagination token to use to continue listing Timelines; this              value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt              and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.              For example, to filter on the displayName, specify \"displayName eq 'AccountingTimeline'\". For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param property_keys: A list of property keys from the 'Timeline' domain to decorate onto each Timeline.              These must take the format {domain}/{scope}/{code}, for example 'Timeline/Account/id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfTimeline
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_timelines_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_timelines_with_http_info(as_at, effective_at, page, limit, filter, sort_by, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def list_timelines_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Timelines. Defaults to returning the latest version of each Timeline if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Timelines.              Note that Timelines are monotemporal, the effectiveAt is for Timevariant Properties on the Timeline only.              Defaults to the current LUSID system datetime if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Timelines; this              value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.              For example, to filter on the displayName, specify \"displayName eq 'AccountingTimeline'\". For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Timeline' domain to decorate onto each Timeline.              These must take the format {domain}/{scope}/{code}, for example 'Timeline/Account/id'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListTimelines: List Timelines  # noqa: E501

        List all the Timelines matching a particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_timelines_with_http_info(as_at, effective_at, page, limit, filter, sort_by, property_keys, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to list the Timelines. Defaults to returning the latest version of each Timeline if not specified.
        :type as_at: datetime
        :param effective_at: The effective datetime or cut label at which to list the Timelines.              Note that Timelines are monotemporal, the effectiveAt is for Timevariant Properties on the Timeline only.              Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param page: The pagination token to use to continue listing Timelines; this              value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt              and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.              For example, to filter on the displayName, specify \"displayName eq 'AccountingTimeline'\". For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param property_keys: A list of property keys from the 'Timeline' domain to decorate onto each Timeline.              These must take the format {domain}/{scope}/{code}, for example 'Timeline/Account/id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfTimeline, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'effective_at',
            'page',
            'limit',
            'filter',
            'sort_by',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_timelines" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfTimeline",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/timelines', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def set_post_close_activity(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the Timeline.")], closed_period_id : Annotated[StrictStr, Field(..., description="The id of the Closed Period. Together with the scope and code of the Timeline,              this uniquely identifies the ClosedPeriod")], post_close_activities_request : Annotated[Optional[PostCloseActivitiesRequest], Field(description="Specifies collection of post close activities")] = None, **kwargs) -> ClosedPeriod:  # noqa: E501
        ...

    @overload
    def set_post_close_activity(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the Timeline.")], closed_period_id : Annotated[StrictStr, Field(..., description="The id of the Closed Period. Together with the scope and code of the Timeline,              this uniquely identifies the ClosedPeriod")], post_close_activities_request : Annotated[Optional[PostCloseActivitiesRequest], Field(description="Specifies collection of post close activities")] = None, async_req: Optional[bool]=True, **kwargs) -> ClosedPeriod:  # noqa: E501
        ...

    @validate_arguments
    def set_post_close_activity(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the Timeline.")], closed_period_id : Annotated[StrictStr, Field(..., description="The id of the Closed Period. Together with the scope and code of the Timeline,              this uniquely identifies the ClosedPeriod")], post_close_activities_request : Annotated[Optional[PostCloseActivitiesRequest], Field(description="Specifies collection of post close activities")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ClosedPeriod, Awaitable[ClosedPeriod]]:  # noqa: E501
        """[EXPERIMENTAL] SetPostCloseActivity: Sets post close activities to a closed period.  # noqa: E501

        Sets empty or more post close activities to the specific closed period.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_post_close_activity(scope, code, closed_period_id, post_close_activities_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Timeline. (required)
        :type scope: str
        :param code: The code of the Timeline. (required)
        :type code: str
        :param closed_period_id: The id of the Closed Period. Together with the scope and code of the Timeline,              this uniquely identifies the ClosedPeriod (required)
        :type closed_period_id: str
        :param post_close_activities_request: Specifies collection of post close activities
        :type post_close_activities_request: PostCloseActivitiesRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ClosedPeriod
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the set_post_close_activity_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.set_post_close_activity_with_http_info(scope, code, closed_period_id, post_close_activities_request, **kwargs)  # noqa: E501

    @validate_arguments
    def set_post_close_activity_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the Timeline.")], closed_period_id : Annotated[StrictStr, Field(..., description="The id of the Closed Period. Together with the scope and code of the Timeline,              this uniquely identifies the ClosedPeriod")], post_close_activities_request : Annotated[Optional[PostCloseActivitiesRequest], Field(description="Specifies collection of post close activities")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] SetPostCloseActivity: Sets post close activities to a closed period.  # noqa: E501

        Sets empty or more post close activities to the specific closed period.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_post_close_activity_with_http_info(scope, code, closed_period_id, post_close_activities_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Timeline. (required)
        :type scope: str
        :param code: The code of the Timeline. (required)
        :type code: str
        :param closed_period_id: The id of the Closed Period. Together with the scope and code of the Timeline,              this uniquely identifies the ClosedPeriod (required)
        :type closed_period_id: str
        :param post_close_activities_request: Specifies collection of post close activities
        :type post_close_activities_request: PostCloseActivitiesRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ClosedPeriod, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'closed_period_id',
            'post_close_activities_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_post_close_activity" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['closed_period_id']:
            _path_params['closedPeriodId'] = _params['closed_period_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['post_close_activities_request'] is not None:
            _body_params = _params['post_close_activities_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ClosedPeriod",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/timelines/{scope}/{code}/closedperiods/{closedPeriodId}/postcloseactivity', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def update_timeline(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Timeline. Together with the domain and scope this uniquely identifies the Timeline.")], update_timeline_request : Annotated[Optional[UpdateTimelineRequest], Field(description="The request containing the updated details of the Timeline")] = None, **kwargs) -> Timeline:  # noqa: E501
        ...

    @overload
    def update_timeline(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Timeline. Together with the domain and scope this uniquely identifies the Timeline.")], update_timeline_request : Annotated[Optional[UpdateTimelineRequest], Field(description="The request containing the updated details of the Timeline")] = None, async_req: Optional[bool]=True, **kwargs) -> Timeline:  # noqa: E501
        ...

    @validate_arguments
    def update_timeline(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Timeline. Together with the domain and scope this uniquely identifies the Timeline.")], update_timeline_request : Annotated[Optional[UpdateTimelineRequest], Field(description="The request containing the updated details of the Timeline")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Timeline, Awaitable[Timeline]]:  # noqa: E501
        """[EXPERIMENTAL] UpdateTimeline: Update Timeline defined by scope and code  # noqa: E501

        Overwrites an existing Timeline  Update request has the same required fields as Create apart from the id.  Returns the updated Timeline at the current effectiveAt.  Note that Timelines are mono-temporal, however they can have Time-Variant Properties.  Updated Properties will be returned at the latest AsAt and EffectiveAt  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_timeline(scope, code, update_timeline_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the specified Timeline. (required)
        :type scope: str
        :param code: The code of the specified Timeline. Together with the domain and scope this uniquely identifies the Timeline. (required)
        :type code: str
        :param update_timeline_request: The request containing the updated details of the Timeline
        :type update_timeline_request: UpdateTimelineRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Timeline
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_timeline_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_timeline_with_http_info(scope, code, update_timeline_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_timeline_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Timeline.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Timeline. Together with the domain and scope this uniquely identifies the Timeline.")], update_timeline_request : Annotated[Optional[UpdateTimelineRequest], Field(description="The request containing the updated details of the Timeline")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] UpdateTimeline: Update Timeline defined by scope and code  # noqa: E501

        Overwrites an existing Timeline  Update request has the same required fields as Create apart from the id.  Returns the updated Timeline at the current effectiveAt.  Note that Timelines are mono-temporal, however they can have Time-Variant Properties.  Updated Properties will be returned at the latest AsAt and EffectiveAt  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_timeline_with_http_info(scope, code, update_timeline_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the specified Timeline. (required)
        :type scope: str
        :param code: The code of the specified Timeline. Together with the domain and scope this uniquely identifies the Timeline. (required)
        :type code: str
        :param update_timeline_request: The request containing the updated details of the Timeline
        :type update_timeline_request: UpdateTimelineRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Timeline, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'update_timeline_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_timeline" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_timeline_request'] is not None:
            _body_params = _params['update_timeline_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Timeline",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/timelines/{scope}/{code}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
