# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, conlist, constr, validator

from typing import Dict, List, Optional

from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.resource_list_of_side_definition import ResourceListOfSideDefinition
from lusid.models.resource_list_of_transaction_type import ResourceListOfTransactionType
from lusid.models.side_definition import SideDefinition
from lusid.models.side_definition_request import SideDefinitionRequest
from lusid.models.sides_definition_request import SidesDefinitionRequest
from lusid.models.transaction_type import TransactionType
from lusid.models.transaction_type_request import TransactionTypeRequest

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class TransactionConfigurationApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def delete_side_definition(self, side : Annotated[StrictStr, Field(..., description="The label to uniquely identify the side.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_side_definition(self, side : Annotated[StrictStr, Field(..., description="The label to uniquely identify the side.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_side_definition(self, side : Annotated[StrictStr, Field(..., description="The label to uniquely identify the side.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """DeleteSideDefinition: Delete the given side definition  # noqa: E501

        Delete the side which user specify in the request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_side_definition(side, scope, async_req=True)
        >>> result = thread.get()

        :param side: The label to uniquely identify the side. (required)
        :type side: str
        :param scope: The scope in which the side exists. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_side_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_side_definition_with_http_info(side, scope, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_side_definition_with_http_info(self, side : Annotated[StrictStr, Field(..., description="The label to uniquely identify the side.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """DeleteSideDefinition: Delete the given side definition  # noqa: E501

        Delete the side which user specify in the request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_side_definition_with_http_info(side, scope, async_req=True)
        >>> result = thread.get()

        :param side: The label to uniquely identify the side. (required)
        :type side: str
        :param scope: The scope in which the side exists. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'side',
            'scope'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_side_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['side']:
            _path_params['side'] = _params['side']


        # process the query parameters
        _query_params = []
        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/transactionconfiguration/sides/{side}/$delete', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_transaction_type(self, source : Annotated[StrictStr, Field(..., description="The source that the type is in")], type : Annotated[StrictStr, Field(..., description="One of the type's aliases")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the transaction types exists. When not supplied the scope is 'default'.")] = None, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_transaction_type(self, source : Annotated[StrictStr, Field(..., description="The source that the type is in")], type : Annotated[StrictStr, Field(..., description="One of the type's aliases")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the transaction types exists. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_transaction_type(self, source : Annotated[StrictStr, Field(..., description="The source that the type is in")], type : Annotated[StrictStr, Field(..., description="One of the type's aliases")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the transaction types exists. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """DeleteTransactionType: Delete a transaction type  # noqa: E501

        /// WARNING! Changing existing transaction types has a material impact on how data, new and old,  is processed and aggregated by LUSID, and will affect your whole organisation. Only call this API if you are fully aware of the implications of the change.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_transaction_type(source, type, scope, async_req=True)
        >>> result = thread.get()

        :param source: The source that the type is in (required)
        :type source: str
        :param type: One of the type's aliases (required)
        :type type: str
        :param scope: The scope in which the transaction types exists. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_transaction_type_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_transaction_type_with_http_info(source, type, scope, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_transaction_type_with_http_info(self, source : Annotated[StrictStr, Field(..., description="The source that the type is in")], type : Annotated[StrictStr, Field(..., description="One of the type's aliases")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the transaction types exists. When not supplied the scope is 'default'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """DeleteTransactionType: Delete a transaction type  # noqa: E501

        /// WARNING! Changing existing transaction types has a material impact on how data, new and old,  is processed and aggregated by LUSID, and will affect your whole organisation. Only call this API if you are fully aware of the implications of the change.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_transaction_type_with_http_info(source, type, scope, async_req=True)
        >>> result = thread.get()

        :param source: The source that the type is in (required)
        :type source: str
        :param type: One of the type's aliases (required)
        :type type: str
        :param scope: The scope in which the transaction types exists. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'source',
            'type',
            'scope'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_transaction_type" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['source']:
            _path_params['source'] = _params['source']

        if _params['type']:
            _path_params['type'] = _params['type']


        # process the query parameters
        _query_params = []
        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/transactionconfiguration/types/{source}/{type}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_transaction_type_source(self, source : Annotated[StrictStr, Field(..., description="The source to set the transaction types for.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the transaction types exists. When not supplied the scope is 'default'.")] = None, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_transaction_type_source(self, source : Annotated[StrictStr, Field(..., description="The source to set the transaction types for.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the transaction types exists. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_transaction_type_source(self, source : Annotated[StrictStr, Field(..., description="The source to set the transaction types for.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the transaction types exists. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """DeleteTransactionTypeSource: Delete all transaction types for the given source and scope  # noqa: E501

        Delete all the types for the given source and scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_transaction_type_source(source, scope, async_req=True)
        >>> result = thread.get()

        :param source: The source to set the transaction types for. (required)
        :type source: str
        :param scope: The scope in which the transaction types exists. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_transaction_type_source_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_transaction_type_source_with_http_info(source, scope, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_transaction_type_source_with_http_info(self, source : Annotated[StrictStr, Field(..., description="The source to set the transaction types for.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the transaction types exists. When not supplied the scope is 'default'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """DeleteTransactionTypeSource: Delete all transaction types for the given source and scope  # noqa: E501

        Delete all the types for the given source and scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_transaction_type_source_with_http_info(source, scope, async_req=True)
        >>> result = thread.get()

        :param source: The source to set the transaction types for. (required)
        :type source: str
        :param scope: The scope in which the transaction types exists. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'source',
            'scope'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_transaction_type_source" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['source']:
            _path_params['source'] = _params['source']


        # process the query parameters
        _query_params = []
        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/transactionconfiguration/types/{source}/$delete', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_side_definition(self, side : Annotated[StrictStr, Field(..., description="The label to uniquely identify the side.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction types. Defaults to returning the latest versions if not specified.")] = None, **kwargs) -> SideDefinition:  # noqa: E501
        ...

    @overload
    def get_side_definition(self, side : Annotated[StrictStr, Field(..., description="The label to uniquely identify the side.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction types. Defaults to returning the latest versions if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> SideDefinition:  # noqa: E501
        ...

    @validate_arguments
    def get_side_definition(self, side : Annotated[StrictStr, Field(..., description="The label to uniquely identify the side.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction types. Defaults to returning the latest versions if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[SideDefinition, Awaitable[SideDefinition]]:  # noqa: E501
        """GetSideDefinition: Get the side definition for a given side name( or label)  # noqa: E501

        Get the side definition user requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_side_definition(side, scope, as_at, async_req=True)
        >>> result = thread.get()

        :param side: The label to uniquely identify the side. (required)
        :type side: str
        :param scope: The scope in which the side exists. When not supplied the scope is 'default'.
        :type scope: str
        :param as_at: The asAt datetime at which to retrieve the transaction types. Defaults to returning the latest versions if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SideDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_side_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_side_definition_with_http_info(side, scope, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_side_definition_with_http_info(self, side : Annotated[StrictStr, Field(..., description="The label to uniquely identify the side.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction types. Defaults to returning the latest versions if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetSideDefinition: Get the side definition for a given side name( or label)  # noqa: E501

        Get the side definition user requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_side_definition_with_http_info(side, scope, as_at, async_req=True)
        >>> result = thread.get()

        :param side: The label to uniquely identify the side. (required)
        :type side: str
        :param scope: The scope in which the side exists. When not supplied the scope is 'default'.
        :type scope: str
        :param as_at: The asAt datetime at which to retrieve the transaction types. Defaults to returning the latest versions if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SideDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'side',
            'scope',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_side_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['side']:
            _path_params['side'] = _params['side']


        # process the query parameters
        _query_params = []
        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "SideDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/transactionconfiguration/sides/{side}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_transaction_type(self, source : Annotated[StrictStr, Field(..., description="The source that the type is in")], type : Annotated[StrictStr, Field(..., description="One of the type's aliases")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction configuration.              Defaults to returning the latest version of the transaction configuration type if not specified")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the transaction types exists. When not supplied the scope is 'default'.")] = None, **kwargs) -> TransactionType:  # noqa: E501
        ...

    @overload
    def get_transaction_type(self, source : Annotated[StrictStr, Field(..., description="The source that the type is in")], type : Annotated[StrictStr, Field(..., description="One of the type's aliases")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction configuration.              Defaults to returning the latest version of the transaction configuration type if not specified")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the transaction types exists. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=True, **kwargs) -> TransactionType:  # noqa: E501
        ...

    @validate_arguments
    def get_transaction_type(self, source : Annotated[StrictStr, Field(..., description="The source that the type is in")], type : Annotated[StrictStr, Field(..., description="One of the type's aliases")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction configuration.              Defaults to returning the latest version of the transaction configuration type if not specified")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the transaction types exists. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[TransactionType, Awaitable[TransactionType]]:  # noqa: E501
        """GetTransactionType: Get a single transaction configuration type  # noqa: E501

        Get a single transaction type. Returns failure if not found  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_transaction_type(source, type, as_at, scope, async_req=True)
        >>> result = thread.get()

        :param source: The source that the type is in (required)
        :type source: str
        :param type: One of the type's aliases (required)
        :type type: str
        :param as_at: The asAt datetime at which to retrieve the transaction configuration.              Defaults to returning the latest version of the transaction configuration type if not specified
        :type as_at: datetime
        :param scope: The scope in which the transaction types exists. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionType
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_transaction_type_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_transaction_type_with_http_info(source, type, as_at, scope, **kwargs)  # noqa: E501

    @validate_arguments
    def get_transaction_type_with_http_info(self, source : Annotated[StrictStr, Field(..., description="The source that the type is in")], type : Annotated[StrictStr, Field(..., description="One of the type's aliases")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction configuration.              Defaults to returning the latest version of the transaction configuration type if not specified")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the transaction types exists. When not supplied the scope is 'default'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetTransactionType: Get a single transaction configuration type  # noqa: E501

        Get a single transaction type. Returns failure if not found  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_transaction_type_with_http_info(source, type, as_at, scope, async_req=True)
        >>> result = thread.get()

        :param source: The source that the type is in (required)
        :type source: str
        :param type: One of the type's aliases (required)
        :type type: str
        :param as_at: The asAt datetime at which to retrieve the transaction configuration.              Defaults to returning the latest version of the transaction configuration type if not specified
        :type as_at: datetime
        :param scope: The scope in which the transaction types exists. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionType, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'source',
            'type',
            'as_at',
            'scope'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transaction_type" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['source']:
            _path_params['source'] = _params['source']

        if _params['type']:
            _path_params['type'] = _params['type']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "TransactionType",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/transactionconfiguration/types/{source}/{type}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_side_definitions(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction types. Defaults to returning the latest versions if not specified.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, **kwargs) -> ResourceListOfSideDefinition:  # noqa: E501
        ...

    @overload
    def list_side_definitions(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction types. Defaults to returning the latest versions if not specified.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfSideDefinition:  # noqa: E501
        ...

    @validate_arguments
    def list_side_definitions(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction types. Defaults to returning the latest versions if not specified.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfSideDefinition, Awaitable[ResourceListOfSideDefinition]]:  # noqa: E501
        """ListSideDefinitions: List the side definitions  # noqa: E501

        List all the side definitions in the given scope  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_side_definitions(as_at, scope, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to retrieve the transaction types. Defaults to returning the latest versions if not specified.
        :type as_at: datetime
        :param scope: The scope in which the side exists. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfSideDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_side_definitions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_side_definitions_with_http_info(as_at, scope, **kwargs)  # noqa: E501

    @validate_arguments
    def list_side_definitions_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction types. Defaults to returning the latest versions if not specified.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """ListSideDefinitions: List the side definitions  # noqa: E501

        List all the side definitions in the given scope  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_side_definitions_with_http_info(as_at, scope, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to retrieve the transaction types. Defaults to returning the latest versions if not specified.
        :type as_at: datetime
        :param scope: The scope in which the side exists. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfSideDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'scope'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_side_definitions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfSideDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/transactionconfiguration/sides', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_transaction_types(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction types. Defaults              to returning the latest versions if not specified.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, **kwargs) -> Dict[str, List[TransactionType]]:  # noqa: E501
        ...

    @overload
    def list_transaction_types(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction types. Defaults              to returning the latest versions if not specified.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=True, **kwargs) -> Dict[str, List[TransactionType]]:  # noqa: E501
        ...

    @validate_arguments
    def list_transaction_types(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction types. Defaults              to returning the latest versions if not specified.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Dict[str, List[TransactionType]], Awaitable[Dict[str, List[TransactionType]]]]:  # noqa: E501
        """ListTransactionTypes: List transaction types  # noqa: E501

        Get the list of current transaction types. For information on the default transaction types provided with  LUSID, see https://support.lusid.com/knowledgebase/article/KA-01873/.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transaction_types(as_at, scope, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to retrieve the transaction types. Defaults              to returning the latest versions if not specified.
        :type as_at: datetime
        :param scope: The scope in which the side exists. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, List[TransactionType]]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_transaction_types_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_transaction_types_with_http_info(as_at, scope, **kwargs)  # noqa: E501

    @validate_arguments
    def list_transaction_types_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the transaction types. Defaults              to returning the latest versions if not specified.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """ListTransactionTypes: List transaction types  # noqa: E501

        Get the list of current transaction types. For information on the default transaction types provided with  LUSID, see https://support.lusid.com/knowledgebase/article/KA-01873/.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transaction_types_with_http_info(as_at, scope, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to retrieve the transaction types. Defaults              to returning the latest versions if not specified.
        :type as_at: datetime
        :param scope: The scope in which the side exists. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, List[TransactionType]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'scope'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_transaction_types" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, List[TransactionType]]",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/transactionconfiguration/types', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def set_side_definition(self, side : Annotated[StrictStr, Field(..., description="The label to uniquely identify the side.")], side_definition_request : Annotated[SideDefinitionRequest, Field(..., description="The side definition to create or replace.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, **kwargs) -> SideDefinition:  # noqa: E501
        ...

    @overload
    def set_side_definition(self, side : Annotated[StrictStr, Field(..., description="The label to uniquely identify the side.")], side_definition_request : Annotated[SideDefinitionRequest, Field(..., description="The side definition to create or replace.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=True, **kwargs) -> SideDefinition:  # noqa: E501
        ...

    @validate_arguments
    def set_side_definition(self, side : Annotated[StrictStr, Field(..., description="The label to uniquely identify the side.")], side_definition_request : Annotated[SideDefinitionRequest, Field(..., description="The side definition to create or replace.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[SideDefinition, Awaitable[SideDefinition]]:  # noqa: E501
        """SetSideDefinition: Set a side definition  # noqa: E501

        Set a new side definition for use in a transaction type. For more information, see https://support.lusid.com/knowledgebase/article/KA-01875.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_side_definition(side, side_definition_request, scope, async_req=True)
        >>> result = thread.get()

        :param side: The label to uniquely identify the side. (required)
        :type side: str
        :param side_definition_request: The side definition to create or replace. (required)
        :type side_definition_request: SideDefinitionRequest
        :param scope: The scope in which the side exists. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SideDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the set_side_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.set_side_definition_with_http_info(side, side_definition_request, scope, **kwargs)  # noqa: E501

    @validate_arguments
    def set_side_definition_with_http_info(self, side : Annotated[StrictStr, Field(..., description="The label to uniquely identify the side.")], side_definition_request : Annotated[SideDefinitionRequest, Field(..., description="The side definition to create or replace.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """SetSideDefinition: Set a side definition  # noqa: E501

        Set a new side definition for use in a transaction type. For more information, see https://support.lusid.com/knowledgebase/article/KA-01875.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_side_definition_with_http_info(side, side_definition_request, scope, async_req=True)
        >>> result = thread.get()

        :param side: The label to uniquely identify the side. (required)
        :type side: str
        :param side_definition_request: The side definition to create or replace. (required)
        :type side_definition_request: SideDefinitionRequest
        :param scope: The scope in which the side exists. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SideDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'side',
            'side_definition_request',
            'scope'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_side_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['side']:
            _path_params['side'] = _params['side']


        # process the query parameters
        _query_params = []
        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['side_definition_request'] is not None:
            _body_params = _params['side_definition_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "SideDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/transactionconfiguration/sides/{side}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def set_side_definitions(self, sides_definition_request : Annotated[conlist(SidesDefinitionRequest), Field(..., description="The list of side definitions to create, or replace.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, **kwargs) -> ResourceListOfSideDefinition:  # noqa: E501
        ...

    @overload
    def set_side_definitions(self, sides_definition_request : Annotated[conlist(SidesDefinitionRequest), Field(..., description="The list of side definitions to create, or replace.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfSideDefinition:  # noqa: E501
        ...

    @validate_arguments
    def set_side_definitions(self, sides_definition_request : Annotated[conlist(SidesDefinitionRequest), Field(..., description="The list of side definitions to create, or replace.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfSideDefinition, Awaitable[ResourceListOfSideDefinition]]:  # noqa: E501
        """SetSideDefinitions: Set the given side definitions  # noqa: E501

        Set a new side definition for use in a transaction type. For more information, see https://support.lusid.com/knowledgebase/article/KA-01875.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_side_definitions(sides_definition_request, scope, async_req=True)
        >>> result = thread.get()

        :param sides_definition_request: The list of side definitions to create, or replace. (required)
        :type sides_definition_request: List[SidesDefinitionRequest]
        :param scope: The scope in which the side exists. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfSideDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the set_side_definitions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.set_side_definitions_with_http_info(sides_definition_request, scope, **kwargs)  # noqa: E501

    @validate_arguments
    def set_side_definitions_with_http_info(self, sides_definition_request : Annotated[conlist(SidesDefinitionRequest), Field(..., description="The list of side definitions to create, or replace.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the side exists. When not supplied the scope is 'default'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """SetSideDefinitions: Set the given side definitions  # noqa: E501

        Set a new side definition for use in a transaction type. For more information, see https://support.lusid.com/knowledgebase/article/KA-01875.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_side_definitions_with_http_info(sides_definition_request, scope, async_req=True)
        >>> result = thread.get()

        :param sides_definition_request: The list of side definitions to create, or replace. (required)
        :type sides_definition_request: List[SidesDefinitionRequest]
        :param scope: The scope in which the side exists. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfSideDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'sides_definition_request',
            'scope'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_side_definitions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['sides_definition_request'] is not None:
            _body_params = _params['sides_definition_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfSideDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/transactionconfiguration/sides', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def set_transaction_type(self, source : Annotated[StrictStr, Field(..., description="The source to set the transaction configuration for")], type : Annotated[StrictStr, Field(..., description="One of the transaction configuration alias types to uniquely identify the configuration. If this type does not exist, then a new transaction type is created using the body of the request in the given source, without including this type")], transaction_type_request : Annotated[TransactionTypeRequest, Field(..., description="The transaction configuration to set")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the transaction types exists. When not supplied the scope is 'default'.")] = None, **kwargs) -> TransactionType:  # noqa: E501
        ...

    @overload
    def set_transaction_type(self, source : Annotated[StrictStr, Field(..., description="The source to set the transaction configuration for")], type : Annotated[StrictStr, Field(..., description="One of the transaction configuration alias types to uniquely identify the configuration. If this type does not exist, then a new transaction type is created using the body of the request in the given source, without including this type")], transaction_type_request : Annotated[TransactionTypeRequest, Field(..., description="The transaction configuration to set")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the transaction types exists. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=True, **kwargs) -> TransactionType:  # noqa: E501
        ...

    @validate_arguments
    def set_transaction_type(self, source : Annotated[StrictStr, Field(..., description="The source to set the transaction configuration for")], type : Annotated[StrictStr, Field(..., description="One of the transaction configuration alias types to uniquely identify the configuration. If this type does not exist, then a new transaction type is created using the body of the request in the given source, without including this type")], transaction_type_request : Annotated[TransactionTypeRequest, Field(..., description="The transaction configuration to set")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the transaction types exists. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[TransactionType, Awaitable[TransactionType]]:  # noqa: E501
        """SetTransactionType: Set a specific transaction type  # noqa: E501

        Set a transaction type for the given source and type. If the requested transaction type does not exist, it will be created    WARNING! Changing existing transaction types has a material impact on how data, new and old, is processed and aggregated by LUSID, and will affect your whole organisation. Only call this API if you are fully aware of the implications of the change.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_transaction_type(source, type, transaction_type_request, scope, async_req=True)
        >>> result = thread.get()

        :param source: The source to set the transaction configuration for (required)
        :type source: str
        :param type: One of the transaction configuration alias types to uniquely identify the configuration. If this type does not exist, then a new transaction type is created using the body of the request in the given source, without including this type (required)
        :type type: str
        :param transaction_type_request: The transaction configuration to set (required)
        :type transaction_type_request: TransactionTypeRequest
        :param scope: The scope in which the transaction types exists. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionType
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the set_transaction_type_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.set_transaction_type_with_http_info(source, type, transaction_type_request, scope, **kwargs)  # noqa: E501

    @validate_arguments
    def set_transaction_type_with_http_info(self, source : Annotated[StrictStr, Field(..., description="The source to set the transaction configuration for")], type : Annotated[StrictStr, Field(..., description="One of the transaction configuration alias types to uniquely identify the configuration. If this type does not exist, then a new transaction type is created using the body of the request in the given source, without including this type")], transaction_type_request : Annotated[TransactionTypeRequest, Field(..., description="The transaction configuration to set")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the transaction types exists. When not supplied the scope is 'default'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """SetTransactionType: Set a specific transaction type  # noqa: E501

        Set a transaction type for the given source and type. If the requested transaction type does not exist, it will be created    WARNING! Changing existing transaction types has a material impact on how data, new and old, is processed and aggregated by LUSID, and will affect your whole organisation. Only call this API if you are fully aware of the implications of the change.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_transaction_type_with_http_info(source, type, transaction_type_request, scope, async_req=True)
        >>> result = thread.get()

        :param source: The source to set the transaction configuration for (required)
        :type source: str
        :param type: One of the transaction configuration alias types to uniquely identify the configuration. If this type does not exist, then a new transaction type is created using the body of the request in the given source, without including this type (required)
        :type type: str
        :param transaction_type_request: The transaction configuration to set (required)
        :type transaction_type_request: TransactionTypeRequest
        :param scope: The scope in which the transaction types exists. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionType, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'source',
            'type',
            'transaction_type_request',
            'scope'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_transaction_type" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['source']:
            _path_params['source'] = _params['source']

        if _params['type']:
            _path_params['type'] = _params['type']


        # process the query parameters
        _query_params = []
        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['transaction_type_request'] is not None:
            _body_params = _params['transaction_type_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "TransactionType",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/transactionconfiguration/types/{source}/{type}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def set_transaction_type_source(self, source : Annotated[StrictStr, Field(..., description="The source to set the transaction types for.")], transaction_type_request : Annotated[conlist(TransactionTypeRequest), Field(..., description="The set of transaction types.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the transaction types exists. When not supplied the scope is 'default'.")] = None, **kwargs) -> ResourceListOfTransactionType:  # noqa: E501
        ...

    @overload
    def set_transaction_type_source(self, source : Annotated[StrictStr, Field(..., description="The source to set the transaction types for.")], transaction_type_request : Annotated[conlist(TransactionTypeRequest), Field(..., description="The set of transaction types.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the transaction types exists. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfTransactionType:  # noqa: E501
        ...

    @validate_arguments
    def set_transaction_type_source(self, source : Annotated[StrictStr, Field(..., description="The source to set the transaction types for.")], transaction_type_request : Annotated[conlist(TransactionTypeRequest), Field(..., description="The set of transaction types.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the transaction types exists. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfTransactionType, Awaitable[ResourceListOfTransactionType]]:  # noqa: E501
        """SetTransactionTypeSource: Set the transaction types for the given source and scope  # noqa: E501

        The complete set of transaction types for the source.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_transaction_type_source(source, transaction_type_request, scope, async_req=True)
        >>> result = thread.get()

        :param source: The source to set the transaction types for. (required)
        :type source: str
        :param transaction_type_request: The set of transaction types. (required)
        :type transaction_type_request: List[TransactionTypeRequest]
        :param scope: The scope in which the transaction types exists. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfTransactionType
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the set_transaction_type_source_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.set_transaction_type_source_with_http_info(source, transaction_type_request, scope, **kwargs)  # noqa: E501

    @validate_arguments
    def set_transaction_type_source_with_http_info(self, source : Annotated[StrictStr, Field(..., description="The source to set the transaction types for.")], transaction_type_request : Annotated[conlist(TransactionTypeRequest), Field(..., description="The set of transaction types.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the transaction types exists. When not supplied the scope is 'default'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """SetTransactionTypeSource: Set the transaction types for the given source and scope  # noqa: E501

        The complete set of transaction types for the source.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_transaction_type_source_with_http_info(source, transaction_type_request, scope, async_req=True)
        >>> result = thread.get()

        :param source: The source to set the transaction types for. (required)
        :type source: str
        :param transaction_type_request: The set of transaction types. (required)
        :type transaction_type_request: List[TransactionTypeRequest]
        :param scope: The scope in which the transaction types exists. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfTransactionType, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'source',
            'transaction_type_request',
            'scope'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_transaction_type_source" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['source']:
            _path_params['source'] = _params['source']


        # process the query parameters
        _query_params = []
        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['transaction_type_request'] is not None:
            _body_params = _params['transaction_type_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfTransactionType",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/transactionconfiguration/types/{source}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
