# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictStr, conint, conlist, constr, validator

from typing import Optional

from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.paged_resource_list_of_item_and_workspace import PagedResourceListOfItemAndWorkspace
from lusid.models.paged_resource_list_of_workspace import PagedResourceListOfWorkspace
from lusid.models.paged_resource_list_of_workspace_item import PagedResourceListOfWorkspaceItem
from lusid.models.workspace import Workspace
from lusid.models.workspace_creation_request import WorkspaceCreationRequest
from lusid.models.workspace_item import WorkspaceItem
from lusid.models.workspace_item_creation_request import WorkspaceItemCreationRequest
from lusid.models.workspace_item_update_request import WorkspaceItemUpdateRequest
from lusid.models.workspace_update_request import WorkspaceUpdateRequest

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class WorkspaceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def create_item(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The item's workspace name.")], workspace_item_creation_request : Annotated[Optional[WorkspaceItemCreationRequest], Field(description="The item to be created.")] = None, **kwargs) -> WorkspaceItem:  # noqa: E501
        ...

    @overload
    def create_item(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The item's workspace name.")], workspace_item_creation_request : Annotated[Optional[WorkspaceItemCreationRequest], Field(description="The item to be created.")] = None, async_req: Optional[bool]=True, **kwargs) -> WorkspaceItem:  # noqa: E501
        ...

    @validate_arguments
    def create_item(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The item's workspace name.")], workspace_item_creation_request : Annotated[Optional[WorkspaceItemCreationRequest], Field(description="The item to be created.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[WorkspaceItem, Awaitable[WorkspaceItem]]:  # noqa: E501
        """[EXPERIMENTAL] CreateItem: Create a new item in a workspace.  # noqa: E501

        Create a new item in a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_item(visibility, workspace_name, workspace_item_creation_request, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the containing workspace. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param workspace_name: The item's workspace name. (required)
        :type workspace_name: str
        :param workspace_item_creation_request: The item to be created.
        :type workspace_item_creation_request: WorkspaceItemCreationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkspaceItem
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_item_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_item_with_http_info(visibility, workspace_name, workspace_item_creation_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_item_with_http_info(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The item's workspace name.")], workspace_item_creation_request : Annotated[Optional[WorkspaceItemCreationRequest], Field(description="The item to be created.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] CreateItem: Create a new item in a workspace.  # noqa: E501

        Create a new item in a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_item_with_http_info(visibility, workspace_name, workspace_item_creation_request, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the containing workspace. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param workspace_name: The item's workspace name. (required)
        :type workspace_name: str
        :param workspace_item_creation_request: The item to be created.
        :type workspace_item_creation_request: WorkspaceItemCreationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WorkspaceItem, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'visibility',
            'workspace_name',
            'workspace_item_creation_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_item" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['visibility']:
            _path_params['visibility'] = _params['visibility']

        if _params['workspace_name']:
            _path_params['workspaceName'] = _params['workspace_name']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['workspace_item_creation_request'] is not None:
            _body_params = _params['workspace_item_creation_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "WorkspaceItem",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/workspaces/{visibility}/{workspaceName}/items', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def create_workspace(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the workspace being created. Must be `shared` or `personal`; case is important.")], workspace_creation_request : Annotated[Optional[WorkspaceCreationRequest], Field(description="The workspace to be created.")] = None, **kwargs) -> Workspace:  # noqa: E501
        ...

    @overload
    def create_workspace(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the workspace being created. Must be `shared` or `personal`; case is important.")], workspace_creation_request : Annotated[Optional[WorkspaceCreationRequest], Field(description="The workspace to be created.")] = None, async_req: Optional[bool]=True, **kwargs) -> Workspace:  # noqa: E501
        ...

    @validate_arguments
    def create_workspace(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the workspace being created. Must be `shared` or `personal`; case is important.")], workspace_creation_request : Annotated[Optional[WorkspaceCreationRequest], Field(description="The workspace to be created.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Workspace, Awaitable[Workspace]]:  # noqa: E501
        """[EXPERIMENTAL] CreateWorkspace: Create a new workspace.  # noqa: E501

        Create a new workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_workspace(visibility, workspace_creation_request, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the workspace being created. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param workspace_creation_request: The workspace to be created.
        :type workspace_creation_request: WorkspaceCreationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Workspace
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_workspace_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_workspace_with_http_info(visibility, workspace_creation_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_workspace_with_http_info(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the workspace being created. Must be `shared` or `personal`; case is important.")], workspace_creation_request : Annotated[Optional[WorkspaceCreationRequest], Field(description="The workspace to be created.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] CreateWorkspace: Create a new workspace.  # noqa: E501

        Create a new workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_workspace_with_http_info(visibility, workspace_creation_request, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the workspace being created. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param workspace_creation_request: The workspace to be created.
        :type workspace_creation_request: WorkspaceCreationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Workspace, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'visibility',
            'workspace_creation_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_workspace" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['visibility']:
            _path_params['visibility'] = _params['visibility']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['workspace_creation_request'] is not None:
            _body_params = _params['workspace_creation_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "Workspace",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/workspaces/{visibility}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_item(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The name of the workspace.")], group_name : Annotated[StrictStr, Field(..., description="The group containing the item.")], item_name : Annotated[StrictStr, Field(..., description="The name of the item.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_item(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The name of the workspace.")], group_name : Annotated[StrictStr, Field(..., description="The group containing the item.")], item_name : Annotated[StrictStr, Field(..., description="The name of the item.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_item(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The name of the workspace.")], group_name : Annotated[StrictStr, Field(..., description="The group containing the item.")], item_name : Annotated[StrictStr, Field(..., description="The name of the item.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteItem: Delete an item from a workspace.  # noqa: E501

        Delete an item from a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_item(visibility, workspace_name, group_name, item_name, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the containing workspace. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param workspace_name: The name of the workspace. (required)
        :type workspace_name: str
        :param group_name: The group containing the item. (required)
        :type group_name: str
        :param item_name: The name of the item. (required)
        :type item_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_item_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_item_with_http_info(visibility, workspace_name, group_name, item_name, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_item_with_http_info(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The name of the workspace.")], group_name : Annotated[StrictStr, Field(..., description="The group containing the item.")], item_name : Annotated[StrictStr, Field(..., description="The name of the item.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteItem: Delete an item from a workspace.  # noqa: E501

        Delete an item from a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_item_with_http_info(visibility, workspace_name, group_name, item_name, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the containing workspace. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param workspace_name: The name of the workspace. (required)
        :type workspace_name: str
        :param group_name: The group containing the item. (required)
        :type group_name: str
        :param item_name: The name of the item. (required)
        :type item_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'visibility',
            'workspace_name',
            'group_name',
            'item_name'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_item" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['visibility']:
            _path_params['visibility'] = _params['visibility']

        if _params['workspace_name']:
            _path_params['workspaceName'] = _params['workspace_name']

        if _params['group_name']:
            _path_params['groupName'] = _params['group_name']

        if _params['item_name']:
            _path_params['itemName'] = _params['item_name']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/workspaces/{visibility}/{workspaceName}/items/{groupName}/{itemName}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_workspace(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The name of the workspace.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_workspace(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The name of the workspace.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_workspace(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The name of the workspace.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteWorkspace: Delete a workspace.  # noqa: E501

        Delete a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_workspace(visibility, workspace_name, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the workspace. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param workspace_name: The name of the workspace. (required)
        :type workspace_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_workspace_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_workspace_with_http_info(visibility, workspace_name, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_workspace_with_http_info(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The name of the workspace.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteWorkspace: Delete a workspace.  # noqa: E501

        Delete a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_workspace_with_http_info(visibility, workspace_name, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the workspace. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param workspace_name: The name of the workspace. (required)
        :type workspace_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'visibility',
            'workspace_name'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workspace" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['visibility']:
            _path_params['visibility'] = _params['visibility']

        if _params['workspace_name']:
            _path_params['workspaceName'] = _params['workspace_name']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/workspaces/{visibility}/{workspaceName}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_item(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The name of the workspace.")], group_name : Annotated[StrictStr, Field(..., description="The group containing the item.")], item_name : Annotated[StrictStr, Field(..., description="The name of the item.")], as_at : Annotated[Optional[datetime], Field(description="The datetime at which to request the workspace item. If not provided, defaults to 'latest'.")] = None, **kwargs) -> WorkspaceItem:  # noqa: E501
        ...

    @overload
    def get_item(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The name of the workspace.")], group_name : Annotated[StrictStr, Field(..., description="The group containing the item.")], item_name : Annotated[StrictStr, Field(..., description="The name of the item.")], as_at : Annotated[Optional[datetime], Field(description="The datetime at which to request the workspace item. If not provided, defaults to 'latest'.")] = None, async_req: Optional[bool]=True, **kwargs) -> WorkspaceItem:  # noqa: E501
        ...

    @validate_arguments
    def get_item(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The name of the workspace.")], group_name : Annotated[StrictStr, Field(..., description="The group containing the item.")], item_name : Annotated[StrictStr, Field(..., description="The name of the item.")], as_at : Annotated[Optional[datetime], Field(description="The datetime at which to request the workspace item. If not provided, defaults to 'latest'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[WorkspaceItem, Awaitable[WorkspaceItem]]:  # noqa: E501
        """[EXPERIMENTAL] GetItem: Get a single workspace item.  # noqa: E501

        Get a single workspace item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_item(visibility, workspace_name, group_name, item_name, as_at, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the containing workspace. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param workspace_name: The name of the workspace. (required)
        :type workspace_name: str
        :param group_name: The group containing the item. (required)
        :type group_name: str
        :param item_name: The name of the item. (required)
        :type item_name: str
        :param as_at: The datetime at which to request the workspace item. If not provided, defaults to 'latest'.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkspaceItem
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_item_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_item_with_http_info(visibility, workspace_name, group_name, item_name, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_item_with_http_info(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The name of the workspace.")], group_name : Annotated[StrictStr, Field(..., description="The group containing the item.")], item_name : Annotated[StrictStr, Field(..., description="The name of the item.")], as_at : Annotated[Optional[datetime], Field(description="The datetime at which to request the workspace item. If not provided, defaults to 'latest'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetItem: Get a single workspace item.  # noqa: E501

        Get a single workspace item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_item_with_http_info(visibility, workspace_name, group_name, item_name, as_at, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the containing workspace. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param workspace_name: The name of the workspace. (required)
        :type workspace_name: str
        :param group_name: The group containing the item. (required)
        :type group_name: str
        :param item_name: The name of the item. (required)
        :type item_name: str
        :param as_at: The datetime at which to request the workspace item. If not provided, defaults to 'latest'.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WorkspaceItem, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'visibility',
            'workspace_name',
            'group_name',
            'item_name',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['visibility']:
            _path_params['visibility'] = _params['visibility']

        if _params['workspace_name']:
            _path_params['workspaceName'] = _params['workspace_name']

        if _params['group_name']:
            _path_params['groupName'] = _params['group_name']

        if _params['item_name']:
            _path_params['itemName'] = _params['item_name']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "WorkspaceItem",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/workspaces/{visibility}/{workspaceName}/items/{groupName}/{itemName}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_workspace(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The workspace name.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve workspaces. Defaults to 'latest' if not specified.")] = None, **kwargs) -> Workspace:  # noqa: E501
        ...

    @overload
    def get_workspace(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The workspace name.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve workspaces. Defaults to 'latest' if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> Workspace:  # noqa: E501
        ...

    @validate_arguments
    def get_workspace(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The workspace name.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve workspaces. Defaults to 'latest' if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Workspace, Awaitable[Workspace]]:  # noqa: E501
        """[EXPERIMENTAL] GetWorkspace: Get a workspace.  # noqa: E501

        Get a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_workspace(visibility, workspace_name, as_at, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the workspace. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param workspace_name: The workspace name. (required)
        :type workspace_name: str
        :param as_at: The asAt datetime at which to retrieve workspaces. Defaults to 'latest' if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Workspace
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_workspace_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_workspace_with_http_info(visibility, workspace_name, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_workspace_with_http_info(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The workspace name.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve workspaces. Defaults to 'latest' if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetWorkspace: Get a workspace.  # noqa: E501

        Get a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_workspace_with_http_info(visibility, workspace_name, as_at, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the workspace. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param workspace_name: The workspace name. (required)
        :type workspace_name: str
        :param as_at: The asAt datetime at which to retrieve workspaces. Defaults to 'latest' if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Workspace, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'visibility',
            'workspace_name',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workspace" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['visibility']:
            _path_params['visibility'] = _params['visibility']

        if _params['workspace_name']:
            _path_params['workspaceName'] = _params['workspace_name']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Workspace",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/workspaces/{visibility}/{workspaceName}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_items(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The item's workspace name.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve workspace items. Defaults to 'latest' if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing workspaces items from a previous call to list workspaces items.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> PagedResourceListOfWorkspaceItem:  # noqa: E501
        ...

    @overload
    def list_items(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The item's workspace name.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve workspace items. Defaults to 'latest' if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing workspaces items from a previous call to list workspaces items.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfWorkspaceItem:  # noqa: E501
        ...

    @validate_arguments
    def list_items(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The item's workspace name.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve workspace items. Defaults to 'latest' if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing workspaces items from a previous call to list workspaces items.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfWorkspaceItem, Awaitable[PagedResourceListOfWorkspaceItem]]:  # noqa: E501
        """[EXPERIMENTAL] ListItems: List the items in a workspace.  # noqa: E501

        List the items in a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_items(visibility, workspace_name, as_at, page, sort_by, limit, filter, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the containing workspace. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param workspace_name: The item's workspace name. (required)
        :type workspace_name: str
        :param as_at: The asAt datetime at which to retrieve workspace items. Defaults to 'latest' if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing workspaces items from a previous call to list workspaces items.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.
        :type page: str
        :param sort_by: A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfWorkspaceItem
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_items_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_items_with_http_info(visibility, workspace_name, as_at, page, sort_by, limit, filter, **kwargs)  # noqa: E501

    @validate_arguments
    def list_items_with_http_info(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The item's workspace name.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve workspace items. Defaults to 'latest' if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing workspaces items from a previous call to list workspaces items.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListItems: List the items in a workspace.  # noqa: E501

        List the items in a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_items_with_http_info(visibility, workspace_name, as_at, page, sort_by, limit, filter, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the containing workspace. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param workspace_name: The item's workspace name. (required)
        :type workspace_name: str
        :param as_at: The asAt datetime at which to retrieve workspace items. Defaults to 'latest' if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing workspaces items from a previous call to list workspaces items.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.
        :type page: str
        :param sort_by: A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfWorkspaceItem, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'visibility',
            'workspace_name',
            'as_at',
            'page',
            'sort_by',
            'limit',
            'filter'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_items" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['visibility']:
            _path_params['visibility'] = _params['visibility']

        if _params['workspace_name']:
            _path_params['workspaceName'] = _params['workspace_name']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfWorkspaceItem",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/workspaces/{visibility}/{workspaceName}/items', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_workspaces(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the workspaces. Must be `shared` or `personal`; case is important.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve workspaces. Defaults to 'latest' if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing workspaces from a previous call to list workspaces.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> PagedResourceListOfWorkspace:  # noqa: E501
        ...

    @overload
    def list_workspaces(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the workspaces. Must be `shared` or `personal`; case is important.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve workspaces. Defaults to 'latest' if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing workspaces from a previous call to list workspaces.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfWorkspace:  # noqa: E501
        ...

    @validate_arguments
    def list_workspaces(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the workspaces. Must be `shared` or `personal`; case is important.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve workspaces. Defaults to 'latest' if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing workspaces from a previous call to list workspaces.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfWorkspace, Awaitable[PagedResourceListOfWorkspace]]:  # noqa: E501
        """[EXPERIMENTAL] ListWorkspaces: List workspaces.  # noqa: E501

        List workspaces.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_workspaces(visibility, as_at, page, sort_by, limit, filter, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the workspaces. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param as_at: The asAt datetime at which to retrieve workspaces. Defaults to 'latest' if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing workspaces from a previous call to list workspaces.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.
        :type page: str
        :param sort_by: A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfWorkspace
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_workspaces_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_workspaces_with_http_info(visibility, as_at, page, sort_by, limit, filter, **kwargs)  # noqa: E501

    @validate_arguments
    def list_workspaces_with_http_info(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the workspaces. Must be `shared` or `personal`; case is important.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve workspaces. Defaults to 'latest' if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing workspaces from a previous call to list workspaces.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListWorkspaces: List workspaces.  # noqa: E501

        List workspaces.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_workspaces_with_http_info(visibility, as_at, page, sort_by, limit, filter, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the workspaces. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param as_at: The asAt datetime at which to retrieve workspaces. Defaults to 'latest' if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing workspaces from a previous call to list workspaces.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.
        :type page: str
        :param sort_by: A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfWorkspace, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'visibility',
            'as_at',
            'page',
            'sort_by',
            'limit',
            'filter'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_workspaces" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['visibility']:
            _path_params['visibility'] = _params['visibility']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfWorkspace",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/workspaces/{visibility}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def search_items(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve workspace items. Defaults to 'latest' if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing workspaces items from a previous call to list workspaces items.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> PagedResourceListOfItemAndWorkspace:  # noqa: E501
        ...

    @overload
    def search_items(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve workspace items. Defaults to 'latest' if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing workspaces items from a previous call to list workspaces items.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfItemAndWorkspace:  # noqa: E501
        ...

    @validate_arguments
    def search_items(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve workspace items. Defaults to 'latest' if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing workspaces items from a previous call to list workspaces items.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfItemAndWorkspace, Awaitable[PagedResourceListOfItemAndWorkspace]]:  # noqa: E501
        """[EXPERIMENTAL] SearchItems: List items across all workspaces.  # noqa: E501

        List items across all workspaces.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_items(visibility, as_at, page, sort_by, limit, filter, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the containing workspace. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param as_at: The asAt datetime at which to retrieve workspace items. Defaults to 'latest' if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing workspaces items from a previous call to list workspaces items.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.
        :type page: str
        :param sort_by: A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfItemAndWorkspace
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the search_items_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.search_items_with_http_info(visibility, as_at, page, sort_by, limit, filter, **kwargs)  # noqa: E501

    @validate_arguments
    def search_items_with_http_info(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve workspace items. Defaults to 'latest' if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing workspaces items from a previous call to list workspaces items.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] SearchItems: List items across all workspaces.  # noqa: E501

        List items across all workspaces.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_items_with_http_info(visibility, as_at, page, sort_by, limit, filter, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the containing workspace. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param as_at: The asAt datetime at which to retrieve workspace items. Defaults to 'latest' if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing workspaces items from a previous call to list workspaces items.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.
        :type page: str
        :param sort_by: A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfItemAndWorkspace, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'visibility',
            'as_at',
            'page',
            'sort_by',
            'limit',
            'filter'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_items" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['visibility']:
            _path_params['visibility'] = _params['visibility']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfItemAndWorkspace",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/workspaces/{visibility}/items', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def update_item(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The workspace name.")], group_name : Annotated[StrictStr, Field(..., description="The group containing the item.")], item_name : Annotated[StrictStr, Field(..., description="The item name.")], workspace_item_update_request : Annotated[Optional[WorkspaceItemUpdateRequest], Field(description="The new item details.")] = None, **kwargs) -> WorkspaceItem:  # noqa: E501
        ...

    @overload
    def update_item(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The workspace name.")], group_name : Annotated[StrictStr, Field(..., description="The group containing the item.")], item_name : Annotated[StrictStr, Field(..., description="The item name.")], workspace_item_update_request : Annotated[Optional[WorkspaceItemUpdateRequest], Field(description="The new item details.")] = None, async_req: Optional[bool]=True, **kwargs) -> WorkspaceItem:  # noqa: E501
        ...

    @validate_arguments
    def update_item(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The workspace name.")], group_name : Annotated[StrictStr, Field(..., description="The group containing the item.")], item_name : Annotated[StrictStr, Field(..., description="The item name.")], workspace_item_update_request : Annotated[Optional[WorkspaceItemUpdateRequest], Field(description="The new item details.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[WorkspaceItem, Awaitable[WorkspaceItem]]:  # noqa: E501
        """[EXPERIMENTAL] UpdateItem: Update an item in a workspace.  # noqa: E501

        Update an item in a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_item(visibility, workspace_name, group_name, item_name, workspace_item_update_request, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the containing workspace. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param workspace_name: The workspace name. (required)
        :type workspace_name: str
        :param group_name: The group containing the item. (required)
        :type group_name: str
        :param item_name: The item name. (required)
        :type item_name: str
        :param workspace_item_update_request: The new item details.
        :type workspace_item_update_request: WorkspaceItemUpdateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkspaceItem
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_item_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_item_with_http_info(visibility, workspace_name, group_name, item_name, workspace_item_update_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_item_with_http_info(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the containing workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The workspace name.")], group_name : Annotated[StrictStr, Field(..., description="The group containing the item.")], item_name : Annotated[StrictStr, Field(..., description="The item name.")], workspace_item_update_request : Annotated[Optional[WorkspaceItemUpdateRequest], Field(description="The new item details.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] UpdateItem: Update an item in a workspace.  # noqa: E501

        Update an item in a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_item_with_http_info(visibility, workspace_name, group_name, item_name, workspace_item_update_request, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the containing workspace. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param workspace_name: The workspace name. (required)
        :type workspace_name: str
        :param group_name: The group containing the item. (required)
        :type group_name: str
        :param item_name: The item name. (required)
        :type item_name: str
        :param workspace_item_update_request: The new item details.
        :type workspace_item_update_request: WorkspaceItemUpdateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WorkspaceItem, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'visibility',
            'workspace_name',
            'group_name',
            'item_name',
            'workspace_item_update_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_item" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['visibility']:
            _path_params['visibility'] = _params['visibility']

        if _params['workspace_name']:
            _path_params['workspaceName'] = _params['workspace_name']

        if _params['group_name']:
            _path_params['groupName'] = _params['group_name']

        if _params['item_name']:
            _path_params['itemName'] = _params['item_name']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['workspace_item_update_request'] is not None:
            _body_params = _params['workspace_item_update_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "WorkspaceItem",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/workspaces/{visibility}/{workspaceName}/items/{groupName}/{itemName}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def update_workspace(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The workspace name.")], workspace_update_request : Annotated[Optional[WorkspaceUpdateRequest], Field(description="The new workspace details.")] = None, **kwargs) -> Workspace:  # noqa: E501
        ...

    @overload
    def update_workspace(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The workspace name.")], workspace_update_request : Annotated[Optional[WorkspaceUpdateRequest], Field(description="The new workspace details.")] = None, async_req: Optional[bool]=True, **kwargs) -> Workspace:  # noqa: E501
        ...

    @validate_arguments
    def update_workspace(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The workspace name.")], workspace_update_request : Annotated[Optional[WorkspaceUpdateRequest], Field(description="The new workspace details.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Workspace, Awaitable[Workspace]]:  # noqa: E501
        """[EXPERIMENTAL] UpdateWorkspace: Update a workspace.  # noqa: E501

        Update a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_workspace(visibility, workspace_name, workspace_update_request, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the workspace. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param workspace_name: The workspace name. (required)
        :type workspace_name: str
        :param workspace_update_request: The new workspace details.
        :type workspace_update_request: WorkspaceUpdateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Workspace
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_workspace_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_workspace_with_http_info(visibility, workspace_name, workspace_update_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_workspace_with_http_info(self, visibility : Annotated[StrictStr, Field(..., description="The visibility for the workspace. Must be `shared` or `personal`; case is important.")], workspace_name : Annotated[StrictStr, Field(..., description="The workspace name.")], workspace_update_request : Annotated[Optional[WorkspaceUpdateRequest], Field(description="The new workspace details.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] UpdateWorkspace: Update a workspace.  # noqa: E501

        Update a workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_workspace_with_http_info(visibility, workspace_name, workspace_update_request, async_req=True)
        >>> result = thread.get()

        :param visibility: The visibility for the workspace. Must be `shared` or `personal`; case is important. (required)
        :type visibility: str
        :param workspace_name: The workspace name. (required)
        :type workspace_name: str
        :param workspace_update_request: The new workspace details.
        :type workspace_update_request: WorkspaceUpdateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Workspace, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'visibility',
            'workspace_name',
            'workspace_update_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_workspace" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['visibility']:
            _path_params['visibility'] = _params['visibility']

        if _params['workspace_name']:
            _path_params['workspaceName'] = _params['workspace_name']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['workspace_update_request'] is not None:
            _body_params = _params['workspace_update_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Workspace",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/workspaces/{visibility}/{workspaceName}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
