# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictBool, StrictStr, conlist 
from lusid.models.resource_id import ResourceId

class ContributionToNonPassingRuleDetail(BaseModel):
    """
    ContributionToNonPassingRuleDetail
    """
    rule_id: Optional[ResourceId] = Field(None, alias="ruleId")
    rule_status:  Optional[StrictStr] = Field(None,alias="ruleStatus", description="The status of the non-passing rule.") 
    breach_task_ids: Optional[conlist(StrictStr)] = Field(None, alias="breachTaskIds", description="The task ids associated with the compliance breach for this order's groups (if failing).")
    likely_responsible_for_status: Optional[StrictBool] = Field(None, alias="likelyResponsibleForStatus", description="Whether this order is deemed as a likely contributor to the non-passing rule for this group.")
    __properties = ["ruleId", "ruleStatus", "breachTaskIds", "likelyResponsibleForStatus"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ContributionToNonPassingRuleDetail:
        """Create an instance of ContributionToNonPassingRuleDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of rule_id
        if self.rule_id:
            _dict['ruleId'] = self.rule_id.to_dict()
        # set to None if rule_status (nullable) is None
        # and __fields_set__ contains the field
        if self.rule_status is None and "rule_status" in self.__fields_set__:
            _dict['ruleStatus'] = None

        # set to None if breach_task_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.breach_task_ids is None and "breach_task_ids" in self.__fields_set__:
            _dict['breachTaskIds'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ContributionToNonPassingRuleDetail:
        """Create an instance of ContributionToNonPassingRuleDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ContributionToNonPassingRuleDetail.parse_obj(obj)

        _obj = ContributionToNonPassingRuleDetail.parse_obj({
            "rule_id": ResourceId.from_dict(obj.get("ruleId")) if obj.get("ruleId") is not None else None,
            "rule_status": obj.get("ruleStatus"),
            "breach_task_ids": obj.get("breachTaskIds"),
            "likely_responsible_for_status": obj.get("likelyResponsibleForStatus")
        })
        return _obj
