# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic.v1 import StrictStr, Field, BaseModel, Field, constr, validator 

class DialectId(BaseModel):
    """
    Unique identifier of a given Dialect  # noqa: E501
    """
    scope:  StrictStr = Field(...,alias="scope", description="The Scope of the dialect.") 
    vendor:  StrictStr = Field(...,alias="vendor", description="The vendor of the dialect, the entity that created it. e.g. ISDA, FINBOURNE.") 
    source_system:  StrictStr = Field(...,alias="sourceSystem", description="The source system of the dialect, the system that understands it. e.g. LUSID, QuantLib.") 
    version:  StrictStr = Field(...,alias="version", description="The semantic version of the dialect: MAJOR.MINOR.PATCH.") 
    serialisation_format:  StrictStr = Field(...,alias="serialisationFormat", description="The serialisation format of a document in this dialect. e.g. JSON, XML.") 
    entity_type:  StrictStr = Field(...,alias="entityType", description="The type of entity this dialect describes e.g. Instrument.") 
    __properties = ["scope", "vendor", "sourceSystem", "version", "serialisationFormat", "entityType"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DialectId:
        """Create an instance of DialectId from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DialectId:
        """Create an instance of DialectId from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DialectId.parse_obj(obj)

        _obj = DialectId.parse_obj({
            "scope": obj.get("scope"),
            "vendor": obj.get("vendor"),
            "source_system": obj.get("sourceSystem"),
            "version": obj.get("version"),
            "serialisation_format": obj.get("serialisationFormat"),
            "entity_type": obj.get("entityType")
        })
        return _obj
