# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr, conlist 

class ErrorDetail(BaseModel):
    """
    ErrorDetail
    """
    id:  Optional[StrictStr] = Field(None,alias="id", description="The id of the failed item that this error relates to.") 
    type:  Optional[StrictStr] = Field(None,alias="type", description="The type of failure that occurred.") 
    detail:  Optional[StrictStr] = Field(None,alias="detail", description="Description of the failure that occurred.") 
    error_details: Optional[conlist(Dict[str, StrictStr])] = Field(None, alias="errorDetails", description="Information about the particular instance of the failure (supplied information depends on the type of failure).")
    __properties = ["id", "type", "detail", "errorDetails"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ErrorDetail:
        """Create an instance of ErrorDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if id (nullable) is None
        # and __fields_set__ contains the field
        if self.id is None and "id" in self.__fields_set__:
            _dict['id'] = None

        # set to None if type (nullable) is None
        # and __fields_set__ contains the field
        if self.type is None and "type" in self.__fields_set__:
            _dict['type'] = None

        # set to None if detail (nullable) is None
        # and __fields_set__ contains the field
        if self.detail is None and "detail" in self.__fields_set__:
            _dict['detail'] = None

        # set to None if error_details (nullable) is None
        # and __fields_set__ contains the field
        if self.error_details is None and "error_details" in self.__fields_set__:
            _dict['errorDetails'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ErrorDetail:
        """Create an instance of ErrorDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ErrorDetail.parse_obj(obj)

        _obj = ErrorDetail.parse_obj({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "detail": obj.get("detail"),
            "error_details": obj.get("errorDetails")
        })
        return _obj
