# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic.v1 import StrictStr, Field, BaseModel, Field 
from lusid.models.resource_id import ResourceId

class ParticipationRequest(BaseModel):
    """
    A request to create or update a Participation.  # noqa: E501
    """
    id: ResourceId = Field(...)
    placement_id: ResourceId = Field(..., alias="placementId")
    order_id: ResourceId = Field(..., alias="orderId")
    __properties = ["id", "placementId", "orderId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ParticipationRequest:
        """Create an instance of ParticipationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of placement_id
        if self.placement_id:
            _dict['placementId'] = self.placement_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order_id
        if self.order_id:
            _dict['orderId'] = self.order_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ParticipationRequest:
        """Create an instance of ParticipationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ParticipationRequest.parse_obj(obj)

        _obj = ParticipationRequest.parse_obj({
            "id": ResourceId.from_dict(obj.get("id")) if obj.get("id") is not None else None,
            "placement_id": ResourceId.from_dict(obj.get("placementId")) if obj.get("placementId") is not None else None,
            "order_id": ResourceId.from_dict(obj.get("orderId")) if obj.get("orderId") is not None else None
        })
        return _obj
