# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, constr 
from lusid.models.related_entity import RelatedEntity
from lusid.models.resource_id import ResourceId
from lusid.models.version import Version

class Relationship(BaseModel):
    """
    Representation of a Relationship between a requested entity with the stated entity as RelatedEntityId  # noqa: E501
    """
    version: Optional[Version] = None
    relationship_definition_id: ResourceId = Field(..., alias="relationshipDefinitionId")
    related_entity: RelatedEntity = Field(..., alias="relatedEntity")
    traversal_direction:  StrictStr = Field(...,alias="traversalDirection", description="Direction of relationship between the requested entity and related entity. This can be 'In' or 'Out'. Read more about relationships traversal direction in LUSID Knowledge Base here https://support.lusid.com/knowledgebase/article/KA-01679.") 
    traversal_description:  StrictStr = Field(...,alias="traversalDescription", description="Description of the relationship based on relationship's traversal direction. If 'TraversalDirection' is 'Out', this description would be 'OutwardDescription' from the associated relationship definition. If 'TraversalDirection' is 'In', this description would be 'InwardDescription' from the associated relationship definition.") 
    effective_from: Optional[datetime] = Field(None, alias="effectiveFrom", description="The effective datetime from which the relationship is valid.")
    effective_until: Optional[datetime] = Field(None, alias="effectiveUntil", description="The effective datetime until which the relationship is valid. If no future deletions are present or an effective until has not been set for the relationship, this will be indefinite and represented by the maximum date.")
    __properties = ["version", "relationshipDefinitionId", "relatedEntity", "traversalDirection", "traversalDescription", "effectiveFrom", "effectiveUntil"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Relationship:
        """Create an instance of Relationship from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of relationship_definition_id
        if self.relationship_definition_id:
            _dict['relationshipDefinitionId'] = self.relationship_definition_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of related_entity
        if self.related_entity:
            _dict['relatedEntity'] = self.related_entity.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Relationship:
        """Create an instance of Relationship from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Relationship.parse_obj(obj)

        _obj = Relationship.parse_obj({
            "version": Version.from_dict(obj.get("version")) if obj.get("version") is not None else None,
            "relationship_definition_id": ResourceId.from_dict(obj.get("relationshipDefinitionId")) if obj.get("relationshipDefinitionId") is not None else None,
            "related_entity": RelatedEntity.from_dict(obj.get("relatedEntity")) if obj.get("relatedEntity") is not None else None,
            "traversal_direction": obj.get("traversalDirection"),
            "traversal_description": obj.get("traversalDescription"),
            "effective_from": obj.get("effectiveFrom"),
            "effective_until": obj.get("effectiveUntil")
        })
        return _obj
