/// Files: security/selinux/hooks.c fs/proc/base.c
/// Fix: 0c461cb727d146c9ef2d3e86214f498b78b7d125
/// Detect-To: bb646cdb12e75d82258c2f2e7746d5952d3e321a

virtual detect

@memdup_attr_write@
identifier buf, count;
position p;
@@

proc_pid_attr_write(..., char *buf, size_t count, ...)
{
	...
*	memdup_user(buf, count)@p
	...
}

@err depends on memdup_attr_write exists@
identifier size, str;
statement S;
position p;
@@

selinux_setprocattr(..., size_t size)
{
	...
*	if (size && str[1]@p && str[1] != '\n') S
	...
}

@script:python depends on detect@
p << err.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2017-2618')
