/// Files: block/blk-core.c block/blk-flush.c
/// Fix: 54648cf1ec2d7f4b6a71767799c45676a138ca24
/// Fixes: 7c94e1c157a227837b04f02f5edeff8301410ba2
/// Version: 1.1.0

virtual detect

@blk_init_flush exists@
identifier q;
@@

blk_init_flush(struct request_queue *q)
{
	...
	q->fq = blk_alloc_flush_queue(q);
	...
}

@err_init depends on blk_init_flush exists@
identifier q, fail;
statement S;
position p;
@@

blk_init_allocated_queue(struct request_queue *q, ...)
{
	...
	if (blk_init_flush(q)) S
	...
fail:
	blk_exit_flush@p(q);
	... when != q->fq = NULL;
	return NULL;
}

@err_direct exists@
identifier q, out_free_flush_queue;
position p;
@@

blk_init_allocated_queue(struct request_queue *q, ...)
{
	...
	q->fq = blk_alloc_flush_queue(q, ...);
	...
out_free_flush_queue:
	blk_free_flush_queue@p(q->fq);
	... when != q->fq = NULL;
(
	return -ENOMEM;
|
	return NULL;
)
}

@script:python depends on detect@
p << err_init.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2018-20856')

@script:python depends on detect@
p << err_direct.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2018-20856')
