/// Files: arch/powerpc/kernel/signal_32.c arch/powerpc/kernel/signal_64.c
/// Fix: f16d80b75a096c52354c6e0a574993f3b0dfbdfe
/// Fixes: 2b0a576d15e0e14751f00f9c87e46bad27f217e7

virtual detect

@uc_transact@
@@

struct rt_sigframe {
	...
*	struct ucontext uc_transact;
	...
};

@err_rt_sigreturn_32 depends on uc_transact exists@
symbol msr_hi;
position p;
@@

* if (\(MSR_TM_ACTIVE\|MSR_TM_SUSPENDED\)(msr_hi<<32)@p) {
	... when != cpu_has_feature(CPU_FTR_TM)
	do_setcontext_tm(...)
	...
  }

@err_rt_sigreturn_64 depends on uc_transact exists@
symbol msr;
statement S;
position p;
@@

* if (\(MSR_TM_ACTIVE\|MSR_TM_SUSPENDED\)(msr)@p) {
	... when != cpu_has_feature(CPU_FTR_TM)
	restore_tm_sigcontexts(...)
	...
  } else S

@script:python depends on detect@
p << err_rt_sigreturn_32.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2019-13648')

@script:python depends on detect@
p << err_rt_sigreturn_64.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2019-13648')
