/// Files: drivers/block/floppy.c
/// Fix: da99466ac243f15fbba65bd261bfc75ffa1532b6
/// Detect-To: v2.6.12-rc2

virtual detect

@divide exists@
expression E;
identifier _floppy, max_sector;
@@

make_raw_rw_request(void)
{
	...
	max_sector = _floppy->sect * _floppy->head;
	... when any
(
	E / max_sector
|
	E % max_sector
)
	...
}

@err depends on divide exists@
identifier g;
position p;
@@

* set_geometry@p(..., struct floppy_struct *g, ...)
{
	... when != if (... || (int)(g->sect * g->head) <= 0 || ...) return -EINVAL;
}

@script:python depends on detect@
p << err.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2019-14283')
