/// Files: security/apparmor/audit.c
/// Fix: c54d481d71c6849e044690d3960aaebc730224cc
/// Fixes: 52e8c38001d8ef0ca07ef428e480cd4a35e46abf

virtual detect

@err exists@
symbol root_ns;
identifier rule;
position p;
@@

aa_audit_rule_init(...)
{
	...
 	rule->label = aa_label_parse(&root_ns->unconfined->label, ...);
	if (IS_ERR(rule->label)) {
*		aa_audit_rule_free(rule);
*		return PTR_ERR(rule@p->label);
	}
	...
}

@script:python depends on detect@
p << err.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2019-18814')
