/// Files: net/nfc/llcp_sock.c net/nfc/llcp/sock.c
/// Fix: c61760e6940dd4039a7f5e84a6afc9cdbf4d82b6
/// Fixes: c33b1cc62ac05c1dbb1cdafe2eb66da01c76ca8d

virtual detect

@err_llcp_sock_bind1 exists@
identifier llcp_sock, put_dev;
position p;
@@

llcp_sock_bind(...)
{
	...
	if (!llcp_sock->service_name) {
*		nfc_llcp_local_put(llcp_sock->local);
		... when != llcp_sock->local = NULL;
*		goto put_dev;@p
	}
	...
}

@err_llcp_sock_bind2 exists@
identifier llcp_sock, put_dev;
position p;
@@

llcp_sock_bind(...)
{
	...
	if (llcp_sock->ssap == \(LLCP_SAP_MAX\|LLCP_MAX_SAP\)) {
*		nfc_llcp_local_put(llcp_sock->local);
		...when != llcp_sock->local = NULL;
*		goto put_dev;@p
	}
	...
}

@err_llcp_sock_connect1 exists@
identifier llcp_sock, put_dev;
position p;
@@

llcp_sock_connect(...)
{
	...
	if (llcp_sock->ssap == LLCP_SAP_MAX) {
		nfc_llcp_local_put(llcp_sock->local);
		... when != llcp_sock->local = NULL;
*		goto put_dev;@p
	}
	...
}

@err_llcp_sock_connect2 exists@
identifier llcp_sock;
symbol sock_llcp_release;
position p;
@@

llcp_sock_connect(...)
{
	...
sock_llcp_release:
	...
*	nfc_llcp_local_put@p(llcp_sock->local);
	... when != llcp_sock->local = NULL;
}

@script:python depends on detect@
p << err_llcp_sock_bind1.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2021-23134')

@script:python depends on detect@
p << err_llcp_sock_bind2.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2021-23134')

@script:python depends on detect@
p << err_llcp_sock_connect1.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2021-23134')

@script:python depends on detect@
p << err_llcp_sock_connect2.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2021-23134')
