/// Files: net/can/bcm.c
/// Fix: d5f9023fa61ee8b94f37a93f08e94b136cf1e463
/// Fixes: ffd980f976e7fd666c2e61bf8ab35107efd11828

virtual detect

@bcm_free_op_rcu@
identifier op;
@@

bcm_remove_op(struct bcm_op *op)
{
	...
	call_rcu(&op->rcu, bcm_free_op_rcu);
}

@err_bcm_delete_rx_op depends on !bcm_free_op_rcu exists@
identifier op;
position p;
@@

bcm_delete_rx_op(...)
{
	...
*	list_del@p(&op->list);
*	bcm_remove_op(op);
	return 1;
	...
}

@err_bcm_release depends on !bcm_free_op_rcu exists@
identifier op;
iterator name list_for_each_entry_safe;
position p;
@@

bcm_release(...)
{
	... when any
	list_for_each_entry_safe(op, ...) {
		...
*		bcm_remove_op@p(op);
		...
	}
	... when any
}

@script:python depends on detect@
p1 << err_bcm_delete_rx_op.p;
p2 << err_bcm_release.p;
@@

coccilib.report.print_report(p1[0], 'ERROR: CVE-2021-3609')
coccilib.report.print_report(p2[0], 'ERROR: CVE-2021-3609')
